/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.serialization.annotation;

import org.exquery.serialization.annotation.AbstractSerializationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationErrorCodes;
import org.exquery.serialization.annotation.SerializationAnnotationException;
import org.exquery.xquery.Literal;

public abstract class AbstractSingleValueSerializationAnnotation
extends AbstractSerializationAnnotation {
    private String value;

    public void initialise() throws SerializationAnnotationException {
        super.initialise();
        this.value = this.parseAnnotationValue();
    }

    public String getValue() {
        return this.value;
    }

    private String parseAnnotationValue() throws SerializationAnnotationException {
        Literal[] annotationValue = this.getLiterals();
        if (annotationValue.length > 1) {
            throw new SerializationAnnotationException(this.getTooManyLiteralsErr());
        }
        if (annotationValue.length != 1) {
            return null;
        }
        return this.parseValue(annotationValue[0]);
    }

    protected String parseValue(Literal value) throws SerializationAnnotationException {
        String valueStr = value.getValue();
        if (valueStr.isEmpty()) {
            throw new SerializationAnnotationException(this.getEmptyAnnotationParamsErr());
        }
        if (!this.validate(valueStr)) {
            throw new SerializationAnnotationException(this.getInvalidValueErr());
        }
        return valueStr;
    }

    protected abstract boolean validate(String var1);

    protected abstract SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getTooManyLiteralsErr();

    protected abstract SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getEmptyAnnotationParamsErr();

    protected abstract SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getInvalidValueErr();
}

