/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.serialization.annotation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.serialization.annotation.AbstractSerializationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationErrorCodes;
import org.exquery.serialization.annotation.SerializationAnnotationException;
import org.exquery.xquery.Literal;

public abstract class AbstractYesNoSerializationAnnotation
extends AbstractSerializationAnnotation {
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final Pattern ptnYesNo = Pattern.compile("yes|no");
    private boolean yes;

    public void initialise() throws SerializationAnnotationException {
        super.initialise();
        this.yes = this.parseAnnotationValue();
    }

    public boolean isYes() {
        return this.yes;
    }

    public String getStringValue() {
        String stringValue = this.yes ? YES : NO;
        return stringValue;
    }

    private boolean parseAnnotationValue() throws SerializationAnnotationException {
        Literal[] annotationValue = this.getLiterals();
        if (annotationValue.length > 1) {
            throw new SerializationAnnotationException(this.getAnnotationParamsCardinalityErr());
        }
        if (annotationValue.length == 0) {
            throw new SerializationAnnotationException(this.getAnnotationMissingParamsErr());
        }
        return this.parseYesNoParam(annotationValue[0]);
    }

    private boolean parseYesNoParam(Literal yesNoValue) throws SerializationAnnotationException {
        String yesNoStr = yesNoValue.getValue();
        if (yesNoStr.isEmpty()) {
            throw new SerializationAnnotationException(this.getAnnotationMissingParamsErr());
        }
        Matcher mtcYesNo = ptnYesNo.matcher(yesNoStr);
        if (!mtcYesNo.matches()) {
            throw new SerializationAnnotationException(this.getInvalidAnnotationParamsErr());
        }
        return yesNoStr.equals(YES);
    }

    protected abstract SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getAnnotationParamsCardinalityErr();

    protected abstract SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getAnnotationMissingParamsErr();

    protected abstract SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getInvalidAnnotationParamsErr();
}

