/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.serialization.annotation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.serialization.annotation.AbstractSingleValueSerializationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationErrorCodes;

public class MediaTypeAnnotation
extends AbstractSingleValueSerializationAnnotation {
    private static final Pattern ptnMediaType = Pattern.compile("[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}");

    @Override
    protected boolean validate(String value) {
        Matcher mtcMediaType = ptnMediaType.matcher(value);
        return mtcMediaType.matches();
    }

    @Override
    protected SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getTooManyLiteralsErr() {
        return SerializationAnnotationErrorCodes.SEST0010;
    }

    @Override
    protected SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getEmptyAnnotationParamsErr() {
        return SerializationAnnotationErrorCodes.SEST0011;
    }

    @Override
    protected SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getInvalidValueErr() {
        return SerializationAnnotationErrorCodes.SEST0012;
    }
}

