/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.serialization.annotation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.InternetMediaType;
import org.exquery.serialization.annotation.AbstractSerializationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationErrorCodes;
import org.exquery.serialization.annotation.SerializationAnnotationException;
import org.exquery.xquery.Literal;

public class MethodAnnotation
extends AbstractSerializationAnnotation {
    private String method;

    public void initialise() throws SerializationAnnotationException {
        super.initialise();
        this.method = this.parseAnnotationValue();
    }

    public String getMethod() {
        return this.method;
    }

    private String parseAnnotationValue() throws SerializationAnnotationException {
        Literal[] annotationValue = this.getLiterals();
        if (annotationValue.length > 1) {
            throw new SerializationAnnotationException(SerializationAnnotationErrorCodes.SEST0001);
        }
        if (annotationValue.length != 1) {
            return null;
        }
        return this.parseMethod(annotationValue[0]);
    }

    private String parseMethod(Literal methodValue) throws SerializationAnnotationException {
        String methodStr = methodValue.getValue();
        if (methodStr.isEmpty()) {
            throw new SerializationAnnotationException(SerializationAnnotationErrorCodes.SEST0002);
        }
        Matcher mtcOutputMethod = SupportedMethod.getPattern().matcher(methodStr);
        if (!mtcOutputMethod.matches()) {
            throw new SerializationAnnotationException(SerializationAnnotationErrorCodes.SEST0003);
        }
        return methodStr;
    }

    public static enum SupportedMethod {
        xml(InternetMediaType.APPLICATION_XML),
        xhtml(InternetMediaType.APPLICATION_XML),
        html(InternetMediaType.TEXT_HTML),
        html5(InternetMediaType.TEXT_HTML),
        json(InternetMediaType.APPLICATION_JSON),
        text(InternetMediaType.TEXT_PLAIN),
        binary(InternetMediaType.APPLICATION_OCTET_STREAM);

        private InternetMediaType defaultInternetMediaType;

        private SupportedMethod(InternetMediaType defaultInternetMediaType) {
            this.defaultInternetMediaType = defaultInternetMediaType;
        }

        public InternetMediaType getDefaultInternetMediaType() {
            return this.defaultInternetMediaType;
        }

        public static Pattern getPattern() {
            SupportedMethod[] supportedMethods = SupportedMethod.values();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < supportedMethods.length; ++i) {
                if (i > 0) {
                    builder.append("|");
                }
                builder.append(supportedMethods[i].toString());
            }
            return Pattern.compile(builder.toString());
        }
    }
}

