/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.serialization.annotation;

import javax.xml.namespace.QName;
import org.exquery.annotation.AnnotationException;
import org.exquery.serialization.annotation.AbstractSerializationAnnotation;
import org.exquery.serialization.annotation.EncodingAnnotation;
import org.exquery.serialization.annotation.IndentAnnotation;
import org.exquery.serialization.annotation.MediaTypeAnnotation;
import org.exquery.serialization.annotation.MethodAnnotation;
import org.exquery.serialization.annotation.OmitXmlDeclarationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationException;
import org.exquery.serialization.annotation.SerializationAnnotationName;
import org.exquery.xquery3.Annotation;

public class SerializationAnnotationFactory {
    public static boolean isSerializationAnnotation(QName annotationName) {
        return annotationName.getNamespaceURI().equals("http://www.w3.org/2010/xslt-xquery-serialization");
    }

    public static SerializationAnnotation getAnnotation(Annotation annotation) throws AnnotationException {
        if (SerializationAnnotationFactory.isSerializationAnnotation(annotation.getName())) {
            return SerializationAnnotationFactory.getSerializationAnnotation(annotation);
        }
        throw new IllegalArgumentException("Unknown annotation: " + annotation.getName().toString());
    }

    private static SerializationAnnotation getSerializationAnnotation(Annotation annotation) throws SerializationAnnotationException {
        AbstractSerializationAnnotation serializationAnnotation;
        SerializationAnnotationName an = SerializationAnnotationName.valueOf((QName)annotation.getName());
        switch (an) {
            case method: {
                serializationAnnotation = new MethodAnnotation();
                break;
            }
            case indent: {
                serializationAnnotation = new IndentAnnotation();
                break;
            }
            case omitxmldeclaration: {
                serializationAnnotation = new OmitXmlDeclarationAnnotation();
                break;
            }
            case mediatype: {
                serializationAnnotation = new MediaTypeAnnotation();
                break;
            }
            case encoding: {
                serializationAnnotation = new EncodingAnnotation();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown annotation: " + annotation.getName().toString());
            }
        }
        serializationAnnotation.setName(annotation.getName());
        serializationAnnotation.setFunctionSignature(annotation.getFunctionSignature());
        serializationAnnotation.setLiterals(annotation.getLiterals());
        serializationAnnotation.initialise();
        return serializationAnnotation;
    }
}

