/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;

public class ContentType {
    private Header myHeader;
    private String myType;
    private String myBoundary;

    public ContentType(String type, String boundary) {
        this.myHeader = null;
        this.myType = type;
        this.myBoundary = boundary;
    }

    public ContentType(Header h) throws HttpClientException {
        if (h == null) {
            throw new HttpClientException("Header is null");
        }
        if (!"Content-Type".equalsIgnoreCase(h.getName())) {
            throw new HttpClientException("Header is not content type");
        }
        this.myHeader = h;
        this.myType = HeaderSet.getHeaderWithoutParam(this.myHeader);
        HeaderElement[] elems = h.getElements();
        if (elems != null) {
            for (HeaderElement e : elems) {
                for (NameValuePair p : e.getParameters()) {
                    if (!"boundary".equals(p.getName())) continue;
                    this.myBoundary = p.getValue();
                }
            }
        }
    }

    public String toString() {
        if (this.myHeader == null) {
            return "Content-Type: " + this.getValue();
        }
        return this.myHeader.toString();
    }

    public String getType() {
        return this.myType;
    }

    public String getBoundary() {
        return this.myBoundary;
    }

    public String getValue() {
        if (this.myType != null) {
            return this.myType;
        }
        if (this.myHeader != null) {
            return this.myHeader.getValue();
        }
        return null;
    }
}

