/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient;

import java.net.URI;
import java.net.URISyntaxException;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpRequest;
import org.expath.httpclient.HttpResponse;
import org.expath.httpclient.impl.ApacheHttpConnection;
import org.expath.httpclient.impl.RequestParser;
import org.expath.httpclient.model.Result;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;

public class HttpClient {
    public static Result sendRequest(Result result, Element request) throws HttpClientException {
        return HttpClient.sendRequest(result, request, null, null);
    }

    public static Result sendRequest(Result result, Element request, String href) throws HttpClientException {
        return HttpClient.sendRequest(result, request, href, null);
    }

    public static Result sendRequest(Result result, Element request, String href, Sequence bodies) throws HttpClientException {
        HttpClient client = new HttpClient();
        return client.doSendRequest(result, request, href, bodies);
    }

    private Result doSendRequest(Result result, Element request, String href, Sequence bodies) throws HttpClientException {
        RequestParser parser = new RequestParser(request);
        HttpRequest req = parser.parse(bodies, href);
        if (href != null && !"".equals(href)) {
            req.setHref(href);
        }
        try {
            URI uri = new URI(req.getHref());
            return this.sendOnce(result, uri, req, parser);
        }
        catch (URISyntaxException ex) {
            throw new HttpClientException("Href is not valid: " + req.getHref(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result sendOnce(Result result, URI uri, HttpRequest request, RequestParser parser) throws HttpClientException {
        ApacheHttpConnection conn = new ApacheHttpConnection(uri);
        try {
            if (parser.getSendAuth()) {
                request.send(result, conn, parser.getCredentials());
            } else {
                HttpResponse response = request.send(result, conn, null);
                if (response.getStatus() == 401) {
                    conn.disconnect();
                    conn = new ApacheHttpConnection(uri);
                    result = result.makeNewResult();
                    request.send(result, conn, parser.getCredentials());
                }
            }
        }
        finally {
            conn.disconnect();
        }
        return result;
    }
}

