/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpConnection;
import org.expath.httpclient.HttpCredentials;
import org.expath.httpclient.HttpRequestBody;
import org.expath.httpclient.impl.AnyEmptyMethod;
import org.expath.httpclient.impl.AnyEntityMethod;
import org.expath.httpclient.impl.LoggerHelper;

@NotThreadSafe
public class ApacheHttpConnection
implements HttpConnection {
    private static final boolean[] METHOD_CHARS = new boolean[128];
    private static final PoolingHttpClientConnectionManager POOLING_CONNECTION_MANAGER;
    private State state = State.INITIAL;
    private URI myUri;
    private CloseableHttpClient myClient;
    private HttpRequestBase myRequest;
    private CloseableHttpResponse myResponse;
    private HttpVersion myVersion;
    private boolean myFollowRedirect = true;
    private Integer myTimeout = null;
    private boolean myGzip = false;
    private boolean myChunked = true;
    private static final CookieStore COOKIES;
    private static final Log LOG;
    private static HttpVersion DEFAULT_HTTP_VERSION;

    public ApacheHttpConnection(URI uri) {
        this.myUri = uri;
        this.myRequest = null;
        this.myResponse = null;
        this.myVersion = DEFAULT_HTTP_VERSION;
    }

    @Override
    public void connect(HttpRequestBody body, HttpCredentials cred) throws HttpClientException {
        if (this.myRequest == null) {
            throw new HttpClientException("setRequestMethod has not been called before");
        }
        this.myRequest.setProtocolVersion((ProtocolVersion)this.myVersion);
        try {
            Header[] headers;
            if (this.myClient == null) {
                this.myClient = this.makeClient();
            }
            if (this.myResponse != null) {
                this.myResponse.close();
            }
            HttpClientContext clientContext = this.setCredentials(cred);
            this.setRequestEntity(body);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("METHOD: " + this.myRequest.getMethod()));
                headers = this.myRequest.getAllHeaders();
                LoggerHelper.logHeaders(LOG, "REQ HEADERS", headers);
                LoggerHelper.logCookies(LOG, "COOKIES", COOKIES.getCookies());
            }
            this.myResponse = this.myClient.execute((HttpUriRequest)this.myRequest, (HttpContext)clientContext);
            if (LOG.isDebugEnabled()) {
                headers = this.myResponse.getAllHeaders();
                LoggerHelper.logHeaders(LOG, "RESP HEADERS", headers);
                LoggerHelper.logCookies(LOG, "COOKIES", COOKIES.getCookies());
            }
        }
        catch (IOException ex) {
            String message = this.getMessage(ex);
            throw new HttpClientException("Error executing the HTTP method: " + message != null ? message : "<unknown>", ex);
        }
        finally {
            this.state = State.POST_CONNECT;
        }
    }

    private String getMessage(Throwable throwable) {
        if (throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        Throwable cause = throwable.getCause();
        if (cause == null || cause == throwable) {
            return null;
        }
        return this.getMessage(cause);
    }

    @Override
    public void disconnect() throws HttpClientException {
        try {
            if (this.myResponse != null) {
                this.myResponse.close();
                this.myResponse = null;
            }
            this.myClient.close();
            this.myClient = null;
        }
        catch (IOException ex) {
            String message = this.getMessage(ex);
            throw new HttpClientException(message, ex);
        }
    }

    @Override
    public void setHttpVersion(String ver) throws HttpClientException {
        if (this.state != State.INITIAL) {
            String msg = "Internal error, HTTP version cannot been set after connect() has been called.";
            throw new HttpClientException(msg);
        }
        if ("1.0".equals(ver)) {
            this.myVersion = HttpVersion.HTTP_1_0;
        } else if ("1.1".equals(ver)) {
            this.myVersion = HttpVersion.HTTP_1_1;
        } else {
            throw new HttpClientException("Internal error, unknown HTTP version: '" + ver + "'");
        }
    }

    @Override
    public void setRequestHeaders(HeaderSet headers) throws HttpClientException {
        if (this.myRequest == null) {
            throw new HttpClientException("setRequestMethod has not been called before");
        }
        this.myRequest.setHeaders(headers.toArray());
    }

    @Override
    public void setRequestMethod(String method, boolean with_content) throws HttpClientException {
        if (LOG.isInfoEnabled()) {
            LOG.debug((Object)("Request method: " + method + " (" + with_content + ")"));
        }
        String uri = this.myUri.toString();
        String m = method.toUpperCase();
        if ("DELETE".equals(m)) {
            this.myRequest = new HttpDelete(uri);
        } else if ("GET".equals(m)) {
            this.myRequest = new HttpGet(uri);
        } else if ("HEAD".equals(m)) {
            this.myRequest = new HttpHead(uri);
        } else if ("OPTIONS".equals(m)) {
            this.myRequest = new HttpOptions(uri);
        } else if ("POST".equals(m)) {
            this.myRequest = new HttpPost(uri);
        } else if ("PUT".equals(m)) {
            this.myRequest = new HttpPut(uri);
        } else if ("TRACE".equals(m)) {
            this.myRequest = new HttpTrace(uri);
        } else {
            if (!this.checkMethodName(method)) {
                throw new HttpClientException("Invalid HTTP method name [" + method + "]");
            }
            this.myRequest = with_content ? new AnyEntityMethod(m, uri) : new AnyEmptyMethod(m, uri);
        }
    }

    @Override
    public void setFollowRedirect(boolean follow) {
        this.myFollowRedirect = follow;
    }

    @Override
    public void setTimeout(int seconds) {
        this.myTimeout = seconds;
    }

    @Override
    public void setGzip(boolean gzip) {
        this.myGzip = gzip;
    }

    @Override
    public void setChunked(boolean chunked) {
        this.myChunked = chunked;
    }

    private boolean checkMethodName(String method) {
        for (char c : method.toCharArray()) {
            if (c <= '\u007f' && METHOD_CHARS[c]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getResponseStatus() {
        return this.myResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getResponseMessage() {
        return this.myResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    public HeaderSet getResponseHeaders() throws HttpClientException {
        return new HeaderSet(this.myResponse.getAllHeaders());
    }

    @Override
    public InputStream getResponseStream() throws HttpClientException {
        try {
            HttpEntity entity = this.myResponse.getEntity();
            return entity == null ? null : entity.getContent();
        }
        catch (IOException ex) {
            throw new HttpClientException("Error getting the HTTP response stream", ex);
        }
    }

    private CloseableHttpClient makeClient() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)POOLING_CONNECTION_MANAGER).setConnectionManagerShared(true);
        clientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(null));
        if (this.myFollowRedirect) {
            clientBuilder.setRedirectStrategy((RedirectStrategy)LaxRedirectStrategy.INSTANCE);
        }
        clientBuilder.setDefaultCookieStore(COOKIES);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.myTimeout != null) {
            requestConfigBuilder.setConnectTimeout(this.myTimeout * 1000).setSocketTimeout(this.myTimeout * 1000);
        }
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        CloseableHttpClient client = clientBuilder.build();
        return client;
    }

    private HttpClientContext setCredentials(HttpCredentials cred) throws HttpClientException {
        HttpClientContext clientContext = HttpClientContext.create();
        if (cred == null) {
            return clientContext;
        }
        URI uri = this.myRequest.getURI();
        int port = uri.getPort();
        if (port == -1) {
            String scheme = uri.getScheme();
            if ("http".equals(scheme)) {
                port = 80;
            } else if ("https".equals(scheme)) {
                port = 443;
            } else {
                throw new HttpClientException("Unknown scheme: " + uri);
            }
        }
        String host = uri.getHost();
        String user = cred.getUser();
        String pwd = cred.getPwd();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set credentials for " + host + ":" + port + " - " + user + " - ***"));
        }
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(user, pwd);
        AuthScope scope = new AuthScope(host, port);
        if (clientContext.getCredentialsProvider() == null) {
            clientContext.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        } else {
            clientContext.getCredentialsProvider().clear();
        }
        clientContext.getCredentialsProvider().setCredentials(scope, (Credentials)c);
        return clientContext;
    }

    private void setRequestEntity(HttpRequestBody body) throws HttpClientException {
        Object entity;
        if (body == null) {
            return;
        }
        if (this.myVersion == HttpVersion.HTTP_1_1) {
            ByteArrayEntity template;
            if (this.myChunked) {
                RequestBodyProducer producer = new RequestBodyProducer(body);
                EntityTemplate entityTemplate = new EntityTemplate((ContentProducer)producer);
                entityTemplate.setContentType(body.getContentType());
                entityTemplate.setChunked(true);
                template = entityTemplate;
            } else {
                try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                    body.serialize(buffer);
                    template = new ByteArrayEntity(buffer.toByteArray());
                }
                catch (IOException e) {
                    throw new HttpClientException(e.getMessage(), e);
                }
            }
            entity = this.myGzip ? new GzipCompressingEntity((HttpEntity)template) : template;
        } else {
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                if (this.myGzip) {
                    try (GZIPOutputStream gzip = new GZIPOutputStream(buffer);){
                        body.serialize(gzip);
                    }
                    this.myRequest.setHeader("Content-Encoding", "gzip");
                } else {
                    body.serialize(buffer);
                }
                entity = new ByteArrayEntity(buffer.toByteArray());
            }
            catch (IOException e) {
                throw new HttpClientException(e.getMessage(), e);
            }
        }
        HttpEntityEnclosingRequestBase req = null;
        if (!(this.myRequest instanceof HttpEntityEnclosingRequestBase)) {
            String msg = "Body not allowed on a " + this.myRequest.getMethod() + " request";
            throw new HttpClientException(msg);
        }
        req = (HttpEntityEnclosingRequestBase)this.myRequest;
        req.setEntity((HttpEntity)entity);
    }

    private static PoolingHttpClientConnectionManager setupConnectionPool() {
        SSLContext sslContext = SSLContexts.createSystemDefault();
        SSLSocketFactoryWithSNI sslConnectionSocketFactory = new SSLSocketFactoryWithSNI(sslContext);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, null, null, null, 15L, TimeUnit.MINUTES);
        poolingHttpClientConnectionManager.setMaxTotal(40);
        return poolingHttpClientConnectionManager;
    }

    static {
        String excl = "()<>@,;:\\\"/[]?={}";
        for (int c = 0; c < 128; c = (int)((char)(c + 1))) {
            ApacheHttpConnection.METHOD_CHARS[c] = c < 33 || c == 127 ? false : excl.indexOf(c) == -1;
        }
        POOLING_CONNECTION_MANAGER = ApacheHttpConnection.setupConnectionPool();
        COOKIES = new BasicCookieStore();
        LOG = LogFactory.getLog(ApacheHttpConnection.class);
        DEFAULT_HTTP_VERSION = HttpVersion.HTTP_1_1;
        String ver = System.getProperty("org.expath.hc.http.version");
        if (ver != null) {
            if ("1.0".equals(ver = ver.trim())) {
                DEFAULT_HTTP_VERSION = HttpVersion.HTTP_1_0;
            } else if ("1.1".equals(ver)) {
                DEFAULT_HTTP_VERSION = HttpVersion.HTTP_1_1;
            } else {
                String msg = "Wrong HTTP version: " + ver + " (check org.expath.hc.http.version)";
                throw new RuntimeException(msg);
            }
        }
    }

    private static class RequestBodyProducer
    implements ContentProducer {
        private HttpRequestBody myBody;

        public RequestBodyProducer(HttpRequestBody body) {
            this.myBody = body;
        }

        public void writeTo(OutputStream out) throws IOException {
            try {
                this.myBody.serialize(out);
            }
            catch (HttpClientException ex) {
                throw new IOException("Error serializing the body content", ex);
            }
        }
    }

    private static enum State {
        INITIAL,
        POST_CONNECT;

    }

    private static class SSLSocketFactoryWithSNI
    extends SSLConnectionSocketFactory {
        public SSLSocketFactoryWithSNI(SSLContext sslContext) {
            super(sslContext);
        }

        public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            if (socket instanceof SSLSocket) {
                try {
                    Class<?> socketClazz = socket.getClass();
                    Method m = socketClazz.getDeclaredMethod("setHost", String.class);
                    m.setAccessible(true);
                    m.invoke((Object)socket, host.getHostName());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.warn((Object)("Problem whilst setting SNI: " + e.getMessage()), (Throwable)e);
                }
            }
            return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        }
    }
}

