/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpRequestBody;
import org.expath.tools.model.Element;

public class HrefRequestBody
extends HttpRequestBody {
    private String myHref;

    public HrefRequestBody(Element elem) throws HttpClientException {
        super(elem);
        this.myHref = elem.getAttribute("src");
    }

    @Override
    public boolean isMultipart() {
        return false;
    }

    @Override
    public void setHeaders(HeaderSet headers) throws HttpClientException {
        if (headers.getFirstHeader("Content-Type") == null) {
            headers.add("Content-Type", this.getContentType());
        }
    }

    @Override
    public void serialize(OutputStream out) throws HttpClientException {
        try {
            String filename = new URI(this.myHref).getPath();
            try (FileInputStream in = new FileInputStream(new File(filename));){
                byte[] buf = new byte[4096];
                int l = -1;
                while ((l = ((InputStream)in).read(buf)) != -1) {
                    out.write(buf, 0, l);
                }
            }
            catch (IOException ex) {
                throw new HttpClientException("Error sending the file content", ex);
            }
        }
        catch (URISyntaxException ex) {
            throw new HttpClientException("Bad URI: " + this.myHref, ex);
        }
    }
}

