/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpCredentials;
import org.expath.httpclient.HttpRequest;
import org.expath.httpclient.HttpRequestBody;
import org.expath.httpclient.impl.BodyFactory;
import org.expath.httpclient.impl.HttpRequestImpl;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Attribute;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;

public class RequestParser {
    private Element myRequest;
    private String myNs;
    private String myOtherNs;
    private HttpCredentials myCredentials = null;
    private boolean mySendAuth = false;

    public RequestParser(Element request) throws HttpClientException {
        String ns = request.getNamespaceUri();
        String name = request.getLocalName();
        boolean ns_ok = true;
        if ("http://expath.org/ns/http".equals(ns)) {
            this.myNs = "http://expath.org/ns/http";
            this.myOtherNs = "http://expath.org/ns/http-client";
        } else if ("http://expath.org/ns/http-client".equals(ns)) {
            this.myNs = "http://expath.org/ns/http-client";
            this.myOtherNs = "http://expath.org/ns/http";
        } else {
            ns_ok = false;
        }
        if (!"request".equals(name) || !ns_ok) {
            String clark = "{" + ns + "}" + name;
            throw new HttpClientException("$request is not an element(http:request), but is " + clark);
        }
        this.myRequest = request;
        this.myNs = ns;
    }

    public String getNamespaceURI() {
        return this.myNs;
    }

    public HttpCredentials getCredentials() {
        return this.myCredentials;
    }

    public boolean getSendAuth() {
        return this.mySendAuth;
    }

    public HttpRequest parse(Sequence bodies, String href) throws HttpClientException {
        String username = null;
        String password = null;
        String auth_method = null;
        HttpRequestImpl req = new HttpRequestImpl();
        req.setHref(href);
        for (Attribute a : this.myRequest.attributes()) {
            String local = a.getLocalName();
            if (a.getNamespaceUri() != null && !a.getNamespaceUri().isEmpty()) continue;
            if ("method".equals(local)) {
                req.setMethod(a.getValue());
                continue;
            }
            if ("href".equals(local)) {
                req.setHref(a.getValue());
                continue;
            }
            if ("http-version".equals(local)) {
                req.setHttpVersion(a.getValue().trim());
                continue;
            }
            if ("status-only".equals(local)) {
                req.setStatusOnly(this.toBoolean(a));
                continue;
            }
            if ("username".equals(local)) {
                username = a.getValue();
                continue;
            }
            if ("password".equals(local)) {
                password = a.getValue();
                continue;
            }
            if ("auth-method".equals(local)) {
                auth_method = a.getValue();
                continue;
            }
            if ("send-authorization".equals(local)) {
                this.mySendAuth = this.toBoolean(a);
                continue;
            }
            if ("override-media-type".equals(local)) {
                req.setOverrideType(a.getValue());
                continue;
            }
            if ("follow-redirect".equals(local)) {
                req.setFollowRedirect(this.toBoolean(a));
                continue;
            }
            if ("timeout".equals(local)) {
                req.setTimeout(this.toInteger(a));
                continue;
            }
            if ("gzip".equals(local)) {
                req.setGzip(this.toBoolean(a));
                continue;
            }
            if ("chunked".equals(local)) {
                req.setChunked(this.toBoolean(a));
                continue;
            }
            throw new HttpClientException("Unknown attribute http:request/@" + local);
        }
        if (req.getMethod() == null) {
            throw new HttpClientException("required @method has not been set on http:request");
        }
        if (req.getHref() == null) {
            throw new HttpClientException("required @href has not been set on http:request");
        }
        if (username != null || password != null || auth_method != null) {
            this.setAuthentication(username, password, auth_method);
        }
        if (req.getHttpVersion() != null && req.getHttpVersion().equals("1.0") && req.isChunked()) {
            throw new HttpClientException("Chunked transfer encoding can only be used with HTTP 1.1");
        }
        HeaderSet headers = new HeaderSet();
        req.setHeaders(headers);
        for (Element child : this.myRequest.children()) {
            String local = child.getLocalName();
            String ns = child.getNamespaceUri();
            if (ns == null || ns.isEmpty()) {
                throw new HttpClientException("Element in no namespace: " + local);
            }
            if (this.myOtherNs.equals(ns)) {
                String clark = "{" + ns + "}" + local;
                throw new HttpClientException("http:request mixes elements in the new and legacy HTTP namespace: " + clark);
            }
            if (!this.myNs.equals(ns)) continue;
            if ("header".equals(local)) {
                this.addHeader(headers, child);
                continue;
            }
            if ("body".equals(local) || "multipart".equals(local)) {
                HttpRequestBody b = BodyFactory.makeRequestBody(child, bodies, this.myNs);
                req.setBody(b);
                continue;
            }
            throw new HttpClientException("Unknown element: " + local);
        }
        return req;
    }

    private void setAuthentication(String user, String pwd, String method) throws HttpClientException {
        if (user == null || pwd == null || method == null) {
            throw new HttpClientException("@username, @password and @auth-method must be all set");
        }
        if ("basic".equals(method)) {
            this.myCredentials = new HttpCredentials(user, pwd, method);
        } else if ("digest".equals(method)) {
            this.myCredentials = new HttpCredentials(user, pwd, method);
        } else {
            throw new HttpClientException("Unknown authentication method: " + method);
        }
    }

    private void addHeader(HeaderSet headers, Element e) throws HttpClientException {
        String name = null;
        String value = null;
        for (Attribute a : e.attributes()) {
            String local = a.getLocalName();
            if (a.getNamespaceUri() != null && !a.getNamespaceUri().isEmpty()) continue;
            if ("name".equals(local)) {
                name = a.getValue();
                continue;
            }
            if ("value".equals(local)) {
                value = a.getValue();
                continue;
            }
            throw new HttpClientException("Unknown attribute http:header/@" + local);
        }
        if (name == null || value == null) {
            throw new HttpClientException("@name and @value are required on http:header");
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            throw new HttpClientException("Content-Length should not be explicitly provided, either it will automatically be added or Transfer-Encoding will be used.");
        }
        if (name.equalsIgnoreCase("Transfer-Encoding")) {
            throw new HttpClientException("Transfer-Encoding should not be explicitly provided, it will automatically be added if required.");
        }
        headers.add(name, value);
    }

    private boolean toBoolean(Attribute a) throws HttpClientException {
        try {
            return a.getBoolean();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error parsing the attribute as a boolean", ex);
        }
    }

    private int toInteger(Attribute a) throws HttpClientException {
        try {
            return a.getInteger();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error parsing the attribute as an integer", ex);
        }
    }
}

