/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.OutputStream;
import java.util.Properties;
import javax.xml.namespace.QName;
import net.iharder.Base64;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpConstants;
import org.expath.httpclient.HttpRequestBody;
import org.expath.httpclient.impl.BodyFactory;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;
import org.expath.tools.serial.SerialParameters;

public class SinglePartRequestBody
extends HttpRequestBody {
    private BodyFactory.Type myMethod;
    private Sequence myChilds;
    private SerialParameters mySerial = new SerialParameters();

    public SinglePartRequestBody(Element elem, Sequence bodies, BodyFactory.Type method) throws HttpClientException {
        super(elem);
        this.myMethod = method;
        switch (this.myMethod) {
            case XML: {
                this.mySerial.setMethod(new QName("xml"));
                break;
            }
            case TEXT: {
                this.mySerial.setMethod(new QName("text"));
                break;
            }
            case HTML: {
                this.mySerial.setMethod(new QName("html"));
                break;
            }
            case XHTML: {
                this.mySerial.setMethod(new QName("xhtml"));
                break;
            }
            case BINARY: 
            case BASE64: {
                this.mySerial.setMethod(new QName("expath:base64"));
                break;
            }
            case HEX: {
                this.mySerial.setMethod(new QName("expath:hex"));
                break;
            }
            default: {
                throw new HttpClientException("Unsupported method! (yet?): " + (Object)((Object)this.myMethod));
            }
        }
        String[] attr_names = new String[]{"src", "media-type", "method", "byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "indent", "normalization-form", "omit-xml-declaration", "standalone", "suppress-indentation", "undeclare-prefixes", "version"};
        this.mySerial.setEncoding(elem.getAttribute(attr_names[7]));
        this.mySerial.setIndent(this.parseYesNo(elem, attr_names[9]));
        this.mySerial.setOmitXmlDeclaration(this.parseYesNo(elem, attr_names[11]));
        String[] NOT_SUPPORTED_ATTRS = new String[]{"byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "escape-uri-attributes", "normalization-form", "standalone", "suppress-indentation", "undeclare-prefixes", "version"};
        for (int i = 0; i < NOT_SUPPORTED_ATTRS.length; ++i) {
            String name = NOT_SUPPORTED_ATTRS[i];
            String val = elem.getAttribute(name);
            if (val == null) continue;
            throw new HttpClientException("Attribute not supported yet: http:body/@" + name);
        }
        try {
            elem.noOtherNCNameAttribute(attr_names, HttpConstants.BOTH_NS_URIS);
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Invalid attributes", ex);
        }
        this.myChilds = this.getBodyElement().getContent();
        try {
            if (this.myChilds.isEmpty()) {
                Sequence body = bodies.next();
                if (body == null) {
                    throw new HttpClientException("There is not enough items within $bodies");
                }
                this.myChilds = body;
            }
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Technical error walking through the http:body content", ex);
        }
    }

    private Boolean parseYesNo(Element elem, String attr_name) throws HttpClientException {
        String val = elem.getAttribute(attr_name);
        if (val == null) {
            return null;
        }
        if ("yes".equals(val)) {
            return Boolean.TRUE;
        }
        if ("no".equals(val)) {
            return Boolean.FALSE;
        }
        String msg = "Incorrect value for " + attr_name + ": " + val;
        throw new HttpClientException(msg);
    }

    @Override
    public void setHeaders(HeaderSet headers) throws HttpClientException {
        if (headers.getFirstHeader("Content-Type") == null) {
            String type = this.getContentType();
            if (this.myMethod == BodyFactory.Type.XML || this.myMethod == BodyFactory.Type.HTML || this.myMethod == BodyFactory.Type.XHTML || this.myMethod == BodyFactory.Type.TEXT) {
                if (this.mySerial.getEncoding() == null) {
                    this.mySerial.setEncoding("UTF-8");
                }
                type = type + "; charset=" + this.mySerial.getEncoding();
            } else if (this.mySerial.getEncoding() != null) {
                throw new HttpClientException("Encoding is not allowed with method '" + (Object)((Object)this.myMethod) + "'");
            }
            headers.add("Content-Type", type);
        }
    }

    @Override
    public void serialize(OutputStream out) throws HttpClientException {
        if (this.myMethod == BodyFactory.Type.HEX) {
            throw new HttpClientException("Method 'hex' not supported yet");
        }
        if (this.myMethod == BodyFactory.Type.BINARY || this.myMethod == BodyFactory.Type.BASE64) {
            out = new Base64.OutputStream(out, 0);
        }
        try {
            this.myChilds.serialize(out, this.mySerial);
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error serializing the result", ex);
        }
    }

    @Override
    public boolean isMultipart() {
        return false;
    }

    private void setOutputProperty(Properties props, String value, String key) {
        if (value != null) {
            props.setProperty(key, value);
        }
    }

    private void setYesNoOutputProperty(Properties props, Boolean value, String key) {
        if (value != null) {
            props.setProperty(key, value != false ? "yes" : "no");
        }
    }
}

