/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.ccil.cowan.tagsoup.Parser;
import org.expath.httpclient.ContentType;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.model.Result;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.tools.ToolsException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlResponseBody
implements HttpResponseBody {
    private ContentType myContentType;
    private HeaderSet myHeaders;

    public XmlResponseBody(Result result, InputStream in, ContentType type, HeaderSet headers, boolean html) throws HttpClientException {
        Charset charset = StandardCharsets.UTF_8;
        InputStreamReader reader = new InputStreamReader(in, charset);
        this.init(result, reader, type, headers, html);
    }

    public XmlResponseBody(Result result, Reader in, ContentType type, HeaderSet headers, boolean html) throws HttpClientException {
        this.init(result, in, type, headers, html);
    }

    private void init(Result result, Reader in, ContentType type, HeaderSet headers, boolean html) throws HttpClientException {
        this.myContentType = type;
        this.myHeaders = headers;
        String sys_id = "TODO-find-a-useful-systemId";
        try {
            Source src;
            if (html) {
                Parser parser = new Parser();
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                InputSource input = new InputSource(in);
                src = new SAXSource((XMLReader)parser, input);
                src.setSystemId(sys_id);
            } else {
                src = new StreamSource(in, sys_id);
            }
            result.add(src);
        }
        catch (SAXException ex) {
            throw new HttpClientException("error parsing result HTML", ex);
        }
    }

    @Override
    public void outputBody(TreeBuilder b) throws HttpClientException {
        if (this.myHeaders != null) {
            b.outputHeaders(this.myHeaders);
        }
        try {
            b.startElem("body");
            b.attribute("media-type", this.myContentType.getValue());
            b.startContent();
            b.endElem();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error building the body", ex);
        }
    }
}

