//>>built
require({cache:{
'bf/container/Repeat':function(){
define("bf/container/Repeat", ["dojo/_base/declare","bf/XFBinding","dojo/query","dojo/dom", "dojo/dom-style","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/_base/window","dojo/behavior","dojo/_base/connect","dojo/on","dojo/_base/lang","bf/util"],
    function(declare, XFBinding,query, dom, domStyle, domAttr, domClass, domConstruct, win, behavior,connect,on,lang){
        return declare(XFBinding, {

                id:null,

                constructor:function(properties, node){
                    // console.debug("Repeat.constructor created new instace node:", node, "\n\n");
                    // this.inherited(arguments);
                    this.id = domAttr.get(this.srcNodeRef,"id");

                    this.appearance = undefined;
                    if (domClass.contains(this.srcNodeRef, "aCompact")) {
                        this.appearance = "compact";
                    } else {
                        this.appearance = "full";
                    }
                    // console.debug("Repeat.postCreate appearance:",this.appearance);

                    var bfInsertRepeatItemHandle = connect.subscribe("betterform-insert-repeatitem-"+ this.id, this, "handleInsert");
                    fluxProcessor.addSubscriber(this.id, bfInsertRepeatItemHandle);
                    var bfItemDeleteHandle = connect.subscribe("betterform-item-deleted-"+ this.id,      this, "handleDelete");
                    fluxProcessor.addSubscriber(this.id, bfItemDeleteHandle);
                    var bfIndexChanged = connect.subscribe("betterform-index-changed-"+ this.id,     this, "handleSetRepeatIndex");
                    fluxProcessor.addSubscriber(this.id, bfIndexChanged);
                    var self = this;
                    this._getRepeatItems().forEach(function(repeatItem){
                        on(repeatItem, "click", lang.hitch(self, self._onClickRepeatItem));
                        var repeatItemId = domAttr.get(repeatItem,"id");
                        // console.debug("Repeat.constructor connect.subscribe('bf-state-change-"+ repeatItemId, " self.handleStateChanged)");
                        var bfStateChanged = connect.subscribe("bf-state-change-"+ repeatItemId, self.handleStateChanged);
                        fluxProcessor.addSubscriber(repeatItemId, bfStateChanged);
                    });

                },
                handleStateChanged:function(contextInfo) {
                    // console.debug("Repeat.handleStateChanged: contextInfo:",contextInfo);
                    var repeatItem = dom.byId(contextInfo.targetId);
                    // console.debug("found repeatItem:",repeatItem);

                    var readonly = contextInfo["readonly"];
                    if(readonly != undefined) {
                        if(readonly == "true"){
                            domClass.replace(repeatItem, "xfReadOnly","xfReadWrite");
                        }else {
                            domClass.replace(repeatItem, "xfReadWrite","xfReadOnly");
                        }
                    }
                    var enabled = contextInfo["enabled"];
                    if(enabled != undefined) {
                        if(enabled == "true"){
                            domClass.replace(repeatItem,"xfEnabled","xfDisabled");
                        }else {
                            domClass.replace(repeatItem, "xfDisabled", "xfEnabled");
                        }
                    }
                },

                _onClickRepeatItem:function(evt){
                    // console.debug("Repeat._onClickRepeatItem:",evt);
                    if(!evt || (!evt.currentTarget && !evt.srcElement)){
                        return;
                    }
                    var repeatItem = (evt.currentTarget) ? evt.currentTarget : evt.srcElement;
                    // console.debug("onClickRepeatItem: repeatItem:",repeatItem);
                    if(domClass.contains(repeatItem,"xfReadOnly")){
                        console.warn("Repeat._onClickRepeatItem: repeatItem ", repeatItem, " is readonly");
                        return;
                    }
                    if(domClass.contains(repeatItem, "xfRepeatIndex") || domClass.contains(repeatItem, "xfRepeatIndexPre")){
                        return;
                    }
                    var repeatNode = this.srcNodeRef;
                    var repeatItems = this._getRepeatItems();
                    var position = repeatItems.indexOf(repeatItem) + 1;

                    query(".xfRepeatIndex", repeatNode).forEach(function(node){
                        domClass.remove(node, "xfRepeatIndex")
                    });

                    query(".xfRepeatIndexPre", repeatNode).forEach(function(node){
                        domClass.remove(node, "xfRepeatIndexPre")
                    });

                    // add xfRepeatIndexPre CSS Class to selected RepeatItem and send setRepeatIndex to the server
                    domClass.add(repeatItem, "xfRepeatIndexPre");
                    fluxProcessor.setRepeatIndex(this.id, position);
                },

                handleSetRepeatIndex:function(/*Map*/ contextInfo) {
                    // console.debug("Repeat.handleSetRepeatIndex: contextInfo'",contextInfo, " for Repeat id: ", this.id);
                    var intIndex = parseInt(contextInfo.index,"10");

                    var repeatNode = this.srcNodeRef;
                    this._removeRepeatIndexClasses();

                    var repeatIndexNode = this._getRepeatItems()[intIndex - 1];
                    if (repeatIndexNode != undefined) {
                        domClass.add(repeatIndexNode, "xfRepeatIndex");
                    }

                },

                handleInsert:function(/*Map*/ contextInfo) {
                    // console.debug("handleInsert contextInfo: ",contextInfo);
                    // search for former repeat-index and remove it
                    this._removeRepeatIndexClasses();
                    // console.debug("handleInsert replace prototype ids - clone prototype: ",contextInfo.originalId + "-prototype");

                    // clone prototype and manipulate classes of repeat item
                    var prototype = dom.byId(contextInfo.originalId + "-prototype");
                    var insertedNode = prototype.cloneNode(true);
                    this._replaceRepeatItemClasses(insertedNode);

                    // replace prototype ids with generated ones
                    var generatedIds = "";
                    if (contextInfo.prototypeId != undefined) {
                        generatedIds = contextInfo.generatedIds;
                        domAttr.set(insertedNode, "id", generatedIds[contextInfo.prototypeId]);

                    } else if (contextInfo.repeatedSelects) {
                        generatedIds = contextInfo.repeatedSelects[0].generatedIds;
                        // console.debug("Generated Ids: ", generatedIds);
                        var clonedNodeId = contextInfo.repeatedSelects[0].generatedIds[0];
                        domAttr.set(insertedNode, "id", clonedNodeId);
                    }
                    // console.debug("updated id of insertedNode:",insertedNode);
                    // replace prototype ids with generated ones

                    this._replacePrototypeIds(insertedNode, generatedIds);

                    // create dijit and place it within repeat
                    var position = parseInt(contextInfo.position,"10");
                    // console.debug("InsertedNode: " + insertedNode.id );
                    var repeatItemNode = undefined;
                    if (dom.byId(insertedNode.id) != null ) {
                        console.warn("Repeat.handleInsert Skipping already present repeatItem: ");
                        repeatItemNode = dom.byId(insertedNode.id);
                    }else {
                        repeatItemNode = this._createRepeatItem(insertedNode, position);
                    }
                    console.debug("repeatItemNode:",repeatItemNode);
                    // console.debug("handleInsert fix inserted controls repeatItemNode:",repeatItemNode);

                    // rename data-bf-class to class
                    query("*[data-bf-class]",repeatItemNode).forEach(function(item){
                        // console.debug("\n\nrename data-bf-class to class");
                        var cssClass = domAttr.get(item,"data-bf-class");
                        if(cssClass && cssClass != ""){
                            domAttr.set(item,"class", cssClass);
                        }
                        item.removeAttribute("data-bf-class");
                    });
                    // console.debug("Repeat.handleInsert before applyBehavior:", behavior);
                    behavior.apply();
                    // console.debug("Repeat.handleInsert after applyBehavior:", behavior);
                    var self = this;

                    require(["dojo/ready","dojo/dom-style","dojo/dom-attr"],function(ready,domStyle, domAttr){
                        ready(function(){
                            console.debug("Repeat: set CSS styles");
                            domClass.add(repeatItemNode,"xfRepeatIndex");
                            on(repeatItemNode, "click", lang.hitch(self ,self._onClickRepeatItem));
                            var repeatItemId = domAttr.get(repeatItemNode,"id");
                            var bfStateChanged = connect.subscribe("bf-state-change-"+ repeatItemId, self.handleStateChanged);
                            fluxProcessor.addSubscriber(repeatItemId, bfStateChanged);
                            if(domStyle.get(repeatItemNode,"display") == "none"){
                                //                                repeatItemNode.removeAttribute("style");
                                //todo: this is save enough? If an repeatitem can have a style then this wouldn't be sufficient
                                domAttr.remove(repeatItemNode,"style");
                            }
                        })
                    });
                },

                handleDelete:function(/*Map*/ contextInfo) {
                    // console.debug("Repeat.handleDelete contextInfo:",contextInfo);
                    var position = parseInt(contextInfo.position,"10");
                    var itemToRemove = this._getRepeatItems()[position - 1];
                    var repeatNode = this.srcNodeRef;
                    if (this.appearance == "compact") {
                        query("> tbody", repeatNode)[0].removeChild(itemToRemove);
                    } else {
                        repeatNode.removeChild(itemToRemove);
                    }
                },

                _removeRepeatIndexClasses:function() {
                    var repeatNode = this.srcNodeRef;
                    // console.debug("Repeat._removeRepeatIndexClasses: repeatNode:",repeatNode, " this:",this);
                    if (this.appearance == "compact") {
                        query("> tbody > .xfRepeatIndexPre", repeatNode).forEach(
                            function(repeatIndexItem) {
                                domClass.remove(repeatIndexItem, "xfRepeatIndexPre");
                            }
                        );
                        query("> tbody > .xfRepeatIndex", repeatNode).forEach(
                            function(repeatIndexItem) {
                                domClass.remove(repeatIndexItem, "xfRepeatIndex");
                            }
                        );
                    } else {
                        query("> .xfRepeatIndexPre", repeatNode).forEach(
                            function(repeatIndexItem) {
                                domClass.remove(repeatIndexItem, "xfRepeatIndexPre");
                            }
                        );
                        query("> .xfRepeatIndex", repeatNode).forEach(
                            function(repeatIndexItem) {
                                domClass.remove(repeatIndexItem, "xfRepeatIndex");
                            }
                        );
                    }
                },
                _replaceRepeatItemClasses:function(/* Node */ node) {
                    // console.debug("Repeat._replaceRepeatItemClasses node:",node );
                    // console.dirxml(node);
                    domClass.remove(node, "xfRepeatPrototype");
                    domClass.remove(node, "xfDisabled");
                    domClass.add(node, "xfRepeatItem");
                    domClass.add(node, "xfEnabled");
                },

                _replacePrototypeIds:function(node, generatedIds) {
                    query("*", node).forEach(
                        function(xfNode) {
                            var idAtt = domAttr.get(xfNode, "id");

                            if (idAtt != undefined && generatedIds[idAtt] != undefined) {
                                domAttr.set(xfNode, "id", generatedIds[idAtt]);
                            }

                            else if (idAtt != undefined) {
                                var idPrefix;
                                var idAppendix;

                                if (idAtt.indexOf("-value") != -1) {
                                    idPrefix = idAtt.substring(0, idAtt.indexOf("-value"));
                                    idAppendix = "-value";
                                } else if (idAtt.indexOf("-label") != -1) {
                                    idPrefix = idAtt.substring(0, idAtt.indexOf("-label"));
                                    idAppendix = "-label";
                                } else if (idAtt.indexOf("-hint") != -1) {
                                    idPrefix = idAtt.substring(0, idAtt.indexOf("-hint"));
                                    idAppendix = "-hint";
                                } else if (idAtt.indexOf("-help") != -1) {
                                    idPrefix = idAtt.substring(0, idAtt.indexOf("-help"));
                                    idAppendix = "-help";
                                } else if (idAtt.indexOf("-alert") != -1) {
                                    idPrefix = idAtt.substring(0, idAtt.indexOf("-alert"));
                                    idAppendix = "-alert";
                                } else {
                                    // console.warn("Repeat._replacePrototypeIds Failure replaceing Id! Id to replace: ", idAtt, " generatedIds: ", generatedIds);
                                    return;
                                }

                                //console.debug("original Id: " + idAtt + " prefix:: " + idPrefix + " appendix:" +idAppendix);;
                                var generatedId = generatedIds[idPrefix] + idAppendix;
                                // console.debug("original Id: " + idAtt + " generatedId: " + generatedId);
                                domAttr.set(xfNode, "id", generatedId);
                            }
                        }
                    );

                },
                _createRepeatItem:function(node, /* int */position) {
                    // console.debug("RepeatItem._createRepeatItem node:",node, " at position " + position);
                    var repeatItemCount = this._getSize();
                    domStyle.set(node, "display","none");

                    var targetNode = null;
                    var repeatNode = this.srcNodeRef;
                    // console.debug("_createRepeatItem: repeatNode:",repeatNode);
                    if (position == 1 && repeatItemCount > 0) {
                        targetNode = this._getRepeatItems()[0];
                        domConstruct.place(node, targetNode, "before");

                    } else if (position == 1 && repeatItemCount == 0) {

                        if (this.appearance == "compact") {
                            // console.debug("RepeatItem._createRepeatItem for CompactRepeat domNode: ", repeatNode);
                            var tbodyNode = query("> tbody", repeatNode)[0];
                            if (tbodyNode == undefined) {
                                tbodyNode = win.doc.createElement("tbody");
                                domConstruct.place(tbodyNode, repeatNode);
                            }
                            domConstruct.place(node, tbodyNode);
                        } else {
                            // console.debug("place repeatItemNode:",node, " at ",repeatNode);
                            domConstruct.place(node, repeatNode);
                        }


                    } else {
                        //  position - 2 causes
                        //  1. XForms Position 1 = JavaScript Array Position 1 and
                        //  2. Default Insert happens after the targetNode

                        targetNode = this._getRepeatItems()[position - 2];
                        // console.debug("RepeatItem._createRepeatItem targetNode: ", targetNode , " repeatItem: ", repeatItemDijit);
                        domConstruct.place(node, targetNode, "after");
                    }
                    // console.debug("RepeatItem._createRepeatItem Insert at Position "+ position + " of  :"+(repeatItemCount+1));
                    return node;
                },

                _getSize:function() {
                    // console.debug("Repeat._getSize");
                    return this._getRepeatItems().length;
                },

                _getRepeatItems:function(){
                    // console.debug("Repeat._getRepeatItems");
                    var repeatItems = undefined;
                    var repeatNode = this.srcNodeRef;
                    // console.debug("Repeat._getRepeatItems repeatNode: ",repeatNode);
                    if (this.appearance == "compact") {
                        repeatItems = query("> tbody > .xfRepeatItem", repeatNode);
                    } else {
                        repeatItems = query("> .xfRepeatItem", repeatNode);
                    }
                    // console.debug("Repeat._getRepeatItems repeatItems: ",repeatItems);
                    return repeatItems;
                }
            }
        );
    });



},
'bf/factory/FactoryTextarea':function(){
define("bf/factory/FactoryTextarea", ["dojo/_base/declare","dojo/_base/connect","dijit/registry","bf/util"],
    function(declare,connect,registry) {
        return declare(null,
            {
                /**
                 *
                 * @param type
                 * @param node
                 */
                create:function(type, node){
                    var xfControlDijit = registry.byId(bf.util.getXfId(node));
                    switch(type){
                        case "texteditor":
                            console.debug("FactoryTextarea (texteditor)");
                            xfControlDijit.setCurrentValue(node.value);

                            xfControlDijit.setValue = function (value) {
                                // console.debug("textarea xfControlDijit: value:",value);
                                node.value   = value;
                            };

                            connect.connect(node,"onkeyup",function(evt){
                                //console.debug("onkeypress",node);
                                if(xfControlDijit.isIncremental()){
                                    xfControlDijit.sendValue(node.value,false);
                                }
                            });

                            connect.connect(node,"onblur",function(evt){
                                //console.debug("onblur",node);
                                xfControlDijit.sendValue(node.value,true);
                            });

                            connect.connect(node,"onfocus",function(evt){
                                xfControlDijit.handleOnFocus();
                            });
                            break;
                        case "htmleditor":
                            //todo: support incremental behavior - this shouldn't be simple keyup updating but interval-based updating
                            var ckPath = dojo.config.baseUrl + "ckeditor/ckeditor.js";

                            require(["dojo/dom-class",ckPath], function(domClass) {
                                // console.debug("ckPath",ckPath, " CKEDITOR:",CKEDITOR);
                                // CKEDITOR.config.scayt_autoStartup = false;
                                // console.debug("load ckeditor for node: ",node.id);

                                CKEDITOR.replace(node.id);
                                var ckInstance = CKEDITOR.instances[node.id];
                                // console.debug("CKEditor instance: ", ckInstance);

                                ckInstance.on('contentDom', function(){
                                    xfControlDijit.setCurrentValue(ckInstance.getData());


                                    xfControlDijit.setValue = function (value) {
                                        ckInstance.setData(value);
                                    };

                                    ckInstance.on('blur',function(evt){
                                        xfControlDijit.sendValue(ckInstance.getData(), true);
                                    });

                                    ckInstance.on('focus',function(){
                                        xfControlDijit.handleOnFocus();
                                    });


                                    ckInstance.document.on( 'keyup', function(evt){
                                        // console.debug("ckInstance change value:",ckInstance.getData());
                                        // Do not capture CTRL hotkeys.
                                        if ( !evt.data.$.ctrlKey && !evt.data.$.metaKey){
                                            if(xfControlDijit.isIncremental()){
                                                xfControlDijit.sendValue(ckInstance.getData(),false);
                                            }

                                        }
                                    });

                                    xfControlDijit.setReadonly = function(){
                                        ckInstance.setReadOnly(true);
                                        domClass.replace(node,"xfReadOnly","xfReadWrite");
                                    };

                                    xfControlDijit.setReadwrite = function(){
                                        ckInstance.setReadOnly(false);
                                        domClass.replace(node,"xfReadWrite", "xfReadOnly");
                                    };


                                });

                                /*



                                connect.connect(node,"onkeyup",function(evt){
                                // console.debug("onkeypress",node);
                                xfControlDijit.sendValue(node.value,false);
                                });

                                */

                            });


                            break;
                        default:
                            console.warn("no mapping found for Node: ", node);

                    }
                }

            }
        );
    }
);


},
'dijit/a11y':function(){
define("dijit/a11y", [
	"dojo/_base/array", // array.forEach array.map
	"dojo/_base/config", // defaultDuration
	"dojo/_base/declare", // declare
	"dojo/dom",			// dom.byId
	"dojo/dom-attr", // domAttr.attr domAttr.has
	"dojo/dom-style", // style.style
	"dojo/_base/sniff", // has("ie")
	"./_base/manager",	// manager._isElementShown
	"."	// for exporting methods to dijit namespace
], function(array, config, declare, dom, domAttr, domStyle, has, manager, dijit){

	// module:
	//		dijit/a11y
	// summary:
	//		Accessibility utility functions (keyboard, tab stops, etc.)

	var shown = (dijit._isElementShown = function(/*Element*/ elem){
		var s = domStyle.get(elem);
		return (s.visibility != "hidden")
			&& (s.visibility != "collapsed")
			&& (s.display != "none")
			&& (domAttr.get(elem, "type") != "hidden");
	});

	dijit.hasDefaultTabStop = function(/*Element*/ elem){
		// summary:
		//		Tests if element is tab-navigable even without an explicit tabIndex setting

		// No explicit tabIndex setting, need to investigate node type
		switch(elem.nodeName.toLowerCase()){
			case "a":
				// An <a> w/out a tabindex is only navigable if it has an href
				return domAttr.has(elem, "href");
			case "area":
			case "button":
			case "input":
			case "object":
			case "select":
			case "textarea":
				// These are navigable by default
				return true;
			case "iframe":
				// If it's an editor <iframe> then it's tab navigable.
				var body;
				try{
					// non-IE
					var contentDocument = elem.contentDocument;
					if("designMode" in contentDocument && contentDocument.designMode == "on"){
						return true;
					}
					body = contentDocument.body;
				}catch(e1){
					// contentWindow.document isn't accessible within IE7/8
					// if the iframe.src points to a foreign url and this
					// page contains an element, that could get focus
					try{
						body = elem.contentWindow.document.body;
					}catch(e2){
						return false;
					}
				}
				return body && (body.contentEditable == 'true' ||
					(body.firstChild && body.firstChild.contentEditable == 'true'));
			default:
				return elem.contentEditable == 'true';
		}
	};

	var isTabNavigable = (dijit.isTabNavigable = function(/*Element*/ elem){
		// summary:
		//		Tests if an element is tab-navigable

		// TODO: convert (and rename method) to return effective tabIndex; will save time in _getTabNavigable()
		if(domAttr.get(elem, "disabled")){
			return false;
		}else if(domAttr.has(elem, "tabIndex")){
			// Explicit tab index setting
			return domAttr.get(elem, "tabIndex") >= 0; // boolean
		}else{
			// No explicit tabIndex setting, so depends on node type
			return dijit.hasDefaultTabStop(elem);
		}
	});

	dijit._getTabNavigable = function(/*DOMNode*/ root){
		// summary:
		//		Finds descendants of the specified root node.
		//
		// description:
		//		Finds the following descendants of the specified root node:
		//		* the first tab-navigable element in document order
		//		  without a tabIndex or with tabIndex="0"
		//		* the last tab-navigable element in document order
		//		  without a tabIndex or with tabIndex="0"
		//		* the first element in document order with the lowest
		//		  positive tabIndex value
		//		* the last element in document order with the highest
		//		  positive tabIndex value
		var first, last, lowest, lowestTabindex, highest, highestTabindex, radioSelected = {};

		function radioName(node){
			// If this element is part of a radio button group, return the name for that group.
			return node && node.tagName.toLowerCase() == "input" &&
				node.type && node.type.toLowerCase() == "radio" &&
				node.name && node.name.toLowerCase();
		}

		var walkTree = function(/*DOMNode*/parent){
			for(var child = parent.firstChild; child; child = child.nextSibling){
				// Skip text elements, hidden elements, and also non-HTML elements (those in custom namespaces) in IE,
				// since show() invokes getAttribute("type"), which crash on VML nodes in IE.
				if(child.nodeType != 1 || (has("ie") && child.scopeName !== "HTML") || !shown(child)){
					continue;
				}

				if(isTabNavigable(child)){
					var tabindex = domAttr.get(child, "tabIndex");
					if(!domAttr.has(child, "tabIndex") || tabindex == 0){
						if(!first){
							first = child;
						}
						last = child;
					}else if(tabindex > 0){
						if(!lowest || tabindex < lowestTabindex){
							lowestTabindex = tabindex;
							lowest = child;
						}
						if(!highest || tabindex >= highestTabindex){
							highestTabindex = tabindex;
							highest = child;
						}
					}
					var rn = radioName(child);
					if(domAttr.get(child, "checked") && rn){
						radioSelected[rn] = child;
					}
				}
				if(child.nodeName.toUpperCase() != 'SELECT'){
					walkTree(child);
				}
			}
		};
		if(shown(root)){
			walkTree(root);
		}
		function rs(node){
			// substitute checked radio button for unchecked one, if there is a checked one with the same name.
			return radioSelected[radioName(node)] || node;
		}

		return { first: rs(first), last: rs(last), lowest: rs(lowest), highest: rs(highest) };
	};
	dijit.getFirstInTabbingOrder = function(/*String|DOMNode*/ root){
		// summary:
		//		Finds the descendant of the specified root node
		//		that is first in the tabbing order
		var elems = dijit._getTabNavigable(dom.byId(root));
		return elems.lowest ? elems.lowest : elems.first; // DomNode
	};

	dijit.getLastInTabbingOrder = function(/*String|DOMNode*/ root){
		// summary:
		//		Finds the descendant of the specified root node
		//		that is last in the tabbing order
		var elems = dijit._getTabNavigable(dom.byId(root));
		return elems.last ? elems.last : elems.highest; // DomNode
	};

	return {
		hasDefaultTabStop: dijit.hasDefaultTabStop,
		isTabNavigable: dijit.isTabNavigable,
		_getTabNavigable: dijit._getTabNavigable,
		getFirstInTabbingOrder: dijit.getFirstInTabbingOrder,
		getLastInTabbingOrder: dijit.getLastInTabbingOrder
	};
});

},
'bf/Mapping':function(){
require(['dojo/_base/declare'],
    function(declare){
        declare("bf.Mapping",null, { });

        /**
         * This file contains all mappings from XForms controls to concrete widget used in the browser.
         *
         * XForms control types and their properties are represented by CSS classes that are present on the
         * output of the XSLT transform (defaults to xhtml.xsl) that is applied once when initing an XForms session.
         *
         * The mapping is hold in an array and each entry consists of a triple:
         * [1] CSS 3 matcher used to identify a specific control in the rendered DOM. Please note that all CSS 3 matchers
         *     can be used as far as they are supported by Dojo query (ver. 1.7 or above). Though most of the matchers
         *     are supported there are some exceptions. If in doubt please consult the official Dojo documentation at
         *     http://dojotoolkit.org.
         * [2] the module name of a JavaScript class. This can be either a factory class that creates the control by using
         *     the third argument or a class that is used directly to provide the widgets' implementation. In the latter
         *     case the third entry in the array may be omitted.
         * [3] a descriptive string (name) that is unique in the context of the given factory.
         *
         * Note: the order of the entries in this array is significant. That means that rules that come first are also
         * applied first to the rendered DOM.
         */
        bf.Mapping.data = [
            //todo: is there any reason why first entry of triple used single quotes while others use double quotes?
            // CONTAINER
            ['.xfGroup',            "bf/factory/FactoryContainer", "group"],
            ['.xfRepeat, .xfTbody',   "bf/factory/FactoryContainer", "repeat"],
            ['.xfSwitch.aDefault',  "bf/factory/FactoryContainer", "switch"],
            ['.xfSwitch.bfTabContainer',"bf/factory/FactoryContainer", "tabswitch"],
            ['.xfDialog',            "bf/factory/FactoryContainer", "dialog"],


            // INPUTS
            ['.xfControl', "bf/XFControl"],
            ['.xfInput:not(.xsdDate):not(.xsdDateTime):not(.xsdTime):not(.xsdBoolean):not(.aBfTimeline) .xfValue',     "bf/factory/FactoryInput", "text"],
            ['.xfInput.xsdBoolean > * >  .xfValue',                                                 "bf/factory/FactoryInput", "checkbox"],
            /*
            the following rule is special in that it matches for 'widgetContainer' and not 'xfValue'. The reason
            for this is the behavior of Dojo Dijits that replace the DOM Node they are applied to. But this creates
            problems with state handling which relies on the existence of these classes which Dojo does not preserver.
            Therefore here the Dijit is created as a child of 'widgetContainer'.
             */
            //todo: use descriptive names for the different types of controls
            ['body.uaDesktop .xfInput.xsdDate:not(.aBfDropdowndate) .widgetContainer', "bf/factory/FactoryInput", "date"],
            ['body.uaDesktop .xfInput.xsdDate.aBfDropdowndate .widgetContainer',       "bf/factory/FactoryInput", "dropDownDate"],

            ['body.uaDesktop .xfInput.xsdDateTime > * > .xfValue',              "bf/factory/FactoryInput", "dateTime"],

            ['body.uaDesktop .xfInput.xsdTime:not(.aBfTimetextbox):not(.aBfDropdowntime) > * >  .xfValue',        "bf/factory/FactoryInput", "htmlTime"],
            ['body.uaDesktop .xfInput.xsdTime.aBfTimetextbox > * >  .xfValue',  "bf/factory/FactoryInput", "timeTextBox"],
            ['body.uaDesktop .xfInput.xsdTime.aBfDropdowntime > * >  .xfValue', "bf/factory/FactoryInput", "dropDownTime"],
            //DateTime support for mobile might still be a problem and must be solved by a combination of controls
            ['body:not(.uaDesktop) .xfInput.xsdDate .xfValue',            "bf/factory/FactoryInput", "mobileDate"],
            ['body:not(.uaDesktop) .xfInput.xsdTime .xfValue',            "bf/factory/FactoryInput", "mobileTime"],
            ['body:not(.uaDesktop) .xfInput.xsdDateTime .xfValue',        "bf/factory/FactoryInput", "mobileDateTime"],


            // SECRET
            ['.xfSecret .xfValue', "bf/factory/FactorySecret", "password"],

            // SELECT1
            ['.xfSelect1:not(.aFull) .widgetContainer', "bf/factory/FactorySelect1", "combobox"],
            ['.xfSelect1.aFull .widgetContainer',       "bf/factory/FactorySelect1", "radiobuttons"],

            // SELECT
            ['.xfSelect.aMinimal .xfValue, .xfSelect.aDefault .xfValue, .xfSelect.aCompact .xfValue',   "bf/factory/FactorySelect", "listcontrol"],
            ['.xfSelect.aFull .xfValue',                                                                "bf/factory/FactorySelect", "checkboxes"],


            // OUTPUT
            ['.xfOutput.mediatypeText:not(.xsdAnyURI) .xfValue',    "bf/factory/FactoryOutput", "text"],
            ['.xfOutput.mediatypeImage .xfValue',   "bf/factory/FactoryOutput", "image"],
            ['.xfOutput.xsdAnyURI .xfValue',        "bf/factory/FactoryOutput", "link"],
            ['.xfOutput.mediatypeHtml .xfValue',    "bf/factory/FactoryOutput", "html"],

            // RANGE
            // matching widgetContainer instead of xfValue due to slider is a dijit control (see comments above)
            ['.xfRange:not(.aBfRating) .widgetContainer',    "bf/factory/FactoryRange", "slider"],
            ['.xfRange.aBfRating .widgetContainer',    "bf/factory/FactoryRange", "rating"],

            // TEXTAREA
            ['.xfTextarea.mediatypeText .xfValue',    "bf/factory/FactoryTextarea", "texteditor"],
            ['.xfTextarea.mediatypeHtml .xfValue',    "bf/factory/FactoryTextarea", "htmleditor"],

            // TRIGGER
            // this matcher handles several types of triggers like standard button, image button and link at once
            ['.xfTrigger.aMinimal .xfValue',   "bf/factory/FactoryTrigger", "link"],
            ['.xfTrigger:not(.aMinimal) .xfValue',   "bf/factory/FactoryTrigger", "button"],
            ['.xfSubmit:not(.aMinimal)  .xfValue',   "bf/factory/FactoryTrigger", "button"],

            // UPLOAD
            ['.xfUpload.xsdAnyURI .widgetContainer',    "bf/factory/FactoryUpload", "fileUpload"],
            ['.xfUpload.xsdBase64Binary .widgetContainer',    "bf/factory/FactoryUpload", "base64binary"],
            ['.xfUpload.xsdHexBinary .widgetContainer',    "bf/factory/FactoryUpload", "hexBinary"],

            // COMMON CHILDS
            ['body.ToolTipAlert',     "bf/common/AlertToolTip"],
            ['body.InlineAlert',      "bf/common/AlertInline"],

            // CUSTOM ENHANCEMENT
            ['.xfInput.aBfTimeline  .xfValue',  "bf/factory/FactoryInput", "timeline"]

        ];
    }
);
},
'bf/select/Select1ComboBox':function(){
define("bf/select/Select1ComboBox", ["dojo/_base/declare", "dijit/_Widget","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/_base/connect","dojo/query","dojo/dom"],
    function(declare, _Widget,domAttr,domClass,domConstruct,connect,query,dom){
        return declare(_Widget, {

            currentValue:null,

            postCreate:function() {
                // console.debug("Select1ComboBox postCreate id:",this.id);
                var bfHandleStateChanged = connect.subscribe("xforms-item-changed-" + this.id , this, "handleStateChanged");
                fluxProcessor.addSubscriber(this.id, bfHandleStateChanged);
                var bfHandleInsertItem = connect.subscribe("betterform-insert-item-" + this.id , this, "handleInsertItem");
                fluxProcessor.addSubscriber(this.id, bfHandleInsertItem);
                var bfHandleDeleteItem = connect.subscribe("betterform-delete-item-" + this.id , this, "handleDeleteItem");
                fluxProcessor.addSubscriber(this.id, bfHandleDeleteItem);

                this.currentValue = this.domNode.value;
            },

            handleInsertItem:function(contextInfo) {
                console.debug("Select1ComboBox.handleInsertItem: ", contextInfo, " currentValue: ", this.domNode.value);
                var position = contextInfo.position;
                var itemsetId = contextInfo.targetId;
                var generatedItemId =  contextInfo.generatedIds[contextInfo.prototypeId];
                // console.debug("generatedItemId: ",generatedItemId, " itemsetId: ",itemsetId);;
                var referenzedNode = query('option[data-bf-itemset=\"'+ itemsetId + '\"]',this.id)[0];
                //TODO: Quick Fix this needs to be fixed properly!!!!
                if (referenzedNode == undefined) {
                    referenzedNode = query('option[data-bf-itemset=\"'+ contextInfo.originalId + '\"]',this.id)[0];
                }
                var options = query('option',this.domNode);
                if (referenzedNode == undefined) {
                    // console.info("referenced node is sill undefined");
                    var emptyNode = options[0];
                    // console.debug("emptyNode",emptyNode, " id:generatedItemId ",generatedItemId);
                    var emptyOption = domConstruct.create("option", {id:generatedItemId}, emptyNode, "after");
                    domAttr.set(emptyOption, "data-bf-itemset", itemsetId);
                    // console.debug("emptyOption: ",emptyOption);
                }
                // console.debug("3. referenzedNode: ",referenzedNode, " position: ",position);
                if(referenzedNode){
                    var item = undefined;
                    if(position == 1){
                        item = domConstruct.create("option", {id:generatedItemId}, referenzedNode, "before");
                        domAttr.set(item, "data-bf-itemset", itemsetId);
                        // domAttr.remove(referenzedNode, "data-bf-itemset");
                        this.domNode.removeChild(referenzedNode);

                    }
                    else {
                        item = domConstruct.create("option", {id:generatedItemId}, options[options.length-1], "after");
                    }
                    domClass.add(item, "xfSelectorItem");
                }else {
                    console.warn("Select1ComboBox: itemset '",itemsetId,"' does not exist for Select1 [id:'",this.id ,"']");
                }
            },

            handleDeleteItem:function(contextInfo) {
                // console.debug("Select1Minimal.handleDeleteItem:  contextInfo:",contextInfo);
                var position = contextInfo.position;
                var itemsetId = contextInfo.targetId;

                var referenzedNode = query('option[data-bf-itemset=\"'+ itemsetId + '\"]',this.id)[0];
                // console.debug("handleDeleteItem: ",referenzedNode, " position:", position);
                var option2remove = undefined;
                if(referenzedNode){
                    if(position == 1){
                        option2remove = referenzedNode;
                    } else {
                        option2remove = this.getNthSiblingOption(position-1, referenzedNode);
                    }
                    this.domNode.removeChild(option2remove);
                }else {
                    console.warn("Select1ComboBox: itemset '",itemsetId,"' does not exist for Select1 [id:'",this.id ,"']");
                }
                // console.debug("handleDeleteItem: this.domNode",this.domNode);
            },

            handleStateChanged:function(contextInfo) {
                // console.debug("Select1Minimal.handleStateChanged contextInfo:",contextInfo, " this: " , this);
                var targetName = contextInfo.targetName;
                var option = dom.byId(contextInfo.parentId);
                var value = contextInfo.value;
                // label changed
                if(targetName == "label" && option){
                    option.innerHTML = value;
                }
                // value changed
                else if(targetName == "value" && option){
                    domAttr.set(option,"value",value);
                    // verify that value is the same as before the insert
                    // console.debug("Select1Minimal.handleStateChanged this.currentValue:",this.currentValue, " value: ",value);
                    if(this.currentValue == value){
                        domAttr.set(this.domNode,"value", value);
                    }
                }else {
                    console.warn("OptGroup.handleStateChanged: no action taken for contextInfo: ",contextInfo);
                }
            },

            getNthSiblingOption:function(position, referenzedNode){
                var siblingNode = referenzedNode;
                var counter = position;
                while(counter != 0) {
                    counter -= 1;
                    siblingNode = siblingNode.nextSibling;
                    // console.debug("getNthSiblingOption: siblingNode:",   siblingNode, " position: ",counter);
                }
                // console.debug("for position " + position + " and referenceNdoe ", referenzedNode, " the siblingNode is",siblingNode );
                return siblingNode;
            }
        });

    }
);
},
'dijit/_WidgetBase':function(){
define("dijit/_WidgetBase", [
	"require",			// require.toUrl
	"dojo/_base/array", // array.forEach array.map
	"dojo/aspect",
	"dojo/_base/config", // config.blankGif
	"dojo/_base/connect", // connect.connect
	"dojo/_base/declare", // declare
	"dojo/dom", // dom.byId
	"dojo/dom-attr", // domAttr.set domAttr.remove
	"dojo/dom-class", // domClass.add domClass.replace
	"dojo/dom-construct", // domConstruct.create domConstruct.destroy domConstruct.place
	"dojo/dom-geometry",	// isBodyLtr
	"dojo/dom-style", // domStyle.set, domStyle.get
	"dojo/_base/kernel",
	"dojo/_base/lang", // mixin(), isArray(), etc.
	"dojo/on",
	"dojo/ready",
	"dojo/Stateful", // Stateful
	"dojo/topic",
	"dojo/_base/window", // win.doc.createTextNode
	"./registry"	// registry.getUniqueId(), registry.findWidgets()
], function(require, array, aspect, config, connect, declare,
			dom, domAttr, domClass, domConstruct, domGeometry, domStyle, kernel,
			lang, on, ready, Stateful, topic, win, registry){

/*=====
var Stateful = dojo.Stateful;
=====*/

// module:
//		dijit/_WidgetBase
// summary:
//		Future base class for all Dijit widgets.

// For back-compat, remove in 2.0.
if(!kernel.isAsync){
	ready(0, function(){
		var requires = ["dijit/_base/manager"];
		require(requires);	// use indirection so modules not rolled into a build
	});
}

// Nested hash listing attributes for each tag, all strings in lowercase.
// ex: {"div": {"style": true, "tabindex" true}, "form": { ...
var tagAttrs = {};
function getAttrs(obj){
	var ret = {};
	for(var attr in obj){
		ret[attr.toLowerCase()] = true;
	}
	return ret;
}

function nonEmptyAttrToDom(attr){
	// summary:
	//		Returns a setter function that copies the attribute to this.domNode,
	//		or removes the attribute from this.domNode, depending on whether the
	//		value is defined or not.
	return function(val){
		domAttr[val ? "set" : "remove"](this.domNode, attr, val);
		this._set(attr, val);
	};
}

return declare("dijit._WidgetBase", Stateful, {
	// summary:
	//		Future base class for all Dijit widgets.
	// description:
	//		Future base class for all Dijit widgets.
	//		_Widget extends this class adding support for various features needed by desktop.
	//
	//		Provides stubs for widget lifecycle methods for subclasses to extend, like postMixInProperties(), buildRendering(),
	//		postCreate(), startup(), and destroy(), and also public API methods like set(), get(), and watch().
	//
	//		Widgets can provide custom setters/getters for widget attributes, which are called automatically by set(name, value).
	//		For an attribute XXX, define methods _setXXXAttr() and/or _getXXXAttr().
	//
	//		_setXXXAttr can also be a string/hash/array mapping from a widget attribute XXX to the widget's DOMNodes:
	//
	//		- DOM node attribute
	// |		_setFocusAttr: {node: "focusNode", type: "attribute"}
	// |		_setFocusAttr: "focusNode"	(shorthand)
	// |		_setFocusAttr: ""		(shorthand, maps to this.domNode)
	// 		Maps this.focus to this.focusNode.focus, or (last example) this.domNode.focus
	//
	//		- DOM node innerHTML
	//	|		_setTitleAttr: { node: "titleNode", type: "innerHTML" }
	//		Maps this.title to this.titleNode.innerHTML
	//
	//		- DOM node innerText
	//	|		_setTitleAttr: { node: "titleNode", type: "innerText" }
	//		Maps this.title to this.titleNode.innerText
	//
	//		- DOM node CSS class
	// |		_setMyClassAttr: { node: "domNode", type: "class" }
	//		Maps this.myClass to this.domNode.className
	//
	//		If the value of _setXXXAttr is an array, then each element in the array matches one of the
	//		formats of the above list.
	//
	//		If the custom setter is null, no action is performed other than saving the new value
	//		in the widget (in this).
	//
	//		If no custom setter is defined for an attribute, then it will be copied
	//		to this.focusNode (if the widget defines a focusNode), or this.domNode otherwise.
	//		That's only done though for attributes that match DOMNode attributes (title,
	//		alt, aria-labelledby, etc.)

	// id: [const] String
	//		A unique, opaque ID string that can be assigned by users or by the
	//		system. If the developer passes an ID which is known not to be
	//		unique, the specified ID is ignored and the system-generated ID is
	//		used instead.
	id: "",
	_setIdAttr: "domNode",	// to copy to this.domNode even for auto-generated id's

	// lang: [const] String
	//		Rarely used.  Overrides the default Dojo locale used to render this widget,
	//		as defined by the [HTML LANG](http://www.w3.org/TR/html401/struct/dirlang.html#adef-lang) attribute.
	//		Value must be among the list of locales specified during by the Dojo bootstrap,
	//		formatted according to [RFC 3066](http://www.ietf.org/rfc/rfc3066.txt) (like en-us).
	lang: "",
	// set on domNode even when there's a focus node.   but don't set lang="", since that's invalid.
	_setLangAttr: nonEmptyAttrToDom("lang"),

	// dir: [const] String
	//		Bi-directional support, as defined by the [HTML DIR](http://www.w3.org/TR/html401/struct/dirlang.html#adef-dir)
	//		attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
	//		default direction.
	dir: "",
	// set on domNode even when there's a focus node.   but don't set dir="", since that's invalid.
	_setDirAttr: nonEmptyAttrToDom("dir"),	// to set on domNode even when there's a focus node

	// textDir: String
	//		Bi-directional support,	the main variable which is responsible for the direction of the text.
	//		The text direction can be different than the GUI direction by using this parameter in creation
	//		of a widget.
	// 		Allowed values:
	//			1. "ltr"
	//			2. "rtl"
	//			3. "auto" - contextual the direction of a text defined by first strong letter.
	//		By default is as the page direction.
	textDir: "",

	// class: String
	//		HTML class attribute
	"class": "",
	_setClassAttr: { node: "domNode", type: "class" },

	// style: String||Object
	//		HTML style attributes as cssText string or name/value hash
	style: "",

	// title: String
	//		HTML title attribute.
	//
	//		For form widgets this specifies a tooltip to display when hovering over
	//		the widget (just like the native HTML title attribute).
	//
	//		For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
	//		etc., it's used to specify the tab label, accordion pane title, etc.
	title: "",

	// tooltip: String
	//		When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
	//		this specifies the tooltip to appear when the mouse is hovered over that text.
	tooltip: "",

	// baseClass: [protected] String
	//		Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
	//		widget state.
	baseClass: "",

	// srcNodeRef: [readonly] DomNode
	//		pointer to original DOM node
	srcNodeRef: null,

	// domNode: [readonly] DomNode
	//		This is our visible representation of the widget! Other DOM
	//		Nodes may by assigned to other properties, usually through the
	//		template system's data-dojo-attach-point syntax, but the domNode
	//		property is the canonical "top level" node in widget UI.
	domNode: null,

	// containerNode: [readonly] DomNode
	//		Designates where children of the source DOM node will be placed.
	//		"Children" in this case refers to both DOM nodes and widgets.
	//		For example, for myWidget:
	//
	//		|	<div data-dojo-type=myWidget>
	//		|		<b> here's a plain DOM node
	//		|		<span data-dojo-type=subWidget>and a widget</span>
	//		|		<i> and another plain DOM node </i>
	//		|	</div>
	//
	//		containerNode would point to:
	//
	//		|		<b> here's a plain DOM node
	//		|		<span data-dojo-type=subWidget>and a widget</span>
	//		|		<i> and another plain DOM node </i>
	//
	//		In templated widgets, "containerNode" is set via a
	//		data-dojo-attach-point assignment.
	//
	//		containerNode must be defined for any widget that accepts innerHTML
	//		(like ContentPane or BorderContainer or even Button), and conversely
	//		is null for widgets that don't, like TextBox.
	containerNode: null,

/*=====
	// _started: Boolean
	//		startup() has completed.
	_started: false,
=====*/

	// attributeMap: [protected] Object
	//		Deprecated.   Instead of attributeMap, widget should have a _setXXXAttr attribute
	//		for each XXX attribute to be mapped to the DOM.
	//
	//		attributeMap sets up a "binding" between attributes (aka properties)
	//		of the widget and the widget's DOM.
	//		Changes to widget attributes listed in attributeMap will be
	//		reflected into the DOM.
	//
	//		For example, calling set('title', 'hello')
	//		on a TitlePane will automatically cause the TitlePane's DOM to update
	//		with the new title.
	//
	//		attributeMap is a hash where the key is an attribute of the widget,
	//		and the value reflects a binding to a:
	//
	//		- DOM node attribute
	// |		focus: {node: "focusNode", type: "attribute"}
	// 		Maps this.focus to this.focusNode.focus
	//
	//		- DOM node innerHTML
	//	|		title: { node: "titleNode", type: "innerHTML" }
	//		Maps this.title to this.titleNode.innerHTML
	//
	//		- DOM node innerText
	//	|		title: { node: "titleNode", type: "innerText" }
	//		Maps this.title to this.titleNode.innerText
	//
	//		- DOM node CSS class
	// |		myClass: { node: "domNode", type: "class" }
	//		Maps this.myClass to this.domNode.className
	//
	//		If the value is an array, then each element in the array matches one of the
	//		formats of the above list.
	//
	//		There are also some shorthands for backwards compatibility:
	//		- string --> { node: string, type: "attribute" }, for example:
	//	|	"focusNode" ---> { node: "focusNode", type: "attribute" }
	//		- "" --> { node: "domNode", type: "attribute" }
	attributeMap: {},

	// _blankGif: [protected] String
	//		Path to a blank 1x1 image.
	//		Used by <img> nodes in templates that really get their image via CSS background-image.
	_blankGif: config.blankGif || require.toUrl("dojo/resources/blank.gif"),

	//////////// INITIALIZATION METHODS ///////////////////////////////////////

	postscript: function(/*Object?*/params, /*DomNode|String*/srcNodeRef){
		// summary:
		//		Kicks off widget instantiation.  See create() for details.
		// tags:
		//		private
		this.create(params, srcNodeRef);
	},

	create: function(/*Object?*/params, /*DomNode|String?*/srcNodeRef){
		// summary:
		//		Kick off the life-cycle of a widget
		// params:
		//		Hash of initialization parameters for widget, including
		//		scalar values (like title, duration etc.) and functions,
		//		typically callbacks like onClick.
		// srcNodeRef:
		//		If a srcNodeRef (DOM node) is specified:
		//			- use srcNodeRef.innerHTML as my contents
		//			- if this is a behavioral widget then apply behavior
		//			  to that srcNodeRef
		//			- otherwise, replace srcNodeRef with my generated DOM
		//			  tree
		// description:
		//		Create calls a number of widget methods (postMixInProperties, buildRendering, postCreate,
		//		etc.), some of which of you'll want to override. See http://dojotoolkit.org/reference-guide/dijit/_WidgetBase.html
		//		for a discussion of the widget creation lifecycle.
		//
		//		Of course, adventurous developers could override create entirely, but this should
		//		only be done as a last resort.
		// tags:
		//		private

		// store pointer to original DOM tree
		this.srcNodeRef = dom.byId(srcNodeRef);

		// For garbage collection.  An array of listener handles returned by this.connect() / this.subscribe()
		this._connects = [];

		// For widgets internal to this widget, invisible to calling code
		this._supportingWidgets = [];

		// this is here for back-compat, remove in 2.0 (but check NodeList-instantiate.html test)
		if(this.srcNodeRef && (typeof this.srcNodeRef.id == "string")){ this.id = this.srcNodeRef.id; }

		// mix in our passed parameters
		if(params){
			this.params = params;
			lang.mixin(this, params);
		}
		this.postMixInProperties();

		// generate an id for the widget if one wasn't specified
		// (be sure to do this before buildRendering() because that function might
		// expect the id to be there.)
		if(!this.id){
			this.id = registry.getUniqueId(this.declaredClass.replace(/\./g,"_"));
		}
		registry.add(this);

		this.buildRendering();

		if(this.domNode){
			// Copy attributes listed in attributeMap into the [newly created] DOM for the widget.
			// Also calls custom setters for all attributes with custom setters.
			this._applyAttributes();

			// If srcNodeRef was specified, then swap out original srcNode for this widget's DOM tree.
			// For 2.0, move this after postCreate().  postCreate() shouldn't depend on the
			// widget being attached to the DOM since it isn't when a widget is created programmatically like
			// new MyWidget({}).   See #11635.
			var source = this.srcNodeRef;
			if(source && source.parentNode && this.domNode !== source){
				source.parentNode.replaceChild(this.domNode, source);
			}
		}

		if(this.domNode){
			// Note: for 2.0 may want to rename widgetId to dojo._scopeName + "_widgetId",
			// assuming that dojo._scopeName even exists in 2.0
			this.domNode.setAttribute("widgetId", this.id);
		}
		this.postCreate();

		// If srcNodeRef has been processed and removed from the DOM (e.g. TemplatedWidget) then delete it to allow GC.
		if(this.srcNodeRef && !this.srcNodeRef.parentNode){
			delete this.srcNodeRef;
		}

		this._created = true;
	},

	_applyAttributes: function(){
		// summary:
		//		Step during widget creation to copy  widget attributes to the
		//		DOM according to attributeMap and _setXXXAttr objects, and also to call
		//		custom _setXXXAttr() methods.
		//
		//		Skips over blank/false attribute values, unless they were explicitly specified
		//		as parameters to the widget, since those are the default anyway,
		//		and setting tabIndex="" is different than not setting tabIndex at all.
		//
		//		For backwards-compatibility reasons attributeMap overrides _setXXXAttr when
		//		_setXXXAttr is a hash/string/array, but _setXXXAttr as a functions override attributeMap.
		// tags:
		//		private

		// Get list of attributes where this.set(name, value) will do something beyond
		// setting this[name] = value.  Specifically, attributes that have:
		//		- associated _setXXXAttr() method/hash/string/array
		//		- entries in attributeMap.
		var ctor = this.constructor,
			list = ctor._setterAttrs;
		if(!list){
			list = (ctor._setterAttrs = []);
			for(var attr in this.attributeMap){
				list.push(attr);
			}

			var proto = ctor.prototype;
			for(var fxName in proto){
				if(fxName in this.attributeMap){ continue; }
				var setterName = "_set" + fxName.replace(/^[a-z]|-[a-zA-Z]/g, function(c){ return c.charAt(c.length-1).toUpperCase(); }) + "Attr";
				if(setterName in proto){
					list.push(fxName);
				}
			}
		}

		// Call this.set() for each attribute that was either specified as parameter to constructor,
		// or was found above and has a default non-null value.   For correlated attributes like value and displayedValue, the one
		// specified as a parameter should take precedence, so apply attributes in this.params last.
		// Particularly important for new DateTextBox({displayedValue: ...}) since DateTextBox's default value is
		// NaN and thus is not ignored like a default value of "".
		array.forEach(list, function(attr){
			if(this.params && attr in this.params){
				// skip this one, do it below
			}else if(this[attr]){
				this.set(attr, this[attr]);
			}
		}, this);
		for(var param in this.params){
			this.set(param, this[param]);
		}
	},

	postMixInProperties: function(){
		// summary:
		//		Called after the parameters to the widget have been read-in,
		//		but before the widget template is instantiated. Especially
		//		useful to set properties that are referenced in the widget
		//		template.
		// tags:
		//		protected
	},

	buildRendering: function(){
		// summary:
		//		Construct the UI for this widget, setting this.domNode.
		//		Most widgets will mixin `dijit._TemplatedMixin`, which implements this method.
		// tags:
		//		protected

		if(!this.domNode){
			// Create root node if it wasn't created by _Templated
			this.domNode = this.srcNodeRef || domConstruct.create('div');
		}

		// baseClass is a single class name or occasionally a space-separated list of names.
		// Add those classes to the DOMNode.  If RTL mode then also add with Rtl suffix.
		// TODO: make baseClass custom setter
		if(this.baseClass){
			var classes = this.baseClass.split(" ");
			if(!this.isLeftToRight()){
				classes = classes.concat( array.map(classes, function(name){ return name+"Rtl"; }));
			}
			domClass.add(this.domNode, classes);
		}
	},

	postCreate: function(){
		// summary:
		//		Processing after the DOM fragment is created
		// description:
		//		Called after the DOM fragment has been created, but not necessarily
		//		added to the document.  Do not include any operations which rely on
		//		node dimensions or placement.
		// tags:
		//		protected
	},

	startup: function(){
		// summary:
		//		Processing after the DOM fragment is added to the document
		// description:
		//		Called after a widget and its children have been created and added to the page,
		//		and all related widgets have finished their create() cycle, up through postCreate().
		//		This is useful for composite widgets that need to control or layout sub-widgets.
		//		Many layout widgets can use this as a wiring phase.
		if(this._started){ return; }
		this._started = true;
		array.forEach(this.getChildren(), function(obj){
			if(!obj._started && !obj._destroyed && lang.isFunction(obj.startup)){
				obj.startup();
				obj._started = true;
			}
		});
	},

	//////////// DESTROY FUNCTIONS ////////////////////////////////

	destroyRecursive: function(/*Boolean?*/ preserveDom){
		// summary:
		// 		Destroy this widget and its descendants
		// description:
		//		This is the generic "destructor" function that all widget users
		// 		should call to cleanly discard with a widget. Once a widget is
		// 		destroyed, it is removed from the manager object.
		// preserveDom:
		//		If true, this method will leave the original DOM structure
		//		alone of descendant Widgets. Note: This will NOT work with
		//		dijit._Templated widgets.

		this._beingDestroyed = true;
		this.destroyDescendants(preserveDom);
		this.destroy(preserveDom);
	},

	destroy: function(/*Boolean*/ preserveDom){
		// summary:
		// 		Destroy this widget, but not its descendants.
		//		This method will, however, destroy internal widgets such as those used within a template.
		// preserveDom: Boolean
		//		If true, this method will leave the original DOM structure alone.
		//		Note: This will not yet work with _Templated widgets

		this._beingDestroyed = true;
		this.uninitialize();

		// remove this.connect() and this.subscribe() listeners
		var c;
		while(c = this._connects.pop()){
			c.remove();
		}

		// destroy widgets created as part of template, etc.
		var w;
		while(w = this._supportingWidgets.pop()){
			if(w.destroyRecursive){
				w.destroyRecursive();
			}else if(w.destroy){
				w.destroy();
			}
		}

		this.destroyRendering(preserveDom);
		registry.remove(this.id);
		this._destroyed = true;
	},

	destroyRendering: function(/*Boolean?*/ preserveDom){
		// summary:
		//		Destroys the DOM nodes associated with this widget
		// preserveDom:
		//		If true, this method will leave the original DOM structure alone
		//		during tear-down. Note: this will not work with _Templated
		//		widgets yet.
		// tags:
		//		protected

		if(this.bgIframe){
			this.bgIframe.destroy(preserveDom);
			delete this.bgIframe;
		}

		if(this.domNode){
			if(preserveDom){
				domAttr.remove(this.domNode, "widgetId");
			}else{
				domConstruct.destroy(this.domNode);
			}
			delete this.domNode;
		}

		if(this.srcNodeRef){
			if(!preserveDom){
				domConstruct.destroy(this.srcNodeRef);
			}
			delete this.srcNodeRef;
		}
	},

	destroyDescendants: function(/*Boolean?*/ preserveDom){
		// summary:
		//		Recursively destroy the children of this widget and their
		//		descendants.
		// preserveDom:
		//		If true, the preserveDom attribute is passed to all descendant
		//		widget's .destroy() method. Not for use with _Templated
		//		widgets.

		// get all direct descendants and destroy them recursively
		array.forEach(this.getChildren(), function(widget){
			if(widget.destroyRecursive){
				widget.destroyRecursive(preserveDom);
			}
		});
	},

	uninitialize: function(){
		// summary:
		//		Stub function. Override to implement custom widget tear-down
		//		behavior.
		// tags:
		//		protected
		return false;
	},

	////////////////// GET/SET, CUSTOM SETTERS, ETC. ///////////////////

	_setStyleAttr: function(/*String||Object*/ value){
		// summary:
		//		Sets the style attribute of the widget according to value,
		//		which is either a hash like {height: "5px", width: "3px"}
		//		or a plain string
		// description:
		//		Determines which node to set the style on based on style setting
		//		in attributeMap.
		// tags:
		//		protected

		var mapNode = this.domNode;

		// Note: technically we should revert any style setting made in a previous call
		// to his method, but that's difficult to keep track of.

		if(lang.isObject(value)){
			domStyle.set(mapNode, value);
		}else{
			if(mapNode.style.cssText){
				mapNode.style.cssText += "; " + value;
			}else{
				mapNode.style.cssText = value;
			}
		}

		this._set("style", value);
	},

	_attrToDom: function(/*String*/ attr, /*String*/ value, /*Object?*/ commands){
		// summary:
		//		Reflect a widget attribute (title, tabIndex, duration etc.) to
		//		the widget DOM, as specified by commands parameter.
		//		If commands isn't specified then it's looked up from attributeMap.
		//		Note some attributes like "type"
		//		cannot be processed this way as they are not mutable.
		//
		// tags:
		//		private

		commands = arguments.length >= 3 ? commands : this.attributeMap[attr];

		array.forEach(lang.isArray(commands) ? commands : [commands], function(command){

			// Get target node and what we are doing to that node
			var mapNode = this[command.node || command || "domNode"];	// DOM node
			var type = command.type || "attribute";	// class, innerHTML, innerText, or attribute

			switch(type){
				case "attribute":
					if(lang.isFunction(value)){ // functions execute in the context of the widget
						value = lang.hitch(this, value);
					}

					// Get the name of the DOM node attribute; usually it's the same
					// as the name of the attribute in the widget (attr), but can be overridden.
					// Also maps handler names to lowercase, like onSubmit --> onsubmit
					var attrName = command.attribute ? command.attribute :
						(/^on[A-Z][a-zA-Z]*$/.test(attr) ? attr.toLowerCase() : attr);

					domAttr.set(mapNode, attrName, value);
					break;
				case "innerText":
					mapNode.innerHTML = "";
					mapNode.appendChild(win.doc.createTextNode(value));
					break;
				case "innerHTML":
					mapNode.innerHTML = value;
					break;
				case "class":
					domClass.replace(mapNode, value, this[attr]);
					break;
			}
		}, this);
	},

	get: function(name){
		// summary:
		//		Get a property from a widget.
		//	name:
		//		The property to get.
		// description:
		//		Get a named property from a widget. The property may
		//		potentially be retrieved via a getter method. If no getter is defined, this
		// 		just retrieves the object's property.
		//
		// 		For example, if the widget has properties `foo` and `bar`
		//		and a method named `_getFooAttr()`, calling:
		//		`myWidget.get("foo")` would be equivalent to calling
		//		`widget._getFooAttr()` and `myWidget.get("bar")`
		//		would be equivalent to the expression
		//		`widget.bar2`
		var names = this._getAttrNames(name);
		return this[names.g] ? this[names.g]() : this[name];
	},

	set: function(name, value){
		// summary:
		//		Set a property on a widget
		//	name:
		//		The property to set.
		//	value:
		//		The value to set in the property.
		// description:
		//		Sets named properties on a widget which may potentially be handled by a
		// 		setter in the widget.
		//
		// 		For example, if the widget has properties `foo` and `bar`
		//		and a method named `_setFooAttr()`, calling
		//		`myWidget.set("foo", "Howdy!")` would be equivalent to calling
		//		`widget._setFooAttr("Howdy!")` and `myWidget.set("bar", 3)`
		//		would be equivalent to the statement `widget.bar = 3;`
		//
		//		set() may also be called with a hash of name/value pairs, ex:
		//
		//	|	myWidget.set({
		//	|		foo: "Howdy",
		//	|		bar: 3
		//	|	});
		//
		//	This is equivalent to calling `set(foo, "Howdy")` and `set(bar, 3)`

		if(typeof name === "object"){
			for(var x in name){
				this.set(x, name[x]);
			}
			return this;
		}
		var names = this._getAttrNames(name),
			setter = this[names.s];
		if(lang.isFunction(setter)){
			// use the explicit setter
			var result = setter.apply(this, Array.prototype.slice.call(arguments, 1));
		}else{
			// Mapping from widget attribute to DOMNode attribute/value/etc.
			// Map according to:
			//		1. attributeMap setting, if one exists (TODO: attributeMap deprecated, remove in 2.0)
			//		2. _setFooAttr: {...} type attribute in the widget (if one exists)
			//		3. apply to focusNode or domNode if standard attribute name, excluding funcs like onClick.
			// Checks if an attribute is a "standard attribute" by whether the DOMNode JS object has a similar
			// attribute name (ex: accept-charset attribute matches jsObject.acceptCharset).
			// Note also that Tree.focusNode() is a function not a DOMNode, so test for that.
			var defaultNode = this.focusNode && !lang.isFunction(this.focusNode) ? "focusNode" : "domNode",
				tag = this[defaultNode].tagName,
				attrsForTag = tagAttrs[tag] || (tagAttrs[tag] = getAttrs(this[defaultNode])),
				map =	name in this.attributeMap ? this.attributeMap[name] :
						names.s in this ? this[names.s] :
						((names.l in attrsForTag && typeof value != "function") ||
							/^aria-|^data-|^role$/.test(name)) ? defaultNode : null;
			if(map != null){
				this._attrToDom(name, value, map);
			}
			this._set(name, value);
		}
		return result || this;
	},

	_attrPairNames: {},		// shared between all widgets
	_getAttrNames: function(name){
		// summary:
		//		Helper function for get() and set().
		//		Caches attribute name values so we don't do the string ops every time.
		// tags:
		//		private

		var apn = this._attrPairNames;
		if(apn[name]){ return apn[name]; }
		var uc = name.replace(/^[a-z]|-[a-zA-Z]/g, function(c){ return c.charAt(c.length-1).toUpperCase(); });
		return (apn[name] = {
			n: name+"Node",
			s: "_set"+uc+"Attr",	// converts dashes to camel case, ex: accept-charset --> _setAcceptCharsetAttr
			g: "_get"+uc+"Attr",
			l: uc.toLowerCase()		// lowercase name w/out dashes, ex: acceptcharset
		});
	},

	_set: function(/*String*/ name, /*anything*/ value){
		// summary:
		//		Helper function to set new value for specified attribute, and call handlers
		//		registered with watch() if the value has changed.
		var oldValue = this[name];
		this[name] = value;
		if(this._watchCallbacks && this._created && value !== oldValue){
			this._watchCallbacks(name, oldValue, value);
		}
	},

	on: function(/*String*/ type, /*Function*/ func){
		// summary:
		//		Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
		// description:
		//		Call specified function when event `type` occurs, ex: `myWidget.on("click", function(){ ... })`.
		//		Note that the function is not run in any particular scope, so if (for example) you want it to run in the
		//		widget's scope you must do `myWidget.on("click", lang.hitch(myWidget, func))`.

		return aspect.after(this, this._onMap(type), func, true);
	},

	_onMap: function(/*String*/ type){
		// summary:
		//		Maps on() type parameter (ex: "mousemove") to method name (ex: "onMouseMove")
		var ctor = this.constructor, map = ctor._onMap;
		if(!map){
			map = (ctor._onMap = {});
			for(var attr in ctor.prototype){
				if(/^on/.test(attr)){
					map[attr.replace(/^on/, "").toLowerCase()] = attr;
				}
			}
		}
		return map[type.toLowerCase()];	// String
	},

	toString: function(){
		// summary:
		//		Returns a string that represents the widget
		// description:
		//		When a widget is cast to a string, this method will be used to generate the
		//		output. Currently, it does not implement any sort of reversible
		//		serialization.
		return '[Widget ' + this.declaredClass + ', ' + (this.id || 'NO ID') + ']'; // String
	},

	getChildren: function(){
		// summary:
		//		Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
		//		Does not return nested widgets, nor widgets that are part of this widget's template.
		return this.containerNode ? registry.findWidgets(this.containerNode) : []; // dijit._Widget[]
	},

	getParent: function(){
		// summary:
		//		Returns the parent widget of this widget
		return registry.getEnclosingWidget(this.domNode.parentNode);
	},

	connect: function(
			/*Object|null*/ obj,
			/*String|Function*/ event,
			/*String|Function*/ method){
		// summary:
		//		Connects specified obj/event to specified method of this object
		//		and registers for disconnect() on widget destroy.
		// description:
		//		Provide widget-specific analog to dojo.connect, except with the
		//		implicit use of this widget as the target object.
		//		Events connected with `this.connect` are disconnected upon
		//		destruction.
		// returns:
		//		A handle that can be passed to `disconnect` in order to disconnect before
		//		the widget is destroyed.
		// example:
		//	|	var btn = new dijit.form.Button();
		//	|	// when foo.bar() is called, call the listener we're going to
		//	|	// provide in the scope of btn
		//	|	btn.connect(foo, "bar", function(){
		//	|		console.debug(this.toString());
		//	|	});
		// tags:
		//		protected

		var handle = connect.connect(obj, event, this, method);
		this._connects.push(handle);
		return handle;		// _Widget.Handle
	},

	disconnect: function(handle){
		// summary:
		//		Disconnects handle created by `connect`.
		//		Also removes handle from this widget's list of connects.
		// tags:
		//		protected
		var i = array.indexOf(this._connects, handle);
		if(i != -1){
			handle.remove();
			this._connects.splice(i, 1);
		}
	},

	subscribe: function(t, method){
		// summary:
		//		Subscribes to the specified topic and calls the specified method
		//		of this object and registers for unsubscribe() on widget destroy.
		// description:
		//		Provide widget-specific analog to dojo.subscribe, except with the
		//		implicit use of this widget as the target object.
		// t: String
		//		The topic
		// method: Function
		//		The callback
		// example:
		//	|	var btn = new dijit.form.Button();
		//	|	// when /my/topic is published, this button changes its label to
		//	|   // be the parameter of the topic.
		//	|	btn.subscribe("/my/topic", function(v){
		//	|		this.set("label", v);
		//	|	});
		// tags:
		//		protected
		var handle = topic.subscribe(t, lang.hitch(this, method));
		this._connects.push(handle);
		return handle;		// _Widget.Handle
	},

	unsubscribe: function(/*Object*/ handle){
		// summary:
		//		Unsubscribes handle created by this.subscribe.
		//		Also removes handle from this widget's list of subscriptions
		// tags:
		//		protected
		this.disconnect(handle);
	},

	isLeftToRight: function(){
		// summary:
		//		Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
		// tags:
		//		protected
		return this.dir ? (this.dir == "ltr") : domGeometry.isBodyLtr(); //Boolean
	},

	isFocusable: function(){
		// summary:
		//		Return true if this widget can currently be focused
		//		and false if not
		return this.focus && (domStyle.get(this.domNode, "display") != "none");
	},

	placeAt: function(/* String|DomNode|_Widget */reference, /* String?|Int? */position){
		// summary:
		//		Place this widget's domNode reference somewhere in the DOM based
		//		on standard domConstruct.place conventions, or passing a Widget reference that
		//		contains and addChild member.
		//
		// description:
		//		A convenience function provided in all _Widgets, providing a simple
		//		shorthand mechanism to put an existing (or newly created) Widget
		//		somewhere in the dom, and allow chaining.
		//
		// reference:
		//		The String id of a domNode, a domNode reference, or a reference to a Widget possessing
		//		an addChild method.
		//
		// position:
		//		If passed a string or domNode reference, the position argument
		//		accepts a string just as domConstruct.place does, one of: "first", "last",
		//		"before", or "after".
		//
		//		If passed a _Widget reference, and that widget reference has an ".addChild" method,
		//		it will be called passing this widget instance into that method, supplying the optional
		//		position index passed.
		//
		// returns:
		//		dijit._Widget
		//		Provides a useful return of the newly created dijit._Widget instance so you
		//		can "chain" this function by instantiating, placing, then saving the return value
		//		to a variable.
		//
		// example:
		// | 	// create a Button with no srcNodeRef, and place it in the body:
		// | 	var button = new dijit.form.Button({ label:"click" }).placeAt(win.body());
		// | 	// now, 'button' is still the widget reference to the newly created button
		// | 	button.on("click", function(e){ console.log('click'); }));
		//
		// example:
		// |	// create a button out of a node with id="src" and append it to id="wrapper":
		// | 	var button = new dijit.form.Button({},"src").placeAt("wrapper");
		//
		// example:
		// |	// place a new button as the first element of some div
		// |	var button = new dijit.form.Button({ label:"click" }).placeAt("wrapper","first");
		//
		// example:
		// |	// create a contentpane and add it to a TabContainer
		// |	var tc = dijit.byId("myTabs");
		// |	new dijit.layout.ContentPane({ href:"foo.html", title:"Wow!" }).placeAt(tc)

		if(reference.declaredClass && reference.addChild){
			reference.addChild(this, position);
		}else{
			domConstruct.place(this.domNode, reference, position);
		}
		return this;
	},

	getTextDir: function(/*String*/ text,/*String*/ originalDir){
		// summary:
		//		Return direction of the text.
		//		The function overridden in the _BidiSupport module,
		//		its main purpose is to calculate the direction of the
		//		text, if was defined by the programmer through textDir.
		//	tags:
		//		protected.
		return originalDir;
	},

	applyTextDir: function(/*===== element, text =====*/){
		// summary:
		//		The function overridden in the _BidiSupport module,
		//		originally used for setting element.dir according to this.textDir.
		//		In this case does nothing.
		// element: DOMNode
		// text: String
		// tags:
		//		protected.
	}
});

});

},
'bf/common/Alert':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */

define("bf/common/Alert", ["dojo/_base/declare","dojo/_base/window","dojo/dom-class","dijit/registry","dojo/query","dojo/dom","dojo/_base/connect"],
    function(declare,win,domClass,registry,query,dom,connect){
        return declare(null, {

        alert:"alert",
        hint:"hint",
        info:"info",
        none:"none",
        alwaysShowHint: query(".bfAlwaysShowHint", win.body())[0],

            constructor:function() {
                // console.debug("Alert.constructor this:",this);
                connect.subscribe("xforms-valid", this, "handleValid");
                connect.subscribe("xforms-invalid", this, "handleInvalid");
            },


            handleValid:function (id, action) {
                // TODO: applyChanges must remove an existing alert

                if(action == "init") {
                    // do nothing on init
                    return;
                }
                // console.debug("Alert.handleValid[id:" + id, " action: " + action + "]");

                var control = registry.byId(id);
                var controlValueIsEmpty;
                if (control == null) {
                    // check if controls is a XFContainer
                    control = dom.byId(id);
                    if(control != undefined){
                        controlValueIsEmpty = true;
                    }else {
                        // console.warn("Alert.handleValid: control '" + id + "' does not exist");
                        return;
                    }
                }else {
                    controlValueIsEmpty = this._controlValueIsEmpty(control);
                }
                // console.debug("control: ",control);


                // console.debug("controlValueIsEmpty:",controlValueIsEmpty, " control.getControlValue(): ",control.getControlValue());

                if(action == "xfDisabled" || action == "changeAlertType" || ((action == "applyChanges" || action == "onBlur") && controlValueIsEmpty)) {
                    this._displayNone(id, action);
                }
                if(action == "onFocus" && (controlValueIsEmpty || this.alwaysShowHint != undefined)) {
                    this._displayHint(id, action);
                }
                else if((action == "applyChanges" || action == "onBlur") && !controlValueIsEmpty) {
                    this._displayInfo(id, action);
                }else {
                    // console.info("Alert.handleValid: action:'", action, "' unknown, commonChild handling for control '", id, "', execution stopped");
                }

                var controlDomNode = (control.domNode) ? control.domNode : control;
                if(domClass.contains(controlDomNode, "bfInvalidControl")) {
                    domClass.remove(controlDomNode, "bfInvalidControl");
                }
            },

        handleInvalid:function(id,action) {
            // console.debug("Alert.handleInvalid [id:" + id , " action: " + action + "]");

            //##### SHOW NOTHING ON INIT #######
            var control = registry.byId(id);
            if(control == null) {
                console.info("Alert.handleInvalid: control '" +id +"' does not exist");
                return;
            }

            // console.debug("control: ",control);

            // evaluate if control value is empty
            var controlValueIsEmpty = this._controlValueIsEmpty(control);

            // console.debug("controlValueIsEmpty:",controlValueIsEmpty, " control.getControlValue(): ",control.getControlValue());
            if(dom.byId(id + "-" + this.alert) == undefined || action == "init" || action == "changeAlertType") {
                return;
            }

    /*
            else if((action == "xfDisabled"|| action =="onBlur" || action =="applyChanges") && controlValueIsEmpty) {
                this._displayNone(id,action);
            }
    */

            else if(action == "onFocus" && (controlValueIsEmpty || this.alwaysShowHint != undefined) ) {
                this._displayHint(id,action);
                return;
            }
            //##### SHOW ALERT #######
            else if(action == "onFocus" || action == "xfDisabled"|| action =="onBlur" || action =="applyChanges" || action == "invalid" || action == "submitError"){
                this._displayAlert(id,action);
            }

            //##### SHOW ALL ALERTS IN RESPONSE TO SUBMIT ERRORS #######
    /*
            else if(action == "submitError") {
                this._displayAlert(id,action);
                return;
            }
    */
            if(!domClass.contains(control.domNode,"bfInvalidControl")) {
                domClass.add(control.domNode,"bfInvalidControl");
            }
        },

        _displayAlert:function(id,action) {
            this._show(id,this.alert,action);
            this._hide(id,this.hint,action);
            this._hide(id,this.info,action);
        },

        _displayHint:function(id,action) {
            this._show(id,this.hint,  action);
            this._hide(id,this.alert, action);
            this._hide(id,this.info,  action);
        },

        _displayInfo:function(id,action) {
            this._show(id,this.info,  action);
            this._hide(id,this.hint,  action);
            this._hide(id,this.alert, action);

        },

        _displayNone:function(id,action) {
            this._hide(id,this.alert, action);
            this._hide(id,this.hint,  action);
            this._hide(id,this.info, action);
        },


        _show:function(id, commonChild,action) {
            console.error("Alert._show must be overwritten by its extending class");
        },


        _hide:function(id, commonChild,action) {
            console.error("Alert._hide must be overwritten by its extending class");
        },

        _controlValueIsEmpty:function(controlDijit){

            var controlValueIsEmpty = false;
            var controlValue = controlDijit.getControlValue();
            if (controlValue == undefined ||  controlValue == '') {
                controlValueIsEmpty =  true;
            }else if (domClass.contains(controlDijit.domNode, "xsdBoolean") && !controlValue) {
                controlValueIsEmpty = true;
            } else if (domClass.contains(controlDijit.domNode, "xfRange") && (controlValue == 0 || controlValue == "0")){
                controlValueIsEmpty = true;
            }
            // console.debug("Alert._controlValueIsEmpty: ",controlValueIsEmpty, " controlValue is: ",controlValue, " controlDOMNode: ", controlDijit.domNode);
            return controlValueIsEmpty;
        }

    });
});

},
'bf/factory/FactorySecret':function(){
define("bf/factory/FactorySecret", ["dojo/_base/declare","dojo/_base/connect","dijit/registry","dojo/dom-attr","bf/util"],
    function(declare,connect,registry, domAttr) {
        return declare(null,
            {
                /**
                 *
                 * @param type
                 * @param node
                 */
                create:function(type, node){
                    var n = node;
                    var xfId = bf.util.getXfId(n);
                    var xfControlDijit = registry.byId(xfId);

                    switch(type){

                        case "password":
                            // console.debug("FactorySecret: secret input: ",n);

                            xfControlDijit.setValue = function(value, schemavalue) {
                                // console.debug("FactoryInput._createText xfControlDijit.setValue:",value);
                                domAttr.set(node, "value", value);
                            };

                            connect.connect(n,"onkeyup",function(evt){
                                if(xfControlDijit.isIncremental()){
                                    xfControlDijit.sendValue(domAttr.get(n,"value"),false);
                                }
                            });

                            connect.connect(n,"onblur",function(evt){
                                xfControlDijit.sendValue(domAttr.get(n,"value"), true);
                            });

                            connect.connect(node,"onfocus",function(evt){
                                xfControlDijit.handleOnFocus();
                            });
                            xfControlDijit.setCurrentValue(domAttr.get(n,"value"));
                            break;
                        default:
                            console.warn();
                    }
                }
            }
        )
    }
);


},
'dojo/Stateful':function(){
define("dojo/Stateful", ["./_base/kernel", "./_base/declare", "./_base/lang", "./_base/array"], function(dojo, declare, lang, array) {
	// module:
	//		dojo/Stateful
	// summary:
	//		TODOC

return dojo.declare("dojo.Stateful", null, {
	// summary:
	//		Base class for objects that provide named properties with optional getter/setter
	//		control and the ability to watch for property changes
	// example:
	//	|	var obj = new dojo.Stateful();
	//	|	obj.watch("foo", function(){
	//	|		console.log("foo changed to " + this.get("foo"));
	//	|	});
	//	|	obj.set("foo","bar");
	postscript: function(mixin){
		if(mixin){
			lang.mixin(this, mixin);
		}
	},

	get: function(/*String*/name){
		// summary:
		//		Get a property on a Stateful instance.
		//	name:
		//		The property to get.
		//	returns:
		//		The property value on this Stateful instance.
		// description:
		//		Get a named property on a Stateful object. The property may
		//		potentially be retrieved via a getter method in subclasses. In the base class
		// 		this just retrieves the object's property.
		// 		For example:
		//	|	stateful = new dojo.Stateful({foo: 3});
		//	|	stateful.get("foo") // returns 3
		//	|	stateful.foo // returns 3

		return this[name]; //Any
	},
	set: function(/*String*/name, /*Object*/value){
		// summary:
		//		Set a property on a Stateful instance
		//	name:
		//		The property to set.
		//	value:
		//		The value to set in the property.
		//	returns:
		//		The function returns this dojo.Stateful instance.
		// description:
		//		Sets named properties on a stateful object and notifies any watchers of
		// 		the property. A programmatic setter may be defined in subclasses.
		// 		For example:
		//	|	stateful = new dojo.Stateful();
		//	|	stateful.watch(function(name, oldValue, value){
		//	|		// this will be called on the set below
		//	|	}
		//	|	stateful.set(foo, 5);
		//
		//	set() may also be called with a hash of name/value pairs, ex:
		//	|	myObj.set({
		//	|		foo: "Howdy",
		//	|		bar: 3
		//	|	})
		//	This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
		if(typeof name === "object"){
			for(var x in name){
				this.set(x, name[x]);
			}
			return this;
		}
		var oldValue = this[name];
		this[name] = value;
		if(this._watchCallbacks){
			this._watchCallbacks(name, oldValue, value);
		}
		return this; //dojo.Stateful
	},
	watch: function(/*String?*/name, /*Function*/callback){
		// summary:
		//		Watches a property for changes
		//	name:
		//		Indicates the property to watch. This is optional (the callback may be the
		// 		only parameter), and if omitted, all the properties will be watched
		// returns:
		//		An object handle for the watch. The unwatch method of this object
		// 		can be used to discontinue watching this property:
		//		|	var watchHandle = obj.watch("foo", callback);
		//		|	watchHandle.unwatch(); // callback won't be called now
		//	callback:
		//		The function to execute when the property changes. This will be called after
		//		the property has been changed. The callback will be called with the |this|
		//		set to the instance, the first argument as the name of the property, the
		// 		second argument as the old value and the third argument as the new value.

		var callbacks = this._watchCallbacks;
		if(!callbacks){
			var self = this;
			callbacks = this._watchCallbacks = function(name, oldValue, value, ignoreCatchall){
				var notify = function(propertyCallbacks){
					if(propertyCallbacks){
                        propertyCallbacks = propertyCallbacks.slice();
						for(var i = 0, l = propertyCallbacks.length; i < l; i++){
							try{
								propertyCallbacks[i].call(self, name, oldValue, value);
							}catch(e){
								console.error(e);
							}
						}
					}
				};
				notify(callbacks['_' + name]);
				if(!ignoreCatchall){
					notify(callbacks["*"]); // the catch-all
				}
			}; // we use a function instead of an object so it will be ignored by JSON conversion
		}
		if(!callback && typeof name === "function"){
			callback = name;
			name = "*";
		}else{
			// prepend with dash to prevent name conflicts with function (like "name" property)
			name = '_' + name;
		}
		var propertyCallbacks = callbacks[name];
		if(typeof propertyCallbacks !== "object"){
			propertyCallbacks = callbacks[name] = [];
		}
		propertyCallbacks.push(callback);
		return {
			unwatch: function(){
				propertyCallbacks.splice(array.indexOf(propertyCallbacks, callback), 1);
			}
		}; //Object
	}

});

});

},
'dijit/_base/manager':function(){
define("dijit/_base/manager", [
	"dojo/_base/array",
	"dojo/_base/config", // defaultDuration
	"../registry",
	".."	// for setting exports to dijit namespace
], function(array, config, registry, dijit){

	// module:
	//		dijit/_base/manager
	// summary:
	//		Shim to methods on registry, plus a few other declarations.
	//		New code should access dijit/registry directly when possible.

	/*=====
	dijit.byId = function(id){
		// summary:
		//		Returns a widget by it's id, or if passed a widget, no-op (like dom.byId())
		// id: String|dijit._Widget
		return registry.byId(id); // dijit._Widget
	};

	dijit.getUniqueId = function(widgetType){
		// summary:
		//		Generates a unique id for a given widgetType
		// widgetType: String
		return registry.getUniqueId(widgetType); // String
	};

	dijit.findWidgets = function(root){
		// summary:
		//		Search subtree under root returning widgets found.
		//		Doesn't search for nested widgets (ie, widgets inside other widgets).
		// root: DOMNode
		return registry.findWidgets(root);
	};

	dijit._destroyAll = function(){
		// summary:
		//		Code to destroy all widgets and do other cleanup on page unload

		return registry._destroyAll();
	};

	dijit.byNode = function(node){
		// summary:
		//		Returns the widget corresponding to the given DOMNode
		// node: DOMNode
		return registry.byNode(node); // dijit._Widget
	};

	dijit.getEnclosingWidget = function(node){
		// summary:
		//		Returns the widget whose DOM tree contains the specified DOMNode, or null if
		//		the node is not contained within the DOM tree of any widget
		// node: DOMNode
		return registry.getEnclosingWidget(node);
	};
	=====*/
	array.forEach(["byId", "getUniqueId", "findWidgets", "_destroyAll", "byNode", "getEnclosingWidget"], function(name){
		dijit[name] = registry[name];
	});

	/*=====
	dojo.mixin(dijit, {
		// defaultDuration: Integer
		//		The default fx.animation speed (in ms) to use for all Dijit
		//		transitional fx.animations, unless otherwise specified
		//		on a per-instance basis. Defaults to 200, overrided by
		//		`djConfig.defaultDuration`
		defaultDuration: 200
	});
	=====*/
	dijit.defaultDuration = config["defaultDuration"] || 200;

	return dijit;
});

},
'bf/factory/FactorySelect':function(){
define("bf/factory/FactorySelect", ["dojo/_base/declare","dojo/_base/connect","dijit/registry","dojo/query","dojo/_base/array", "dojo/dom-attr","dojo/dom-construct", "dojo/dom-class","dojo/dom", "bf/util"],
    function(declare,connect,registry,query,array,domAttr,domConstruct,domClass,dom) {
        return declare(null,
            {
                /**
                 *
                 * @param type
                 * @param node
                 */
                create:function(type, n){
                    var node = n;
                    var xfId = bf.util.getXfId(node);
                    var xfControlDijit = registry.byId(xfId);
                    var dataObj = bf.util.parseDataAttribute(node,"data-bf-params");
                    var initialValue = dataObj.value;
                    xfControlDijit.setCurrentValue(initialValue);

                    var self = this;
                    var openselection = dataObj.selection == "open";
                    if(type == "listcontrol" && openselection){
                        type = "open";
                    }else if(openselection){
                        console.warn("selection = 'open' not support for xf:select with appearance='full'");
                    }

                    switch(type){
                        case "listcontrol":

                            require(["bf/select/Select1ComboBox"], function(Select1ComboBox) {
                                // console.debug("FactorySelect (minimal/compact) id:",xfId);
                                var selectWidget = new Select1ComboBox({id:n.id,value:initialValue}, n);
                                connect.connect(node,"onchange",function(evt){
                                    var value = self._handleOnChangeMinimal(xfId,node);

                                    if(xfControlDijit.isIncremental()){
                                        xfControlDijit.sendValue(value,false);
                                    }
                                });

                                connect.connect(node,"onblur",function(evt){
                                    var value = self.getSelectMinimalValue(node);

                                    xfControlDijit.sendValue(value,true);
                                });

                                connect.connect(node,"onfocus",function(evt){
                                    xfControlDijit.handleOnFocus();
                                });

                                xfControlDijit.setValue=function(value) {
                                    query(".xfSelectorItem",node).forEach(function(item){
                                        item.selected = value.indexOf(item.value) != -1;
                                    });
                                };

                            });

                            break;
                        case "checkboxes":
                            require(["bf/select/SelectCheckBox"], function(SelectCheckBox) {
                                var selectFull = new SelectCheckBox({id:node.id,xfControl:xfControlDijit}, node);


                                connect.connect(node,"onclick",function(evt){
                                    var selectedValues  = self.getSelectedFullOptions();
                                    // console.debug("selectedValues:",selectedValues);
                                    var ids = "";
                                    var selectedValue = "";
                                    array.forEach(selectedValues, function(item) {
                                        // concat ids of selected options
                                        var optionId = bf.util.getXfId(item);
                                        ids =  (ids == "") ? optionId : ids + ";" + optionId;
                                        // concat values of selected options
                                        selectedValue = (selectedValue == "") ? item.value : selectedValue + " " + item.value;
                                    });
                                    // console.debug("MultiSelectFull.onChange SelectedItem Ids: ", ids, " value: ", selectedValue);
                                    fluxProcessor.dispatchEventType(xfId, "xformsSelect", ids);

                                    if(xfControlDijit.isIncremental()){
                                        xfControlDijit.sendValue(selectedValue,false);
                                    }
                                });

                                connect.connect(node,"onfocus",function(evt){
                                    xfControlDijit.handleOnFocus();
                                });

                                xfControlDijit.setValue=function(value) {
                                    // console.debug("FactorySelect checkboxes: setValue:",value);
                                    selectFull.currentValue = value.split(" ");

                                    query(".xfCheckBoxValue",node).forEach(function(item){
                                        item.checked = value.indexOf(item.value) != -1;
                                    });
                                };
                                xfControlDijit.setReadonly = function() {
                                    // console.debug("FactorySelect (Checkbox).setReadonly xfControlDijit:",xfControlDijit);
                                    domClass.replace(xfControlDijit.srcNodeRef, "xfReadOnly", "xfReadWrite");
                                    selectFull.setReadOnly();
                                };

                                xfControlDijit.setReadwrite = function() {
                                    // console.debug("FactorySelect (Checkbox).setReadwrite xfControlDijit",xfControlDijit);
                                    domClass.replace(xfControlDijit.srcNodeRef,"xfReadWrite", "xfReadOnly");
                                    selectFull.setReadWrite();
                                };


                            });
                            break;
                        case "open":
                            require(["dojo/dom-construct","dojo/dom-class","dijit/form/TextBox","dojo/_base/lang"], function(domConstruct,domClass,TextBox,lang){
                                domClass.add(xfControlDijit.domNode,"xfSelectOpen");

                                var textNode = domConstruct.place("<div>", node, "before");
                                var freeTextDijit = new TextBox({},textNode);
                                var textValue =  self._getOpenSelectValuePartition(initialValue, node);
                                // save textValue as bfValue on dijit for later processing
                                freeTextDijit.set("bfValue", textValue);
                                freeTextDijit.set("value",textValue);

                                connect.connect(freeTextDijit, "onKeyUp",function(event){
                                    //console.debug("freeTextDijit._onKeyUp: event:", event);
                                    var bfValue = freeTextDijit.get("bfValue");
                                    var value = freeTextDijit.get("value");
                                    freeTextDijit.set("bfValue", value);
                                    var result = lang.trim(self.getSelectMinimalValue(node) + " " + value);
                                    //console.debug("OpenSelect.freeTextDijit._handleOnChange: value:",result, " incremental:" , xfControlDijit.isIncremental());
                                    if(xfControlDijit.isIncremental()){
                                        xfControlDijit.sendValue(result,false);
                                    }
                                });

                                connect.connect(freeTextDijit, "onBlur" ,function(event){
                                    //console.debug("freeTextDijit._onBlur: event:", event);
                                    var bfValue = freeTextDijit.get("bfValue");
                                    var value = freeTextDijit.get("value");
                                    freeTextDijit.set("bfValue", value);
                                    var result = lang.trim(self.getSelectMinimalValue(node) + " " + value);
                                    //console.debug("OpenSelect.freeTextDijit._onblur: value:",result, " incremental:" , xfControlDijit.isIncremental());
                                    xfControlDijit.sendValue(result,true);
                                });

                                // onChange handler for select part
                                connect.connect(node,"onchange",function(evt){
                                    var selectValue = self._handleOnChangeMinimal(xfId,node);
                                    var result = lang.trim(selectValue + " " + freeTextDijit.get("value"));
                                    //console.debug("OpenSelect.onChange: value:",result);
                                    if(xfControlDijit.isIncremental()){
                                        xfControlDijit.sendValue(result,false);
                                    }
                                });


                                connect.connect(node,"onblur",function(evt){
                                    var selectValue = self.getSelectMinimalValue(node);
                                    var result = lang.trim(selectValue + " " + freeTextDijit.get("value"));
                                    //console.debug("OpenSelect.onblur: value:",result);

                                    xfControlDijit.sendValue(result,true);
                                });


                                var widgetContainer = node.parentNode;
                                if(domClass.contains(widgetContainer,"widgetContainer")){
                                    //console.debug("found widgetContainer:",widgetContainer);
                                    domAttr.set(widgetContainer,"tabindex",0);
                                    connect.connect(widgetContainer,"onfocus",function(evt){
                                        //console.debug("widgetContainer onfocus");
                                        xfControlDijit.handleOnFocus();
                                    });
                                }


                                xfControlDijit.setValue=function(value) {
                                    // console.debug("SelectOpen.setValue:",value);
                                    query(".xfSelectorItem",node).forEach(function(item){
                                        item.selected = value.indexOf(item.value) != -1;
                                    });
                                    var textValue =  self._getOpenSelectValuePartition(value, node);
                                    freeTextDijit.set("bfValue", textValue);
                                    freeTextDijit.set("value",textValue);
                                };
                                // READONLY HANDLING
                                connect.connect(xfControlDijit,"setReadonly",function(evt){
                                    freeTextDijit.set("disabled",true);
                                });
                                connect.connect(xfControlDijit,"setReadwrite",function(evt){
                                    freeTextDijit.set("disabled",false);
                                });
                            });
                            break;
                        default:
                            console.warn("FactorySelect.default");

                    }
                },
                _getOpenSelectValuePartition:function(value, selectNode) {
                    // console.debug("FactorySelect._getOpenSelectValuePartition: check which values in '", value, "' are not present within given select");
                    if(value && value != "" ) {
                        var selectValues = new Array();
                         dojo.query(".xfSelectorItem",selectNode).forEach(function(item){
                             selectValues.push(domAttr.get(item,"value"));
                        });
                        var freeTextTmpValue = new Array();
                        array.forEach(value.split(" "),function(value2analyse){
                            if(array.indexOf(selectValues,value2analyse) == -1){
                                freeTextTmpValue.push(value2analyse);
                            }
                        });
                        return freeTextTmpValue.join(" ");
                    }
                    return "";
                },

                getSelectMinimalValue:function(node) {
                    var selectedValue = "";
                    query(".xfSelectorItem",node).forEach(function(item){
                        if(item.selected){
                            selectedValue  = (selectedValue  == "") ? item.value : selectedValue + " " + item.value;
                        }
                    });
                    return selectedValue;
                },

                _handleOnChangeMinimal:function(selectId, node) {
                    var selectedOptions = new Array();
                    query(".xfSelectorItem",node).forEach(function(item){
                        if(item.selected){
                            selectedOptions.push(item);
                        }
                    });
                    // console.debug("selectedValues:",selectedValues);
                    var ids = "";
                    var selectedValue = "";
                    array.forEach(selectedOptions, function(item) {
                        // concat ids of selected options
                        ids =  (ids == "") ? item.id : ids + ";" + item.id;
                        // concat values of selected options
                        selectedValue = (selectedValue == "") ? item.value : selectedValue + " " + item.value;
                    });
                    // console.debug("MultiSelect.onChange SelectedItem Ids: ", ids, " value: ", selectedValue);
                    // trigger xforms-select event
                    fluxProcessor.dispatchEventType(selectId, "xformsSelect", ids);
                    return selectedValue;
                },

                getSelectedFullOptions:function(node) {
                    var selectedOptions = new Array();
                    query(".xfCheckBoxValue",node).forEach(function(item){
                        if(item.checked){
                            selectedOptions.push(item);
                        }
                    });
                    return selectedOptions;
                }
            }
        );
    }
);


},
'bf/factory/FactoryInput':function(){
define("bf/factory/FactoryInput", ["dojo/_base/declare","dojo/_base/connect","dijit/registry","dojo/dom-attr","dojo/dom-class","bf/util"],
    function(declare,connect,registry,domAttr,domClass) {
        return declare(null,
            {
                /**
                 *
                 * @param type
                 * @param node
                 */
                create:function(type, node){
                    // console.debug("FactoryInput: type",type, " node:",node);
                    var xfControlDijit = registry.byId(bf.util.getXfId(node));
                    /*
                     xfControl is an instance of the XFControl class. This is the generic class that handles all interactions
                     with the XForms processor implementation. The concrete native browser or javascript controls are called
                     'widgets' in the context of the client side. They are the concrete representations the user interacts with.
                     @see: _createText() for more information about how to connect xfControl and a concrete Widget
                     */

                    switch(type){
                    //INPUT TYPE STRING
                        case "text":
                            this._createText(xfControlDijit,node);
                            break;
                        case "htmlTime":
                            this._createTimeHTML(xfControlDijit,node);
                            break;
                    //INPUT TYPE BOOLEAN
                        case "checkbox":
                            this._createCheckbox(xfControlDijit, node);

                            break;
                    //INPUT TYPE DATE
                       case "date":
                            // console.debug("FactoryInput: found: .uaDesktop .xfInput.xsdDate .widgetContainer",node);
                            this._createDate(xfControlDijit, node);
                            break;
                       case "dropDownDate":
                            // console.debug("FactoryInput: found: .uaDesktop .xfInput.xsdDate .widgetContainer",node);
                            this._createDropDownDate(xfControlDijit, node);
                            break;
                        //INPUT TYPE DATE TIME
                        case "dateTime":
                            this._createDateTime(xfControlDijit,node);
                            break;
                        //INPUT TYPE TIME
                        case "timeTextBox":
                            this._createTimeTextBox(xfControlDijit,node);
                            break;
                        case "dropDownTime":
                            this._createDropDownTime(xfControlDijit,node);
                            break;
                        case "mobileDate":
                            this._createMobileDate(xfControlDijit, node);
                            break;
                        case "mobileDateTime":
                            this._createMobileDateTime(xfControlDijit, node);
                            break;
                        case "mobileTime":
                            this._createMobileTime(xfControlDijit, node);
                            break;
                        case "timeline":
                            this._createTimeline(xfControlDijit, node);
                            break;
                        case "tbd":
                            console.warn("No handler for node", node, " yet");
                        default:
                            console.warn("FactoryInput unknown type for node:", node);

                    }
                },

                _createText:function(xfControlDijit,node){
                    // console.debug("FactoryInput.createInputPlain");
                    /* Overwriten "abstract" API function on XFControl to handle updating of control values */
                    xfControlDijit.setValue = function(value, schemavalue) {
                        // console.debug("FactoryInput._createText xfControlDijit.setValue:",value);
                        domAttr.set(node, "value", value);
                    };

                    /*
                     ###########################################################################################
                     EVENT BINDING
                     ###########################################################################################

                     Widgets are bound to their XFControl via events. Whenever a user changes the value of a control this change
                     must be propagated to its XFControl which will in turn send it to the server whenever appropriate.

                     There must be at least one event handler to notify XFControl of value changes. However it is highly
                     recommended to add two listeners - one to support incremental updates and one for onblur updates. Please
                     be aware that the order of registration can be significant for proper operation.
                     */

                    connect.connect(node,"onkeyup",function(evt){
                        // console.debug("onkeypress",n);
                        if(xfControlDijit.isIncremental()){
                            xfControlDijit.sendValue(node.value,false);
                        }
                    });

                    connect.connect(node,"onblur",function(evt){
                        // console.debug("onblur",n);
                        xfControlDijit.sendValue(node.value,true);
                    });

                    connect.connect(node,"onfocus",function(evt){
                        // console.debug("xf:input text got focus");
                        xfControlDijit.handleOnFocus();
                    });
                    xfControlDijit.setCurrentValue(domAttr.get(node,"value"));

                },

                _createTimeHTML:function(xfControlDijit,node){
                    domAttr.set(node, "type", "text");
                    this._createText(xfControlDijit,node)
                },


                _createCheckbox:function(xfControlDijit, node){
                     // console.debug("FactoryInput.createInputBoolean");
                     // console.debug("FOUND: boolean input field: ",node, " node.checked:",node.checked);
                    xfControlDijit.setCurrentValue(node.checked);
                    if(domAttr.get(node,"type") != "checkbox"){
                        domAttr.set(node,"type","checkbox");
                    }
                    /* overwritten "abstract" API function of XFControl */
                    xfControlDijit.setValue = function(value, schemavalue) {
                        domAttr.set(node,"checked",value  == true || value == 'true');
                    };

                    /*
                     input type="checkbox" fails to honor readonly attribute and thus is overwritten here. It seems this is
                     rather a HTML Spec issue as e.g. comboxes behave the same. You can visibly change the value though
                     the control is readonly. As this seems rather contra intuitive for users we have chosen to use 'disabled'
                     here instead.
                     */
                    xfControlDijit.setReadonly = function() {
                        // console.debug("overwritten checkbox function");
                        domClass.replace(node,"xfReadOnly","xfReadWrite");
                        domAttr.set(node, "disabled","disabled");
                    };
                    xfControlDijit.setReadwrite = function() {
                        domClass.replace(node,"xfReadWrite","xfReadOnly");
                        node.removeAttribute("disabled");
                    };

                    connect.connect(node,"onblur",function(evt){
                        // console.debug("onblur",node, " node.checked:",node.checked);
                        xfControlDijit.sendValue(node.checked,true);
                    });

                    connect.connect(node,"onclick",function(evt){
                         // console.debug("FactoryInput (boolean) onclick node.checked:",node.checked);
                        xfControlDijit.sendValue(node.checked,false);
                    });

                    connect.connect(node,"onfocus",function(evt){
                        // console.debug("FactoryInput (boolean) onfocus node.checked:",node.checked);
                        xfControlDijit.handleOnFocus();
                    });


                },

                _createDropDownDate:function(xfControlDijit, node){
                    var n = node;
                    var self = this;
                    require(["dojo/query","bf/input/DropDownDate"],function(query,DropDownDate){
                        n = query(".xfValue",node)[0];
                        var xfId = bf.util.getXfId(n);
                        var xfControlDijit = registry.byId(xfId);
                        var dataObj = bf.util.parseDataAttribute(n,"data-bf-params");
                        var dateFormat = dataObj.date;
                        var value = dataObj.value;
                        if(!value) {
                            value = domAttr.get(n,"value");
                        }
                        var dateWidget = new DropDownDate({
                            value:value,
                            dateFormat:dateFormat
                        },n);
                        xfControlDijit.setCurrentValue(value);
                        self._connectControlDijit(xfControlDijit, dateWidget);
                    });
                },


                _createDate:function(xfControlDijit, node){
                    var n = node;
                    var self = this;
                    require(["dojo/dom","dojo/query","dijit/form/DateTextBox"],function(dom, query,DateTextBox){
                        n = query(".xfValue",node)[0];
                        // console.debug("found date value node: n:",n);
                        var xfId = bf.util.getXfId(n);
                        var xfControlDijit = registry.byId(xfId);

                        var dataObj = bf.util.parseDataAttribute(n,"data-bf-params");
                        var datePattern = dataObj.date;
                        if(!datePattern || datePattern == ""){
                            datePattern = "MM/dd/yyyy"
                        }
                        // console.debug("input type=date datePattern:",datePattern);
                        var value = dataObj.value;
                        if(!value) {
                            value = domAttr.get(n,"value");
                        }
                        if(value == ""){
                            value = undefined;
                        }else {
                            xfControlDijit.setCurrentValue(value);
                        }
                        var hint = dom.byId(xfId+"-hint");
                        var dateWidget = new DateTextBox({
                                required:false,
                                placeHolder: (hint != undefined && !hint.hasChildNodes())? hint.innerHTML : "",
                                constraints:{
                                    selector:'date',
                                    datePattern:datePattern
                        } },n);
                        if(value != undefined) {
                            dateWidget.set("value",value);
                        }
                        dateWidget.validate = function(/*Boolean*/ isFocused){ return true; };
                        self._connectControlDijit(xfControlDijit, dateWidget);
                    });
                },

                _createDateTime:function(controlDijit, node){
                    var n = node;
                    // console.debug("_createDateTime: node value: ",domAttr.get(node,"value"));
                    var xfControlDijit = controlDijit;
                    var controlId =domAttr.get(n,"id");

                    var dataObj = bf.util.parseDataAttribute(n,"data-bf-params");
                    console.debug("createDateTime: dataObj:",dataObj);
                    var tmpValue = dataObj.value;
                    if(!tmpValue) {
                        tmpValue = domAttr.get(n,"value");
                    }
                    // console.debug("FactoryInput._createDateTime: tmpValue:",tmpValue);
                    var xfValue = this._getISODate(tmpValue);
                    // console.debug("FactoryInput._createDateTime: xfValue:",xfValue);

                    xfControlDijit.setCurrentValue(xfValue);
                    var self = this;
                    var xfId = bf.util.getXfId(n);
                    // console.debug("FactoryInput dateTime: id: ", controlId, " xfValue: ",xfValue, " node:",n);
                    require(["bf/input/DateTime"], function(DateTime) {
                        var dateTimeWidget = new DateTime({
                            name:controlId,
                            value:xfValue,
                            xfControlDijit:xfControlDijit,
                            miliseconds:false,
                            appearance:"minimal",
                            dateConstraints:{
                                datePattern:'M/d/yyyy'
                            },
                            timeConstraints:{
                                timePattern:'HH:mm:ss z',
                                clickableIncrement: 'T00:15:00',
                                visibleIncrement: 'T00:15:00',
                                visibleRange: 'T01:00:00'

                            },
                            title:domAttr.get(n, "title"),
                            xfControlId:xfId
                        },n);

                        connect.connect(dateTimeWidget, "set", function (attrName, value) {
                            // console.debug("dateTimeWidget: set attrName:",attrName, " value:",value, " incremental:", xfControlDijit.isIncremental());
                            if((attrName == "focused" &&  !value) || attrName == "value"){
                                if(attrName == "focused"){
                                    xfControlDijit.sendValue(this.get("value"),true);
                                }else if(attrName == "value" && xfControlDijit.isIncremental()) {
                                    xfControlDijit.sendValue(this.get("value"),false);
                                }

                            }else if(attrName == "focused" &&  value){
                                xfControlDijit.handleOnFocus();
                            }
                        });

                        xfControlDijit.setValue = function(value,schemavalue) {
                            // console.debug("FactoryInput._createDateTime xfControlDijit.setValue: ",value,schemavalue );
                            dateTimeWidget.set('value', schemavalue);
                        };

                        self._overwriteReadonly(xfControlDijit, dateTimeWidget);
                    });

                },
                _createTimeTextBox:function(controlDijit, n){
                    var xfControlDijit = controlDijit;
                    var node = n;
                    var self = this;
                    // console.info("FactoryInput Time");
                    require(["dijit/form/TimeTextBox","dojo/date/stamp"],function(TimeTextBox,stamp){
                        var value = domAttr.get(node,"value");
                        xfControlDijit.setCurrentValue(value);
                        // console.debug("FactoryInput TimeValue1:",value, " node:",node);
                        var timezone = undefined;
                        if(value.indexOf("+") !=-1){
                            timezone = value.substring(value.indexOf("+"),value.length);
                        }
                        var zulu = (value.indexOf("Z") !=-1);
                        if(value != undefined && value != "" && value.indexOf("T")==-1){
                            value = "T"+value
                        }
                        // console.debug("FactoryInput TimeValue2:",value, " node:",node);
                        var timeTextBox = new TimeTextBox({
                            value:value,
                            constraints: {
                                timePattern:'HH:mm:ss',
                                clickableIncrement: 'T00:15:00',
                                visibleIncrement: 'T00:15:00',
                                visibleRange: 'T02:00:00'
                            }
                        },node);
                        connect.connect(timeTextBox, "set", function (attrName, value) {
                            // console.debug("InputFactor (timeTextBox).set attrName:",attrName," value:",value);
                            if((attrName == "focused" &&  !value) || attrName == "value") {
                                var textboxTime = timeTextBox.get("value");
                                if(textboxTime != undefined && textboxTime != ""){
                                    textboxTime = stamp.toISOString(textboxTime,{selector:"time",zulu:zulu});
                                    // console.debug("toISOString:",textboxTime);
                                    if(textboxTime.indexOf("T") != -1){
                                        // console.debug("cut off T");
                                        textboxTime = textboxTime.substring(1,textboxTime.length);
                                    }
                                }
                                // console.debug("textboxTime:",textboxTime);
                                if(attrName == "focused") {
                                    xfControlDijit.sendValue(textboxTime,true);
                                }else if(attrName == "value" && xfControlDijit.isIncremental())
                                    xfControlDijit.sendValue(textboxTime,false);
                             }
                        });

                        xfControlDijit.setValue = function(value,schemavalue) {
                            // console.debug("value:",value);
                            if(value != undefined && value != "" && value.indexOf("T")==-1){
                                value = "T"+value
                            }
                            timeTextBox.set('value', value);
                        };
                        self._overwriteReadonly(xfControlDijit,timeTextBox);

                        connect.connect(timeTextBox,"_onFocus",function(evt){
                            xfControlDijit.handleOnFocus();
                        });

                    });
                },

                _createTimeline:function(controlDijit, n){
                    var xfControlDijit = controlDijit;
                    var node = n;
                    var self = this;
                    require(["bf/input/Timeline"],function(Timeline){
                        var value = domAttr.get(node,"value");
                        xfControlDijit.setCurrentValue(value);
                        var timeline = new Timeline({ value:value}, node);
                        console.debug("created new timeline: " , timeline );

                        xfControlDijit.setValue = function(value,schemavalue) {
                            // console.debug("value:",value);
                            timeline.set('value', value);
                        };
                    });
                },

                _createDropDownTime:function(controlDijit, n){
                    var xfControlDijit = controlDijit;
                    var node = n;
                    var self = this;
                    require(["bf/input/Time","dojo/date/stamp"],function(Time,stamp){
                        var value = domAttr.get(node,"value");
                        xfControlDijit.setCurrentValue(value);
                        var time = new Time({ value:value}, node);
                        connect.connect(time, "set", function (attrName, value) {
                            // console.debug("InputFactor (dropDownTime.set value:",value);
                            if(attrName == "focused" && !value){
                                xfControlDijit.sendValue(time.get("value"), true);
                            }else if(attrName == "value" && xfControlDijit.isIncremental()){
                                xfControlDijit.sendValue(time.get("value"), false);
                            }else if(attrName == "focused" && value){
                                xfControlDijit.handleOnFocus();
                            }
                        });

                        xfControlDijit.setValue = function(value,schemavalue) {
                            // console.debug("value:",value);
                            time.set('value', value);
                        };
                        self._overwriteReadonly(xfControlDijit,time);
                    });
                },

                _createMobileDate:function(xfControlDijit, dateWidget){
                    this._createMobileWidget(xfControlDijit,dateWidget,"date");

                },

                _createMobileDateTime:function(xfControlDijit, dateTimeWidget){
                    this._createMobileWidget(xfControlDijit,dateTimeWidget,"dateTime");
                },

                _createMobileTime:function(xfControlDijit, timeWidget){
                    this._createMobileWidget(xfControlDijit,timeWidget,"time");
                },

                _createMobileWidget:function(xfControlDijit, widget, type){
                    var dataObj = bf.util.parseDataAttribute(widget,"data-bf-params");
                    var value = this._getISODate(dataObj.value);
                    domAttr.set(widget, "value", value);
                    xfControlDijit.setCurrentValue(value);

                    xfControlDijit.setValue = function(value, schemavalue) {
                        domAttr.set(widget, "value", value);
                    };
                    var self = this;
                    connect.connect(widget,"onkeyup",function(evt){
                        var value = widget.value;
                        if(type == "dateTime"){
                            value = self._getISODateTime(value);
                        }else if(type=="time"){
                            value = self._getMobileTime(value);
                        }
                        //console.debug("send: (keyup)"+ value);
                        xfControlDijit.sendValue(value,false);
                    });
                    connect.connect(widget,"onblur",function(evt){
                        var value = widget.value;
                        if(type == "dateTime"){
                            value = self._getISODateTime(value);
                        }else if(type=="time"){
                            value = self._getMobileTime(value);
                        }
                        // console.debug("send: (keyup)"+ value);
                        // console.debug("dateTime.send: (blur) "+ value);
                        xfControlDijit.sendValue(value, true);
                    });
                },
                /**
                 *
                 * @param xfControlDijit
                 * @param controlWidget
                 * @private
                 */
                _connectControlDijit:function(xfControlDijit, controlWidget){
                    // console.debug("connectDateDijit: xfControlDijit:",xfControlDijit," controlWidget:",controlWidget);
                    if(!domClass.contains(controlWidget.domNode,"xfValue")){
                        domClass.add(controlWidget.domNode,"xfValue");
                    }

                    connect.connect(controlWidget, "set", function (attrName, value) {
                        console.debug("controlWidget.set attrName:",attrName, " value:",value, " incremental: ",xfControlDijit.isIncremental());
                        if((attrName == "focused" &&  !value) || attrName == "value") {
                            var controlValue;
                            if(controlWidget.serialize){
                                try {
                                    controlValue = controlWidget.serialize(controlWidget.get("value")).substring(0, 10);
                                }
                                catch(e){
                                    // if the value could not be parsed (e.g. cause it's invalid) simply return the displayed value
                                    controlValue = controlWidget.get("displayedValue");
                                    // console.debug("Error serializing date: controlValue:",controlValue, " controlWidget:",controlWidget);
                                }

                            }else{
                                controlValue = controlWidget.get("value");
                            }
                            // looses focus
                            if(attrName == "focused"){
                                xfControlDijit.sendValue(controlValue, true);
                            }
                            else if(attrName == "value" && xfControlDijit.isIncremental()){
                                xfControlDijit.sendValue(controlValue,false);
                            }


                        }else if(attrName == "focused" &&  value){
                            xfControlDijit.handleOnFocus();
                        }
                    });
                    xfControlDijit.setValue = function(value,schemavalue) {
                        //console.debug("FactoryInput (date) xfControlDijit.setValue value:",value, " schemavalue:",schemavalue);
                        if(schemavalue == ""){
                            schemavalue = undefined;
                        }
                        controlWidget.set('value', schemavalue);
                    };
                    this._overwriteReadonly(xfControlDijit, controlWidget);
                },

                _overwriteReadonly:function(xfControlDijit,controlWidget){
                    xfControlDijit.setReadonly = function() {
                        domClass.replace(xfControlDijit.domNode,"xfReadOnly","xfReadWrite");
                        controlWidget.set('readOnly', true);
                    };
                    xfControlDijit.setReadwrite = function() {
                        domClass.replace(xfControlDijit.domNode,"xfReadWrite","xfReadOnly");
                        controlWidget.set('readOnly', false);
                    };
                },

                _getISODate:function(value){
                    var timezone = undefined;
                    if(value.indexOf("+") !=-1){
                        timezone = value.substring(value.indexOf("+"),value.length);
                        if(timezone.indexOf(":")!=-1){
                            timezone = timezone.replace(":","");
                        }
                    }
                    // console.debug("FactoryInput._getISODate: value:",value);
                    var zulu = (value.indexOf("Z") !=-1);
                    if(timezone == undefined && value != undefined && value != "" && !zulu){
                        value = value + "Z";
                    }

                    if(value) {
                        var date = new Date(value);
                        // console.debug("FactoryInput._getISODate: date:",date);
                        return date.toISOString();
                    }else {
                        // console.debug("FactoryInput._getISODate: date is undefined");
                        return "";
                    }
                },

                _getISODateTime:function(value){
                    var datePart = value.substring(0,value.indexOf('T'));
                    // console.debug("datePart:" + datePart);
                    var timePart = value.substring(value.indexOf('T'),value.length);
                    // console.debug("timePart:" + timePart + " " + timePart.length);
                    if(timePart.length == 7) {
                        timePart = timePart.substring(0,6)+":00.000Z";
                    }
                    var result = datePart + timePart;
                    // console.debug("result:" + result);
                    return result;
                },

                _getMobileTime:function(value){
                    if(value.length == 5) {
                        value = value +":00";
                    }
                    // console.debug("_getMobileTime: value" + value);
                    return value;
                }
            }
        );
    }
);


},
'bf/factory/FactoryTrigger':function(){
define("bf/factory/FactoryTrigger", ["dojo/_base/declare","dojo/_base/connect","dijit/registry"],
    function(declare,connect,registry) {
        return declare(null,
            {
                /**
                 * This rule matches plain standard <input type="button", a trigger rendered with image and
                 * a trigger represented as a link.
                 *
                 * @param type
                 * @param node the node to map to a concrete widget
                 */
                create:function(type, node){
                    var parentId = node.id.substring(0,node.id.lastIndexOf("-"));
                    connect.connect(node, "onclick", function(evt){
                        // console.debug("FactoryTrigger: node: ", node, " onclick function. Dispatch Event to: ", parentId, " evt: ", evt);
                        fluxProcessor.dispatchEvent(parentId);
                    });
                    var xfId = bf.util.getXfId(node);
                    var xfControlDijit = registry.byId(xfId);

                    switch(type){
                        case "link":
                            xfControlDijit.setLabel = function(value) {
                                // console.debug("FactoryTrigger.setLabel for link: value: ",value);
                                node.innerHTML = value;
                            };
                            break;
                        case "button":
                            xfControlDijit.setLabel = function(value) {
                                // console.debug("FactoryTrigger.setLabel for button: value: ",value);
                                node.value = value;
                                node.innerHTML = value;
                            };
                            break;
                        default:
                            console.warn("FactoryTrigger unknown type: ",type);

                    }
                }

            }
        );
    }
);


},
'dijit/registry':function(){
define("dijit/registry", [
	"dojo/_base/array", // array.forEach array.map
	"dojo/_base/sniff", // has("ie")
	"dojo/_base/unload", // unload.addOnWindowUnload
	"dojo/_base/window", // win.body
	"."	// dijit._scopeName
], function(array, has, unload, win, dijit){

	// module:
	//		dijit/registry
	// summary:
	//		Registry of existing widget on page, plus some utility methods.
	//		Must be accessed through AMD api, ex:
	//		require(["dijit/registry"], function(registry){ registry.byId("foo"); })

	var _widgetTypeCtr = {}, hash = {};

	var registry =  {
		// summary:
		//		A set of widgets indexed by id

		length: 0,

		add: function(/*dijit._Widget*/ widget){
			// summary:
			//		Add a widget to the registry. If a duplicate ID is detected, a error is thrown.
			//
			// widget: dijit._Widget
			//		Any dijit._Widget subclass.
			if(hash[widget.id]){
				throw new Error("Tried to register widget with id==" + widget.id + " but that id is already registered");
			}
			hash[widget.id] = widget;
			this.length++;
		},

		remove: function(/*String*/ id){
			// summary:
			//		Remove a widget from the registry. Does not destroy the widget; simply
			//		removes the reference.
			if(hash[id]){
				delete hash[id];
				this.length--;
			}
		},

		byId: function(/*String|Widget*/ id){
			// summary:
			//		Find a widget by it's id.
			//		If passed a widget then just returns the widget.
			return typeof id == "string" ? hash[id] : id;	// dijit._Widget
		},

		byNode: function(/*DOMNode*/ node){
			// summary:
			//		Returns the widget corresponding to the given DOMNode
			return hash[node.getAttribute("widgetId")]; // dijit._Widget
		},

		toArray: function(){
			// summary:
			//		Convert registry into a true Array
			//
			// example:
			//		Work with the widget .domNodes in a real Array
			//		|	array.map(dijit.registry.toArray(), function(w){ return w.domNode; });

			var ar = [];
			for(var id in hash){
				ar.push(hash[id]);
			}
			return ar;	// dijit._Widget[]
		},

		getUniqueId: function(/*String*/widgetType){
			// summary:
			//		Generates a unique id for a given widgetType

			var id;
			do{
				id = widgetType + "_" +
					(widgetType in _widgetTypeCtr ?
						++_widgetTypeCtr[widgetType] : _widgetTypeCtr[widgetType] = 0);
			}while(hash[id]);
			return dijit._scopeName == "dijit" ? id : dijit._scopeName + "_" + id; // String
		},

		findWidgets: function(/*DomNode*/ root){
			// summary:
			//		Search subtree under root returning widgets found.
			//		Doesn't search for nested widgets (ie, widgets inside other widgets).

			var outAry = [];

			function getChildrenHelper(root){
				for(var node = root.firstChild; node; node = node.nextSibling){
					if(node.nodeType == 1){
						var widgetId = node.getAttribute("widgetId");
						if(widgetId){
							var widget = hash[widgetId];
							if(widget){	// may be null on page w/multiple dojo's loaded
								outAry.push(widget);
							}
						}else{
							getChildrenHelper(node);
						}
					}
				}
			}

			getChildrenHelper(root);
			return outAry;
		},

		_destroyAll: function(){
			// summary:
			//		Code to destroy all widgets and do other cleanup on page unload

			// Clean up focus manager lingering references to widgets and nodes
			dijit._curFocus = null;
			dijit._prevFocus = null;
			dijit._activeStack = [];

			// Destroy all the widgets, top down
			array.forEach(registry.findWidgets(win.body()), function(widget){
				// Avoid double destroy of widgets like Menu that are attached to <body>
				// even though they are logically children of other widgets.
				if(!widget._destroyed){
					if(widget.destroyRecursive){
						widget.destroyRecursive();
					}else if(widget.destroy){
						widget.destroy();
					}
				}
			});
		},

		getEnclosingWidget: function(/*DOMNode*/ node){
			// summary:
			//		Returns the widget whose DOM tree contains the specified DOMNode, or null if
			//		the node is not contained within the DOM tree of any widget
			while(node){
				var id = node.getAttribute && node.getAttribute("widgetId");
				if(id){
					return hash[id];
				}
				node = node.parentNode;
			}
			return null;
		},

		// In case someone needs to access hash.
		// Actually, this is accessed from WidgetSet back-compatibility code
		_hash: hash
	};

	if(has("ie")){
		// Only run _destroyAll() for IE because we think it's only necessary in that case,
		// and because it causes problems on FF.  See bug #3531 for details.
		unload.addOnWindowUnload(function(){
			registry._destroyAll();
		});
	}

	/*=====
	dijit.registry = {
		// summary:
		//		A list of widgets on a page.
	};
	=====*/
	dijit.registry = registry;

	return registry;
});

},
'dojo/uacss':function(){
define("dojo/uacss", ["./dom-geometry", "./_base/lang", "./ready", "./_base/sniff", "./_base/window"],
	function(geometry, lang, ready, has, baseWindow){
	// module:
	//		dojo/uacss
	// summary:
	//		Applies pre-set CSS classes to the top-level HTML node, based on:
	//			- browser (ex: dj_ie)
	//			- browser version (ex: dj_ie6)
	//			- box model (ex: dj_contentBox)
	//			- text direction (ex: dijitRtl)
	//
	//		In addition, browser, browser version, and box model are
	//		combined with an RTL flag when browser text is RTL. ex: dj_ie-rtl.

	var
		html = baseWindow.doc.documentElement,
		ie = has("ie"),
		opera = has("opera"),
		maj = Math.floor,
		ff = has("ff"),
		boxModel = geometry.boxModel.replace(/-/,''),

		classes = {
			"dj_ie": ie,
			"dj_ie6": maj(ie) == 6,
			"dj_ie7": maj(ie) == 7,
			"dj_ie8": maj(ie) == 8,
			"dj_ie9": maj(ie) == 9,
			"dj_quirks": has("quirks"),
			"dj_iequirks": ie && has("quirks"),

			// NOTE: Opera not supported by dijit
			"dj_opera": opera,

			"dj_khtml": has("khtml"),

			"dj_webkit": has("webkit"),
			"dj_safari": has("safari"),
			"dj_chrome": has("chrome"),

			"dj_gecko": has("mozilla"),
			"dj_ff3": maj(ff) == 3
		}; // no dojo unsupported browsers

	classes["dj_" + boxModel] = true;

	// apply browser, browser version, and box model class names
	var classStr = "";
	for(var clz in classes){
		if(classes[clz]){
			classStr += clz + " ";
		}
	}
	html.className = lang.trim(html.className + " " + classStr);

	// If RTL mode, then add dj_rtl flag plus repeat existing classes with -rtl extension.
	// We can't run the code below until the <body> tag has loaded (so we can check for dir=rtl).
	// priority is 90 to run ahead of parser priority of 100
	ready(90, function(){
		if(!geometry.isBodyLtr()){
			var rtlClassStr = "dj_rtl dijitRtl " + classStr.replace(/ /g, "-rtl ");
			html.className = lang.trim(html.className + " " + rtlClassStr + "dj_rtl dijitRtl " + classStr.replace(/ /g, "-rtl "));
		}
	});
	return has;
});

},
'bf/ClientServerEvent':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */

define("bf/ClientServerEvent", ["dojo/_base/declare"], function(declare){
    return declare(null,{

        /*
         This class represents the interface to the XForms processor (aka 'betterForm Web'). It is the only class
         actually having dependency on DWR to handle the AJAX part of things and calling remote Java methods on
         de.betterform.web.flux.FluxFacade.
         */

        targetId:null,
        eventType:null,
        contextInfo:null,
        value:null,
        repeatItem:null,
        callerFunction:"",

        constructor:function () {
        },

        createClientServerEvent:function (targetId, eventType, contextInfo) {
            var newInstance = new ClientServerEvent();
            newInstance.targetId = targetId;
            newInstance.eventType = eventType;
            newInstance.contextInfo = contextInfo;
            return newInstance;
        },

        setTargetId:function (targetId) {
            this.targetId = targetId;
        },

        setEventType:function (eventType) {
            this.eventType = eventType;
        },

        setContextInfo:function (contextInfo) {
            this.contextInfo = contextInfo;
        },

        setValue:function (value) {
            this.value = value;
        },

        setRepeatItem:function (repeatItem) {
            this.repeatItem = repeatItem;
        },

        setCallerFunction:function (callerFunction) {
            this.callerFunction = callerFunction;
        },

        getTargetId:function () {
            return this.targetId;
        },

        getEventType:function () {
            return this.eventType;
        },

        getContextInfo:function () {
            return this.contextInfo;
        },

        getValue:function () {
            return this.value;
        },

        getRepeatItem:function () {
            return this.repeatItem;
        },

        getCallerFunction:function () {
            return this.callerFunction;
        }
    })
});

},
'bf/XFControl':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */

define("bf/XFControl", ["dojo/_base/declare", "dijit/_Widget","bf/XFBinding","dojo/dom", "dojo/dom-class","dojo/query",
        "dojo/dom-attr","dojo/_base/connect","dojo/dom-construct","dijit/registry","dojo/behavior","bf/util"],
    function(declare, _Widget, XFBinding, dom, domClass,query,domAttr,connect,domConstruct,registry,behavior){
        return declare([_Widget,XFBinding], {


    /**
     * All Rights Reserved.
     * @author Joern Turner
     *
     * XFControl represents a XForms control on the client. Instances of XFControl maintain the  MIP states,
     * the xforms appearance and some other information as CSS classes and acts as a proxy between concrete
     * controls and XForms controls. It always wraps a widget which is the concrete control the user interacts
     * with to input or change a value.
     *
     * An example DOM structure at runtime looks like this:
     * <span id="original id of XForms control on the server" class="xfControl (...)">
     *     <input type="text" class="xfValue".../>
     * </span>
     *
     * A XFControl always gets the id of the original XForms control. This id is used in all events to connect
     * the processor to the concrete UI widget used in the device (browser).
     *
     **/
        currentValue:null,
        incremental:false,

        /**
         * function to update the currentValue of XFControl (important
         * @param value
         */
        setCurrentValue:function(value){
            // console.debug("XFControl.setCurrentValue value:", value, " currentValue:",this.currentValue);
            this.currentValue = value;

        },

        postCreate:function() {
            if(this.isIncremental()){
                this.incremental = true;
            }
        },

        /**
         * sends an updated value of a widget to the server
         * @param value - the current Widget value to be send to the server
         * @param changeFocus - notifies xfControl if DOMFocusOut must be fired
         */

        sendValue:function(value, /*Boolean*/ changeFocus) {
            // console.debug("XFControl.sendValue: currentvalue:", this.currentValue, " - newValue:",value);
            if(this.isReadonly()){
                // console.debug("XFControl sendValue - control is readonly - ignoring event");
                return;
            }

            if (value != undefined && this.currentValue != value) {
                //update internal value
                this.currentValue = value;
                fluxProcessor.sendValue(this.id, value);
                this._handleRequiredEmpty();
            }
            if(this.isValid()){
                connect.publish("xforms-valid",[this.id,"onBlur"]);
            }else {
                connect.publish("xforms-invalid",[this.id,"onBlur"]);
            }

            /*if(changeFocus && fluxProcessor.usesDOMFocusOUT){*/
            if(changeFocus){
                this.bfFocus = false;
                //notify server of lost focus
                fluxProcessor.dispatchEventType(this.id,"DOMFocusOut");
            }
        },

        /*
        handles state changes (value and MIP changes) send by the server and applies them to the control. State
        changes are received from the client side xforms processor (XFProcessor) which handles all communication
        between client and server.
        Extends XFBinding.handleStateChanged
         */
        handleStateChanged:function(contextInfo) {
            // console.debug("XFControl.handleStateChanged this:", this, " contextInfo:",contextInfo);
            var tmpContextInfo = contextInfo;
            this.inherited(arguments);

            if (contextInfo["parentId"] == undefined) {
                var self = this;
                require(["dojo/ready"], function (ready) {
                    ready(function () {
                        // console.debug("XFControl.handleStateChanged after super call self.value:",self.value, " tmpContextInfo['value']: ", tmpContextInfo["value"]);
                        var value = tmpContextInfo["value"];
                        if (value != null && contextInfo["targetName"] != "label") {
                            // console.debug("XFControl.handleStateChange value != null: contextInfo:", contextInfo);
                            self.currentValue = value;
                            // console.debug("XFControl.handleStateChanged: calling self.setValue with value:",self.value ," and this.schemavalue:",tmpContextInfo["schemaValue"]);
                            self.setValue(value, tmpContextInfo["schemaValue"]);
                        }
                    })
                });
            }
        },

        isIncremental:function(){
            return domClass.contains(this.domNode, "xfIncremental");
        },

        /*
         fetches the value from the widget
         */
        getControlValue:function() {
            if(this.currentValue != undefined){
                return this.currentValue;
            }else {
                return "";
            }
        },


        // TODO: Lars: implement new (if needed), controlValue does not exist anymore
        _checkForDataTypeChange:function(dataType) {
             // console.debug("_checkForDataTypeChange: old dataType: " + this.dataType + " new dataType: ", dataType, " contextInfo:",contextInfo);

            if (this.controlValue == undefined) {
                var controlValueTemplate = query("*[id ='" + this.id + "-value']", this.domNode)[0];
                if (controlValueTemplate == undefined) {
                    controlValueTemplate = query(".xfValue", this.domNode)[0];
                }
                if (controlValueTemplate == undefined) {
                    console.error("Control._checkForDataTypeChange Error: XFControl " + this.id + " has no ControlValue node");
                    return;
                }
                else {
                    domAttr.set(controlValueTemplate, "dataType", dataType);
                    domAttr.set(controlValueTemplate, "id", this.id + "-value");
    //                this.controlValue = fluxProcessor.factory.createWidget(controlValueTemplate, this.id);

                }

            } else if (this.dataType != dataType && !(this.dataType == "" && dataType == "string")) {
                // console.debug("datatype for existing dijit changed this.dataType: " , this.dataType + "  dataType: ", dataType);

                var controlValueNode = document.createElement("span");
                domAttr.set(controlValueNode, "dataType", dataType);
                domAttr.set(controlValueNode, "controlType", this.controlType);
                domAttr.set(controlValueNode, "id", this.id + "-value");

                domClass.add(controlValueNode, "xfValue");
                var formerTypeClass = "xsd" + this.dataType.replace(/^[a-z]/, this.dataType.substring(0, 1).toUpperCase());
                if (domClass.contains(this.domNode, formerTypeClass)) {
                    // console.debug("remove CSS Type " + formerTypeClass);
                    domClass.remove(this.domNode, formerTypeClass);
                }
                domClass.add(this.domNode, "xsd" + dataType.replace(/^[a-z]/, dataType.substring(0, 1).toUpperCase()));

                this.controlValue.destroy();
                this.controlValue = fluxProcessor.factory.createWidget(controlValueNode, this.id);
                domConstruct.place(this.controlValue.domNode, this.domNode);
            }
            this.dataType = dataType;
        },

            /**
             * Function to handle MIP properties / value and Label on parent
             * Extends XFBinding._handleHelperChanged
             * @param properties
             */
        _handleHelperChanged: function(properties) {
            // console.debug("Control.handleHelperChanged: this.id: "+this.id+ "type='" + properties["targetName"] + "',  value='" + properties["value"] + "'");
            this.inherited(arguments);
            if(properties["targetName"] == "value") {
                this.setValue(properties["value"]);
            }
        },

        /**
         * "Abstract" API Function to update the value of the corresponding Widget
         * @param value localized value
         * @param schemavalue optional / original schema value (not localized)
         */
        setValue:function(value, schemavalue) {
            console.error("XFControl.setValue must be overwritten by it's accoring ControlValue Widget [id:", this.id + "-value]");
        },

        _handleRequiredEmpty:function(){
            if (domClass.contains(this.domNode, "xfRequiredEmpty")) {
                domClass.remove(this.domNode, "xfRequiredEmpty");
            }
        },

        getWidget:function() {
            if(this.widget == undefined) {
                this.widget = dom.byId(this.id+"-value");
            }
            return this.widget;
        },

        handleOnFocus:function() {
            //storing current control id for handling help
            // console.debug("XFControl.handleOnFocus storing current control id:", this.id, " value: ",this.currentValue);

            fluxProcessor.currentControlId = this.id;

            /*if (!this.bfFocus && fluxProcessor.usesDOMFocusIN) {*/
            if (!this.bfFocus) {
                // console.debug("ControlValue: dispatch DOMFocusIn to ",this.xfControl.id);
                fluxProcessor.dispatchEventType(this.id,"DOMFocusIn");
            }
            this.bfFocus = true;
            if(this.isValid()){
                connect.publish("xforms-valid",[this.id,"onFocus"]);
            }else {
                connect.publish("xforms-invalid",[this.id,"onFocus"]);
            }
        }

    });
});



},
'dojo/window':function(){
define("dojo/window", ["./_base/lang", "./_base/sniff", "./_base/window", "./dom", "./dom-geometry", "./dom-style"],
	function(lang, has, baseWindow, dom, geom, style) {

// module:
//		dojo/window
// summary:
//		TODOC

var window = lang.getObject("dojo.window", true);

/*=====
dojo.window = {
	// summary:
	//		TODO
};
window = dojo.window;
=====*/

window.getBox = function(){
	// summary:
	//		Returns the dimensions and scroll position of the viewable area of a browser window

	var
		scrollRoot = (baseWindow.doc.compatMode == 'BackCompat') ? baseWindow.body() : baseWindow.doc.documentElement,
		// get scroll position
		scroll = geom.docScroll(), // scrollRoot.scrollTop/Left should work
		w, h;

	if(has("touch")){ // if(scrollbars not supported)
		var uiWindow = baseWindow.doc.parentWindow || baseWindow.doc.defaultView;   // use UI window, not dojo.global window. baseWindow.doc.parentWindow probably not needed since it's not defined for webkit
		// on mobile, scrollRoot.clientHeight <= uiWindow.innerHeight <= scrollRoot.offsetHeight, return uiWindow.innerHeight
		w = uiWindow.innerWidth || scrollRoot.clientWidth; // || scrollRoot.clientXXX probably never evaluated
		h = uiWindow.innerHeight || scrollRoot.clientHeight;
	}else{
		// on desktops, scrollRoot.clientHeight <= scrollRoot.offsetHeight <= uiWindow.innerHeight, return scrollRoot.clientHeight
		// uiWindow.innerWidth/Height includes the scrollbar and cannot be used
		w = scrollRoot.clientWidth;
		h = scrollRoot.clientHeight;
	}
	return {
		l: scroll.x,
		t: scroll.y,
		w: w,
		h: h
	};
};

window.get = function(doc){
	// summary:
	// 		Get window object associated with document doc

	// In some IE versions (at least 6.0), document.parentWindow does not return a
	// reference to the real window object (maybe a copy), so we must fix it as well
	// We use IE specific execScript to attach the real window reference to
	// document._parentWindow for later use
	if(has("ie") && window !== document.parentWindow){
		/*
		In IE 6, only the variable "window" can be used to connect events (others
		may be only copies).
		*/
		doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
		//to prevent memory leak, unset it after use
		//another possibility is to add an onUnload handler which seems overkill to me (liucougar)
		var win = doc._parentWindow;
		doc._parentWindow = null;
		return win;	//	Window
	}

	return doc.parentWindow || doc.defaultView;	//	Window
};

window.scrollIntoView = function(/*DomNode*/ node, /*Object?*/ pos){
	// summary:
	//		Scroll the passed node into view, if it is not already.

	// don't rely on node.scrollIntoView working just because the function is there

	try{ // catch unexpected/unrecreatable errors (#7808) since we can recover using a semi-acceptable native method
		node = dom.byId(node);
		var doc = node.ownerDocument || baseWindow.doc,
			body = doc.body || baseWindow.body(),
			html = doc.documentElement || body.parentNode,
			isIE = has("ie"), isWK = has("webkit");
		// if an untested browser, then use the native method
		if((!(has("mozilla") || isIE || isWK || has("opera")) || node == body || node == html) && (typeof node.scrollIntoView != "undefined")){
			node.scrollIntoView(false); // short-circuit to native if possible
			return;
		}
		var backCompat = doc.compatMode == 'BackCompat',
			clientAreaRoot = (isIE >= 9 && node.ownerDocument.parentWindow.frameElement)
				? ((html.clientHeight > 0 && html.clientWidth > 0 && (body.clientHeight == 0 || body.clientWidth == 0 || body.clientHeight > html.clientHeight || body.clientWidth > html.clientWidth)) ? html : body)
				: (backCompat ? body : html),
			scrollRoot = isWK ? body : clientAreaRoot,
			rootWidth = clientAreaRoot.clientWidth,
			rootHeight = clientAreaRoot.clientHeight,
			rtl = !geom.isBodyLtr(),
			nodePos = pos || geom.position(node),
			el = node.parentNode,
			isFixed = function(el){
				return ((isIE <= 6 || (isIE && backCompat))? false : (style.get(el, 'position').toLowerCase() == "fixed"));
			};
		if(isFixed(node)){ return; } // nothing to do

		while(el){
			if(el == body){ el = scrollRoot; }
			var elPos = geom.position(el),
				fixedPos = isFixed(el);

			if(el == scrollRoot){
				elPos.w = rootWidth; elPos.h = rootHeight;
				if(scrollRoot == html && isIE && rtl){ elPos.x += scrollRoot.offsetWidth-elPos.w; } // IE workaround where scrollbar causes negative x
				if(elPos.x < 0 || !isIE){ elPos.x = 0; } // IE can have values > 0
				if(elPos.y < 0 || !isIE){ elPos.y = 0; }
			}else{
				var pb = geom.getPadBorderExtents(el);
				elPos.w -= pb.w; elPos.h -= pb.h; elPos.x += pb.l; elPos.y += pb.t;
				var clientSize = el.clientWidth,
					scrollBarSize = elPos.w - clientSize;
				if(clientSize > 0 && scrollBarSize > 0){
					elPos.w = clientSize;
					elPos.x += (rtl && (isIE || el.clientLeft > pb.l/*Chrome*/)) ? scrollBarSize : 0;
				}
				clientSize = el.clientHeight;
				scrollBarSize = elPos.h - clientSize;
				if(clientSize > 0 && scrollBarSize > 0){
					elPos.h = clientSize;
				}
			}
			if(fixedPos){ // bounded by viewport, not parents
				if(elPos.y < 0){
					elPos.h += elPos.y; elPos.y = 0;
				}
				if(elPos.x < 0){
					elPos.w += elPos.x; elPos.x = 0;
				}
				if(elPos.y + elPos.h > rootHeight){
					elPos.h = rootHeight - elPos.y;
				}
				if(elPos.x + elPos.w > rootWidth){
					elPos.w = rootWidth - elPos.x;
				}
			}
			// calculate overflow in all 4 directions
			var l = nodePos.x - elPos.x, // beyond left: < 0
				t = nodePos.y - Math.max(elPos.y, 0), // beyond top: < 0
				r = l + nodePos.w - elPos.w, // beyond right: > 0
				bot = t + nodePos.h - elPos.h; // beyond bottom: > 0
			if(r * l > 0){
				var s = Math[l < 0? "max" : "min"](l, r);
				if(rtl && ((isIE == 8 && !backCompat) || isIE >= 9)){ s = -s; }
				nodePos.x += el.scrollLeft;
				el.scrollLeft += s;
				nodePos.x -= el.scrollLeft;
			}
			if(bot * t > 0){
				nodePos.y += el.scrollTop;
				el.scrollTop += Math[t < 0? "max" : "min"](t, bot);
				nodePos.y -= el.scrollTop;
			}
			el = (el != scrollRoot) && !fixedPos && el.parentNode;
		}
	}catch(error){
		console.error('scrollIntoView: ' + error);
		node.scrollIntoView(false);
	}
};

return window;
});

},
'bf/XFProcessor':function(){
define("bf/XFProcessor", ["dojo/_base/declare",
    "bf/XFormsProcessor",
    "bf/ClientServerEvent",
    "dojo/dom",
    "dojo/query",
    "dojo/dom-class",
    "dojo/_base/window",
    "dojo/dom-style",
    "dojo/dom-attr",
    "dojo/_base/connect",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "dojo/_base/array",
    "dijit/registry",
    "dojo/has",
    "dojo/_base/json",
    "dojo/_base/event"], function(declare, XFormsProcessor,ClientServerEvent,
                                  dom,query,domClass,win,domStyle,domAttr,connect,lang,domConstruct,array,registry,has, json, dojoEvent){
    return declare("bf.XFProcessor",XFormsProcessor, {

        /**
         All Rights Reserved.
         @author Joern Turner
         @author Lars Windauer

         This class represents the interface to the remote XForms processor (aka 'betterForm Web') with DWR. It is the only class
         actually having dependency on DWR to handle the AJAX part of things and calling remote Java methods on
         de.betterform.web.betterform.FluxFacade.
         **/

        sessionKey:dojo.config.bf.sessionkey,
        skipshutdown:false,
        isDirty:false,
        currentControlId:"", // todo: only used for help, refactor later
        unloadMsg:"You are about to leave this XForms application",
        isReady:false,
        contextroot:dojo.config.bf.contextroot,
        subscribers:[], //todo:see line above
        clientServerEventQueue:[],
        requestPending:false,
        fifoReaderTimer:null,
        lastServerClientFocusEvent:null,
        usesDOMFocusIN:dojo.config.bf.useDOMFocusIN,
        usesDOMFocusOUT:dojo.config.bf.useDOMFocusOUT,
        useXFSelect:dojo.config.bf.useXFSelect,
        logEvents:dojo.config.bf.logEvents,
        mappingProcessor:null,
        _uiReady:false,
        initialEvents:[],
        bfDialogs:[],
        indicatorObjectTimer: null,
        indicatorContainer: null,
        indicatorImage: null,
        indicatorTargetObject: null,


        constructor:function() {
            // console.debug("XFProcessor.constructor sessionKey:",this.sessionKey);

            // initialize DWR

            Flux._path = dojo.config.bf.fluxPath;
            this.unloadMsg = dojo.config.bf.unloadingMessage;
            // console.debug("calling Flux.init");
            Flux.init(dojo.config.bf.sessionkey, dojo.hitch(this,this.applyChanges));

            // This is used for referencing this object from within ajax-callback-functions
            this.indicatorContainer = dom.byId('bfLoading');
            this.indicatorImage = dom.byId('indicator');
            this.indicatorImage.className = 'xfDisabled';
            // Initialize the clientServerEventQueue for immediately being able to append Elements
            this.clientServerEventQueue = [];

            connect.connect(window, "onbeforeunload", this, "handleUnload");
            connect.connect(window, "onunload", this, "close");
            this.skipshutdown = false;

            // Browser Detection
            this.userAgent = navigator.userAgent;
            //this.createCookie();
        },

        createCookie: function() {
            var date = new Date();
            date.setTime(date.getTime()+(7*24*60*60*1000));
            var expires = "; expires="+date.toGMTString();
            
            document.cookie = bfSessionKey+"="+this.sessionKey+expires+";";
        },
        
        handleUnload:function(evt) {
            // console.debug("XFProcessor.handleUnload Event: ", evt);
            if (this.isDirty && !this.skipshutdown) {
                // console.debug("dojoEvent:",dojoEvent)
                if(dojoEvent){
                    dojoEvent.stop(evt);
                }

                // console.debug(this.unloadMsg);
                // For IE
                evt.returnValue = this.unloadMsg;
                // For all others
                return this.unloadMsg;
            }
        },

        close:function() {
            // console.debug("fluxProcessor.close")
            var tmpSkipShutdown = lang.hitch(this, fluxProcessor.skipShutdown).skipshutdown;
            if (!tmpSkipShutdown) {
                fluxProcessor.closeSession();
            }
        },

        closeSession: function() {
            // console.debug("fluxProcessor.closeSession")
            try {
                dwr.engine.setErrorHandler(this._handleExceptions);
                dwr.engine.setOrdered(true);
                Flux.close(this.sessionKey);
            }
            catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.closeSession ", ex);
            }
        },

        ignoreExceptions: function (msg) {
            console.warn("XFProcessor.ignoreExceptions: msg:",msg);
        },


        /* Tries to sequentially process pending Events, as long as there is no other roundtrip in progress (Client-Server-Client)
         * Initiates a roundtrip the following conditions apply:
         * 1) The related Objects still exist:  Dijit + Dojo/DOM
         * 2) The Control is NOT read-only (only validated if it CAN be read-only)
         * 3) If an appended Attribute is a reference, the target (dijit/dojo) still needs to exist.
         * ... changed references are updated. (e.g. xf:repeat items)
         */
        eventFifoReader: function() {
            // console.debug("XFProcessor.eventFifoReader: this.clientServerEventQueue:",this.clientServerEventQueue);
            var nextPendingClientServerEvent = null;
            var dojoObject = null;
            var dijitObject = null;

            //Loop as long as Pending Events are being skipped (as long as no Request is being initiated)
            while ((!this.requestPending) && (this.clientServerEventQueue.length != 0)) {
                var setRepeatIndexEvent = undefined;
                for(var i = 0; i < this.clientServerEventQueue.length;i++) {
                    var clientServerEvent = this.clientServerEventQueue[i];
                    if(clientServerEvent.callerFunction=="setRepeatIndex"){
                        setRepeatIndexEvent = clientServerEvent;
                        this.clientServerEventQueue.splice(i, 1);
                        break;
                    }
                }
                if(setRepeatIndexEvent != undefined) {
                    nextPendingClientServerEvent = setRepeatIndexEvent;
                }else {
                    nextPendingClientServerEvent = this.clientServerEventQueue.shift();
                }

                // console.debug("nextPendingClientServerEvent: ",nextPendingClientServerEvent);
                var callerFunction = nextPendingClientServerEvent.getCallerFunction();
                var nextPendingTargetId = nextPendingClientServerEvent.getTargetId();

                //*****************************************************************************
                // START: skip this pending Event, if one of the following conditions occurred:
                //*****************************************************************************

                dojoObject = dom.byId(nextPendingTargetId);
                // console.debug("EventFifoReader dojoObject:",dojoObject, " targetId: ",nextPendingTargetId);
                if (dojoObject == null) {
                    console.warn("Event (Client to Server) for Dojo Control " + dojoObject + " skipped. CAUSE: OBJECT is NULL",nextPendingTargetId);
                    continue;
                }

                if(callerFunction != "setRepeatIndex"){
                    dijitObject = registry.byId(nextPendingTargetId);
                }

                // console.debug("EventFifoReader dijitObject:",dijitObject, " targetId: ",nextPendingTargetId);

                if (dojoObject == null && dijitObject == null && callerFunction != "setRepeatIndex") {
                    console.warn("XFProcessor.eventFifoReader: Event (Client to Server) for Dijit Control " + dijitObject + " skipped. CAUSE: OBJECT is NULL");
                    continue;

                }else if(callerFunction != "setRepeatIndex"){
                    // Test if this dijit-control has an isReadonly() method
                    // console.debug("XFProcessor.eventFifoReader: check if Object is readonly:",dijitObject, " reaondly: ",dijitObject.isReadonly());

                    if (dijitObject && dijitObject.isReadonly()) {
                        console.warn("XFProcessor.eventFifoReader: Event (Client to Server) for Dijit Control " + dijitObject + " skipped. CAUSE: READ-ONLY");
                        continue;
                    }

                }


                // Test if the Control's event was a setControlValue
                if (callerFunction == "setControlValue") {
                    // Test if the next Control-Value-Change originates from the same Control as this Control-Value-Change
                    if (this.clientServerEventQueue[0] != null) {
                        // Test if the targetId of this event and the next one are equal
                        if (this.clientServerEventQueue[0].getTargetId() == nextPendingTargetId) {
                            // Test if the CallerFunction of the next Event is also setControlValue
                            if (this.clientServerEventQueue[0].getCallerFunction() == "setControlValue") {
                                // console.debug("XFProcessor.eventFifoReader: Event (Client to Server) for Dijit Control " + dijitObject + " skipped. CAUSE: superseeded by following value-change of same Control");
                                continue;
                            }
                            else {
                                //console.debug("Nothing to skip. CAUSE: Following Event's CallerFunction differs from setControlValue");
                            }
                        }
                        else {
                            // console.debug("Nothing to skip. CAUSE: Next Event's ID was different from this Event's ID");
                        }
                    }
                    else {
                        // console.debug("Nothing to skip. CAUSE: Buffer was empty");
                    }
                }
                else {
                    // console.debug("Nothing to skip. CAUSE: No setControlValue found");
                }

                // Further processing of setRepeatIndex events
                // TODO: check if really not needed anymore
                /*
                 if (callerFunction == "setRepeatIndex") {
                 var repeatItems = query("#" + nextPendingClientServerEvent.targetId +" > tbody > .xfRepeatItem");
                 console.debug("repeatItems: " ,repeatItems," repeatitem position: ",repeatItems[(nextPendingClientServerEvent.getValue -1)]);

                 if (nextPendingClientServerEvent.getRepeatItem() == null) {
                 console.warn("Event (Client to Server) for Dijit Control " + nextPendingTargetId + " skipped. CAUSE: Repeat-Item for being selected has disappeared");
                 continue;
                 }

                 if (nextPendingClientServerEvent.getValue() != dijit.byNode(nextPendingClientServerEvent.getRepeatItem())._getXFormsPosition()) {
                 console.warn("Original Position: " + nextPendingClientServerEvent.getValue + " New Position: " + nextPendingClientServerEvent.getRepeatItem()._getXFormsPosition());
                 // Update the changed Position of this XForms-Repeat-Item
                 nextPendingclientServerEvent.setValue(dijit.byNode(nextPendingClientServerEvent.getRepeatItem())._getXFormsPosition());
                 }
                 }
                 */

                //*****************************************************************************
                // END:   skip this pending Event, if one of the following conditions occurred:
                //*****************************************************************************

                if (dojoObject != null) {
                    this._useLoadingMessage(dojoObject);
                }

                // console.debug("XFProcessor.dispatch event for ",callerFunction);
                switch (callerFunction) {
                    case "dispatchEvent":                this.requestPending = true; this._dispatchEvent(nextPendingTargetId); break;
                    case "dispatchEventType":        this.requestPending = true; this._dispatchEventType(nextPendingTargetId, nextPendingClientServerEvent.getEventType(), nextPendingClientServerEvent.getContextInfo()); break;
                    case "setControlValue":            this.requestPending = true; this._setControlValue(nextPendingTargetId, nextPendingClientServerEvent.getValue()); break;
                    //Re-transform the dojo-Id to repeat-Id
                    case "setRepeatIndex":            this.requestPending = true; this._setRepeatIndex(nextPendingTargetId, nextPendingClientServerEvent.getValue()); break;
                    default:                                        break;
                }
            }
            // console.debug("XFProcessor after Event is dispatched ");
            //Check if there are still more events pending
            if (this.clientServerEventQueue.length != 0) {
                // console.debug("XFProcessor after: this.clientServerEventQueue: ",this.clientServerEventQueue);
                clearTimeout(this.fifoReaderTimer);
                // Just to be sure, that the FIFO Buffer is being checked even in case, that an AJAX-response got lost
                this.fifoReaderTimer = setTimeout("fluxProcessor.eventFifoReader()", 2000);
            }
            else {
                //the last Request has been sent ... stop the timer
                clearTimeout(this.fifoReaderTimer);
            }
        },

        /*
         * Appends the provided clientServerEvent to the Pending-Event-FIFO-Buffer
         * Triggers the FIFO-Reader for trying to process the next pending events at the FIFO-Buffer.
         */
        eventFifoWriter: function(clientServerEvent) {
            // console.debug("XFProcessor.eventFifoWriter clientServerEvent:",clientServerEvent);

            //insert the new clientServerEvent at the beginning of the Buffer
            this.clientServerEventQueue.push(clientServerEvent);
            switch (clientServerEvent) {
                case "dispatchEvent":      console.info("FIFO-WRITE: dispatchEvent(" + clientServerEvent.getTargetId() + ")"); break;
                case "dispatchEventType":  console.info("FIFO-WRITE: dispatchEventType(" + clientServerEvent.getTargetId() + ", " + clientServerEvent.getEventType() + ", " + clientServerEvent.getContextInfo() + ")"); break;
                case "setControlValue":    console.info("FIFO-WRITE: setControlValue(" + clientServerEvent.getTargetId() + ", " + clientServerEvent.getValue() + ")"); break;
                case "setRepeatIndex":     console.info("FIFO-WRITE: setRepeatIndex(" + clientServerEvent.getTargetId() + ", " + clientServerEvent.getValue() + ")"); break;
                default:                   break;
            }
            //schedule the next try for reading the next pending Event of the FIFO-Buffer
            clearTimeout(this.fifoReaderTimer);
            this.fifoReaderTimer = setTimeout("fluxProcessor.eventFifoReader()", 0);
        },

        //eventually an 'activate' method still makes sense to provide a simple DOMActivate of a trigger Element
        dispatchEvent: function (targetId) {
            // console.debug("XFProcessor.dispatchEvent targetId:",targetId);

            var newClientServerEvent = new ClientServerEvent();
            newClientServerEvent.setTargetId(targetId);
            newClientServerEvent.setCallerFunction("dispatchEvent");
            this.eventFifoWriter(newClientServerEvent);
        },

        //eventually an 'activate' method still makes sense to provide a simple DOMActivate of a trigger Element
        _dispatchEvent: function (targetId) {
            // console.debug("XFProcessor.dispatch(",targetId,") this.xfProcessor: ", this);
            try {
                dwr.engine.setErrorHandler(this._handleExceptions);
                dwr.engine.setOrdered(true);
                Flux.dispatchEvent(targetId, this.sessionKey, this.applyChanges);
            } catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.dispatchEvent", ex);
            }
        },

        dispatchEventType:function(targetId, eventType, contextInfo) {
            if((this.usesDOMFocusOUT == false && "DOMFocusOut" == eventType) ||
                (this.usesDOMFocusIN == false && "DOMFocusIn" == eventType) ||
                (this.useXFSelect == false && "xformsSelect" == eventType)){
                console.info("XFProcessor.dispatchEventType: event:",eventType, " is disabled in form!! targetId is: ",targetId);
                return;

            }
            // change clientside eventType xformsSelect to DOMActivate for the Java processor
            if(eventType == "xformsSelect"){
                eventType = "DOMActivate";
            }
            // console.debug("XFProcessor.dispatchEventType(",targetId,") this: ", this, " eventType:",eventType, " contextInfo:",contextInfo);
            var newClientServerEvent = new ClientServerEvent();
            newClientServerEvent.setTargetId(targetId);
            newClientServerEvent.setEventType(eventType);
            newClientServerEvent.setContextInfo(contextInfo);
            newClientServerEvent.setCallerFunction("dispatchEventType");
            this.eventFifoWriter(newClientServerEvent);
        },

        _dispatchEventType:function(targetId, eventType, contextInfo) {
            // console.debug("XFProcessor._dispatchEventType(",targetId,") this: ", this, " eventType:",eventType, " contextInfo:",contextInfo);
            try {
                dwr.engine.setErrorHandler(this._handleExceptions);
                dwr.engine.setOrdered(true);
                if (contextInfo == undefined) {
                    Flux.dispatchEventType(targetId, eventType, this.sessionKey, lang.hitch(this, this.applyChanges));
                } else {
                    Flux.dispatchEventTypeWithContext(targetId, eventType, this.sessionKey, contextInfo, lang.hitch(this, this.applyChanges));
                }
            }
            catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.dispatchEventType", ex);
            }
        },

        /*
         Sends a value from a widget to the server. Will be called after any user interaction.
         */
        sendValue: function(controlId, value) {
            // console.debug("XFProcessor.sendValue", id, value);
            var newClientServerEvent = new ClientServerEvent();
            newClientServerEvent.setTargetId(controlId);
            newClientServerEvent.setValue(value);
            newClientServerEvent.setCallerFunction("setControlValue");
            this.eventFifoWriter(newClientServerEvent);
        },

        _setControlValue: function (controlId, value) {
            console.debug("XFProcessor.setControlValue", controlId, value);
            this.isDirty = true;
            try {
                dwr.engine.setErrorHandler(this._handleExceptions);
                dwr.engine.setOrdered(true);
                dwr.engine.setErrorHandler(this._handleExceptions);
                //        Flux.setUIControlValue(id, value, this.sessionKey,this.changeManager.applyChanges);
                Flux.setUIControlValue(controlId, value, this.sessionKey, this.applyChanges);
            }
            catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.setControlValue", ex);
            }
        },

        setRepeatIndex: function(/*String*/repeatId, /*String*/targetPosition) {
            console.debug("FluxProcessor.setRepeatIndex repeatId:",repeatId, " targetPosition:",targetPosition);
            var newClientServerEvent = new ClientServerEvent();
            newClientServerEvent.setTargetId(repeatId);
            newClientServerEvent.setValue(targetPosition);
            newClientServerEvent.setCallerFunction("setRepeatIndex");
            this.eventFifoWriter(newClientServerEvent);
        },

        _setRepeatIndex:function(/*String*/repeatId, /*String*/targetPosition) {
            // console.debug("XFProcessor.setRepeatIndex for Repeat "+ repeatId + " to position " + targetPosition);
            try {
                dwr.engine.setErrorHandler(this._handleExceptions);
                dwr.engine.setOrdered(true);
                Flux.setRepeatIndex(repeatId, targetPosition, this.sessionKey, this.applyChanges);
            } catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.setRepeatIndex", ex);
            }
        },


        //################################################################################################
        //################################################################################################
        //################################################################################################

        _fifoProcessingFinished: function() {
            // console.debug("XFProcessor._fifoProcessingFinished");
            domClass.remove(this.indicatorTargetObject, "bfPending");
            // Don't iterate through all items ... only use the last one and skip the rest
            var currentItem = this.lastServerClientFocusEvent;
            if (currentItem != undefined) {
                if (currentItem != null) {
                    currentItem.postponedFunction(currentItem.postponedXmlEvent);
                    this.lastServerClientFocusEvent = null;
                }
            }


            fluxProcessor.indicatorImage.className = 'xfDisabled';
        },

        _useLoadingMessage:function(dojoObject) {
            // console.debug("XFProcessor._useLoadingMessage dojoObject:", dojoObject);
            if (fluxProcessor.indicatorObjectTimer) {
                clearTimeout(fluxProcessor.indicatorObjectTimer);
            }
            if (this.indicatorTargetObject) {
                domClass.remove(this.indicatorTargetObject, "bfPending");
            }

            this.indicatorTargetObject = dojoObject;

            domClass.add(dojoObject, "bfPending");

            try {
                dwr.engine.setPreHook(function() {
                    fluxProcessor.indicatorImage.className = 'xfEnabled';
                    return false;
                });
                dwr.engine.setPostHook(function() {
                    fluxProcessor.indicatorObjectTimer = setTimeout('fluxProcessor._fifoProcessingFinished()', 500);
                    return false;
                });
            }
            catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux._useLoadingMessage", ex);
            }
        },

        _handleExceptions:function(msg, exception) {
            console.debug("XFProcessor._handleExceptions msg:",msg, " exception: ", exception);
            if (msg != undefined && exception != undefined) {
                console.error(msg, ' - Exception: ', exception);
            } else if (msg != undefined) {
                console.error(msg);
                alert(msg);
            } else {
                console.error("Unknown exception occured! arguments: ", arguments);
            }
        },

        applyChanges: function(data) {
            try {
                var validityEvents = [];
                var index = 0;

                //eventLog writing
                var eventLog = dom.byId("eventLog");

                array.forEach(data,
                    function(xmlEvent) {
                        // *** DO NOT COMMENT THIS OUT !!! ***
                        if(!fluxProcessor._uiReady && xmlEvent.type != "xforms-model-construct" &&
                            xmlEvent.type != "betterform-instance-created" &&
                            xmlEvent.type != "xforms-model-construct-done" &&
                            xmlEvent.type != "xforms-ready"){
                            fluxProcessor.initialEvents.push(xmlEvent);
                        }else {
                            console.debug("XFProcessor.applyChanges:", xmlEvent.type, " [", xmlEvent.contextInfo, "]");

                            /*
                             if 'logEvents' is true the eventlog from the server will be written
                             to DOM and can be viewed in a separate expandable section in the window.
                             */
                            //todo: the following code should be made a behavior only if debugging is available
                            //probably we have to add a private _applyChanges method to do the actual work to
                            //allow us to hook to this function and connect to it for outputting debug output.
                            if(fluxProcessor.logEvents){
                                //iterate contextinfo
                                var contextInfo = xmlEvent.contextInfo;
                                var tableCells = "";
                                // console.warn("ContextInfo.dataItem: ",contextInfo);
                                for (var dataItem in contextInfo){
                                    var funcArg = contextInfo[dataItem];

                                    //suppressing empty default info
                                    if(funcArg != null) {
                                        if(dataItem == "targetId" &&
                                            (xmlEvent.type == "betterform-state-changed" ||
                                                xmlEvent.type == "xforms-value-changed" ||
                                                xmlEvent.type == "xforms-valid" ||
                                                xmlEvent.type == "xforms-invalid" ||
                                                xmlEvent.type == "xforms-readonly" ||
                                                xmlEvent.type == "xforms-readwrite" ||
                                                xmlEvent.type == "xforms-required" ||
                                                xmlEvent.type == "xforms-optional" ||
                                                xmlEvent.type == "xforms-enabled" ||
                                                xmlEvent.type == "DOMFocusOut" ||
                                                xmlEvent.type == "DOMActivate" ||
                                                xmlEvent.type == "betterform-AVT-changed"
                                                )
                                            ){
                                            tableCells += "<tr><td class='propName'>"+ dataItem + "</td><td class='propValue'><a href='#' onclick='bf.devtool.reveal(this);'>" + contextInfo[dataItem] + "</a></td></tr>"
                                        }else if(dataItem == "targetElement" && xmlEvent.type == "betterform-load-uri"){
                                            var targetElement = contextInfo.xlinkTarget;
                                            tableCells += "<tr><td class='propName'>"+ dataItem + "</td><td class='propValue'><a href='#' onclick='bf.devtool.reveal(this);'>" + targetElement + "</a></td></tr>"
                                        }
                                        else {
                                            tableCells += "<tr><td class='propName'>"+ dataItem + "</td><td class='propValue'>" +  contextInfo[dataItem] + "</td></tr>"
                                        }
                                    }
                                }
                                //create output
                                domConstruct.create("li", {
                                    innerHTML: "<a href='#' onclick='bf.devtool.toggleEntry(this);'><span>"+xmlEvent.type+"</span></a><table class='eventLogTable'>" + tableCells + "</table>"
                                }, eventLog);
                            }

                            switch (xmlEvent.type) {
                                case "betterform-index-changed"      : fluxProcessor._handleBetterFormIndexChanged(xmlEvent); break;
                                case "betterform-insert-itemset"     : fluxProcessor._handleBetterFormInsertItemset(xmlEvent); break;
                                case "betterform-insert-repeatitem"  : fluxProcessor._handleBetterFormInsertRepeatItem(xmlEvent); break;
                                case "betterform-item-deleted"       : fluxProcessor._handleBetterFormItemDeleted(xmlEvent); break;
                                case "betterform-load-uri"           : fluxProcessor._handleBetterFormLoadURI(xmlEvent); break;
                                case "betterform-render-message"     : fluxProcessor._handleBetterFormRenderMessage(xmlEvent); break;
                                case "betterform-replace-all"        :
                                case "betterform-replace-all-xforms"        : fluxProcessor._handleBetterFormReplaceAll(xmlEvent); break;
                                case "betterform-state-changed"      : fluxProcessor._handleBetterFormStateChanged(xmlEvent); break;
                                case "betterform-item-changed"      : fluxProcessor._handleBetterFormItemChanged(xmlEvent); break;
                                case "betterform-dialog-open"        : fluxProcessor._handleBetterFormDialogOpen(xmlEvent); break;
                                case "betterform-dialog-close"       : fluxProcessor._handleBetterFormDialogClose(xmlEvent); break;
                                case "betterform-AVT-changed"        : fluxProcessor._handleAVTChanged(xmlEvent);break;
                                case "betterform-instance-created"   : fluxProcessor._handleInstanceCreated(xmlEvent);break;
                                case "betterform-model-removed"      : fluxProcessor._handleModelRemoved(xmlEvent);break;
                                case "betterform-exception"          : fluxProcessor._handleBetterformException(xmlEvent); break;
                                case "upload-progress-event"         : fluxProcessor._handleUploadProgressEvent(xmlEvent); break;
                                case "xforms-focus"                  : fluxProcessor._handleXFormsFocus(xmlEvent); break;
                                case "xforms-help"                   : fluxProcessor._handleShowHelp(xmlEvent); break;
                                case "xforms-hint"                   : fluxProcessor._handleXFormsHint(xmlEvent); break;
                                case "xforms-link-exception"         : fluxProcessor._handleLinkException(xmlEvent); break;
                                case "betterform-switch-toggled"     : connect.publish("bf-switch-toggled-" + xmlEvent.contextInfo.targetId, xmlEvent.contextInfo); break;
                                case "betterform-script-action"      : eval(xmlEvent.contextInfo["script"]); break;
                                case "xforms-value-changed"          : /* console.debug(xmlEvent); */ break;
                                case "xforms-version-exception"      : fluxProcessor._handleVersionException(xmlEvent); break;
                                case "xforms-binding-exception"      : fluxProcessor._handleBindingException(xmlEvent);break;
                                case "xforms-submit-error"           : fluxProcessor._handleSubmitError(xmlEvent); break;
                                case "DOMFocusIn"                    : fluxProcessor.lastServerClientFocusEvent = {postponedFunction:fluxProcessor._handleDOMFocusIn, postponedXmlEvent:xmlEvent}; break;    //cache the xmlEvent for being processed later
                                case "xforms-out-of-range"           : fluxProcessor._handleOutOfRange(xmlEvent);break;
                                case "xforms-in-range"               : fluxProcessor._handleInRange(xmlEvent);break;
                                case "xforms-invalid"                : fluxProcessor._handleInvalid(xmlEvent);break;
                                case "xforms-valid"                  : validityEvents[index] = xmlEvent; index++;break;
                                case "betterform-custom-mip-changed" : fluxProcessor._handleCustomMIPChanged(xmlEvent);break;
                                case "betterform-id-generated"       : break;
                                case "DOMActivate"                   : break;
                                case "xforms-select"                 : break;
                                case "xforms-deselect"               : break;
                                case "DOMFocusOut"                   : break;
                                case "xforms-model-construct"        : /*console.info("xforms-model-construct-done")*/;break;
                                case "xforms-model-construct-done"   : /*console.info("xforms-model-construct-done");*/fluxProcessor._buildUI();  break;
                                case "xforms-ready"                  : /*console.info("xforms-ready");*/fluxProcessor.isReady = true;connect.publish("xforms-ready", []);break; //not perfect - should be on XFormsModelElement
                                case "xforms-submit"                 : break;
                                case "xforms-submit-done"            : fluxProcessor._handleSubmitDone(xmlEvent);break;
                                /* Unknow XMLEvent: */
                                default                              : console.error("Event " + xmlEvent.type + " unknown [Event:", xmlEvent, "]"); break;
                            }

                        }
                    }
                );

                if(fluxProcessor.logEvents){
                    // add a devider for eventLogViewer
                    domConstruct.create("li", {
                        innerHTML: "<span class='logDevider'/>"
                    }, eventLog);
                }

                if (validityEvents.length > 0) {
                    fluxProcessor._handleValidity(validityEvents);
                }
            }
            catch(ex) {
                fluxProcessor._handleExceptions("An error occurred during applyChanges ", ex);
            }
            //The pending request tournaround has been completed
            fluxProcessor.requestPending = false;
            //Schedule the next FIFO-Read try in 0 ms
            clearTimeout(fluxProcessor.fifoReaderTimer);
            fluxProcessor.fifoReaderTimer = setTimeout("fluxProcessor.eventFifoReader()", 0);
        },

        _buildUI : function(){
            require(["bf/MappingProcessor","dojo/behavior", "dojo/domReady!"],function(MappingProcessor,behavior){
                if (this.mappingProcessor == undefined) {
                    this.mappingProcessor = new MappingProcessor();
                }
                behavior.apply();
            });

            // fire remaining initial events
            require(["dojo/ready"], function (ready) {
                ready(function () {
                    // console.debug("missing initial Events:",fluxProcessor.initialEvents);
                    fluxProcessor._uiReady = true;
                    fluxProcessor.applyChanges(fluxProcessor.initialEvents);
                    fluxProcessor.initialEvents = null;
                    var formWrapper = dom.byId("formWrapper");
                    if(formWrapper){
                        // console.debug("formWrapper:",formWrapper);
                        domStyle.set(formWrapper,"visibility","visible");
                        // betterform-styles.less sets this to hidden initially
                        domStyle.set(document.body,"overflow","auto");
                    }else {
                        console.debug("form wrapper not present. continue processing");
                    }
                });
            });
        },


        _handleInvalid:function(xmlEvent){
            console.debug("XFProcessor._handleInvalid xmlEvent:",xmlEvent);
            var targetid = xmlEvent.contextInfo.targetId;
            var alertContainer = dom.byId(targetid + "-alert");

            if(alertContainer != null){
                //remove old ones
                query(".bfAlertMsg",alertContainer).forEach(function(bfAlertMsg) {
                    domConstruct.destroy(bfAlertMsg);
                });

                //add incoming ones

                array.forEach(xmlEvent.contextInfo.alerts, function(alert,index) {
                    // console.debug("alert " + index + " is " + alert);
                    //domConstruct.create("span",{class:'bfAlertMsg',innerHTML:alert},alertContainer);
                    var alertNode = domConstruct.create("span",{innerHTML:alert},alertContainer);
                    domClass.add(alertNode, "bfAlertMsg");
                });
                //            connect.publish("xforms-invalid", [targetid,"invalid"]);
                domStyle.set(alertContainer, "display", "inline-block");
            }
        },

        _handleAVTChanged:function(xmlEvent){
            // console.debug("XFProcessor._handleAVTChanged xmlEvent:",xmlEvent);
            domAttr.set(xmlEvent.contextInfo.targetId, xmlEvent.contextInfo.attribute, xmlEvent.contextInfo.value);
        },

        _handleInstanceCreated:function(xmlEvent){
            // console.debug("XFProcessor._handleInstanceCreated xmlEvent:",xmlEvent);
            // TODO: Lars: add animation again
            // dojo.require("dojox.fx");
            var debugPane = dom.byId("bfDebugLinks");

            if(debugPane != null){
                var contextroot = domAttr.get(dom.byId("bfDebug"),"context");
                var newLink = document.createElement("a");
                domAttr.set(newLink,"href",contextroot + xmlEvent.contextInfo.modelId + "/" + xmlEvent.contextInfo.instanceId);
                domAttr.set(newLink,"target","_blank");
                domAttr.set(newLink,"modelId",xmlEvent.contextInfo.modelId);
                var linkText = document.createTextNode("Model:" + xmlEvent.contextInfo.modelId + " :: " + "Instance:" + xmlEvent.contextInfo.instanceId);
                newLink.appendChild(linkText);
                debugPane.appendChild(newLink);
                // dojox.fx.highlight({node:newLink, color:'#999999', duration:600}).play()
            }
        },

        _handleModelRemoved:function(xmlEvent){
            // console.debug("XFProcessor._handleModelRemoved xmlEvent:",xmlEvent);
            var modelId = xmlEvent.contextInfo.modelId;
            require(["dojo/query", "dojo/NodeList-manipulate"], function(query){
                query("#bfDebug a[modelId='" + modelId +"']").remove();
            });
        },

        _handleValidity:function(validityEvents) {
            // console.debug("XFProcessor._handleValidity validityEvents:",validityEvents);
            array.forEach(validityEvents, function(xmlEvent) {
                var control = registry.byId(xmlEvent.contextInfo.targetId);
                if (control != undefined) {
                    if (xmlEvent.type == "xforms-valid") {
                        control.setValid();
                    } else {
                        control.setInvalid();
                    }
                }
            });
        },


        /*
         ******************************************************************************************************
         * handles XForms binding exception
         ******************************************************************************************************
         */
        _handleBindingException:function(xmlEvent) {
            //todo: must be reviewed completely
            console.debug("XFProcessor._handleBindingException xmlEvent:",xmlEvent);
            console.warn("xforms-binding-exception at " + xmlEvent.contextInfo.targetId + " - " + xmlEvent.contextInfo.defaultinfo);
        },

        /*
         ******************************************************************************************************
         * handles XForms Version exception
         ******************************************************************************************************
         */
        _handleVersionException:function(xmlEvent) {
            //todo: must be reviewed completely
            console.error(xmlEvent.contextInfo.errorinformation);
        },

        /*
         ******************************************************************************************************
         * handles arbitrary exception occuring on server-side and write them our to DOM
         ******************************************************************************************************
         */
        _handleBetterformException:function(xmlEvent) {
            console.debug("XFProcessor._handleBetterformException xmlEvent:",xmlEvent);
            var description = xmlEvent.contextInfo.message;
            console.error(xmlEvent.contextInfo.message);
            var exception = dom.byId('betterFORM-exception');
            var log;
            var exceptionText;
            if (!exception) {
                log = document.createElement('div');
                log.id = 'betterFORM-exceptionLog';
                document.body.appendChild(log);
                exception = document.createElement('exception');
                exception.id = 'betterFORM-exception';
                exceptionText = document.createTextNode(description);
                exception.appendChild(exceptionText);
                log.appendChild(exception);
            } else {
                exception.removeChild(exception.firstChild);
                exceptionText = document.createTextNode(description);
                exception.appendChild(exceptionText);
            }
        },

        /*
         ******************************************************************************************************
         * handles XForms submit error by publishing xforms-invalid to all invalid controls and adding
         * a class 'xfRequiredEmpty' to required controls that have no value
         ******************************************************************************************************
         */
        _handleSubmitError:function(xmlEvent) {
            // console.warn("xforms-submit-error at ", xmlEvent.contextInfo);
            query(".xfInvalid", win.body()).forEach(function(control) {
                // console.debug("_handleSubmitError: invalid control: ", control);
                connect.publish("xforms-invalid", [domAttr.get(control, "id"),"submitError"]);
            });
            query(".xfRequired", win.body()).forEach(function(control) {
                //if control has no value add CSS class xfRequiredEmpty
                // console.debug("check required: control: ", control);
                var xfControl = registry.byId(domAttr.get(control, "id"));
                // console.debug("found Control Widget: xfControl: ", xfControl, " typeof xfControl.getControlValue  == 'function'': ", typeof xfControl.getControlValue == 'function');
                if(xfControl != undefined && typeof xfControl.getControlValue == 'function'){
                    var xfValue = xfControl.getControlValue();
                    if(xfValue == undefined || xfValue == ''){
                        domClass.add(xfControl.domNode,"xfRequiredEmpty");
                    }
                }
            });
        },


        /*
         ******************************************************************************************************
         * handles the XForms load actions including the embedding of subforms.
         ******************************************************************************************************
         */
        _handleBetterFormLoadURI:function(/*XMLEvent*/ xmlEvent) {
            console.debug("XFProcessor._handleBetterFormLoadURI xmlEvent:",xmlEvent);

            // xf:load show=replace
            if (xmlEvent.contextInfo.show == "replace") {
                fluxProcessor.skipshutdown = true;
                window.location.href = xmlEvent.contextInfo.uri;
            }
            // xf:load show=new
            else if (xmlEvent.contextInfo.show == "new") {
                window.open(xmlEvent.contextInfo.uri, '_betterform', 'menubar=yes,toolbar=yes,location=yes,directories=yes,fullscreen=no,titlebar=yes,hotkeys=yes,status=yes,scrollbars=yes,resizable=yes');

            }
            /* xf:load show=embed
             to embed an existing form into the running form
             */
            else if (xmlEvent.contextInfo.show == "embed") {
//            console.debug("xmlEvent.contextInfo.show='embed'", this);
                // getting target from event - can be either the value of a 'name' or 'id' Attribute
                var xlinkTarget = xmlEvent.contextInfo.xlinkTarget;

                //determine the DOM Element in the client DOM which is the target for embedding
                var targetid;
                if (dom.byId(xlinkTarget) != undefined) {
                    targetid = xlinkTarget;
                } else {
                    // if we reach here the xlinkTarget is no idref but the value of a name Attrbute that needs resolving
                    // to an id.
                    var tmp = query("*[name='" + xlinkTarget + "']")[0];
                    targetid = domAttr.get(tmp, "id");
                    console.debug("target id for embedding is: ", targetid);
                }

                this._unloadDOM(targetid);

                //get original Element in master DOM
                var htmlEntryPoint = dom.byId(targetid);
                htmlEntryPoint.innerHTML = xmlEvent.contextInfo.targetElement;
                domAttr.set(htmlEntryPoint, "id", xlinkTarget + "Old");
                var nodesToEmbed = dom.byId(targetid);

//            require("dojo/parser", function(parser){
//                parser.parse(htmlEntryPoint);
//            });
                // dojo.parser.parse(htmlEntryPoint);

                domConstruct.place(nodesToEmbed, htmlEntryPoint, "before");
//            dojo.fx.wipeIn({node: nodesToEmbed,duration: 500}).play();
                domStyle.set(nodesToEmbed,"display","block");

                //copy classes from mountpoint
                var classes = domAttr.get(htmlEntryPoint, "class");
                domAttr.set(nodesToEmbed, "class", classes);

                htmlEntryPoint.parentNode.removeChild(htmlEntryPoint);

                var self = this;
                // console.debug("\n\nTarget ID: ",targetid);
                require(["dojo/behavior"],function(behavior) {
                    // console.debug("htmlEntryPoint:",nodesToEmbed);
                    self.bfDialogs[targetid] = new Array();
                    query(".bfcDialog", nodesToEmbed).forEach(function(item) {
                        // console.debug("\n\nAdd Dialog:",domAttr.get(item,"id"));
                        var dialogId = domAttr.get(item,"id");
                        self.bfDialogs[targetid].push(dialogId);
                        if (registry.byId(dialogId) !=  undefined) {
                            item.parentNode.removeChild(item);
                        }
                    });
                    behavior.apply();
                });
                var contextInfo = xmlEvent.contextInfo;
                require(["dojo/ready"], function (ready) {
                    ready(function () {
                        var utilizedEvents = contextInfo.utilizedEvents;
                        // console.debug("xmlEvent.contextInfo.utilizedEvents:",xmlEvent.contextInfo.utilizedEvents);
                        if(utilizedEvents && utilizedEvents != ""){
                            var utilizedEventsObj =  json.fromJson("{" + utilizedEvents +  "}");
                            // console.debug("utilizedEventsObj:",utilizedEventsObj);
                            if(utilizedEventsObj.useXFSelect){
                                self.useXFSelect = true;
                            }
                            if(utilizedEventsObj.useDOMFocusIN){
                                self.useDOMFocusIN = true;
                            }
                            if(utilizedEventsObj.useDOMFocusOUT){
                                self.useDOMFocusOUT = true;
                            }
                        }

                        // finally dynamically load the CSS (if some) form the embedded form
                        var cssToLoad = contextInfo.inlineCSS;
//            console.debug("css to load: ", cssToLoad);
                        var headID = document.getElementsByTagName("head")[0];
                        var mountpoint = dom.byId(xlinkTarget);

                        if(cssToLoad != undefined && cssToLoad != ""){
                            //console.debug("adding Style: ", cssToLoad);
                            var stylesheet1 = document.createElement('style');
                            domAttr.set(stylesheet1,"type", "text/css");
                            domAttr.set(stylesheet1,"name", xlinkTarget);
                            var head1 = document.getElementsByTagName('head')[0];
                            head1.appendChild(stylesheet1);
                            if (stylesheet1.styleSheet) {   // IE
                                stylesheet1.styleSheet.cssText = cssToLoad;
                            } else {                // the world
                                var textNode1 = document.createTextNode(cssToLoad);
                                stylesheet1.appendChild(textNode1);
                            }
                        }

                        var externalCssToLoad = contextInfo.externalCSS;

                        if (externalCssToLoad != undefined && externalCssToLoad != "") {
                            var styles = externalCssToLoad.split('#');
                            var head2 = document.getElementsByTagName('head')[0];
                            for (var i = 0; i <= styles.length; i = i+1) {
                                if (styles[i] != undefined && styles[i] != "") {
                                    // console.debug("adding Style: ", styles[i]);
                                    var stylesheet2 = document.createElement('link');
                                    domAttr.set(stylesheet2,"rel","stylesheet");
                                    domAttr.set(stylesheet2,"type","text/css");
                                    domAttr.set(stylesheet2,"href",styles[i]);
                                    domAttr.set(stylesheet2,"name",xlinkTarget);
                                    head2.appendChild(stylesheet2);
                                }
                            }
                        }

                        var inlineJavaScriptToLoad = contextInfo.inlineJavascript;
                        if (inlineJavaScriptToLoad != undefined && inlineJavaScriptToLoad != "") {
                            //console.debug("adding script: ", inlineJavaScriptToLoad);
                            var javascript1 = document.createElement('script');
                            domAttr.set(javascript1,"type", "text/javascript");
                            domAttr.set(javascript1,"name", xlinkTarget);
                            var head3 = document.getElementsByTagName('head')[0];
                            head3.appendChild(javascript1);
                            javascript1.text = inlineJavaScriptToLoad;
                        }

                        var externalJavaScriptToLoad = contextInfo.externalJavascript;
                        if (externalJavaScriptToLoad != undefined && externalJavaScriptToLoad != "") {
                            var scripts = externalJavaScriptToLoad.split('#');
                            var head4 = document.getElementsByTagName("head")[0];
                            for (var z = 0; z <= scripts.length; z = z+1) {
                                if (scripts[z] != undefined && scripts[z] != "") {
                                    //console.debug("adding script: ", scripts[z]);
                                    var javascript2 = document.createElement('script');
                                    domAttr.set(javascript2,"type","text/javascript");
                                    domAttr.set(javascript2,"src",scripts[z]);
                                    domAttr.set(javascript2,"name",xlinkTarget);
                                    head4.appendChild(javascript2);
                                }
                            }
                        }
                    })
                })
            }
            /*  xf:load show=none
             to unload (loaded) subforms
             */
            else if (xmlEvent.contextInfo.show == "none") {
                // console.debug("XFProcessor._handleBetterFormLoadURI: htmlEntryPoint", htmlEntryPoint);
                this._unloadDOM(xmlEvent.contextInfo.xlinkTarget);
            }
            else {
                console.error("betterform-load-uri show='" + xmlEvent.contextInfo.show + "' unknown!");
            }


        },

        _unloadDOM:function(target) {
            // console.debug("_unloadDOM: target:",target);
            //delete CSS specific to subform
            var htmlEntryPoint = dom.byId(target);
            if (htmlEntryPoint == undefined) {
                return;
            }

            var styleList = document.getElementsByTagName("style");
            //console.debug("styleList" , styleList);
            if (styleList != undefined) {
                array.forEach(styleList, function(item) {
                    //console.debug("style: ", item);
                    if (item != undefined) {
                        if(domAttr.get(item,"name") == target){
                            //console.debug("removing style: ", item);
                            //console.debug("parentNode: ", item.parentNode);
                            item.parentNode.removeChild(item);
                        }
                    }
                });
            }

            /*
             unload previously loaded subform-specific stylesheets
             */
            var externalStyleList = document.getElementsByTagName("link");
            // console.debug("XFProcessor._unloadDOM: styleList" , externalStyleList);
            if (externalStyleList != undefined) {
                array.forEach(externalStyleList, function(item) {
                    //console.debug("style: ", item);
                    if (item != undefined) {
                        if(domAttr.get(item,"name") == target){
                            console.debug("removing style: ", item);
                            console.debug("parentNode: ", item.parentNode);
                            item.parentNode.removeChild(item);
                        }
                    }
                });
            }

            /*
             unload previously loaded subform-specific Javascripts
             */
            var scriptList = document.getElementsByTagName("script");
            //console.debug("scriptList" , scriptList);
            if (scriptList != undefined) {
                array.forEach(scriptList, function(item) {
                    //console.debug("script: ", item);
                    if (item != undefined) {
                        if(domAttr.get(item,"name") == target){
                            //console.debug("removing: ", item);
                            //console.debug("parentNode: ", item.parentNode);
                            item.parentNode.removeChild(item);
                        }
                    }
                });
            }

            var widgetID = "widgetid";
            if (has("ie") >= 5) {
                widgetID = "widgetId"
            }

            /*
             destroy all child dijits within subform tree
             */
            var widgets = query("*[" + widgetID + "]", htmlEntryPoint);
            var self = this;
            array.forEach(widgets,
                function(item) {
                    // console.debug("XFProcessor._unloadDOM item:",item);
                    if (item != undefined) {
                        var itemId = domAttr.get(item, 'id');
                        self._destroyUIControl(itemId,widgetID);
                    }
                }
            );
            // console.debug("Target id: ",target);
            if(this.bfDialogs && this.bfDialogs[target] && this.bfDialogs[target].length > 0){
                var dialogId = this.bfDialogs[target];
                // console.debug("dialogs to remove: ", dialogId);
                array.forEach(this.bfDialogs[target],function(id){
                    // console.debug("dialog to find and delete: ", id);
                    var dialogDijit = registry.byId(id);
                    if(dialogDijit){
                        // console.debug("destroy dialogDijit: ",dialogDijit);
                        var widgets = query("*[" + widgetID + "]", dialogDijit.domNode);
                        // console.debug("delete widgets in dialog: ",widgets);
                        array.forEach(widgets,
                            function(item) {
                                if (item != undefined) {
                                    var itemId = domAttr.get(item, 'id');
                                    self._destroyUIControl(itemId,widgetID);
                                }
                            }
                        );

                        dialogDijit.destroy();
                    }else {
                        console.warn("could not find a dijit for dialogDijit:",dialogDijit);
                    }
                });
                // console.debug("delete dialog", dialogId);
                delete this.bfDialogs[target];
            }
            console.info("XFProcessor._unloadDOM AFTER REMOVING SUBSCRIBERS: :",this.subscribers);
            while (htmlEntryPoint.hasChildNodes()) {
                // console.debug("XFProcessor._unloadDOM: hasChildNodes START");
                // console.dirxml(htmlEntryPoint.firstChild);
                // console.debug("XFProcessor._unloadDOM: hasChildNodes END");
                htmlEntryPoint.removeChild(htmlEntryPoint.firstChild);
            }
        },

        _destroyUIControl:function(itemId,widgetID) {
            var childDijit = registry.byId(itemId);
            if (childDijit != undefined) {
                // console.debug("XFProcessor._unloadDOM: destroy itemId: ",itemId, " dijit:", childDijit);
                this.removeSubscribers(itemId);
                childDijit.destroy();
            } else {
                var dijitId = domAttr.get(dom.byId(itemId), widgetID);
                if (dijitId != undefined) {
                // console.debug("XFProcessor._unloadDOM: ChildDijit is null; dijitId:",dijitId);
                self.removeSubscribers(dijitId);
                childDijit = registry.byId(dijitId);
                if (childDijit != undefined) {
                    childDijit.destroy();
                }
            }
            }
        },

        _handleCustomMIPChanged:function(xmlEvent) {
            //console.debug("FluxProcessor._handleCustomMIPChanged xlmEvent:", xmlEvent);

            // Put classes on the container? Yes, not on the value. That way you can allways decide to just style the value.
            // The other way around is not possible in css... You cannot style an ancestor based on e.g. classes on a child
            // So not
            //    var uiControl = dojo.byId(xmlEvent.contextInfo.targetId + "-value");
            // but
            var uiControl = dom.byId(xmlEvent.contextInfo.targetId);
            if (uiControl != undefined) {
                var classes = uiControl.className;
                var customMIPs = xmlEvent.contextInfo;

                for (var key in customMIPs) {
                    // targetId and targetName are in the contextInfo, but are NOT custom MIPs :-)
                    if (key != "targetId" && key !="targetName") {

                        // check if an existing class is present with the prefix
                        var replaceString = key+"\\\w*";
                        var match = classes.match(replaceString);
                        // if so, remove it
                        if (match != null) {
                            domClass.remove(uiControl,match);
                        }
                        // and add the new class
                        domClass.add(uiControl, key+customMIPs[key]);
                    }
                }
            }

        },

        /*
         ******************************************************************************************************
         * handles XForms xforms-submit-done events
         ******************************************************************************************************
         */
        _handleSubmitDone:function(xmlEvent) {
            // console.debug("XFProcessor._handleSubmitDone xmlEvent:",xmlEvent);

            if (xmlEvent.contextInfo.document != null) {
                //***** handle submission replace="new" *****
                //***** handle submission replace="new" *****
                //***** handle submission replace="new" *****
                var doc = xmlEvent.contextInfo.document;
                var newWindow = window.open();
                newWindow.document.write(doc);
                newWindow.document.close();
            } else if (xmlEvent.contextInfo.embedElement != null) {
                //*****   handle submission replace="embedHTML" *****
                //*****   handle submission replace="embedHTML" *****
                //*****   handle submission replace="embedHTML" *****
                if (xmlEvent.contextInfo.embedTarget == undefined) {
                    return;
                }
                var target = xmlEvent.contextInfo.embedTarget;
                var content = xmlEvent.contextInfo.embedElement;
                // console.debug("handle Embedding target:",target, " content:", content);

                //determine the DOM Element in the client DOM which is the target for embedding
                var targetid;
                if (dom.byId(target) != undefined) {
                    targetid = target;
                } else {
                    // if we reach here the target is no idref but the value of a name Attrbute that needs resolving
                    // to an id.
                    var tmp = query("*[name='" + target + "']")[0];
                    targetid = domAttr.get(tmp,"id");
                    console.debug("target id for embedding is: ", targetid);
                }

                this._unloadDOM(targetid);

                //get original Element in master DOM
                var htmlEntryPoint = dom.byId(targetid);
                htmlEntryPoint.innerHTML = content;

                require(["dojo/parser","dojo/behavior"], function(parser,behavior){
                    parser.parse(htmlEntryPoint);
                    behavior.apply();
                });
            }
        },

        /*
         ******************************************************************************************************
         * handles XForms message actions
         ******************************************************************************************************
         */
        _handleBetterFormRenderMessage:function(/*XMLEvent*/ xmlEvent) {
            console.debug("XFProcessor._handleBetterFormRenderMessage xmlEvent:", xmlEvent);
            var message = xmlEvent.contextInfo.message;
            var level = xmlEvent.contextInfo.level;
            //console.debug("XFProcessor.handleRenderMessage: message='" + message + "', level='" + level + "'");
            if (level == "ephemeral") {
                require(["dojox/widget/Toaster"],function(Toaster) {
                    if(registry.byId("betterformMessageToaster") == undefined) {
                        new Toaster({
                            id:"betterformMessageToaster",
                            positionDirection:"bl-up",
                            duration:"8000",
                            messageTopic:'bfMessageTopic'
                        },"betterformMessageToaster");
                    }
                    connect.publish("bfMessageTopic", [ {
                        message: message,
                        type: "fatal",
                        duration: 8000
                    }]);
                })
            }
            else {
                var exception = xmlEvent.contextInfo.exception;
                if (exception != undefined) {
                    console.warn("An Exception occured in Facade: ", exception);
                } else {
                    alert(message);
                }
                console.debug("finished _handleBetterFormRenderMessage");
            }
        },

        /*
         ******************************************************************************************************
         * handles XForms xforms-out-of-range events
         ******************************************************************************************************
         */
        _handleOutOfRange:function(xmlEvent) {
            /*
             var message = "Value for ui control '" + xmlEvent.contextInfo.targetName + "' (id:"+xmlEvent.contextInfo.targetId+") is out of range";
             registry.byId("betterformMessageToaster").setContent(message,'message');
             registry.byId("betterformMessageToaster").show();
             */
            var uiControl = dom.byId(xmlEvent.contextInfo.targetId + "-value");
            if (uiControl != undefined) {
                if (domClass.contains(uiControl, "xfInRange")) {
                    domClass.remove(uiControl, "xfInRange");
                }
                domClass.add(uiControl, "xfOutOfRange");
            }
        },

        /*
         ******************************************************************************************************
         * handles XForms xforms-in-range events
         ******************************************************************************************************
         */
        _handleInRange:function(xmlEvent) {
            console.debug("XFProcessor._handleInRange xmlEvent:", xmlEvent);
            var uiControl = dom.byId(xmlEvent.contextInfo.targetId + "-value");
            if (uiControl != undefined) {
                if (domClass.contains(uiControl, "xfOutOfRange")) {
                    domClass.remove(uiControl, "xfOutOfRange");
                }
                domClass.add(uiControl, "xfInRange");
            }
        },

        //todo: probably to be merged with '_handleSubmitDone'?
        _handleBetterFormReplaceAll:function( xmlEvent) {
            console.debug("XFProcessor._handleBetterFormReplaceAll");
            fluxProcessor.skipshutdown = true;

            // add new parameter (params are located before the anchor sign # in an URI)
            var anchorIndex = window.location.href.lastIndexOf("#");
            var queryIndex = window.location.href.lastIndexOf("?");
            var path = window.location.href;
            if (anchorIndex != -1) {
                path = window.location.href.substring(0, anchorIndex);
            }
            if (queryIndex == -1) {
                path += "?";
            }


            if (xmlEvent.type  === "betterform-replace-all-xforms" ) {
                path =  xmlEvent.contextInfo.redirectXForms;
                fluxProcessor.closeSession();
            }  else {
                path += "&submissionResponse=true&sessionKey=" + fluxProcessor.sessionKey;
            }
            if (anchorIndex != -1) {
                path += window.location.href.substring(anchorIndex);
            }
            window.open(path, "_self");
        },


        //todo: should be moved into a behavior
        _handleBetterFormDialogOpen:function(/*XMLEvent*/ xmlEvent) {
            console.debug("XFProcessor._handleBetterformDialogOpen: targetId: '",xmlEvent.contextInfo.targetId,"' parentId: " , xmlEvent.contextInfo.parentId);
            var xfControlId =xmlEvent.contextInfo.targetId;
            // if XForms Control Dijit allready exists call show on selected control
            if(registry.byId(xfControlId) != undefined){
                registry.byId(xfControlId).show();
            }else {
                console.error("XFProcessor: error during betterform-dialog-show-event: targetId '",xmlEvent.contextInfo.targetId, "', xfControlId: '", xfControlId,"' does not exist");
            }
        },

        //todo: should be moved into a behavior
        _handleBetterFormDialogClose:function(/*XMLEvent*/ xmlEvent) {
            console.debug("XFProcessor._handleBetterformDialogClose: targetId: '",xmlEvent.contextInfo.targetId,"' parentId: " , xmlEvent.contextInfo.parentId);
            var xfControlId =xmlEvent.contextInfo.targetId;
            // if XForms Control Dijit allready exists call hide on selected control
            if(registry.byId(xfControlId) != undefined){
                registry.byId(xfControlId).hide();
            }else {
                console.error("XFProcessor: error during betterform-dialog-hide-event: targetId '",xmlEvent.contextInfo.targetId,"' does not exist");
            }
        },


        _handleBetterFormStateChanged:function(/*XMLEvent*/ xmlEvent) {
            var contextInfo = xmlEvent.contextInfo;
            // IMPORTANT: DOJO/READY MUST NOT BE REMOVED!
            //  Otherwise _handleBetterFormStateChanged will be called before _handleBetterFORMInsert is finished!
            require(["dojo/ready"], function(ready){
                ready(function(){
                    // console.debug("XFProcessor._handleBetterFormStateChanged: contextInfo: ", contextInfo);
                    var parentId = contextInfo.parentId;

                    // if contextInfo.parentId is present dojo must publish to this id instead of targetid (e.g. used for value changes of labels)
                    if(parentId) {
                        // console.debug("XFProcessor._handleBetterFormStateChanged: publish (parent): bf-state-change- ", parentId, " contextInfo:",contextInfo);
                        connect.publish("bf-state-change-"+ parentId, contextInfo);

                    }
                    else {
                        // console.debug("XFProcessor._handleBetterFormStateChanged: publish: bf-state-change- ", contextInfo.targetId, " contextInfo:",contextInfo);
                        connect.publish("bf-state-change-"+ contextInfo.targetId,contextInfo);
                    }
                });
            })
        },

        _handleBetterFormItemChanged:function(/*XMLEvent*/ xmlEvent) {
            console.debug("XFProcessor._handleBetterFormItemChanged: targetId: " + xmlEvent.contextInfo.targetId , " xmlEvent: " , xmlEvent);
            var parentDOMNode = dom.byId(xmlEvent.contextInfo.parentId);
            try {
                while(!domClass.contains(parentDOMNode, "xfValue")){
                    parentDOMNode = parentDOMNode.parentNode;
                }
                // console.debug("XFProcessor._handleBetterFormItemChanged: id: ", domAttr.get(parentDOMNode, "id"), " parentNode: ",parentDOMNode);
                var selectParentId = domAttr.get(parentDOMNode, "id");
                connect.publish("xforms-item-changed-"+ selectParentId, xmlEvent.contextInfo);
            } catch(e) {
                console.warn("XFProcessor._handleBetterFormItemChanged: Select(1) or  item [", xmlEvent.contextInfo.parentId, "] not found! Error:",e);
            }
        },


        //todo: should be moved to a behavior
        //todo: note that xforms-insert might not target repeat or itemset
        _handleBetterFormInsertRepeatItem:function(xmlEvent) {
            // console.debug("XFProcessor.betterform-insert-repeatitem [id: '", xmlEvent.contextInfo.targetId, "'] xmlEvent:",xmlEvent);
            connect.publish("betterform-insert-repeatitem-"+ xmlEvent.contextInfo.targetId, xmlEvent.contextInfo);
        },

        _handleBetterFormInsertItemset:function(xmlEvent) {
            // console.debug("betterform-insert-itemset [id: '", xmlEvent.contextInfo.parentId+"-value", " / contextInfo:",xmlEvent.contextInfo,']' );
            connect.publish("betterform-insert-item-"+ xmlEvent.contextInfo.parentId + "-value", xmlEvent.contextInfo);
        },
        _handleBetterFormItemDeleted:function(xmlEvent) {
            // console.debug("handle betterform-item-deleted for ", xmlEvent.contextInfo.targetName, " [id: '", xmlEvent.contextInfo.targetId, "'] xmlEvent:", xmlEvent);
            if (xmlEvent.contextInfo.targetName == "itemset") {
                connect.publish("betterform-delete-item-"+ xmlEvent.contextInfo.parentId + "-value", xmlEvent.contextInfo);
            }else {
                connect.publish("betterform-item-deleted-"+ xmlEvent.contextInfo.targetId, xmlEvent.contextInfo);
            }
        },

        //todo: move to repeat behavior
        _handleBetterFormIndexChanged:function(xmlEvent) {
            // console.debug("XFProcessor._handleBetterFormIndexChanged xmlEvent:",xmlEvent);
            connect.publish("betterform-index-changed-"+xmlEvent.contextInfo.targetId, xmlEvent.contextInfo);

        },

        _handleUploadProgressEvent:function(xmlEvent) {
            console.debug("XFProcessor._handleUploadProgressEvent: xmlEvent:",xmlEvent);
            var xfControlId = xmlEvent.contextInfo.targetId;
            // if XForms Control Dijit allready exists call handleStateChanged on selected control
            if (registry.byId(xfControlId+"-value") != undefined) {
                registry.byId(xfControlId+"-value").updateProgress(xmlEvent.contextInfo.progress);
            } else {
                console.error("error during upload-progress-event: targetId " + xmlEvent.contextInfo.targetId + " does not exist");
            }
        },
        _handleXFormsFocus:function(xmlEvent) {
            console.debug("xforms-focus xmlEvent: ", xmlEvent);
            try {
                var targetName = xmlEvent.contextInfo.targetName;
                if (targetName != "group" && targetName != "repeat" && targetName != "switch" && targetName != "case") {
                    var controlToFocus = registry.byId(xmlEvent.contextInfo.targetId + "-value");
                    if(!controlToFocus){
                        controlToFocus = dom.byId(xmlEvent.contextInfo.targetId + "-value");
                    }
                    if(controlToFocus && controlToFocus.focus){
                        controlToFocus.focus();
                    }else {
                        console.warn("Control " + xmlEvent.contextInfo.targetId + " does not exist");
                    }
                }
            }
            catch(ex) {
                fluxProcessor._handleExceptions("error during xforms-focus: targetId " + xmlEvent.contextInfo.targetId + " does not exist - Exception:", ex);
            }

        },

        _handleDOMFocusIn:function(xmlEvent) {
            console.debug("XFProcessor._handleDOMFocusIn xmlEvent:",xmlEvent);
            xfControlId = xmlEvent.contextInfo.targetId + "-value";
            if (registry.byId(xfControlId) != undefined) {
                // console.debug("dom-focus-in-dijit control: ",xfControlId);
                registry.byId(xfControlId)._handleDOMFocusIn();
            } else if (dom.byId(xfControlId) != undefined) {
                // console.debug("dom-focus-in-dojo control: ",xfControlId);
                var domControlValue = dom.byId(xfControlId);
                domControlValue.focus();
            } else {
                console.warn("XFProcessor._handleDOMFocusIn no Element found for id:", xfControlId, " might have been destroyed");
            }
        },

        _handleXFormsHint:function(xmlEvent) {
            console.debug("XFProcessor._handleXFormsHint xmlEvent:",xmlEvent);
            var xfControlId = xmlEvent.contextInfo.targetId;
            var message = domAttr.get(dom.byId(xfControlId + "-value"), "title");
            registry.byId("betterformMessageToaster").setContent(message, 'message');
            registry.byId("betterformMessageToaster").show();
        },

        _handleShowHelp:function(xmlEvent) {
            console.debug("XFProcessor._handleShowHelp xmlEvent:",xmlEvent);
            fluxProcessor.currentControlId = xmlEvent.contextInfo.targetId;
            fluxProcessor.showHelp();
        },

        _handleLinkException:function(xmlEvent) {
            console.debug("XFProcessor._handleLinkException xmlEvent:",xmlEvent);
            console.error("Fatal error - " + xmlEvent.type + ": Failed to load resource: " + xmlEvent.contextInfo.resourceUri);
            //        fluxProcessor.closeSession();
        },

        fetchProgress:function(fetchProgressId, fileName) {
            // console.debug("XFProcessor.fetchProgress id:", fetchProgressId);
            try {
                console.debug("XFProcessor.fetchProgress id:", fetchProgressId, "fileName: " , fileName , " this.sessionKey:", this.sessionKey);
                Flux.fetchProgress(fetchProgressId, fileName, this.sessionKey, this.applyChanges);
            }
            catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.fetchProgress", ex);
            }
        },

        /*
         @param: String locale
         */

        setLocale:function(locale) {
            console.debug("XFProcessor.setLocale: Changed locale to: " + locale);
            try {
                Flux.setLocale(locale, this.sessionKey, this.applyChanges);
            }
            catch(ex) {
                fluxProcessor._handleExceptions("Failure executing Flux.setLocale", ex);
            }
        },

        showHelp:function(controlId) {
            console.debug("showng help for:", controlId);
            var helpCtrl = dom.byId(controlId + '-help');
            if (helpCtrl == undefined) {
                console.warn("No help available for Control Id: '" + controlId + "'");
                return;
            }
            var helpText = dom.byId(controlId + "-help-text");
            var currentState = domStyle.get(helpText,"display");

            if(currentState == "none"){
                domStyle.set(helpText, "display","inline-block");
            }else{
                domStyle.set(helpText, "display","none");
            }
        },

        getInstanceDocument:function(modelId, instanceId){
            console.debug("XFProcessor.getInstanceDocument modeId:", modelId, " instanceId:",instanceId);
            dwr.engine.setErrorHandler(this._handleExceptions);
            Flux.getInstanceDocument(modelId, instanceId, this.sessionKey,this.printInstance);
        },

        printInstance:function(data){
            console.debug("XFProcessor.printInstance data:", data);
            // console.dirxml(data);
            dom.byId("debugFrame").innerHTML=data;
        },

        addSubscriber:function(subscriberID, handle){
            if(this.subscribers[subscriberID] == undefined) {
                this.subscribers[subscriberID] = new Array();
            }
            this.subscribers[subscriberID].push(handle);
        },
        removeSubscribers:function(subscriberID){
            // console.warn("removing subscribers for id: ", id, " subcribers: ",this.subscribers[id]);
            if(this.subscribers[subscriberID]!=undefined){
                array.forEach(this.subscribers[subscriberID], function(handle) {
                    // console.debug("removing handle:",handle);
                    connect.unsubscribe(handle);
                });
                delete this.subscribers[subscriberID];
            }
        }
    })
});

},
'bf/factory/FactorySelect1':function(){
define("bf/factory/FactorySelect1", ["dojo/_base/declare","dojo/_base/connect","dijit/registry","dojo/dom-attr","dojo/dom-class","dojo/query","bf/util"],
    function(declare,connect,registry,domAttr,domClass,query) {
        return declare(null,
            {
                /**
                 *
                 * @param type
                 * @param node
                 */
                create:function(type, node){
                    var n = query(".xfValue",node)[0];
                    var xfId = bf.util.getXfId(n);
                    var xfControlDijit = registry.byId(xfId);
                    var dataObj = bf.util.parseDataAttribute(n,"data-bf-params");
                    var initialValue = dataObj.value;

                    xfControlDijit.setCurrentValue(initialValue);

                    var openselection = dataObj.selection == "open";
                    if(type == "combobox" && openselection){
                        type = "open";
                    }else if(openselection){
                        console.warn("selection = 'open' not support for xf:select with appearance='full'");
                    }

                    // console.debug("FactorySelect1 type: ", type);
                    switch(type){
                        case "combobox":
                            require(["bf/select/Select1ComboBox"], function(Select1ComboBox) {
                                console.debug("FactorySelect (minimal/compact) id:",xfId);
                                var select1Widget = new Select1ComboBox({id:n.id,value:initialValue}, n);

                                xfControlDijit.setValue = function(value, schemavalue) {
                                    // console.debug("FactorySelect1.setValue for combobox value: ", value, " this: ", this, " select1Widget:",select1Widget);
                                    select1Widget.currentValue =  value;
                                    domAttr.set(n, "value", value);
                                };

                                connect.connect(n,"onchange",function(evt){
                                    // console.debug("FactorySelect1 comboBox: onchange",n);
                                    // trigger xforms-select event by sending DOMActivate to the XFormsProcessor
                                    // TODO: Lars: should the factory call the fluxProcessor directly or do we need something else here?
                                    var selectedOption = n.options[n.selectedIndex];
                                    fluxProcessor.dispatchEventType(xfId, "xformsSelect", domAttr.get(selectedOption,"id"));
                                    if(xfControlDijit.isIncremental()){
                                        xfControlDijit.sendValue(n.value,false);
                                    }

                                });

                                connect.connect(n,"onblur",function(evt){
                                    xfControlDijit.sendValue(n.value, true);
                                });
                                connect.connect(n,"onfocus",function(evt){
                                    xfControlDijit.handleOnFocus();
                                });
                            });
                            break;
                        case "radiobuttons":
                            // console.debug("FactorySelect (full) id:",xfId);

                            require(["dojo/query", "bf/select/Select1Radio"], function(query, Select1Radio) {

                                var select1RadioWidget = new Select1Radio({id:n.id,controlId:xfId}, n);

                                query(".xfRadioValue", n).forEach(function(radioValue){
                                    radioValue.onclick = function(evt) {
                                        // console.debug("xfRadioValue.onClick:",radioValue);
                                        var selectedOptionId = bf.util.getXfId(radioValue);
                                        // console.debug("selected option id: ", selectedOptionId);
                                        fluxProcessor.dispatchEventType(xfId, "xformsSelect", selectedOptionId);
                                        if(xfControlDijit.isIncremental()){
                                            xfControlDijit.sendValue(radioValue.value,false );
                                        }
                                    }
                                });

                                xfControlDijit.setValue = function(value) {
                                    query(".xfRadioValue", n).forEach(function(radioValue){
                                        if(radioValue.value == value){
                                            domAttr.set(radioValue,"checked", true);
                                        }else {
                                            domAttr.set(radioValue,"checked", false);
                                        }
                                    });
                                };
                                connect.connect(select1RadioWidget, "onFocus",function() {
                                    xfControlDijit.handleOnFocus();
                                });
                                xfControlDijit.setReadonly = function() {
                                    // console.debug("FactorySelect (Checkbox).setReadonly xfControlDijit:",xfControlDijit);
                                    domClass.replace(xfControlDijit.srcNodeRef, "xfReadOnly", "xfReadWrite");
                                    select1RadioWidget.setReadOnly();
                                };

                                xfControlDijit.setReadwrite = function() {
                                    // console.debug("FactorySelect (Checkbox).setReadwrite xfControlDijit",xfControlDijit);
                                    domClass.replace(xfControlDijit.srcNodeRef,"xfReadWrite", "xfReadOnly");
                                    select1RadioWidget.setReadWrite();
                                };



                            });
                            break;
                        case "open":
                            require(["dijit/form/ComboBox"],function(ComboBox){
                                var comboBox = new ComboBox({
                                    id:n.id,
                                    name:n.name,
                                    className:"xfValue",
                                    autocomplete:true,
                                    onChange: function(value){
                                        // console.log("combobox onchange ", value);
                                        var result = this.item ? this.item.value : value;
                                        // console.debug("send result:",result);
                                        xfControlDijit.sendValue(result,false);
                                    },
                                    onBlur:function(){
                                        var items = this.store.query({ name: this.get("value") });
                                        // console.debug("item:",items);
                                        var result = items[0] ? items[0].value : this.get("value");
                                        // console.debug("result:",result);
                                        xfControlDijit.sendValue(result,true);
                                    },
                                    onFocus:function(){
                                        xfControlDijit.handleOnFocus();
                                    }
                                }, n);

                                // handle initial value
                                var initialItems = comboBox.store.query({ value: initialValue });
                                if(initialItems[0]){
                                    comboBox.set("item",initialItems[0]);
                                } else {
                                    comboBox.set("value",initialValue);
                                }

                                // override xfControl.setValue
                                xfControlDijit.setValue = function(value) {
                                    // console.debug("FactorySelect.setValue: ", value);
                                    comboBox.currentValue = value;

                                    var items = comboBox.store.query({ value: value });
                                    // console.debug("items:",items);
                                    if(items[0]){
                                        comboBox.set("item",items[0]);
                                    }else {
                                        comboBox.set("value",value);
                                    }
                                };

                                connect.subscribe("xforms-item-changed-" + n.id , function(contextInfo){
                                    console.warn("TBD: FactorySelect1 (open) xforms-item-changed contextInfo:",contextInfo)
                                });
                                connect.subscribe("betterform-insert-item-" + n.id , function(contextInfo){
                                    console.warn("TBD: FactorySelect1 (open) betterform-insert-item contextInfo:",contextInfo)
                                });
                                connect.subscribe("betterform-delete-item-" + n.id , function(contextInfo){
                                    console.warn("TBD: FactorySelect1 (open) betterform-delete-item contextInfo:",contextInfo)
                                });


                                // READONLY HANDLING
                                xfControlDijit.setReadonly = function() {
                                    domClass.replace(n,"xfReadWrite","xfReadOnly");
                                    comboBox.set("disabled",true);
                                };

                                xfControlDijit.setReadwrite=function() {
                                    domClass.replace(n,"xfReadWrite", "xfReadOnly");
                                    comboBox.set("disabled",false);
                                };
                            });
                            break;
                        default:
                            console.warn("FactorySelect1.default");

                    }
                }

            }
        );
    }
);


},
'dijit/_OnDijitClickMixin':function(){
define("dijit/_OnDijitClickMixin", [
	"dojo/on",
	"dojo/_base/array", // array.forEach
	"dojo/keys", // keys.ENTER keys.SPACE
	"dojo/_base/declare", // declare
	"dojo/_base/sniff", // has("ie")
	"dojo/_base/unload", // unload.addOnWindowUnload
	"dojo/_base/window" // win.doc.addEventListener win.doc.attachEvent win.doc.detachEvent
], function(on, array, keys, declare, has, unload, win){

	// module:
	//		dijit/_OnDijitClickMixin
	// summary:
	//		Mixin so you can pass "ondijitclick" to this.connect() method,
	//		as a way to handle clicks by mouse, or by keyboard (SPACE/ENTER key)


	// Keep track of where the last keydown event was, to help avoid generating
	// spurious ondijitclick events when:
	// 1. focus is on a <button> or <a>
	// 2. user presses then releases the ENTER key
	// 3. onclick handler fires and shifts focus to another node, with an ondijitclick handler
	// 4. onkeyup event fires, causing the ondijitclick handler to fire
	var lastKeyDownNode = null;
	if(has("ie")){
		(function(){
			var keydownCallback = function(evt){
				lastKeyDownNode = evt.srcElement;
			};
			win.doc.attachEvent('onkeydown', keydownCallback);
			unload.addOnWindowUnload(function(){
				win.doc.detachEvent('onkeydown', keydownCallback);
			});
		})();
	}else{
		win.doc.addEventListener('keydown', function(evt){
			lastKeyDownNode = evt.target;
		}, true);
	}

	// Custom a11yclick (a.k.a. ondijitclick) event
	var a11yclick = function(node, listener){
		if(/input|button/i.test(node.nodeName)){
			// pass through, the browser already generates click event on SPACE/ENTER key
			return on(node, "click", listener);
		}else{
			// Don't fire the click event unless both the keydown and keyup occur on this node.
			// Avoids problems where focus shifted to this node or away from the node on keydown,
			// either causing this node to process a stray keyup event, or causing another node
			// to get a stray keyup event.

			function clickKey(/*Event*/ e){
				return (e.keyCode == keys.ENTER || e.keyCode == keys.SPACE) &&
						!e.ctrlKey && !e.shiftKey && !e.altKey && !e.metaKey;
			}
			var handles = [
				on(node, "keypress", function(e){
					//console.log(this.id + ": onkeydown, e.target = ", e.target, ", lastKeyDownNode was ", lastKeyDownNode, ", equality is ", (e.target === lastKeyDownNode));
					if(clickKey(e)){
						// needed on IE for when focus changes between keydown and keyup - otherwise dropdown menus do not work
						lastKeyDownNode = e.target;

						// Prevent viewport scrolling on space key in IE<9.
						// (Reproducible on test_Button.html on any of the first dijit.form.Button examples)
						// Do this onkeypress rather than onkeydown because onkeydown.preventDefault() will
						// suppress the onkeypress event, breaking _HasDropDown
						e.preventDefault();
					}
				}),

				on(node, "keyup", function(e){
					//console.log(this.id + ": onkeyup, e.target = ", e.target, ", lastKeyDownNode was ", lastKeyDownNode, ", equality is ", (e.target === lastKeyDownNode));
					if(clickKey(e) && e.target == lastKeyDownNode){	// === breaks greasemonkey
						//need reset here or have problems in FF when focus returns to trigger element after closing popup/alert
						lastKeyDownNode = null;
						listener.call(this, e);
					}
				}),

				on(node, "click", function(e){
					// and connect for mouse clicks too (or touch-clicks on mobile)
					listener.call(this, e);
				})
			];

			return {
				remove: function(){
					array.forEach(handles, function(h){ h.remove(); });
				}
			};
		}
	};

	return declare("dijit._OnDijitClickMixin", null, {
		connect: function(
				/*Object|null*/ obj,
				/*String|Function*/ event,
				/*String|Function*/ method){
			// summary:
			//		Connects specified obj/event to specified method of this object
			//		and registers for disconnect() on widget destroy.
			// description:
			//		Provide widget-specific analog to connect.connect, except with the
			//		implicit use of this widget as the target object.
			//		This version of connect also provides a special "ondijitclick"
			//		event which triggers on a click or space or enter keyup.
			//		Events connected with `this.connect` are disconnected upon
			//		destruction.
			// returns:
			//		A handle that can be passed to `disconnect` in order to disconnect before
			//		the widget is destroyed.
			// example:
			//	|	var btn = new dijit.form.Button();
			//	|	// when foo.bar() is called, call the listener we're going to
			//	|	// provide in the scope of btn
			//	|	btn.connect(foo, "bar", function(){
			//	|		console.debug(this.toString());
			//	|	});
			// tags:
			//		protected

			return this.inherited(arguments, [obj, event == "ondijitclick" ? a11yclick : event, method]);
		}
	});
});

},
'dijit/hccss':function(){
define("dijit/hccss", [
	"require",			// require.toUrl
	"dojo/_base/config", // config.blankGif
	"dojo/dom-class", // domClass.add domConstruct.create domStyle.getComputedStyle
	"dojo/dom-construct", // domClass.add domConstruct.create domStyle.getComputedStyle
	"dojo/dom-style", // domClass.add domConstruct.create domStyle.getComputedStyle
	"dojo/ready", // ready
	"dojo/_base/sniff", // has("ie") has("mozilla")
	"dojo/_base/window" // win.body
], function(require, config, domClass, domConstruct, domStyle, ready, has, win){

	// module:
	//		dijit/hccss
	// summary:
	//		Test if computer is in high contrast mode, and sets dijit_a11y flag on <body> if it is.

	if(has("ie") || has("mozilla")){	// NOTE: checking in Safari messes things up
		// priority is 90 to run ahead of parser priority of 100
		ready(90, function(){
			// summary:
			//		Detects if we are in high-contrast mode or not

			// create div for testing if high contrast mode is on or images are turned off
			var div = domConstruct.create("div",{
				id: "a11yTestNode",
				style:{
					cssText:'border: 1px solid;'
						+ 'border-color:red green;'
						+ 'position: absolute;'
						+ 'height: 5px;'
						+ 'top: -999px;'
						+ 'background-image: url("' + (config.blankGif || require.toUrl("dojo/resources/blank.gif")) + '");'
				}
			}, win.body());

			// test it
			var cs = domStyle.getComputedStyle(div);
			if(cs){
				var bkImg = cs.backgroundImage;
				var needsA11y = (cs.borderTopColor == cs.borderRightColor) || (bkImg != null && (bkImg == "none" || bkImg == "url(invalid-url:)" ));
				if(needsA11y){
					domClass.add(win.body(), "dijit_a11y");
				}
				if(has("ie")){
					div.outerHTML = "";		// prevent mixed-content warning, see http://support.microsoft.com/kb/925014
				}else{
					win.body().removeChild(div);
				}
			}
		});
	}
});

},
'bf/XFormsModelElement':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */

define("bf/XFormsModelElement", ["dojo/_base/declare"],
    function(declare){
        return declare("bf.XFormsModelElement",null, {

    /**
        All Rights Reserved.
        @author Joern Turner
        @author Lars Windauer

        Client-side IDL implemenation of XForms 1.1 4.8.1

        Note: because of the async nature of the server inteface it's not possible to implement the IDL
        with the exact signature, as the remoting functions need to use a callback function to receive the results
        from the async request. To avoid the pain of making a AJAX-driven applications behave synchronously an additional
        param 'func' is required which is the callback function to be called with the response.

    **/
        constructor: function() {
        },

        postCreate:function(){
            console.info("creating XFormsModelElement","[@id=" + this.id + "]");
        },

        getInstanceDocument:function(/*String*/ instanceId, /*callbackFunction*/ func){
            this._useLoadingMessage();
            dwr.engine.setErrorHandler(fluxProcessor._handleExceptions);
            XFormsModelElement.getInstanceDocument(this.id, instanceId, fluxProcessor.sessionKey,func);
        },
        getInstanceAsString:function(instanceId,func){
            this._useLoadingMessage();
            dwr.engine.setErrorHandler(fluxProcessor._handleExceptions);
            XFormsModelElement.getInstanceAsString(this.id, instanceId, fluxProcessor.sessionKey,func);
        },

        rebuild: function(){
            this._useLoadingMessage();
            dwr.engine.setErrorHandler(fluxProcessor._handleExceptions);
            XFormsModelElement.rebuild(this.id, fluxProcessor.getSessionKey(),null);
        },

        recalculate: function(){
            this._useLoadingMessage();
            dwr.engine.setErrorHandler(fluxProcessor._handleExceptions);
            XFormsModelElement.recalculate(this.id, fluxProcessor.getSessionKey(),null);
        },

        revalidate:function(){
            this._useLoadingMessage();
            dwr.engine.setErrorHandler(fluxProcessor._handleExceptions);
            XFormsModelElement.revalidate(this.id, fluxProcessor.getSessionKey(),null);
        },

        refresh:function(){
            this._useLoadingMessage();
            dwr.engine.setErrorHandler(fluxProcessor._handleExceptions);
            XFormsModelElement.refresh(this.id, fluxProcessor.getSessionKey(),null);
        },
        _useLoadingMessage:function(){
            dwr.engine.setPreHook(function() {
                 document.getElementById('indicator').className = 'xfEnabled';
                });

                dwr.engine.setPostHook(function() {
                 document.getElementById('indicator').className = 'xfDisabled';
                });
        }

    });
});

},
'bf/factory/FactoryContainer':function(){
define("bf/factory/FactoryContainer", ["dojo/_base/declare","bf/util"],
    function(declare) {
        return declare( null,
            {
                /**
                 * Function to create Container Classes / Controls like Group, Switch, Repeat
                 * @param type
                 * @param node
                 */
                create:function(type, node){
                    var n = node;
                    switch(type){
                        case "group":
                            // console.debug("FactoryContainer (group)");
                            require(["dojo/dom","dojo/dom-attr","dojo/_base/connect","bf/XFBinding"], function(dom,domAttr,connect,XFBinding) {
                                var group = new XFBinding({}, n);
//                                connect.subscribe("bf-state-change-"+ group.id, group, "handleStateChanged");
                                group.setLabel = function( value) {
                                    // console.debug("FactoryContainer (group) _setLabel: ",this.id);
                                    var targetId = this.id;
                                    var labelNode = dom.byId(targetId + "-label");
                                    // labelledBy is an alertnative way to find the corresponding label.
                                    // Compact repeats only have this at the moment
                                    if (labelNode == undefined && domAttr.get(this.domNode, "labelledBy") != undefined) {
                                        labelNode = dom.byId(domAttr.get(this.domNode, "labelledBy"));
                                    }
                                    if (labelNode != undefined && value != undefined) {
                                        labelNode.innerHTML = value;
                                        labelNode.title = value;
                                    }
                                }
                            });
                            break;

                        case "repeat":
                            // console.debug("FactoryContainer (repeat)");
                            require(["bf/container/Repeat"], function(Repeat) {
                                new Repeat({}, n);
                            });
                            break;

                        case "switch":
                            // console.debug("FactoryContainer (switch) n: ",n);
                            require(["dojo/dom-class","dojo/_base/connect"], function(domClass,connect) {
                                connect.subscribe("bf-switch-toggled-"+ n.id, function(contextInfo) {
                                    // console.debug("FactoryContain (switch) bf-switch-toggled contextInfo:",contextInfo);
                                    if(contextInfo.deselected != undefined) {
                                        domClass.replace(contextInfo.deselected, "xfDeselectedCase", "xfSelectedCase");
                                    }
                                    if(contextInfo.selected){
                                        domClass.replace(contextInfo.selected, "xfSelectedCase", "xfDeselectedCase");
                                    }
                                });
                            });
                            break;
                        case "tabswitch":
                            console.debug("FactoryContainer (tabswitch) n: ",n);
                            require(["dijit/layout/ContentPane","dijit/layout/TabContainer","dojo/query","dojo/aspect","dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/_base/connect","dojo/dom-style"],
                                function(ContentPane, TabContainer, query,aspect,array,dom,domAttr,connect,domStyle) {
                                // connect and overwrite 'handleStateChanged' since it is not supported by switch
                                var xfCases = query(".xfCase",n);
                                var tabContainerId = domAttr.get(n,"id");

                                var tabContainer = new TabContainer({id:tabContainerId, tabPosition: "top", "class": "bfTabContainer"},n);
                                // add xfCases to TabContainer
                                array.forEach(xfCases, function(xfCase) {
                                    var selected = domAttr.get(xfCase,"selected") == "true";
                                    var title = domAttr.get(xfCase, "title");
                                    // domStyle.set(xfCase, "display","block");
                                    console.debug("add case: " + title  + " selected: " + selected);
                                    var xfCaseDijit = new ContentPane({title:title},xfCase);
                                    xfCaseDijit.startup();
                                    tabContainer.addChild(xfCaseDijit);
                                    if(selected){
                                        console.debug("TabContainer.select case: " + title);
                                        tabContainer.selectChild(xfCaseDijit);
                                    }
                                });
                                tabContainer.startup();
                                tabContainer.layout();

                                // save and overwrite tabContainer.selectChild function, selectChild is executed in response to
                                // bf-switch-toggled-[this-id];
                                var originalSelectChild = tabContainer["selectChild"];
                                tabContainer["selectChild"] = function(page,animated) {
                                    var btnToActivate = "t-" + domAttr.get(dom.byId(page.id),"caseid");
                                    fluxProcessor.dispatchEvent(btnToActivate);
                                };
                                connect.subscribe("bf-switch-toggled-"+ n.id, function(contextInfo) {
                                    var selectedCase = query("*[caseid='"+ contextInfo.selected + "']",tabContainer.domNode)[0];
                                    originalSelectChild.apply(tabContainer,[selectedCase.id,null]);
                                });

                            });
                            break;
                        case "dialog":
                            require(["dojo/dom","dojo/dom-attr","dijit/Dialog", "dijit/registry"], function(dom,domAttr,Dialog, registry) {
                                console.debug("create new Dialog",n);
                                var id = domAttr.get(n,"id");
                                var widget = registry.byId(id);
                                if (widget == undefined) {
                                    new Dialog({
                                        id:id,
                                        title: domAttr.get(n,"title")
                                    },n);
                                } else {
                                    console.warn("Dialog already present skipping initialization.")
                                }
                            });
                            break;
                        default:
                            console.warn("FactoryContainer unknonw type: ",type);
                    }
                }
            }
        )
    }
);


},
'bf/XFormsProcessor':function(){
define("bf/XFormsProcessor", ["dojo/_base/declare"],
    function(declare){
        return declare(null, {
    /*
     * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
     * Licensed under the terms of BSD License
     */

    /*
    This class represents the interface to the XForms processor (aka 'betterForm Web'). It is the only class
    actually having dependency on DWR to handle the AJAX part of things and calling remote Java methods on
    de.betterform.web.flux.FluxFacade.
    */
        sessionKey:"",

        constructor: function() {
            // console.info("XFormsProcessor creating XForms Processor");
        },

        init: function(){
        },

        keepAlive: function() {
        },

        closeSession: function() {
        },

        ignoreExceptions: function (msg){
        },

        //eventually an 'activate' method still makes sense to provide a simple DOMActivate of a trigger Element

        dispatchEvent: function (targetId) {
        },

        setControlValue: function (id, value) {
        },

        setRange: function (id, value) {
        },


        setRepeatIndex:function (targetRepeatElement){
        },


        _useLoadingMessage:function(){
        },

        _handleExceptions:function(msg) {
            console.error(msg);
        }
    })
});

},
'bf/select/SelectCheckBox':function(){
define("bf/select/SelectCheckBox", ["dojo/_base/declare", "dijit/_Widget","dojo/query","dojo/_base/connect","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom"],
    function(declare, _Widget,query,connect,domAttr,domClass,domConstruct,dom){
        return declare(_Widget, {
            control:null,
            currentValue:null,

            postCreate:function() {
                // console.debug("SelectCheckBox. postCreate id:",this.id);
                var bfHandleStateChanged = connect.subscribe("xforms-item-changed-" + this.id , this, "handleStateChanged");
                fluxProcessor.addSubscriber(this.id, bfHandleStateChanged);
                var bfHandleInsertItem = connect.subscribe("betterform-insert-item-" + this.id , this, "handleInsertItem");
                fluxProcessor.addSubscriber(this.id, bfHandleInsertItem);
                var bfHandleDeleteItem = connect.subscribe("betterform-delete-item-" + this.id , this, "handleDeleteItem");
                fluxProcessor.addSubscriber(this.id, bfHandleDeleteItem);
            },

            _onBlur:function() {
                // console.debug("bf.SelectFull._onBlur arguments:",arguments, " control:",this.xfControl);
                var selectedValue = this._getSelectedValueAsString();
                this.xfControl.sendValue(selectedValue,true);
            },

            handleStateChanged:function(contextInfo){
                // console.debug("SelectCheckBox.handleStateChanged");
                var value = contextInfo.value;
                if(contextInfo.targetName == "label"){
                    dom.byId(contextInfo.parentId+"-label").innerHTML = value;
                }else if(contextInfo.targetName == "value"){
                    var checkBox = dom.byId(contextInfo.parentId+"-value");
                    domAttr.set(checkBox,"value",value);
                    // console.debug("check if value ", value, " is selected: selectedValues: ",this.currentValue);
                    if(this.currentValue.indexOf(value) != -1){
                        checkBox.checked = true;
                    }else {
                        checkBox.checked = false;
                    }
                }else {
                    console.warn("SelectCheckBox.handleStateChanged: no action taken for contextInfo: ",contextInfo);
                }

            },
            /**
             * Create new entry for Select
             * @param contextInfo
             */
            handleInsertItem:function(contextInfo) {
                // console.debug("SelectCheckBox.handleInsert [id: ",this.id, " / contextInfo:",contextInfo,"]");
                // this.currentValue = this._getSelectedValue();
                var currentItemset = dom.byId(contextInfo.targetId);
                // console.debug("SelectCheckBox.handleInsert itemset: ",currentItemset);
                var generatedIds= contextInfo.generatedIds;
                var itemId = generatedIds[contextInfo.prototypeId];

                var itemNode = domConstruct.create("span", {id:itemId}, currentItemset, contextInfo.position);
                domClass.add(itemNode, "xfSelectorItem");
                var valueNode = domConstruct.create("input", {id:itemId+"-value",type:"checkbox",value:contextInfo.value}, itemNode, "first");
                domClass.add(valueNode,"xfCheckBoxValue");
                var labelNode = domConstruct.create("label", {id:itemId+"-label",value:contextInfo.label}, itemNode, "last");
                domClass.add(labelNode, "xfCheckBoxLabel");
            },

            handleDeleteItem:function(contextInfo){
                // console.debug("SelectCheckBox.handleDeleteItem contextInfo:",contextInfo);
                var currentItemset = dom.byId(contextInfo.targetId);
                var itemToRemove = query(".xfSelectorItem", currentItemset)[contextInfo.position-1];
                currentItemset.removeChild(itemToRemove);

            },

            setReadOnly:function(){
                // console.debug("SelectCheckBox.setReadOnly");
                query(".xfCheckBoxValue",this.domNode).forEach(function(item){
                    domAttr.set(item, "disabled","disabled");
                });
            },

            setReadWrite:function(){
                // console.debug("SelectCheckBox.setReadWrite");
                query(".xfCheckBoxValue",this.domNode).forEach(function(item){
                    domAttr.remove(item, "disabled");
                });
            },

            _getSelectedValueAsString:function() {
                var resultString = this._getSelectedValue().join(" ");
                // console.debug("SelectCheckBox._getSelectedValueAsString: ", resultString);
                return resultString;
            },

            _getSelectedValue:function(){
                var selectedValue = new Array();
                query(".xfCheckBoxValue",this.domNode).forEach(function(item){
                    if(item.checked){
                        selectedValue.push(item.value);
                    }
                });
                // console.debug("SelectCheckBox._getSelectedValue value:",selectedValue);
                return selectedValue;
            }
    });
});


},
'bf/factory/FactoryOutput':function(){
define("bf/factory/FactoryOutput", ["dojo/_base/declare","dojo/_base/connect","dijit/registry","dojo/dom-attr","dojo/dom-style","dojo/dom-class","dojo/_base/lang","bf/util"],
    function(declare,connect,registry,domAttr,domStyle,domClass,lang) {
        return declare(null,
            {
                /**
                 *
                 * @param type
                 * @param node
                 */
                create:function(type, node){
                    var n = node;
                    var xfId = bf.util.getXfId(n);
                    var xfControlDijit = registry.byId(xfId);
                    // TODO: TBR: Lars: special handling for outputs within labels
                    var xfControlNode = xfControlDijit.domNode;
                    if(xfControlNode.parentNode.localName == "label"){
                        // console.debug("output is placed within label");
                        domStyle.set(xfControlNode, "display","inline");
                        domStyle.set(xfControlNode, "border",0);
                        domStyle.set(xfControlNode, "padding",0);
                    }

                    switch(type){

                        case "text":
                            // console.debug("FOUND .xfOutput.mediatypeText .xfValue ",n);
                            xfControlDijit.setCurrentValue(n.innerHTML);
                            xfControlDijit.setValue = function(value,schematype) {
                                // console.debug("xfControl.setValue: .xfOutput.mediatypeText .xfValue");
                                n.innerHTML = value;
                            };
                            connect.connect(n,"onblur",function(evt){
                                xfControlDijit.sendValue(n.innerHTML,true);
                            });

                            connect.connect(n,"onfocus",function(evt){
                                xfControlDijit.handleOnFocus();
                            });

                            break;
                        case "image":
                            // console.debug("FOUND .xfOutput.mediatypeImage .xfValue:",n);
                            xfControlDijit.setValue = function(value) {
                                domAttr.set(n, "src", value);
                            };
                            break;
                        case "link":
                            // console.debug("FOUND .xfOutput.xsdAnyURI .xfValue",n);
                            xfControlDijit.setCurrentValue(n.innerHTML);
                            connect.connect(n,"onblur",function(evt){
                                xfControlDijit.sendValue(n.innerHTML,true);
                            });

                            connect.connect(n,"onfocus",function(evt){
                                xfControlDijit.handleOnFocus();
                            });

                            //todo: this solution works in FF - others have to be tested
                            xfControlDijit.setReadonly = function(){
                                domClass.replace(n,"xfReadOnly","xfReadWrite");
                                domStyle.set(n, "pointerEvents","none");
                                domStyle.set(n, "cursor","default");
                            };

                            xfControlDijit.setReadwrite = function(){
                                domClass.replace(n,"xfReadWrite", "xfReadOnly");
                                domStyle.set(n, "pointerEvents","auto");
                                domStyle.set(n, "cursor","pointer");
                            };

                            xfControlDijit.setValue = function(value) {
                                // console.debug("xfControl.setValue: .xfOutput.xsdAnyURI .xfValue")
                                domAttr.set(n, "href", value);
                                n.innerHTML = value;
                            };
                            break;
                        case "html":
                            var currentValue = n.innerHTML;
                            var escapedValue = this.safeReplace("{0}", [currentValue]);
                            // console.debug(escapedValue);
                            n.innerHTML = escapedValue;
                            var self = this;
                            xfControlDijit.setValue = function(value) {
                                n.innerHTML = self.safeReplace("{0}", [value]);
                            };
                            break;
                        default:
                            console.warn("FactoryInput.default");

                    }
                },
                safeReplace:function(tmpl, dict){
                    // convert dict to a function, if needed
                    var fn = lang.isFunction(dict) ? dict : function(_, name){
                        return lang.getObject(name, false, dict);
                    };
                    // perform the substitution
                    return lang.replace(tmpl, function(_, name){
                        if(name.charAt(0) == '!'){
                            // no escaping
                            return fn(_, name.slice(1));
                        }
                        // escape
                        return fn(_, name).
                            replace(/&amp;/g, "&").
                            replace(/&lt;/g, "<").
                            replace(/&gt;/g, ">").
                            replace(/&quot;/g, "\"");
                    });
                }
            }
        );
    }
);


},
'bf/common/AlertInline':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */
define("bf/common/AlertInline", ["dojo/_base/declare","bf/common/Alert","dojo/dom","dojo/dom-style","dojo/_base/lang"],
    function(declare, Alert,dom,domStyle,lang){
    return declare(Alert, {

        // @Override
        _show:function(id, commonChild) {
//            this.inherited(arguments);
            //console.debug("InlineAlert._show [id:'",id,"' commonChild:'", commonChild,"']");
            var commonChildNode = dom.byId(id + '-' + commonChild);
            if(commonChildNode == undefined || commonChild == this.info) {
                return;
            }
            this._render(id, commonChild,"inline-block");
        },


        // @Override
        _hide:function(id, commonChild) {
            // console.debug("InlineAlert._hide [id:'",id,"' commonChild:'", commonChild,"']");
            var commonChildNode = dom.byId(id + '-' + commonChild);
            if(commonChildNode == undefined || commonChild == this.info) {
                return;
            }
            this._render(id, commonChild,"none");

        },

        _render:function(id, commonChild, show) {
            // console.debug("InlineAlert._render [id:'",id,"' commonChild:'", commonChild," ' show:'",show, "']");
            //todo: jt: searching the node again seems unnecessary as it's already accessed from caller ('_show')
            var mip = dom.byId(id + "-" + commonChild);
            if (mip != undefined && mip.innerHTML != '') {
                // add onclick handler to alerts to close them by mouse click
                if(commonChild == "alert" && show=="inline") {
                    domStyle.set(mip, "cursor", "pointer");
/*
                    mip.onclick = lang.hitch(this, function(evt) {
                        // console.debug("Alert clicked id: ", id, " commonChild: ", commonChild, " show: " , show);
                        this._hide(id,commonChild);
                       // this._show(id,"hint");
                    });
*/
                }
                domStyle.set(mip, "display", show);
//                document.getElementById(id + "-value").focus();
            } else {
                console.info(id + "-" + commonChild + " is not defined for Control " + id);
            }
        }

    });
});

},
'bf/XFBinding':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */

define("bf/XFBinding", ["dojo/_base/declare","dojo/dom", "dojo/dom-class","dojo/query",
    "dojo/dom-attr","dojo/_base/connect","dojo/dom-construct","dijit/registry","dojo/behavior", "bf/util"],
    function(declare, dom, domClass,query,domAttr,connect,domConstruct,registry,behavior){
        return declare(null, {


            /**
             * All Rights Reserved.
             * @author Joern Turner
             *
             * BoundElement is a superclass for all controls and container but also for those elements bound by an AVT. It
             * contains all functions dealing with state changes except the handling of the value.
             *
             **/

            id:"",
            bfFocus:false,

            constructor:function(properties, node){
                // console.debug("XFBinding.constructor properties:",properties, " node:" ,node);
                this.srcNodeRef = node;
                this.id = node.id;
                // console.debug("XFBinding.constructor setDefaultClasses");
                bf.util.setDefaultClasses(this.srcNodeRef);

                /*
                 Controls publish their validity state to the processor which will pass it to the selected alertHandler
                 */
                // console.debug("XFBinding.constructor handleValid");
                if (this.isValid()) {
                    connect.publish("xforms-valid", [this.id,"init"]);
                } else {
                    connect.publish("xforms-invalid", [this.id,"init"]);
                }
                // console.debug("XFBinding.constructor subscribe state change");
                // console.debug("XFBinding.constructor: connect.subscribe('bf-state-change-"+ this.id + "', this, 'handleStateChanged')");

                var bfStateChangedHandle = connect.subscribe("bf-state-change-"+ this.id, this, "handleStateChanged");
                fluxProcessor.addSubscriber(this.id, bfStateChangedHandle);

            },

            /*
             handles state changes (value and MIP changes) send by the server and applies them to the control. State
             changes are received from the client side xforms processor (XFProcessor) which handles all communication
             between client and server.
             */
            handleStateChanged:function(contextInfo) {
            // console.debug("XFBinding.handleStateChanged: ",contextInfo);

                if (contextInfo["parentId"]) {
                // console.debug("XFBinding.handleStateChanged: calling _handleHelperChanged");
                    this._handleHelperChanged(contextInfo);
                } else {
                // console.debug("XFBinding.handleStateChanged: adjust properties");
                    this.value = contextInfo["value"];
                    this.valid = contextInfo["valid"];
                    this.readonly = contextInfo["readonly"];
                    this.required = contextInfo["required"];
                    this.relevant = contextInfo["enabled"];
                    var formerType = this.type;
                    this.type = contextInfo["type"];

                    // console.debug("XFBinding.handleStateChanged value:",this.value," valid:", this.valid, " readonly:",this.readonly," required:",this.required, " relevant:",this.relevant, " targetName:",contextInfo["targetName"]," type:",contextInfo["type"], " contextInfo:",contextInfo);

                    // check xsd type and adjust if needed
                    //console.debug("XFBinding.handleStateChanged this.type: ", this.type, " formerType:",formerType);
                    if(this.type != undefined && this.type != "" && this.type != formerType){
                        var index = this.type.indexOf(":");
                        if (index != -1) {
                            this.type = this.type.substring(index+1, this.type.length);
                        }
                        //console.info("XFBinding.handleStateChange: removed namespace from type:" , this.type);
                        // console.warn("XFBinding.handleStateChange type changed");
                        var xsdType = "xsd" + this.type.replace(/^[a-z]/, this.type.substring(0, 1).toUpperCase());
                        // TODO: existing types must be removed in case of type switch
                        //console.debug("apply new type: ",xsdType, " to Control Widget");
                        if(!domClass.contains(this.srcNodeRef, xsdType)){
                            // console.debug("XFBinding.handleStateChange behavior.apply");
                            domClass.add(this.srcNodeRef, xsdType);
                            behavior.apply();
                        }
                    }
                    var self = this;
                    require(["dojo/ready"],function(ready){
                        ready(function(){

                            // console.debug("XFBinding.handleStateChanged (ready): self.value:",self.value, " self.readonly:",self.readonly, " self.srcNodeRef:",self.srcNodeRef);
                            // Validity handling
                            // console.debug("XFBinding.handleStateChanged handle Valid");
                            if (self.valid != undefined) {
                                if (self.valid == "true") {
                                    // console.debug("XFBinding.handleStateChanged setValid");
                                    self.setValid();
                                }
                                else if (!domClass.contains(self.srcNodeRef, "bfInvalidControl")) {
                                    // console.debug("XFBinding.handleStateChanged setInvalid");
                                    /*
                                     todo: got the feeling that this case should be handled elsewhere....
                                     if a control is intially invalid it just has xfInvalid but not bfInvalidControl. This may happen
                                     during init and somehow the subscriber won't be called then (too early???)

                                     Ok, for now: if control is not valid (has 'xfInvalid' class) and not has 'bfInvalidControl' (which
                                     actually shows an alert) it must nevertheless publish invalid event for the alerts to work correctly.
                                     */
                                    self.setInvalid();
                                }
                            }
                            // console.debug("XFBinding.handleStateChanged handle ReadOnly");
                            if(self.readonly != undefined) {
                                if (self.readonly == "true") {
                                    self.setReadonly();
                                }else {
                                    self.setReadwrite();
                                }
                            }
                            // console.debug("XFBinding.handleStateChanged handle Required");
                            if(self.required != undefined) {
                                if (self.required == "true") {
                                    self.setRequired();
                                }else {
                                    self.setOptional();
                                }
                            }
                            // console.debug("XFBinding.handleStateChanged handle Relevant");
                            if(self.relevant != undefined) {
                                if (self.relevant == "true") {
                                    self.setEnabled();
                                }else {
                                    self.setDisabled();
                                }
                            }
                            // console.debug("XFBinding.handleStateChanged END ready()");
                        });
                    })
                }
            },

            isRequired:function() {
                // console.debug("Control.isRequired",this.srcNodeRef);
                if (domClass.contains(this.srcNodeRef, "xfOptional")) {
                    return false;
                } else if (domClass.contains(this.srcNodeRef, "xfRequired")) {
                    return true;
                } else {
                    console.error("XFBinding.isRequired No required state found")
                }
            },

            isReadonly:function() {
                // console.debug("Control.isReadonly",this.srcNodeRef);
                if (domClass.contains(this.srcNodeRef, "xfReadWrite")) {
                    return false;
                } else if (domClass.contains(this.srcNodeRef, "xfReadOnly")) {
                    return true;
                } else {
                    console.error("XFBinding.isReadonly No readonly state found")
                }
            },

            isRelevant:function() {
                //console.debug("Control.isRelevant",this.srcNodeRef);
                if (domClass.contains(this.srcNodeRef, "xfDisabled")) {
                    return false;
                } else if (domClass.contains(this.srcNodeRef, "xfEnabled")) {
                    return true;
                } else {
                    console.error("XFBinding.isRelevant: No relevant state found")
                }
            },

            isValid:function() {
                // console.debug("XFBinding.isValid",this.srcNodeRef);

                if (domClass.contains(this.srcNodeRef, "xfInvalid")) {
                    return false;
                } else if (domClass.contains(this.srcNodeRef, "xfValid")) {
                    return true;
                } else {
                    console.error("XFBinding.isValid No validate state found for " + this.id);
                }
            },

            setValid:function() {
                //console.debug("XFBinding.setValid(): " + this.id);
                domClass.replace(this.srcNodeRef, "xfValid","xfInvalid");
                if (domClass.contains(this.srcNodeRef, "xfRequiredEmpty")) {
                        domClass.remove(this.srcNodeRef, "xfRequiredEmpty");
                }
                connect.publish("xforms-valid", [this.id,"applyChanges"]);

            },

            setInvalid:function() {
                domClass.replace(this.srcNodeRef, "xfInvalid", "xfValid");
                connect.publish("xforms-invalid", [this.id,"applyChanges"]);
            },

            setReadonly:function() {
                // console.debug("XFBinding.setReadonly widget:",this.getWidget());
                domClass.replace(this.srcNodeRef, "xfReadOnly", "xfReadWrite");
                domAttr.set(this.getWidget(), "readonly","readonly");
                domAttr.set(this.getWidget(), "disabled","disabled");
            },

            setReadwrite:function() {
                // console.debug("XFBinding.setReadwrite widget:",this.getWidget());

                domClass.replace(this.srcNodeRef,"xfReadWrite", "xfReadOnly");
                this.getWidget().removeAttribute("readonly");
                this.getWidget().removeAttribute("disabled");
            },

            setRequired:function() {
                domClass.replace(this.srcNodeRef, "xfRequired", "xfOptional");
            },

            setOptional:function() {
                domClass.replace(this.srcNodeRef, "xfOptional", "xfRequired");
            },

            setEnabled:function() {
                var label = this._getLabel();
                if (label != undefined) {
                    if (domClass.contains(label, "xfDisabled")) {
                        domClass.replace(label, "xfEnabled", "xfDisabled");
                    } else {
                        domClass.add(label, "xfEnabled");
                    }
                }
                domClass.replace(this.srcNodeRef, "xfEnabled","xfDisabled");

                if (this.isValid()) {
                    connect.publish("xforms-valid", [this.id, "xfDisabled"]);
                } else {
                    connect.publish("xforms-invalid", [this.id, "xfDisabled"]);
                }
            },

            setDisabled:function() {
                var label = this._getLabel();
                if (label != undefined) {
                    if (domClass.contains(label, "xfEnabled")) {
                        domClass.replace(label,"xfDisabled", "xfEnabled");
                    } else {
                        domClass.add(label, "xfDisabled");
                    }
                }
                domClass.replace(this.srcNodeRef, "xfDisabled", "xfEnabled");
                if (this.isValid()) {
                    connect.publish("xforms-valid", [this.id, "xfDisabled"]);
                } else {
                    connect.publish("xforms-invalid", [this.id, "xfDisabled"]);
                }
            },

            _handleHelperChanged: function(properties) {
                // console.debug("XFBinding.handleHelperChanged: this.id: "+this.id+ " type='" + properties["targetName"] + "',  value='" + properties["value"] + "'");
                switch (properties["targetName"]) {
                    case "label":
                    this.setLabel(properties["value"]);
                        return;
                    case "help":
                    this.setHelp(properties["value"]);
                        return;
                    case "hint":
                    this.setHint(properties["value"]);
                        return;
                    case "alert":
                    this.setAlert(properties["value"]);
                        return;
                    default:
                        console.warn("XFBinding._handleHelperChange: can't handle ", properties["targetName"]);
                }
            },

            setLabel:function(value) {
                // console.debug("XFBinding.setLabel value:"+ value);

                var labelNode = this._getLabel();
                if (labelNode != undefined) {
                    labelNode.innerHTML = value;
                }
                else {
                    console.warn("XFBinding.setLabel Failure updating label for Control '" + this.id + "-label' with value: " + value);
                }
            },
            setHelp:function(value) {
                // console.warn("TBD: Control.setHelp value:"+ value);
                var helpNode = dom.byId(this.id + "-help");
                if (helpNode != undefined) {
                    helpNode.innerHTML = value;
                }
                else {
                    console.warn("XFBinding.setHelp Failure updating help for Control '" + this.id + "-help' with value: " + value);
                }
            },

            setHint:function(value) {
                // Container for storing the hint-node if it exists
                var hintNode = dom.byId(this.id + "-hint");
                // Container for storing the node which contains a title attribute
                //todo: review valueNode reference
                var valueNode = registry.byId(this.id + "-value");

                // Value for: Is a title-Attribute availabel at the current DOM-structure
                var titleAttributeFound = false;

                // Value for: Is a hint Node available at the current DOM-structure
                var hintNodeFound;
                // Check if a hint-node is available and store that information
                hintNodeFound = hintNode != undefined;

                // Check if a title-attribute is available and store that information
                if (valueNode != undefined) {
                    try {
                        // Try to retrieve the title attribute of the according value-node
                        var titleAttribute = domAttr.get(valueNode, "title");
                        // Test if the retrieved title-attribute is defined and has a non-empty value
                        titleAttributeFound = titleAttribute != undefined && titleAttribute != "";
                    }
                    catch(exception) {
                        console.warn("XFBinding.setHint title attribute for hint " +  this.id + "-hint" + " is empty");
                    }
                }

                // If a hint-node was found
                if (hintNodeFound) {
                    // Only update the hint-node's content
                    hintNode.innerHTML = value;
                }

                // If a title-attribute was found
                if (titleAttributeFound) {
                    // Update the title-attribute
                    domAttr.set(valueNode, "title", value);
                }

                // If no hint-node was found and no title-attribute was found
                if (!hintNodeFound && !titleAttributeFound) {
                    // Print an error to the console
                    console.warn("XFBinding.setHint Failure updating hint for Control '" + this.id + " with value: " + value + " ... neither found '" + this.id + "-hint' nor '" + this.id + "-value");
                }
            },

            setAlert:function(value) {
                var alertNode = dom.byId(this.id + "-alert");
                if (alertNode != undefined) {
                    alertNode.innerHTML = value;
                }
                else {
                    console.error("XFBinding.setAlert Failure updating alert for Control '" + this.id + "-alert' with value: " + value);
                }

            },

            // function to get the label for a specific control, handles label ids manipulated by Dojo as well
            _getLabel: function() {
                var label = dom.byId(this.id + "-label");
                if(label == undefined) {
                    label = dom.byId(this.id + "-value_label");
                }
                return label;
            },


            getWidget:function() {
                if(domClass.contains(this.srcNodeRef,"xfContainer")){
                    if(this.widget == undefined) {
                        this.widget = this.srcNodeRef;
                    }
                    return this.widget;

                }else {
                    if(this.widget == undefined) {
                        this.widget = dom.byId(this.id+"-value");
                    }
                    return this.widget;
                }
            }
        });
    });



},
'bf/util':function(){
/*
 * Copyright (c) 2012. betterFORM Project - http://www.betterform.de
 * Licensed under the terms of BSD License
 */

require(['dojo/_base/declare',"dojo/dom-class","dojo/dom-attr","dojo/_base/json"],
    function(declare,domClass,domAttr,json){
        declare("bf.util", null, {

        });

        // TODO: Lars: function is never called, remove?
        bf.util.showAtWidget = function(widgetId) {
            //    var widget = dom.byId(widgetId + '-value');
            var widget = query("*[widgetId='" + widgetId + "-value']");
            // console.debug("showWidget:", widget);
            //var widget = dom.byId(widgetId + '-value');


            /* Wipe In Version */
        /*
            var position = dojo.coords(widget[0], true);
            console.debug("pos:", dojo.coords(widget[0], false));
            console.debug("abs: ", dojo._abs(widget[0],true));
            console.debug("abs: ", dojo._abs(widget[0],false));
            var help = dom.byId(widgetId + "-helptext");
            //help.style.left = position.x + 'px';
            var height = position.y + (2 * position.h);
            console.debug("Height: " + height);
            help.style.top = height;
            dojo.fx.wipeIn({node:help,duration:300}).play();
        */
        };

        // TODO: Lars: function 'getContainerByClass' is never called, remove?
/*
        bf.util.getContainerByClass = function(n, cssString ){
            var node = n;
            var cssClass = cssString;
            require(["dojo/_base/window"], function(win){
                var body = win.body();
                while(node && node != body && !domClass.contains(node, cssClass)) {
                    node = node.parentNode;
                }
                if(domClass.contains(node, cssClass)){
                    return node;
                }
                return null;

            })
        };
*/


        /**
         * Function to replace one CSS Class with another on a given node
         *
         * @param element node on which the CSS Class is replaced
         * @param current CSS class to be replaced
         * @param update CSS Class to replace current CSS Class with
         * @return {Boolean} return true if CSS Class was replaced
         */
        bf.util.replaceClass = function (element, current, update) {
            //console.debug("bf.util.replaceClass " + current + " with " +  update + " for Control ", element);
            console.warn("WARNING: bf.util.replaceClass is deprecated, use domClass.replace instead!!");
            if (!element || !element.className) {
                return false;
            }

            var oldClassName = element.className;

            // surround all strings with spaces to guarantee non-ambigous lookups
            var classList = " " + oldClassName + " ";
            var classCurrent = " " + current + " ";
            var classUpdate = " " + update + " ";

            if (classList.indexOf(classUpdate) == -1) {
                var newClassName = classList.replace(new RegExp(classCurrent), classUpdate);
                if (newClassName.indexOf(classUpdate) == -1) {
                    // ensure the new class name, even if no replacement happened
                    newClassName = classList + update + " ";
                }

                // remove leading and trailing spaces and update the element's class name
                newClassName = newClassName.slice(1, newClassName.length - 1);
                element.className = newClassName;

                return true;
            }

            return false;
        };
        bf.util.setDefaultClasses = function (element) {
            if(!domClass.contains(element,"xfEnabled") && !domClass.contains(element,"xfDisabled")){
                domClass.add(element,"xfEnabled");
            }
            if(!domClass.contains(element,"xfOptional") && !domClass.contains(element,"xfRequired")){
                domClass.add(element,"xfOptional");
            }
            if(!domClass.contains(element,"xfReadWrite") && !domClass.contains(element,"xfReadOnly")){
                domClass.add(element,"xfReadWrite");
            }
            if(!domClass.contains(element,"xfValid") && !domClass.contains(element,"xfInvalid")){
                domClass.add(element,"xfValid");
            }
        };


        /**
         *
         * @param element
         * @param styleToRemove
         * @return {Boolean}
         */
        // TODO: Lars: function 'removeStyle' is never called, remove?

        bf.util.removeStyle = function(element,styleToRemove) {
            if(element == undefined || styleToRemove == undefined) {
                return false;
            }
            var style = domAttr.get(element, "style");
            // console.debug("deleting style: " + styleToRemove + " for stlye: "+ style);
            if(style != undefined && style.indexOf(styleToRemove)!= -1){
                // console.debug("deleting style: " + styleToRemove + " for stlye: "+ style);
                style.replace(styleToRemove,"");
                domAttr.set(element, "style", style);
                return true;
            }
            return false;
        };

        bf.util.removeNamespace = function(value){
                var nonNamespacedValue = value;
                if(nonNamespacedValue != undefined && nonNamespacedValue != "" && nonNamespacedValue.indexOf(":") != -1) {
                    nonNamespacedValue = nonNamespacedValue.substring(nonNamespacedValue.indexOf(":")+1,nonNamespacedValue.length);
                }
                return nonNamespacedValue;
        };

        bf.util.getXfId = function(/*Node*/n){
                var tmp = n.id.substring(0,n.id.lastIndexOf("-"));
                // console.debug("returning xfId: ",tmp);
                return tmp;
        };

        bf.util.toggleDebug = function(){
            require(["dojo/dom","dojo/dom-style","dojo/_base/connect","dojo/_base/fx"],function(dom,domStyle,connect,fx){
                var debugpane = dom.byId("bfDebug");
                if(domClass.contains(debugpane,"open")){
                    var closeAnim = fx.animateProperty({
                        node:debugpane,
                        properties: {
                            width:{start:100,end:0,unit:"%"},
                            opacity:{start:1.0, end:0}
                        }
                    });
                    connect.connect(closeAnim, "onEnd", function(node){
                        domStyle.set(node,"opacity", 0);
                        domStyle.set(node,"display", "none");
                    });
                    closeAnim.play();
                    domClass.remove(debugpane,"open");
                    domClass.add(debugpane,"closed");

                }else{
                    domStyle.set(debugpane,"display", "block");
                    var openAnim = fx.animateProperty({
                        node:debugpane,
                        properties: {
                            width:{start:0,end:100,units:"%"},
                            opacity:{start:0, end:1.0}
                        }
                    });
                    connect.connect(openAnim, "onEnd", function(node){
                        domStyle.set(node,"opacity", 1.0);

                    });
                    openAnim.play();
                    domClass.remove(debugpane,"closed");
                    domClass.add(debugpane,"open");
                }

            });
        };

        bf.util.parseDataAttribute = function(node, dataAttributeName){
            // console.debug("bf.util.parseDataAttribute: node:",node, " dataAttributeName:",dataAttributeName);
            var result = {};
            var dataAttrString = domAttr.get(node,dataAttributeName);
            // console.debug("dataAttrString: ",dataAttrString);
            if(dataAttrString && dataAttrString != ""){
                result =  json.fromJson("{" + dataAttrString +  "}");
            }
            return result;
        }
    }
);
},
'dijit/_Widget':function(){
define("dijit/_Widget", [
	"dojo/aspect",	// aspect.around
	"dojo/_base/config",	// config.isDebug
	"dojo/_base/connect",	// connect.connect
	"dojo/_base/declare", // declare
	"dojo/_base/kernel", // kernel.deprecated
	"dojo/_base/lang", // lang.hitch
	"dojo/query",
	"dojo/ready",
	"./registry",	// registry.byNode
	"./_WidgetBase",
	"./_OnDijitClickMixin",
	"./_FocusMixin",
	"dojo/uacss",		// browser sniffing (included for back-compat; subclasses may be using)
	"./hccss"		// high contrast mode sniffing (included to set CSS classes on <body>, module ret value unused)
], function(aspect, config, connect, declare, kernel, lang, query, ready,
			registry, _WidgetBase, _OnDijitClickMixin, _FocusMixin){

/*=====
	var _WidgetBase = dijit._WidgetBase;
	var _OnDijitClickMixin = dijit._OnDijitClickMixin;
	var _FocusMixin = dijit._FocusMixin;
=====*/


// module:
//		dijit/_Widget
// summary:
//		Old base for widgets.   New widgets should extend _WidgetBase instead


function connectToDomNode(){
	// summary:
	//		If user connects to a widget method === this function, then they will
	//		instead actually be connecting the equivalent event on this.domNode
}

// Trap dojo.connect() calls to connectToDomNode methods, and redirect to _Widget.on()
function aroundAdvice(originalConnect){
	return function(obj, event, scope, method){
		if(obj && typeof event == "string" && obj[event] == connectToDomNode){
			return obj.on(event.substring(2).toLowerCase(), lang.hitch(scope, method));
		}
		return originalConnect.apply(connect, arguments);
	};
}
aspect.around(connect, "connect", aroundAdvice);
if(kernel.connect){
	aspect.around(kernel, "connect", aroundAdvice);
}

var _Widget = declare("dijit._Widget", [_WidgetBase, _OnDijitClickMixin, _FocusMixin], {
	// summary:
	//		Base class for all Dijit widgets.
	//
	//		Extends _WidgetBase, adding support for:
	//			- declaratively/programatically specifying widget initialization parameters like
	//				onMouseMove="foo" that call foo when this.domNode gets a mousemove event
	//			- ondijitclick
	//				Support new data-dojo-attach-event="ondijitclick: ..." that is triggered by a mouse click or a SPACE/ENTER keypress
	//			- focus related functions
	//				In particular, the onFocus()/onBlur() callbacks.   Driven internally by
	//				dijit/_base/focus.js.
	//			- deprecated methods
	//			- onShow(), onHide(), onClose()
	//
	//		Also, by loading code in dijit/_base, turns on:
	//			- browser sniffing (putting browser id like .dj_ie on <html> node)
	//			- high contrast mode sniffing (add .dijit_a11y class to <body> if machine is in high contrast mode)


	////////////////// DEFERRED CONNECTS ///////////////////

	onClick: connectToDomNode,
	/*=====
	onClick: function(event){
		// summary:
		//		Connect to this function to receive notifications of mouse click events.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onDblClick: connectToDomNode,
	/*=====
	onDblClick: function(event){
		// summary:
		//		Connect to this function to receive notifications of mouse double click events.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onKeyDown: connectToDomNode,
	/*=====
	onKeyDown: function(event){
		// summary:
		//		Connect to this function to receive notifications of keys being pressed down.
		// event:
		//		key Event
		// tags:
		//		callback
	},
	=====*/
	onKeyPress: connectToDomNode,
	/*=====
	onKeyPress: function(event){
		// summary:
		//		Connect to this function to receive notifications of printable keys being typed.
		// event:
		//		key Event
		// tags:
		//		callback
	},
	=====*/
	onKeyUp: connectToDomNode,
	/*=====
	onKeyUp: function(event){
		// summary:
		//		Connect to this function to receive notifications of keys being released.
		// event:
		//		key Event
		// tags:
		//		callback
	},
	=====*/
	onMouseDown: connectToDomNode,
	/*=====
	onMouseDown: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse button is pressed down.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseMove: connectToDomNode,
	/*=====
	onMouseMove: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseOut: connectToDomNode,
	/*=====
	onMouseOut: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseOver: connectToDomNode,
	/*=====
	onMouseOver: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseLeave: connectToDomNode,
	/*=====
	onMouseLeave: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves off of this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseEnter: connectToDomNode,
	/*=====
	onMouseEnter: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves onto this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseUp: connectToDomNode,
	/*=====
	onMouseUp: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse button is released.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/

	constructor: function(params){
		// extract parameters like onMouseMove that should connect directly to this.domNode
		this._toConnect = {};
		for(var name in params){
			if(this[name] === connectToDomNode){
				this._toConnect[name.replace(/^on/, "").toLowerCase()] = params[name];
				delete params[name];
			}
		}
	},

	postCreate: function(){
		this.inherited(arguments);

		// perform connection from this.domNode to user specified handlers (ex: onMouseMove)
		for(var name in this._toConnect){
			this.on(name, this._toConnect[name]);
		}
		delete this._toConnect;
	},

	on: function(/*String*/ type, /*Function*/ func){
		if(this[this._onMap(type)] === connectToDomNode){
			// Use connect.connect() rather than on() to get handling for "onmouseenter" on non-IE, etc.
			// Also, need to specify context as "this" rather than the default context of the DOMNode
			return connect.connect(this.domNode, type.toLowerCase(), this, func);
		}
		return this.inherited(arguments);
	},

	_setFocusedAttr: function(val){
		// Remove this method in 2.0 (or sooner), just here to set _focused == focused, for back compat
		// (but since it's a private variable we aren't required to keep supporting it).
		this._focused = val;
		this._set("focused", val);
	},

	////////////////// DEPRECATED METHODS ///////////////////

	setAttribute: function(/*String*/ attr, /*anything*/ value){
		// summary:
		//		Deprecated.  Use set() instead.
		// tags:
		//		deprecated
		kernel.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.", "", "2.0");
		this.set(attr, value);
	},

	attr: function(/*String|Object*/name, /*Object?*/value){
		// summary:
		//		Set or get properties on a widget instance.
		//	name:
		//		The property to get or set. If an object is passed here and not
		//		a string, its keys are used as names of attributes to be set
		//		and the value of the object as values to set in the widget.
		//	value:
		//		Optional. If provided, attr() operates as a setter. If omitted,
		//		the current value of the named property is returned.
		// description:
		//		This method is deprecated, use get() or set() directly.

		// Print deprecation warning but only once per calling function
		if(config.isDebug){
			var alreadyCalledHash = arguments.callee._ach || (arguments.callee._ach = {}),
				caller = (arguments.callee.caller || "unknown caller").toString();
			if(!alreadyCalledHash[caller]){
				kernel.deprecated(this.declaredClass + "::attr() is deprecated. Use get() or set() instead, called from " +
				caller, "", "2.0");
				alreadyCalledHash[caller] = true;
			}
		}

		var args = arguments.length;
		if(args >= 2 || typeof name === "object"){ // setter
			return this.set.apply(this, arguments);
		}else{ // getter
			return this.get(name);
		}
	},

	getDescendants: function(){
		// summary:
		//		Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
		//		This method should generally be avoided as it returns widgets declared in templates, which are
		//		supposed to be internal/hidden, but it's left here for back-compat reasons.

		kernel.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.", "", "2.0");
		return this.containerNode ? query('[widgetId]', this.containerNode).map(registry.byNode) : []; // dijit._Widget[]
	},

	////////////////// MISCELLANEOUS METHODS ///////////////////

	_onShow: function(){
		// summary:
		//		Internal method called when this widget is made visible.
		//		See `onShow` for details.
		this.onShow();
	},

	onShow: function(){
		// summary:
		//		Called when this widget becomes the selected pane in a
		//		`dijit.layout.TabContainer`, `dijit.layout.StackContainer`,
		//		`dijit.layout.AccordionContainer`, etc.
		//
		//		Also called to indicate display of a `dijit.Dialog`, `dijit.TooltipDialog`, or `dijit.TitlePane`.
		// tags:
		//		callback
	},

	onHide: function(){
		// summary:
			//		Called when another widget becomes the selected pane in a
			//		`dijit.layout.TabContainer`, `dijit.layout.StackContainer`,
			//		`dijit.layout.AccordionContainer`, etc.
			//
			//		Also called to indicate hide of a `dijit.Dialog`, `dijit.TooltipDialog`, or `dijit.TitlePane`.
			// tags:
			//		callback
	},

	onClose: function(){
		// summary:
		//		Called when this widget is being displayed as a popup (ex: a Calendar popped
		//		up from a DateTextBox), and it is hidden.
		//		This is called from the dijit.popup code, and should not be called directly.
		//
		//		Also used as a parameter for children of `dijit.layout.StackContainer` or subclasses.
		//		Callback if a user tries to close the child.   Child will be closed if this function returns true.
		// tags:
		//		extension

		return true;		// Boolean
	}
});

// For back-compat, remove in 2.0.
if(!kernel.isAsync){
	ready(0, function(){
		var requires = ["dijit/_base"];
		require(requires);	// use indirection so modules not rolled into a build
	});
}
return _Widget;
});

},
'dijit/_FocusMixin':function(){
define("dijit/_FocusMixin", [
	"./focus",
	"./_WidgetBase",
	"dojo/_base/declare", // declare
	"dojo/_base/lang" // lang.extend
], function(focus, _WidgetBase, declare, lang){

/*=====
	var _WidgetBase = dijit._WidgetBase;
=====*/

	// module:
	//		dijit/_FocusMixin
	// summary:
	//		Mixin to widget to provide _onFocus() and _onBlur() methods that
	//		fire when a widget or it's descendants get/lose focus

	// We don't know where _FocusMixin will occur in the inheritance chain, but we need the _onFocus()/_onBlur() below
	// to be last in the inheritance chain, so mixin to _WidgetBase.
	lang.extend(_WidgetBase, {
		// focused: [readonly] Boolean
		//		This widget or a widget it contains has focus, or is "active" because
		//		it was recently clicked.
		focused: false,

		onFocus: function(){
			// summary:
			//		Called when the widget becomes "active" because
			//		it or a widget inside of it either has focus, or has recently
			//		been clicked.
			// tags:
			//		callback
		},

		onBlur: function(){
			// summary:
			//		Called when the widget stops being "active" because
			//		focus moved to something outside of it, or the user
			//		clicked somewhere outside of it, or the widget was
			//		hidden.
			// tags:
			//		callback
		},

		_onFocus: function(){
			// summary:
			//		This is where widgets do processing for when they are active,
			//		such as changing CSS classes.  See onFocus() for more details.
			// tags:
			//		protected
			this.onFocus();
		},

		_onBlur: function(){
			// summary:
			//		This is where widgets do processing for when they stop being active,
			//		such as changing CSS classes.  See onBlur() for more details.
			// tags:
			//		protected
			this.onBlur();
		}
	});

	return declare("dijit._FocusMixin", null, {
		// summary:
		//		Mixin to widget to provide _onFocus() and _onBlur() methods that
		//		fire when a widget or it's descendants get/lose focus

		// flag that I want _onFocus()/_onBlur() notifications from focus manager
		_focusManager: focus
	});

});

},
'dijit/focus':function(){
define("dijit/focus", [
	"dojo/aspect",
	"dojo/_base/declare", // declare
	"dojo/dom", // domAttr.get dom.isDescendant
	"dojo/dom-attr", // domAttr.get dom.isDescendant
	"dojo/dom-construct", // connect to domConstruct.empty, domConstruct.destroy
	"dojo/Evented",
	"dojo/_base/lang", // lang.hitch
	"dojo/on",
	"dojo/ready",
	"dojo/_base/sniff", // has("ie")
	"dojo/Stateful",
	"dojo/_base/unload", // unload.addOnWindowUnload
	"dojo/_base/window", // win.body
	"dojo/window", // winUtils.get
	"./a11y",	// a11y.isTabNavigable
	"./registry",	// registry.byId
	"."		// to set dijit.focus
], function(aspect, declare, dom, domAttr, domConstruct, Evented, lang, on, ready, has, Stateful, unload, win, winUtils,
			a11y, registry, dijit){

	// module:
	//		dijit/focus
	// summary:
	//		Returns a singleton that tracks the currently focused node, and which widgets are currently "active".

/*=====
	dijit.focus = {
		// summary:
		//		Tracks the currently focused node, and which widgets are currently "active".
		//		Access via require(["dijit/focus"], function(focus){ ... }).
		//
		//		A widget is considered active if it or a descendant widget has focus,
		//		or if a non-focusable node of this widget or a descendant was recently clicked.
		//
		//		Call focus.watch("curNode", callback) to track the current focused DOMNode,
		//		or focus.watch("activeStack", callback) to track the currently focused stack of widgets.
		//
		//		Call focus.on("widget-blur", func) or focus.on("widget-focus", ...) to monitor when
		//		when widgets become active/inactive
		//
		//		Finally, focus(node) will focus a node, suppressing errors if the node doesn't exist.

		// curNode: DomNode
		//		Currently focused item on screen
		curNode: null,

		// activeStack: dijit._Widget[]
		//		List of currently active widgets (focused widget and it's ancestors)
		activeStack: [],

		registerIframe: function(iframe){
			// summary:
			//		Registers listeners on the specified iframe so that any click
			//		or focus event on that iframe (or anything in it) is reported
			//		as a focus/click event on the <iframe> itself.
			// description:
			//		Currently only used by editor.
			// returns:
			//		Handle with remove() method to deregister.
		},

		registerWin: function(targetWindow, effectiveNode){
			// summary:
			//		Registers listeners on the specified window (either the main
			//		window or an iframe's window) to detect when the user has clicked somewhere
			//		or focused somewhere.
			// description:
			//		Users should call registerIframe() instead of this method.
			// targetWindow: Window?
			//		If specified this is the window associated with the iframe,
			//		i.e. iframe.contentWindow.
			// effectiveNode: DOMNode?
			//		If specified, report any focus events inside targetWindow as
			//		an event on effectiveNode, rather than on evt.target.
			// returns:
			//		Handle with remove() method to deregister.
		}
	};
=====*/

	var FocusManager = declare([Stateful, Evented], {
		// curNode: DomNode
		//		Currently focused item on screen
		curNode: null,

		// activeStack: dijit._Widget[]
		//		List of currently active widgets (focused widget and it's ancestors)
		activeStack: [],

		constructor: function(){
			// Don't leave curNode/prevNode pointing to bogus elements
			var check = lang.hitch(this, function(node){
				if(dom.isDescendant(this.curNode, node)){
					this.set("curNode", null);
				}
				if(dom.isDescendant(this.prevNode, node)){
					this.set("prevNode", null);
				}
			});
			aspect.before(domConstruct, "empty", check);
			aspect.before(domConstruct, "destroy", check);
		},

		registerIframe: function(/*DomNode*/ iframe){
			// summary:
			//		Registers listeners on the specified iframe so that any click
			//		or focus event on that iframe (or anything in it) is reported
			//		as a focus/click event on the <iframe> itself.
			// description:
			//		Currently only used by editor.
			// returns:
			//		Handle with remove() method to deregister.
			return this.registerWin(iframe.contentWindow, iframe);
		},

		registerWin: function(/*Window?*/targetWindow, /*DomNode?*/ effectiveNode){
			// summary:
			//		Registers listeners on the specified window (either the main
			//		window or an iframe's window) to detect when the user has clicked somewhere
			//		or focused somewhere.
			// description:
			//		Users should call registerIframe() instead of this method.
			// targetWindow:
			//		If specified this is the window associated with the iframe,
			//		i.e. iframe.contentWindow.
			// effectiveNode:
			//		If specified, report any focus events inside targetWindow as
			//		an event on effectiveNode, rather than on evt.target.
			// returns:
			//		Handle with remove() method to deregister.

			// TODO: make this function private in 2.0; Editor/users should call registerIframe(),

			var _this = this;
			var mousedownListener = function(evt){
				_this._justMouseDowned = true;
				setTimeout(function(){ _this._justMouseDowned = false; }, 0);

				// workaround weird IE bug where the click is on an orphaned node
				// (first time clicking a Select/DropDownButton inside a TooltipDialog)
				if(has("ie") && evt && evt.srcElement && evt.srcElement.parentNode == null){
					return;
				}

				_this._onTouchNode(effectiveNode || evt.target || evt.srcElement, "mouse");
			};

			// Listen for blur and focus events on targetWindow's document.
			// IIRC, I'm using attachEvent() rather than dojo.connect() because focus/blur events don't bubble
			// through dojo.connect(), and also maybe to catch the focus events early, before onfocus handlers
			// fire.
			// Connect to <html> (rather than document) on IE to avoid memory leaks, but document on other browsers because
			// (at least for FF) the focus event doesn't fire on <html> or <body>.
			var doc = has("ie") ? targetWindow.document.documentElement : targetWindow.document;
			if(doc){
				if(has("ie")){
					targetWindow.document.body.attachEvent('onmousedown', mousedownListener);
					var activateListener = function(evt){
						// IE reports that nodes like <body> have gotten focus, even though they have tabIndex=-1,
						// ignore those events
						var tag = evt.srcElement.tagName.toLowerCase();
						if(tag == "#document" || tag == "body"){ return; }

						// Previous code called _onTouchNode() for any activate event on a non-focusable node.   Can
						// probably just ignore such an event as it will be handled by onmousedown handler above, but
						// leaving the code for now.
						if(a11y.isTabNavigable(evt.srcElement)){
							_this._onFocusNode(effectiveNode || evt.srcElement);
						}else{
							_this._onTouchNode(effectiveNode || evt.srcElement);
						}
					};
					doc.attachEvent('onactivate', activateListener);
					var deactivateListener =  function(evt){
						_this._onBlurNode(effectiveNode || evt.srcElement);
					};
					doc.attachEvent('ondeactivate', deactivateListener);

					return {
						remove: function(){
							targetWindow.document.detachEvent('onmousedown', mousedownListener);
							doc.detachEvent('onactivate', activateListener);
							doc.detachEvent('ondeactivate', deactivateListener);
							doc = null;	// prevent memory leak (apparent circular reference via closure)
						}
					};
				}else{
					doc.body.addEventListener('mousedown', mousedownListener, true);
					doc.body.addEventListener('touchstart', mousedownListener, true);
					var focusListener = function(evt){
						_this._onFocusNode(effectiveNode || evt.target);
					};
					doc.addEventListener('focus', focusListener, true);
					var blurListener = function(evt){
						_this._onBlurNode(effectiveNode || evt.target);
					};
					doc.addEventListener('blur', blurListener, true);

					return {
						remove: function(){
							doc.body.removeEventListener('mousedown', mousedownListener, true);
							doc.body.removeEventListener('touchstart', mousedownListener, true);
							doc.removeEventListener('focus', focusListener, true);
							doc.removeEventListener('blur', blurListener, true);
							doc = null;	// prevent memory leak (apparent circular reference via closure)
						}
					};
				}
			}
		},

		_onBlurNode: function(/*DomNode*/ /*===== node =====*/){
			// summary:
			// 		Called when focus leaves a node.
			//		Usually ignored, _unless_ it *isn't* followed by touching another node,
			//		which indicates that we tabbed off the last field on the page,
			//		in which case every widget is marked inactive
			this.set("prevNode", this.curNode);
			this.set("curNode", null);

			if(this._justMouseDowned){
				// the mouse down caused a new widget to be marked as active; this blur event
				// is coming late, so ignore it.
				return;
			}

			// if the blur event isn't followed by a focus event then mark all widgets as inactive.
			if(this._clearActiveWidgetsTimer){
				clearTimeout(this._clearActiveWidgetsTimer);
			}
			this._clearActiveWidgetsTimer = setTimeout(lang.hitch(this, function(){
				delete this._clearActiveWidgetsTimer;
				this._setStack([]);
				this.prevNode = null;
			}), 100);
		},

		_onTouchNode: function(/*DomNode*/ node, /*String*/ by){
			// summary:
			//		Callback when node is focused or mouse-downed
			// node:
			//		The node that was touched.
			// by:
			//		"mouse" if the focus/touch was caused by a mouse down event

			// ignore the recent blurNode event
			if(this._clearActiveWidgetsTimer){
				clearTimeout(this._clearActiveWidgetsTimer);
				delete this._clearActiveWidgetsTimer;
			}

			// compute stack of active widgets (ex: ComboButton --> Menu --> MenuItem)
			var newStack=[];
			try{
				while(node){
					var popupParent = domAttr.get(node, "dijitPopupParent");
					if(popupParent){
						node=registry.byId(popupParent).domNode;
					}else if(node.tagName && node.tagName.toLowerCase() == "body"){
						// is this the root of the document or just the root of an iframe?
						if(node === win.body()){
							// node is the root of the main document
							break;
						}
						// otherwise, find the iframe this node refers to (can't access it via parentNode,
						// need to do this trick instead). window.frameElement is supported in IE/FF/Webkit
						node=winUtils.get(node.ownerDocument).frameElement;
					}else{
						// if this node is the root node of a widget, then add widget id to stack,
						// except ignore clicks on disabled widgets (actually focusing a disabled widget still works,
						// to support MenuItem)
						var id = node.getAttribute && node.getAttribute("widgetId"),
							widget = id && registry.byId(id);
						if(widget && !(by == "mouse" && widget.get("disabled"))){
							newStack.unshift(id);
						}
						node=node.parentNode;
					}
				}
			}catch(e){ /* squelch */ }

			this._setStack(newStack, by);
		},

		_onFocusNode: function(/*DomNode*/ node){
			// summary:
			//		Callback when node is focused

			if(!node){
				return;
			}

			if(node.nodeType == 9){
				// Ignore focus events on the document itself.  This is here so that
				// (for example) clicking the up/down arrows of a spinner
				// (which don't get focus) won't cause that widget to blur. (FF issue)
				return;
			}

			this._onTouchNode(node);

			if(node == this.curNode){ return; }
			this.set("curNode", node);
		},

		_setStack: function(/*String[]*/ newStack, /*String*/ by){
			// summary:
			//		The stack of active widgets has changed.  Send out appropriate events and records new stack.
			// newStack:
			//		array of widget id's, starting from the top (outermost) widget
			// by:
			//		"mouse" if the focus/touch was caused by a mouse down event

			var oldStack = this.activeStack;
			this.set("activeStack", newStack);

			// compare old stack to new stack to see how many elements they have in common
			for(var nCommon=0; nCommon<Math.min(oldStack.length, newStack.length); nCommon++){
				if(oldStack[nCommon] != newStack[nCommon]){
					break;
				}
			}

			var widget;
			// for all elements that have gone out of focus, set focused=false
			for(var i=oldStack.length-1; i>=nCommon; i--){
				widget = registry.byId(oldStack[i]);
				if(widget){
					widget._hasBeenBlurred = true;		// TODO: used by form widgets, should be moved there
					widget.set("focused", false);
					if(widget._focusManager == this){
						widget._onBlur(by);
					}
					this.emit("widget-blur", widget, by);
				}
			}

			// for all element that have come into focus, set focused=true
			for(i=nCommon; i<newStack.length; i++){
				widget = registry.byId(newStack[i]);
				if(widget){
					widget.set("focused", true);
					if(widget._focusManager == this){
						widget._onFocus(by);
					}
					this.emit("widget-focus", widget, by);
				}
			}
		},

		focus: function(node){
			// summary:
			//		Focus the specified node, suppressing errors if they occur
			if(node){
				try{ node.focus(); }catch(e){/*quiet*/}
			}
		}
	});

	var singleton = new FocusManager();

	// register top window and all the iframes it contains
	ready(function(){
		var handle = singleton.registerWin(win.doc.parentWindow || win.doc.defaultView);
		if(has("ie")){
			unload.addOnWindowUnload(function(){
				handle.remove();
				handle = null;
			})
		}
	});

	// Setup dijit.focus as a pointer to the singleton but also (for backwards compatibility)
	// as a function to set focus.
	dijit.focus = function(node){
		singleton.focus(node);	// indirection here allows dijit/_base/focus.js to override behavior
	};
	for(var attr in singleton){
		if(!/^_/.test(attr)){
			dijit.focus[attr] = typeof singleton[attr] == "function" ? lang.hitch(singleton, attr) : singleton[attr];
		}
	}
	singleton.watch(function(attr, oldVal, newVal){
		dijit.focus[attr] = newVal;
	});

	return singleton;
});

},
'dojo/behavior':function(){
define("dojo/behavior", ["./_base/kernel", "./_base/lang", "./_base/array", "./_base/connect", "./query", "./ready"], function(dojo, lang, darray, connect, query, ready) {
	// module:
	//		dojo/behavior
	// summary:
	//		TODOC


dojo.behavior = new function(){
	// summary:
	//		Utility for unobtrusive/progressive event binding, DOM traversal,
	//		and manipulation.
	//
	// description:
	//
	//		A very simple, lightweight mechanism for applying code to
	//		existing documents, based around `dojo.query` (CSS3 selectors) for node selection,
	//		and a simple two-command API: `dojo.behavior.add()` and `dojo.behavior.apply()`;
	//
	//		Behaviors apply to a given page, and are registered following the syntax
	//		options described by `dojo.behavior.add` to match nodes to actions, or "behaviors".
	//
	//		Added behaviors are applied to the current DOM when .apply() is called,
	//		matching only new nodes found since .apply() was last called.
	//
	function arrIn(obj, name){
		if(!obj[name]){ obj[name] = []; }
		return obj[name];
	}

	var _inc = 0;

	function forIn(obj, scope, func){
		var tmpObj = {};
		for(var x in obj){
			if(typeof tmpObj[x] == "undefined"){
				if(!func){
					scope(obj[x], x);
				}else{
					func.call(scope, obj[x], x);
				}
			}
		}
	}

	// FIXME: need a better test so we don't exclude nightly Safari's!
	this._behaviors = {};
	this.add = function(/* Object */behaviorObj){
		// summary:
		//		Add the specified behavior to the list of behaviors, ignoring existing
		//		matches.
		// behaviorObj: Object
		//		The behavior object that will be added to behaviors list. The behaviors
		//		in the list will be applied the next time apply() is called.
		// description:
		//		Add the specified behavior to the list of behaviors which will
		//		be applied the next time apply() is called. Calls to add() for
		//		an already existing behavior do not replace the previous rules,
		//		but are instead additive. New nodes which match the rule will
		//		have all add()-ed behaviors applied to them when matched.
		//
		//		The "found" method is a generalized handler that's called as soon
		//		as the node matches the selector. Rules for values that follow also
		//		apply to the "found" key.
		//
		//		The "on*" handlers are attached with `dojo.connect()`, using the
		//		matching node
		//
		//		If the value corresponding to the ID key is a function and not a
		//		list, it's treated as though it was the value of "found".
		//
		// 		dojo.behavior.add() can be called any number of times before
		//		the DOM is ready. `dojo.behavior.apply()` is called automatically
		//		by `dojo.addOnLoad`, though can be called to re-apply previously added
		//		behaviors anytime the DOM changes.
		//
		//		There are a variety of formats permitted in the behaviorObject
		//
		// example:
		//		Simple list of properties. "found" is special. "Found" is assumed if
		//		no property object for a given selector, and property is a function.
		//
		//	|	dojo.behavior.add({
		//	|		"#id": {
		//	|			"found": function(element){
		//	|				// node match found
		//	|			},
		//	|			"onclick": function(evt){
		//	|				// register onclick handler for found node
		//	|			}
		//	|		},
		// 	|		"#otherid": function(element){
		//	|			// assumes "found" with this syntax
		//	|		}
		//	|	});
		//
		// example:
		//		 If property is a string, a dojo.publish will be issued on the channel:
		//
		//	|	dojo.behavior.add({
		//	|		// dojo.publish() whenever class="noclick" found on anchors
		//	|		"a.noclick": "/got/newAnchor",
		//	|		"div.wrapper": {
		//	|			"onclick": "/node/wasClicked"
		//	|		}
		//	|	});
		//	|	dojo.subscribe("/got/newAnchor", function(node){
		//	|		// handle node finding when dojo.behavior.apply() is called,
		//	|		// provided a newly matched node is found.
		//	|	});
		//
		// example:
		//		Scoping can be accomplished by passing an object as a property to
		//		a connection handle (on*):
		//
		//	|	dojo.behavior.add({
		//	|		 	"#id": {
		//	|				// like calling dojo.hitch(foo,"bar"). execute foo.bar() in scope of foo
		//	|				"onmouseenter": { targetObj: foo, targetFunc: "bar" },
		//	|				"onmouseleave": { targetObj: foo, targetFunc: "baz" }
		//	|			}
		//	|	});
		//
		// example:
		//		Bahaviors match on CSS3 Selectors, powered by dojo.query. Example selectors:
		//
		//	|	dojo.behavior.add({
		//	|		// match all direct descendants
		//	|		"#id4 > *": function(element){
		//	|			// ...
		//	|		},
		//	|
		//	|		// match the first child node that's an element
		//	|		"#id4 > :first-child": { ... },
		//	|
		//	|		// match the last child node that's an element
		//	|		"#id4 > :last-child":  { ... },
		//	|
		//	|		// all elements of type tagname
		//	|		"tagname": {
		//	|			// ...
		//	|		},
		//	|
		//	|		"tagname1 tagname2 tagname3": {
		//	|			// ...
		//	|		},
		//	|
		//	|		".classname": {
		//	|			// ...
		//	|		},
		//	|
		//	|		"tagname.classname": {
		//	|			// ...
		//	|		}
		//	|	});
		//

		forIn(behaviorObj, this, function(behavior, name){
			var tBehavior = arrIn(this._behaviors, name);
			if(typeof tBehavior["id"] != "number"){
				tBehavior.id = _inc++;
			}
			var cversion = [];
			tBehavior.push(cversion);
			if((lang.isString(behavior))||(lang.isFunction(behavior))){
				behavior = { found: behavior };
			}
			forIn(behavior, function(rule, ruleName){
				arrIn(cversion, ruleName).push(rule);
			});
		});
	};

	var _applyToNode = function(node, action, ruleSetName){
		if(lang.isString(action)){
			if(ruleSetName == "found"){
				connect.publish(action, [ node ]);
			}else{
				connect.connect(node, ruleSetName, function(){
					connect.publish(action, arguments);
				});
			}
		}else if(lang.isFunction(action)){
			if(ruleSetName == "found"){
				action(node);
			}else{
				connect.connect(node, ruleSetName, action);
			}
		}
	};

	this.apply = function(){
		// summary:
		//		Applies all currently registered behaviors to the document.
		//
		// description:
		//		Applies all currently registered behaviors to the document,
		//		taking care to ensure that only incremental updates are made
		//		since the last time add() or apply() were called.
		//
		//		If new matching nodes have been added, all rules in a behavior will be
		//		applied to that node. For previously matched nodes, only
		//		behaviors which have been added since the last call to apply()
		//		will be added to the nodes.
		//
		//		apply() is called once automatically by `dojo.addOnLoad`, so
		//		registering behaviors with `dojo.behavior.add` before the DOM is
		//		ready is acceptable, provided the dojo.behavior module is ready.
		//
		//		Calling appy() manually after manipulating the DOM is required
		//		to rescan the DOM and apply newly .add()ed behaviors, or to match
		//		nodes that match existing behaviors when those nodes are added to
		//		the DOM.
		//
		forIn(this._behaviors, function(tBehavior, id){
			query(id).forEach(
				function(elem){
					var runFrom = 0;
					var bid = "_dj_behavior_"+tBehavior.id;
					if(typeof elem[bid] == "number"){
						runFrom = elem[bid];
						if(runFrom == (tBehavior.length)){
							return;
						}
					}
					// run through the versions, applying newer rules at each step

					for(var x=runFrom, tver; tver = tBehavior[x]; x++){
						forIn(tver, function(ruleSet, ruleSetName){
							if(lang.isArray(ruleSet)){
								darray.forEach(ruleSet, function(action){
									_applyToNode(elem, action, ruleSetName);
								});
							}
						});
					}

					// ensure that re-application only adds new rules to the node
					elem[bid] = tBehavior.length;
				}
			);
		});
	};
};

ready(dojo.behavior, "apply"); // FIXME: should this use a priority? before/after parser priority?

return dojo.behavior;
});

},
'dijit/main':function(){
define("dijit/main", [
	"dojo/_base/kernel"
], function(dojo){
	// module:
	//		dijit
	// summary:
	//		The dijit package main module

	return dojo.dijit;
});

},
'bf/select/Select1Radio':function(){
define("bf/select/Select1Radio", ["dojo/_base/declare", "dijit/_Widget","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dijit/registry","dojo/query","dojo/_base/connect","dojo/dom"],
    function(declare, _Widget,domAttr,domClass,domConstruct,registry,query,connect,dom){
        return declare(_Widget, {
            controlId:null,
            currentValue:null,

            postCreate:function() {
                // console.debug("Select1Radio.postCreate");
                connect.subscribe("xforms-item-changed-" + this.id , this, "handleStateChanged");
                connect.subscribe("betterform-insert-item-" + this.id , this, "handleInsertItem");
                connect.subscribe("betterform-delete-item-" + this.id , this, "handleDeleteItem");

            },

            _onBlur:function() {
                // console.debug("bf.Select1Full._onBlur arguments:",arguments);
                var checkedRadioItemValue = undefined;
                query(".xfRadioValue", this.domNode).forEach(function(item) {
                    // console.debug("analysing radioitem:",item);
                    if(item.checked){
                        checkedRadioItemValue = item.value;
                        // console.debug("selected radioitem:",checkedRadioItemValue);
                    }
                });
                registry.byId(this.controlId).sendValue(checkedRadioItemValue,true);
            },

            handleInsertItem:function(contextInfo) {
                // console.debug("bf.Select1Full.handleInsertItem: ", contextInfo);
                var checkedRadioItemValue;
                query(".xfRadioValue", this.domNode).forEach(function(item) {
                    // console.debug("analysing radioitem:",item);
                    if(item.checked){
                        checkedRadioItemValue = item.value;
                        // console.debug("selected radioitem:",checkedRadioItemValue);
                    }
                });
                this.currentValue = checkedRadioItemValue;
                // console.debug("Select1Radio.handleInsert this.currentValue:",this.currentValue);

                var itemsetId = contextInfo.targetId;
                var generatedItemId =  contextInfo.generatedIds[contextInfo.prototypeId];

                var selectedItemset = dom.byId(itemsetId);
                if(selectedItemset){
                    // memorize checked radio item
                    /*
                     var checkedRadioItem = query(".xfRadioValue[checked]", selectedItemset);
                     console.debug("checkedRadioItem: ",checkedRadioItem);
                     var checkedRadioItemValue = checkedRadioItem[0].value;
                     console.debug("checkedRadioItemValue: ",checkedRadioItemValue);
                     */

                    var xfSelectorItem = domConstruct.create("span", {id:generatedItemId}, selectedItemset, "last");
                    domClass.add(xfSelectorItem, "xfSelectorItem");
                    var xfSelectorItemValue = domConstruct.create("input", {id:generatedItemId+"-value"}, xfSelectorItem, "first");
                    domClass.add(xfSelectorItemValue, "xfRadioValue");
                    domAttr.set(xfSelectorItemValue, "type", "radio");
                    domAttr.set(xfSelectorItemValue, "name", "d_" + this.controlId);
                    domAttr.set(xfSelectorItemValue, "parentid", this.controlId);
                    domAttr.set(xfSelectorItemValue, "tabindex", "0");
                    var xfControlId = this.controlId;
                    xfSelectorItemValue.onclick = function(evt) {
                        registry.byId(xfControlId).sendValue(xfSelectorItemValue.value,evt);
                    };

                    var xfSelectorItemLabel = domConstruct.create("label", {id:generatedItemId+"-label"}, xfSelectorItemValue, "after");
                    domAttr.set(xfSelectorItemLabel, "for", generatedItemId+"-value");
                    domClass.add(xfSelectorItemLabel, "xfRadioLabel");

                    /*
                     var radioItemToCheck= query(".xfRadioValue[value=\""+ checkedRadioItemValue +"\"]", selectedItemset)[0];
                     console.debug("radioItemToCheck: ",radioItemToCheck);
                     domAttr.set(radioItemToCheck,"checked", true);
                     */
                }else {
                    console.warn("Select1Radio: itemset '",itemsetId,"' does not exist for Select1 [id:'",this.id ,"']");
                }
            },

            handleDeleteItem:function(contextInfo){
                // console.debug("handleDeleteItem for id:",this.id, " contextInfo:",contextInfo);
                var itemsetNode = dom.byId(contextInfo.originalId);
                var selectorItems  = query(".xfSelectorItem", itemsetNode);

                itemsetNode.removeChild(selectorItems[(contextInfo.position -1)]);


            },

            handleStateChanged:function(contextInfo) {
                // console.debug("Select1Radio.handleStateChanged: contextInfo:",contextInfo);
                var targetName = contextInfo.targetName;
                if(targetName == "label"){
                    dom.byId(contextInfo.parentId + "-label").innerHTML = contextInfo.value;
                }else if(targetName == "value"){
                    var radioValue = dom.byId(contextInfo.parentId+"-value");
                    domAttr.set(radioValue,"value",contextInfo.value);
                    if(this.currentValue == contextInfo.value){
                        // console.debug("\n\nverify that value is the same as before the insert this.currentValue: ",this.currentValue);
                        domAttr.set(radioValue,"checked", true);
                    }else {
                        domAttr.set(radioValue,"checked", false);
                    }
                }else {
                    console.warn("Select1Radio.handleStateChanged: no action taken for contextInfo: ",contextInfo);
                }
            },

            setReadOnly:function(){
                // console.debug("Select1Radio.setReadOnly");
                query(".xfRadioValue", this.domNode).forEach(function(item) {
                    domAttr.set(item, "disabled","disabled");
                });
            },

            setReadWrite:function(){
                // console.debug("Select1Radio.setReadWrite");
                query(".xfRadioValue", this.domNode).forEach(function(item) {
                    domAttr.remove(item, "disabled");
                });
            }
        });
    }
);
},
'bf/MappingProcessor':function(){
/**
 * MappingProcessor generates dojo.behaviors of the CSS matchers defined in Mapping.js. Further it calls the the Factory.create
 * function of a given factory and passes in the matched node and the 3rd param of the mapping (a string telling the
 * factory which Widget to create)
 */
define("bf/MappingProcessor", ["dojo/_base/declare"],
    function(declare) {
        return declare(null, {
            factories:{},

            constructor:function() {
                var widgetFactories = this.factories;

                require(["dojo/behavior","dojo/dom-attr","dojo/_base/array","bf/XFControl","bf/Mapping"],
                    function(behavior,domAttr,array){
                        // read all mappings and iterate them
                        var mappings = bf.Mapping.data;
                        array.forEach(mappings, function(mapping){
                            var widgetBehavior = {};
                            var behaviorString = mapping[0];
                            // create dojo.behavior programmatically
                            widgetBehavior[behaviorString] = {
                                found: function(n){
                                    // the 2nd entry of each mapping array specifies which factory to call or which object to
                                    // create
                                    var JS_CLASS_NAME = mapping[1];
                                    // a string telling the factory which widget to create
                                    var param= mapping[2];
                                    // console.debug("FOUND: ", n);
                                    // console.debug("MappingProcessor: map to: ", JS_CLASS_NAME, " param: ", param);
                                    require([JS_CLASS_NAME],
                                        function(JS_CLASS_NAME){
                                            // if a factory is used, a 'param' must be given, otherwise the behavior will
                                            // create for any appearance of the match string a new object (see else)
                                            if(param){
                                                // check if an instance of the factory is already present
                                                var factory = undefined;
                                                if(widgetFactories[mapping[1]]){
                                                    // console.debug("MappingProcessor: use existing factory: ",mapping[1]);
                                                    factory = widgetFactories[mapping[1]];
                                                }else {
                                                    // console.debug("create new factory: ",mapping[1]);
                                                    try {
                                                        factory = new JS_CLASS_NAME({},n);
                                                        widgetFactories[mapping[1]] = factory;
                                                    }catch(err) {
                                                        console.error("MappingProcessor: Could not create factory ",JS_CLASS_NAME, " Mapping: ",mapping);
                                                    }
                                                }
                                                // call the create function of the factory
                                                // console.debug("MappingProcessor: factory.create: ",factory);
                                                factory.create(param,n);
                                            }else {
                                                try {
                                                    new JS_CLASS_NAME({},n);
                                                }catch(err) {
                                                    console.error("Could not create dijit ",JS_CLASS_NAME, " Mapping: ",mapping);
                                                }
                                            }
                                        }
                                    );
                                }
                            };
                            // console.debug("add new behavior: ",widgetBehavior);
                            // add the created behavior to dojo.behavior
                            behavior.add(widgetBehavior);
                        }
                    );
                });
            }
        });
    }
);


}}});

require(["dojo/i18n"], function(i18n){
i18n._preloadLocalizations("bf/nls/core", []);
});
define("bf/core", [], 1);
