//>>built
require({cache:{
'dojox/highlight/languages/delphi':function(){
define("dojox/highlight/languages/delphi", ["dojox/main", "../_base"], function(dojox){

	var DELPHI_KEYWORDS = {
		'and': 1, 'safecall': 1, 'cdecl': 1, 'then': 1, 'string': 1,
		'exports': 1, 'library': 1, 'not': 1, 'pascal': 1, 'set': 1,
		'virtual': 1, 'file': 1, 'in': 1, 'array': 1, 'label': 1, 'packed': 1,
		'end.': 1, 'index': 1, 'while': 1, 'const': 1, 'raise': 1, 'for': 1,
		'to': 1, 'implementation': 1, 'with': 1, 'except': 1, 'overload': 1,
		'destructor': 1, 'downto': 1, 'finally': 1, 'program': 1, 'exit': 1,
		'unit': 1, 'inherited': 1, 'override': 1, 'if': 1, 'type': 1,
		'until': 1, 'function': 1, 'do': 1, 'begin': 1, 'repeat': 1, 'goto': 1,
		'nil': 1, 'far': 1, 'initialization': 1, 'object': 1, 'else': 1,
		'var': 1, 'uses': 1, 'external': 1, 'resourcestring': 1,
		'interface': 1, 'end': 1, 'finalization': 1, 'class': 1, 'asm': 1,
		'mod': 1, 'case': 1, 'on': 1, 'shr': 1, 'shl': 1, 'of': 1,
		'register': 1, 'xorwrite': 1, 'threadvar': 1, 'try': 1, 'record': 1,
		'near': 1, 'stored': 1, 'constructor': 1, 'stdcall': 1, 'inline': 1,
		'div': 1, 'out': 1, 'or': 1, 'procedure': 1
	};
	var DELPHI_CLASS_KEYWORDS = {
		'safecall': 1, 'stdcall': 1, 'pascal': 1, 'stored': 1, 'const': 1,
		'implementation': 1, 'finalization': 1, 'except': 1, 'to': 1,
		'finally': 1, 'program': 1, 'inherited': 1, 'override': 1, 'then': 1,
		'exports': 1, 'string': 1, 'read': 1, 'not': 1, 'mod': 1, 'shr': 1,
		'try': 1, 'div': 1, 'shl': 1, 'set': 1, 'library': 1, 'message': 1,
		'packed': 1, 'index': 1, 'for': 1, 'near': 1, 'overload': 1,
		'label': 1, 'downto': 1, 'exit': 1, 'public': 1, 'goto': 1,
		'interface': 1, 'asm': 1, 'on': 1, 'of': 1, 'constructor': 1, 'or': 1,
		'private': 1, 'array': 1, 'unit': 1, 'raise': 1, 'destructor': 1,
		'var': 1, 'type': 1, 'until': 1, 'function': 1, 'else': 1,
		'external': 1, 'with': 1, 'case': 1, 'default': 1, 'record': 1,
		'while': 1, 'protected': 1, 'property': 1, 'procedure': 1,
		'published': 1, 'and': 1, 'cdecl': 1, 'do': 1, 'threadvar': 1,
		'file': 1, 'in': 1, 'if': 1, 'end': 1, 'virtual': 1, 'write': 1,
		'far': 1, 'out': 1, 'begin': 1, 'repeat': 1, 'nil': 1,
		'initialization': 1, 'object': 1, 'uses': 1, 'resourcestring': 1,
		'class': 1, 'register': 1, 'xorwrite': 1, 'inline': 1
	};

	var dh = dojox.highlight, dhc = dh.constants;
	dh.languages.delphi = {
		// summary: Delphi highlight definitions
		defaultMode: {
			lexems: [dhc.IDENT_RE],
			illegal: '("|\\$[G-Zg-z]|\\/\\*|</)',
			contains: ['comment', 'string', 'number', 'function', 'class'],
			keywords: DELPHI_KEYWORDS
		},
		case_insensitive: true,
		modes: [
			{
				className: 'comment',
				begin: '{', end: '}'
			},
			{
				className: 'comment',
				begin: '\\(\\*', end: '\\*\\)',
				relevance: 10
			},
			dhc.C_LINE_COMMENT_MODE,
			{
				className: 'number',
				begin: dhc.NUMBER_RE, end: '^',
				relevance: 0
			},
			{
				className: 'string',
				begin: '\'', end: '\'',
				contains: ['quote'],
				relevance: 0
			},
			{
				className: 'string',
				begin: '(#\\d+)+', end: '^'
			},
			{
				className: 'quote',
				begin: '\'\'', end: '^'
			},
			{
				className: 'function',
				begin: 'function', end: '[:;]',
				lexems: [dhc.IDENT_RE],
				keywords: {'function': 1},
				contains: ['title', 'params', 'comment'],
				relevance: 0
			},
			{
				className: 'function',
				begin: '(procedure|constructor|destructor)', end: ';',
				lexems: [dhc.IDENT_RE],
				keywords: {'constructor': 1, 'destructor': 1, 'procedure': 1},
				contains: ['title', 'params', 'comment'],
				relevance: 10
			},
			{
				className: 'title',
				begin: dhc.IDENT_RE, end: '^'
			},
			{
				className: 'params',
				begin: '\\(', end: '\\)',
				lexems: [dhc.IDENT_RE],
				keywords: DELPHI_KEYWORDS,
				contains: ['string']
			},
			{
				className: 'class',
				begin: '=\\s*class', end: 'end;',
				lexems: [dhc.IDENT_RE],
				keywords: DELPHI_CLASS_KEYWORDS,
				contains: ['string', 'comment', 'function']
			}
		]
	};

	return dh.languages.delphi
});

},
'dojox/highlight/languages/django':function(){
define("dojox/highlight/languages/django", ["dojox/main", "../_base", "./xml", "./html"], function(dojox){

	var dh = dojox.highlight, dhc = dh.constants, dhl = dh.languages, x = dhl.xml, h = dhl.html;
	dhl.django = {
		defaultMode: {
			contains: ['tag', 'comment', 'doctype', 'template_comment', 'template_tag', 'variable']
		},
		case_insensitive: true,
		modes: [
			x.XML_COMMENT,
			h.HTML_DOCTYPE,
			{
				className: 'tag',
				lexems: [dhc.IDENT_RE],
				keywords: h.HTML_TAGS,
				begin: '<[A-Za-z/]', end: '>',
				contains: ['attribute', 'template_comment', 'template_tag', 'variable']
			},
			x.XML_ATTR,
			h.HTML_ATTR,
			{
				className: 'value',
				begin: '"', end: '"',
				contains: ['template_comment', 'template_tag', 'variable']
			},
			h.HTML_VALUE,
			{
				className: 'template_comment',
				begin: '\\{\\%\\s*comment\\s*\\%\\}',
				end: '\\{\\%\\s*endcomment\\s*\\%\\}'
			},
			{
				className: 'template_comment',
				begin: '\\{#', end: '#\\}'
			},
			{
				className: 'template_tag',
				begin: '\\{\\%', end: '\\%\\}',
				lexems: [dhc.IDENT_RE],
				keywords: {
					'comment': 1, 'endcomment': 1, 'load': 1,
					'templatetag': 1, 'ifchanged': 1, 'endifchanged': 1,
					'if': 1, 'endif': 1, 'firstof': 1, 'for': 1,
					'endfor': 1, 'in': 1, 'ifnotequal': 1,
					'endifnotequal': 1, 'widthratio': 1, 'extends': 1,
					'include': 1, 'spaceless': 1, 'endspaceless': 1,
					'regroup': 1, 'by': 1, 'as': 1, 'ifequal': 1,
					'endifequal': 1, 'ssi': 1, 'now': 1, 'with': 1,
					'cycle': 1, 'url': 1, 'filter': 1, 'endfilter': 1,
					'debug': 1, 'block': 1, 'endblock': 1, 'else': 1
				},
				contains: ['filter']
			},
			{
				className: 'variable',
				begin: '\\{\\{', end: '\\}\\}',
				contains: ['filter']
			},
			{
				className: 'filter',
				begin: '\\|[A-Za-z]+\\:?', end: '^', excludeEnd: true,
				lexems: [dhc.IDENT_RE],
				keywords: {
					'truncatewords': 1, 'removetags': 1, 'linebreaksbr': 1,
					'yesno': 1, 'get_digit': 1, 'timesince': 1, 'random': 1,
					'striptags': 1, 'filesizeformat': 1, 'escape': 1,
					'linebreaks': 1, 'length_is': 1, 'ljust': 1, 'rjust': 1,
					'cut': 1, 'urlize': 1, 'fix_ampersands': 1, 'title': 1,
					'floatformat': 1, 'capfirst': 1, 'pprint': 1,
					'divisibleby': 1, 'add': 1, 'make_list': 1,
					'unordered_list': 1, 'urlencode': 1, 'timeuntil': 1,
					'urlizetrunc': 1, 'wordcount': 1, 'stringformat': 1,
					'linenumbers': 1, 'slice': 1, 'date': 1, 'dictsort': 1,
					'dictsortreversed': 1, 'default_if_none': 1,
					'pluralize': 1, 'lower': 1, 'join': 1, 'center': 1,
					'default': 1, 'truncatewords_html': 1, 'upper': 1,
					'length': 1, 'phone2numeric': 1, 'wordwrap': 1, 'time': 1,
					'addslashes': 1, 'slugify': 1, 'first': 1
				},
				contains: ['argument']
			},
			{
				className: 'argument',
				begin: '"', end: '"'
			}
		]
	};

	return dhl.django;
	
});

},
'dojox/highlight/languages/cpp':function(){
define("dojox/highlight/languages/cpp", ["dojo", "dojox/main", "../_base"], function(dojo, dojox){
	
	var dh = dojox.highlight, dhc = dh.constants;
	dh.languages.cpp = {
		// summary: C++ highlight definitions
		defaultMode: {
			lexems: [dhc.UNDERSCORE_IDENT_RE],
			illegal: '</',
			contains: ['comment', 'string', 'number', 'preprocessor'],
			keywords: {
				'false': 1, 'int': 1, 'float': 1, 'while': 1, 'private': 1,
				'char': 1, 'catch': 1, 'export': 1, 'virtual': 1,
				'operator': 2, 'sizeof': 2, 'dynamic_cast': 2, 'typedef': 2,
				'const_cast': 2, 'const': 1, 'struct': 1, 'for': 1,
				'static_cast': 2, 'union': 1, 'namespace': 1, 'unsigned': 1,
				'long': 1, 'throw': 1, 'volatile': 2, 'static': 1,
				'protected': 1, 'bool': 1, 'template': 1, 'mutable': 1,
				'if': 1, 'public': 1, 'friend': 2, 'do': 1, 'return': 1,
				'goto': 1, 'auto': 1, 'void': 2, 'enum': 1, 'else': 1,
				'break': 1, 'new': 1, 'extern': 1, 'using': 1, 'true': 1,
				'class': 1, 'asm': 1, 'case': 1, 'typeid': 1, 'short': 1,
				'reinterpret_cast': 2, 'default': 1, 'double': 1,
				'register': 1, 'explicit': 1, 'signed': 1, 'typename': 1,
				'try': 1, 'this': 1, 'switch': 1, 'continue': 1, 'wchar_t': 1,
				'inline': 1, 'delete': 1
			}
		},
		modes: [
			dhc.C_LINE_COMMENT_MODE,
			dhc.C_BLOCK_COMMENT_MODE,
			dhc.C_NUMBER_MODE,
			dhc.QUOTE_STRING_MODE,
			dhc.BACKSLASH_ESCAPE,
			{
				className: 'string',
				begin: '\'',
				end: '[^\\\\]\'',
				illegal: '[^\\\\][^\']'
			},
			{
				className: 'preprocessor',
				begin: '#', end: '$'
			}
		]
	};
	
	return dh.languages.cpp;

});

},
'url:dijit/templates/MenuBar.html':"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\"  role=\"menubar\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress: _onKeyPress\"></div>\n",
'dijit/MenuBarItem':function(){
require({cache:{
'url:dijit/templates/MenuBarItem.html':"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\n\t<span data-dojo-attach-point=\"containerNode\"></span>\n</div>\n"}});
define("dijit/MenuBarItem", [
	"dojo/_base/declare", // declare
	"./MenuItem",
	"dojo/text!./templates/MenuBarItem.html"
], function(declare, MenuItem, template){

/*=====
	var MenuItem = dijit.MenuItem;
=====*/

	// module:
	//		dijit/MenuBarItem
	// summary:
	//		Item in a MenuBar that's clickable, and doesn't spawn a submenu when pressed (or hovered)


	var _MenuBarItemMixin = declare("dijit._MenuBarItemMixin", null, {
		templateString: template,

		// Map widget attributes to DOMNode attributes.
		_setIconClassAttr: null	// cancel MenuItem setter because we don't have a place for an icon
	});

	var MenuBarItem = declare("dijit.MenuBarItem", [MenuItem, _MenuBarItemMixin], {
		// summary:
		//		Item in a MenuBar that's clickable, and doesn't spawn a submenu when pressed (or hovered)

	});
	MenuBarItem._MenuBarItemMixin = _MenuBarItemMixin;	// dojox.mobile is accessing this


	return MenuBarItem;
});

},
'dojox/highlight/languages/java':function(){
define("dojox/highlight/languages/java", ["dojox/main", "../_base"], function(dojox){

	var dh = dojox.highlight, dhc = dh.constants;
	var javakeywords = {
				'false': 1, 'int': 1, 'float': 1, 'while': 1, 'private': 1,
				'char': 1, 'catch': 1, 'abstract': 1, 'assert': 1,
				'const': 1, 'byte': 1, 'for': 1, 'final': 1,
				'finally': 1, 'implements': 1, 'import': 1, 'extends': 1,
				'long': 1, 'throw': 1, 'instanceof': 2, 'static': 1,
				'protected': 1, 'boolean': 1, 'interface': 2, 'native': 1,
				'if': 1, 'public': 1, 'new': 1, 'do': 1, 'return': 1,
				'goto': 1, 'package': 2, 'void': 2, 'short': 1, 'else': 1,
				'break': 1, 'new': 1, 'strictfp': 1, 'super': 1, 'true': 1,
				'class': 1, 'synchronized': 1, 'case': 1, 'this': 1, 'short': 1,
				'throws': 1, 'transient': 1, 'double': 1, 'volatile': 1,
				'try': 1, 'this': 1, 'switch': 1, 'continue': 1
			}
	dh.languages.java = {
		// summary: Java highlight definitions
		defaultMode: {
			lexems: [dhc.UNDERSCORE_IDENT_RE],
			illegal: '</',
			contains: ['comment', 'string', 'number', 'function','block'],
			keywords: javakeywords
		},
		modes: [
			dhc.C_LINE_COMMENT_MODE,
			dhc.C_BLOCK_COMMENT_MODE,
			dhc.C_NUMBER_MODE,
			dhc.QUOTE_STRING_MODE,
			dhc.BACKSLASH_ESCAPE,
			{
				className: 'string',
				begin: '\'',
				end: '[^\\\\]\'',
				illegal: '[^\\\\][^\']'
			},
			{
				className: 'function',
				begin: '\\(',
				end: '\\)',
				contains: ['comment', 'number', 'string', 'function', 'block'],
				keywords: javakeywords
			},
			{
				lexems: [dhc.UNDERSCORE_IDENT_RE],
				className: 'block',
				begin: '\\{',
				end: '\\}',
				contains: ['comment', 'string', 'number', 'function','block'],
				keywords: javakeywords
			}
		]
	};

	return dh.languages.java;
});

},
'dojox/highlight/languages/xml':function(){
define("dojox/highlight/languages/xml", ["dojox/main", "../_base"], function(dojox){

	var XML_COMMENT = {
		className: 'comment',
		begin: '<!--', end: '-->'
	};
	
	var XML_ATTR = {
		className: 'attribute',
		begin: ' [a-zA-Z-]+\\s*=\\s*', end: '^',
		contains: ['value']
	};
	
	var XML_VALUE = {
		className: 'value',
		begin: '"', end: '"'
	};
	
	var dh = dojox.highlight, dhc = dh.constants;
	dh.languages.xml = {
		defaultMode: {
			contains: ['pi', 'comment', 'cdata', 'tag']
		},
		case_insensitive: true,
		modes: [
			{
				className: 'pi',
				begin: '<\\?', end: '\\?>',
				relevance: 10
			},
			XML_COMMENT,
			{
				className: 'cdata',
				begin: '<\\!\\[CDATA\\[', end: '\\]\\]>'
			},
			{
				className: 'tag',
				begin: '</?', end: '>',
				contains: ['title', 'tag_internal'],
				relevance: 1.5
			},
			{
				className: 'title',
				begin: '[A-Za-z:_][A-Za-z0-9\\._:-]+', end: '^',
				relevance: 0
			},
			{
				className: 'tag_internal',
				begin: '^', endsWithParent: true,
				contains: ['attribute'],
				relevance: 0,
				illegal: '[\\+\\.]'
			},
			XML_ATTR,
			XML_VALUE
		],
		// exporting constants
		XML_COMMENT: XML_COMMENT,
		XML_ATTR: XML_ATTR,
		XML_VALUE: XML_VALUE
	};

	return dh.languages.xml;

});

},
'dojox/highlight/languages/groovy':function(){
define("dojox/highlight/languages/groovy", ["dojox/main", "../_base"], function(dojox){

	var dh = dojox.highlight, dhc = dh.constants;
	var GROOVY_KEYWORDS = {
				'false': 1, 'int': 1, 'float': 1, 'while': 1, 'private': 1,
				'char': 1, 'catch': 1, 'abstract': 1, 'assert': 1,
				'const': 1, 'byte': 1, 'for': 1, 'final': 1,
				'finally': 1, 'implements': 1, 'import': 1, 'extends': 1,
				'long': 1, 'throw': 1, 'instanceof': 2, 'static': 1,
				'protected': 1, 'boolean': 1, 'interface': 2, 'native': 1,
				'if': 1, 'public': 1, 'new': 1, 'do': 1, 'return': 1,
				'goto': 1, 'package': 2, 'void': 2, 'short': 1, 'else': 1,
				'break': 1, 'new': 1, 'strictfp': 1, 'super': 1, 'true': 1,
				'class': 1, 'synchronized': 1, 'case': 1, 'this': 1, 'short': 1,
				'throws': 1, 'transient': 1, 'double': 1, 'volatile': 1,
				'try': 1, 'this': 1, 'switch': 1, 'continue': 1, 'def': 2
			}
	dh.languages.groovy = {
		// summary: Groovy highlight definitions
		defaultMode: {
			lexems: [dhc.UNDERSCORE_IDENT_RE],
			illegal: '</',
			contains: ['comment', 'string', 'number', 'function', 'block'],
			keywords: GROOVY_KEYWORDS
		},
		modes: [
			dhc.C_LINE_COMMENT_MODE,
			dhc.C_BLOCK_COMMENT_MODE,
			dhc.C_NUMBER_MODE,
 			{
				className: 'string',
				begin: '\"\"\"', end: '\"\"\"',
				contains: ['escape'],
				relevance: 0
			},
			dhc.QUOTE_STRING_MODE,
			dhc.BACKSLASH_ESCAPE,
 			{
				className: 'string',
				begin: '\'\'\'', end: '\'\'\'',
				contains: ['escape'],
				relevance: 0
			},
			dhc.APOS_STRING_MODE,
			{
				className: 'function',
				begin: '\\(',
				end: '\\)',
				contains: ['comment', 'number', 'string', 'function', 'block'],
				keywords: GROOVY_KEYWORDS
			},
			{
				lexems: [dhc.UNDERSCORE_IDENT_RE],
				className: 'block',
				begin: '\\{',
				end: '\\}',
				contains: ['comment', 'string', 'number', 'function', 'block'],
				keywords: GROOVY_KEYWORDS
			}
		],
		//exporting constants
		GROOVY_KEYWORDS: GROOVY_KEYWORDS
	};

	return dh.languages.groovy;
	
});

},
'dijit/PopupMenuItem':function(){
define("dijit/PopupMenuItem", [
	"dojo/_base/declare", // declare
	"dojo/dom-style", // domStyle.set
	"dojo/query", // query
	"dojo/_base/window", // win.body
	"./registry",	// registry.byNode
	"./MenuItem",
	"./hccss"
], function(declare, domStyle, query, win, registry, MenuItem){

/*=====
	var MenuItem = dijit.MenuItem;
=====*/

	// module:
	//		dijit/PopupMenuItem
	// summary:
	//		An item in a Menu that spawn a drop down (usually a drop down menu)

	return declare("dijit.PopupMenuItem", MenuItem, {
		// summary:
		//		An item in a Menu that spawn a drop down (usually a drop down menu)

		_fillContent: function(){
			// summary:
			//		When Menu is declared in markup, this code gets the menu label and
			//		the popup widget from the srcNodeRef.
			// description:
			//		srcNodeRefinnerHTML contains both the menu item text and a popup widget
			//		The first part holds the menu item text and the second part is the popup
			// example:
			// |	<div data-dojo-type="dijit.PopupMenuItem">
			// |		<span>pick me</span>
			// |		<popup> ... </popup>
			// |	</div>
			// tags:
			//		protected

			if(this.srcNodeRef){
				var nodes = query("*", this.srcNodeRef);
				this.inherited(arguments, [nodes[0]]);

				// save pointer to srcNode so we can grab the drop down widget after it's instantiated
				this.dropDownContainer = this.srcNodeRef;
			}
		},

		startup: function(){
			if(this._started){ return; }
			this.inherited(arguments);

			// we didn't copy the dropdown widget from the this.srcNodeRef, so it's in no-man's
			// land now.  move it to win.doc.body.
			if(!this.popup){
				var node = query("[widgetId]", this.dropDownContainer)[0];
				this.popup = registry.byNode(node);
			}
			win.body().appendChild(this.popup.domNode);
			this.popup.startup();

			this.popup.domNode.style.display="none";
			if(this.arrowWrapper){
				domStyle.set(this.arrowWrapper, "visibility", "");
			}
			this.focusNode.setAttribute("aria-haspopup", "true");
		},

		destroyDescendants: function(/*Boolean*/ preserveDom){
			if(this.popup){
				// Destroy the popup, unless it's already been destroyed.  This can happen because
				// the popup is a direct child of <body> even though it's logically my child.
				if(!this.popup._destroyed){
					this.popup.destroyRecursive(preserveDom);
				}
				delete this.popup;
			}
			this.inherited(arguments);
		}
	});
});

},
'dijit/PopupMenuBarItem':function(){
define("dijit/PopupMenuBarItem", [
	"dojo/_base/declare", // declare
	"./PopupMenuItem",
	"./MenuBarItem"
], function(declare, PopupMenuItem, MenuBarItem){

	// module:
	//		dijit/PopupMenuBarItem
	// summary:
	//		Item in a MenuBar like "File" or "Edit", that spawns a submenu when pressed (or hovered)

	var _MenuBarItemMixin = MenuBarItem._MenuBarItemMixin;

/*=====
	var PopupMenuItem = dijit.PopupMenuItem;
	var _MenuBarItemMixin = dijit._MenuBarItemMixin;
=====*/

	return declare("dijit.PopupMenuBarItem", [PopupMenuItem, _MenuBarItemMixin], {
		// summary:
		//		Item in a MenuBar like "File" or "Edit", that spawns a submenu when pressed (or hovered)
	});
});

},
'dojox/main':function(){
define("dojox/main", ["dojo/_base/kernel"], function(dojo) {
	// module:
	//		dojox/main
	// summary:
	//		The dojox package main module; dojox package is somewhat unusual in that the main module currently just provides an empty object.

	return dojo.dojox;
});
},
'dojox/highlight/_base':function(){
define("dojox/highlight/_base", ["dojo", "dojox/main"], function(dojo, dojox){

	/*=====
		dojox.highlight = {
			//	summary:
			//		Syntax highlighting with language auto-detection package
			//
			//	description:
			//
			//		Syntax highlighting with language auto-detection package.
			//		Released under CLA by the Dojo Toolkit, original BSD release
			//		available from: http://softwaremaniacs.org/soft/highlight/
			//
			//
		};
	=====*/
	var dh = dojo.getObject("dojox.highlight", true),
		C_NUMBER_RE = '\\b(0x[A-Za-z0-9]+|\\d+(\\.\\d+)?)'
	;
	dh.languages = dh.languages || {};
	// constants

	dh.constants = {
		IDENT_RE: '[a-zA-Z][a-zA-Z0-9_]*',
		UNDERSCORE_IDENT_RE: '[a-zA-Z_][a-zA-Z0-9_]*',
		NUMBER_RE: '\\b\\d+(\\.\\d+)?',
		C_NUMBER_RE: C_NUMBER_RE,
		// Common modes
		APOS_STRING_MODE: {
			className: 'string',
			begin: '\'', end: '\'',
			illegal: '\\n',
			contains: ['escape'],
			relevance: 0
		},
		QUOTE_STRING_MODE: {
			className: 'string',
			begin: '"',
			end: '"',
			illegal: '\\n',
			contains: ['escape'],
			relevance: 0
		},
		BACKSLASH_ESCAPE: {
			className: 'escape',
			begin: '\\\\.', end: '^',
			relevance: 0
		},
		C_LINE_COMMENT_MODE: {
			className: 'comment',
			begin: '//', end: '$',
			relevance: 0
		},
		C_BLOCK_COMMENT_MODE: {
			className: 'comment',
			begin: '/\\*', end: '\\*/'
		},
		HASH_COMMENT_MODE: {
			className: 'comment',
			begin: '#', end: '$'
		},
		C_NUMBER_MODE: {
			className: 'number',
			begin: C_NUMBER_RE, end: '^',
			relevance: 0
		}
	};

	// utilities
	
	function esc(value){
		return value.replace(/&/gm, '&amp;').replace(/</gm, '&lt;').replace(/>/gm, '&gt;');
	}
	
	function verifyText(block){
		return dojo.every(block.childNodes, function(node){
			return node.nodeType == 3 || String(node.nodeName).toLowerCase() == 'br';
		});
	}

	function blockText(block){
		var result = [];
		dojo.forEach(block.childNodes, function(node){
			if(node.nodeType == 3){
				result.push(node.nodeValue);
			}else if(String(node.nodeName).toLowerCase() == 'br'){
				result.push("\n");
			}else{
				throw 'Complex markup';
			}
		});
		return result.join("");
	}

	function buildKeywordGroups(mode){
		if(!mode.keywordGroups){
			for(var key in mode.keywords){
				var kw = mode.keywords[key];
    			if(kw instanceof Object){  // dojo.isObject?
					mode.keywordGroups = mode.keywords;
				}else{
					mode.keywordGroups = {keyword: mode.keywords};
				}
				break;
			}
		}
	}
	
	function buildKeywords(lang){
		if(lang.defaultMode && lang.modes){
			buildKeywordGroups(lang.defaultMode);
			dojo.forEach(lang.modes, buildKeywordGroups);
		}
	}
	
	// main object

	var Highlighter = function(langName, textBlock){
		// initialize the state
		this.langName = langName;
		this.lang = dh.languages[langName];
		this.modes = [this.lang.defaultMode];
		this.relevance = 0;
		this.keywordCount = 0;
		this.result = [];
		
		// build resources lazily
		if(!this.lang.defaultMode.illegalRe){
			this.buildRes();
			buildKeywords(this.lang);
		}
		
		// run the algorithm
		try{
			this.highlight(textBlock);
			this.result = this.result.join("");
		}catch(e){
			if(e == 'Illegal'){
				this.relevance = 0;
				this.keywordCount = 0;
				this.partialResult = this.result.join("");
				this.result = esc(textBlock);
			}else{
				throw e;
			}
		}
	};

	dojo.extend(Highlighter, {
		buildRes: function(){
			dojo.forEach(this.lang.modes, function(mode){
				if(mode.begin){
					mode.beginRe = this.langRe('^' + mode.begin);
				}
				if(mode.end){
					mode.endRe = this.langRe('^' + mode.end);
				}
				if(mode.illegal){
					mode.illegalRe = this.langRe('^(?:' + mode.illegal + ')');
				}
			}, this);
			this.lang.defaultMode.illegalRe = this.langRe('^(?:' + this.lang.defaultMode.illegal + ')');
		},
		
		subMode: function(lexeme){
			var classes = this.modes[this.modes.length - 1].contains;
			if(classes){
				var modes = this.lang.modes;
				for(var i = 0; i < classes.length; ++i){
					var className = classes[i];
					for(var j = 0; j < modes.length; ++j){
						var mode = modes[j];
						if(mode.className == className && mode.beginRe.test(lexeme)){ return mode; }
					}
				}
			}
			return null;
		},

		endOfMode: function(lexeme){
			for(var i = this.modes.length - 1; i >= 0; --i){
				var mode = this.modes[i];
				if(mode.end && mode.endRe.test(lexeme)){ return this.modes.length - i; }
				if(!mode.endsWithParent){ break; }
			}
			return 0;
		},

		isIllegal: function(lexeme){
			var illegalRe = this.modes[this.modes.length - 1].illegalRe;
			return illegalRe && illegalRe.test(lexeme);
		},


		langRe: function(value, global){
			var mode =  'm' + (this.lang.case_insensitive ? 'i' : '') + (global ? 'g' : '');
			return new RegExp(value, mode);
		},
	
		buildTerminators: function(){
			var mode = this.modes[this.modes.length - 1],
				terminators = {};
			if(mode.contains){
				dojo.forEach(this.lang.modes, function(lmode){
					if(dojo.indexOf(mode.contains, lmode.className) >= 0){
						terminators[lmode.begin] = 1;
					}
				});
			}
			for(var i = this.modes.length - 1; i >= 0; --i){
				var m = this.modes[i];
				if(m.end){ terminators[m.end] = 1; }
				if(!m.endsWithParent){ break; }
			}
			if(mode.illegal){ terminators[mode.illegal] = 1; }
			var t = [];
			for(i in terminators){ t.push(i); }
			mode.terminatorsRe = this.langRe("(" + t.join("|") + ")");
		},

		eatModeChunk: function(value, index){
			var mode = this.modes[this.modes.length - 1];
			
			// create terminators lazily
			if(!mode.terminatorsRe){
				this.buildTerminators();
			}
	
			value = value.substr(index);
			var match = mode.terminatorsRe.exec(value);
			if(!match){
				return {
					buffer: value,
					lexeme: "",
					end:    true
				};
			}
			return {
				buffer: match.index ? value.substr(0, match.index) : "",
				lexeme: match[0],
				end:    false
			};
		},
	
		keywordMatch: function(mode, match){
			var matchStr = match[0];
			if(this.lang.case_insensitive){ matchStr = matchStr.toLowerCase(); }
			for(var className in mode.keywordGroups){
				if(matchStr in mode.keywordGroups[className]){ return className; }
			}
			return "";
		},
		
		buildLexemes: function(mode){
			var lexemes = {};
			dojo.forEach(mode.lexems, function(lexeme){
				lexemes[lexeme] = 1;
			});
			var t = [];
			for(var i in lexemes){ t.push(i); }
			mode.lexemsRe = this.langRe("(" + t.join("|") + ")", true);
		},
	
		processKeywords: function(buffer){
			var mode = this.modes[this.modes.length - 1];
			if(!mode.keywords || !mode.lexems){
				return esc(buffer);
			}
			
			// create lexemes lazily
			if(!mode.lexemsRe){
				this.buildLexemes(mode);
			}
			
			mode.lexemsRe.lastIndex = 0;
			var result = [], lastIndex = 0,
				match = mode.lexemsRe.exec(buffer);
			while(match){
				result.push(esc(buffer.substr(lastIndex, match.index - lastIndex)));
				var keywordM = this.keywordMatch(mode, match);
				if(keywordM){
					++this.keywordCount;
					result.push('<span class="'+ keywordM +'">' + esc(match[0]) + '</span>');
				}else{
					result.push(esc(match[0]));
				}
				lastIndex = mode.lexemsRe.lastIndex;
				match = mode.lexemsRe.exec(buffer);
			}
			result.push(esc(buffer.substr(lastIndex, buffer.length - lastIndex)));
			return result.join("");
		},
	
		processModeInfo: function(buffer, lexeme, end) {
			var mode = this.modes[this.modes.length - 1];
			if(end){
				this.result.push(this.processKeywords(mode.buffer + buffer));
				return;
			}
			if(this.isIllegal(lexeme)){ throw 'Illegal'; }
			var newMode = this.subMode(lexeme);
			if(newMode){
				mode.buffer += buffer;
				this.result.push(this.processKeywords(mode.buffer));
				if(newMode.excludeBegin){
					this.result.push(lexeme + '<span class="' + newMode.className + '">');
					newMode.buffer = '';
				}else{
					this.result.push('<span class="' + newMode.className + '">');
					newMode.buffer = lexeme;
				}
				this.modes.push(newMode);
				this.relevance += typeof newMode.relevance == "number" ? newMode.relevance : 1;
				return;
			}
			var endLevel = this.endOfMode(lexeme);
			if(endLevel){
				mode.buffer += buffer;
				if(mode.excludeEnd){
					this.result.push(this.processKeywords(mode.buffer) + '</span>' + lexeme);
				}else{
					this.result.push(this.processKeywords(mode.buffer + lexeme) + '</span>');
				}
				while(endLevel > 1){
					this.result.push('</span>');
					--endLevel;
					this.modes.pop();
				}
				this.modes.pop();
				this.modes[this.modes.length - 1].buffer = '';
				return;
			}
		},
	
		highlight: function(value){
			var index = 0;
			this.lang.defaultMode.buffer = '';
			do{
				var modeInfo = this.eatModeChunk(value, index);
				this.processModeInfo(modeInfo.buffer, modeInfo.lexeme, modeInfo.end);
				index += modeInfo.buffer.length + modeInfo.lexeme.length;
			}while(!modeInfo.end);
			if(this.modes.length > 1){
				throw 'Illegal';
			}
		}
	});
	
	// more utilities
	
	function replaceText(node, className, text){
		if(String(node.tagName).toLowerCase() == "code" && String(node.parentNode.tagName).toLowerCase() == "pre"){
			// See these 4 lines? This is IE's notion of "node.innerHTML = text". Love this browser :-/
			var container = document.createElement('div'),
				environment = node.parentNode.parentNode;
			container.innerHTML = '<pre><code class="' + className + '">' + text + '</code></pre>';
			environment.replaceChild(container.firstChild, node.parentNode);
		}else{
			node.className = className;
			node.innerHTML = text;
		}
	}
	function highlightStringLanguage(lang, str){
		var highlight = new Highlighter(lang, str);
		return {result:highlight.result, langName:lang, partialResult:highlight.partialResult};
	}

	function highlightLanguage(block, lang){
		var result = highlightStringLanguage(lang, blockText(block));
		replaceText(block, block.className, result.result);
	}

	function highlightStringAuto(str){
		var result = "", langName = "", bestRelevance = 2,
			textBlock = str;
		for(var key in dh.languages){
			if(!dh.languages[key].defaultMode){ continue; }	// skip internal members
			var highlight = new Highlighter(key, textBlock),
				relevance = highlight.keywordCount + highlight.relevance, relevanceMax = 0;
			if(!result || relevance > relevanceMax){
				relevanceMax = relevance;
				result = highlight.result;
				langName = highlight.langName;
			}
		}
		return {result:result, langName:langName};
	}
	
	function highlightAuto(block){
		var result = highlightStringAuto(blockText(block));
		if(result.result){
			replaceText(block, result.langName, result.result);
		}
	}
	
	// the public API

	dojox.highlight.processString = function(/* String */ str, /* String? */lang){
		// summary: highlight a string of text
		// returns: Object containing:
		//         result - string of html with spans to apply formatting
		//         partialResult - if the formating failed: string of html
		//                 up to the point of the failure, otherwise: undefined
		//         langName - the language used to do the formatting
		return lang ? highlightStringLanguage(lang, str) : highlightStringAuto(str);
	};

	dojox.highlight.init = function(/* String|DomNode */ node){
		//	summary: Highlight a passed node
		//
		//	description:
		//
		//		Syntax highlight a passed DomNode or String ID of a DomNode
		//
		//
		//	example:
		//	|	dojox.highlight.init("someId");
		//
		node = dojo.byId(node);
		if(dojo.hasClass(node, "no-highlight")){ return; }
		if(!verifyText(node)){ return; }
	
		var classes = node.className.split(/\s+/),
			flag = dojo.some(classes, function(className){
				if(className.charAt(0) != "_" && dh.languages[className]){
					highlightLanguage(node, className);
					return true;	// stop iterations
				}
				return false;	// continue iterations
			});
		if(!flag){
			highlightAuto(node);
		}
	};

/*=====
	dojox.highlight.Code = function(props, node){
		//	summary: A Class object to allow for dojoType usage with the highlight engine. This is
		//		NOT a Widget in the conventional sense, and does not have any member functions for
		//		the instance. This is provided as a convenience. You likely should be calling
		//		`dojox.highlight.init` directly.
		//
		//	props: Object?
		//		Unused. Pass 'null' or {}. Positional usage to allow `dojo.parser` to instantiate
		//		this class as other Widgets would be.
		//
		//	node: String|DomNode
		//		A String ID or DomNode reference to use as the root node of this instance.
		//
		//	example:
		//	|	<pre><code dojoType="dojox.highlight.Code">for(var i in obj){ ... }</code></pre>
		//
		//	example:
		//	|	var inst = new dojox.highlight.Code({}, "someId");
		//
		this.node = dojo.byId(node);
	};
=====*/

	dh.Code = function(props, node){ dh.init(node); };

	return dh;

});

},
'dojox/highlight/languages/javascript':function(){
define("dojox/highlight/languages/javascript", ["dojox/main", "../_base"], function(dojox){

	var dh = dojox.highlight, dhc = dh.constants;
	dh.languages.javascript = {
		defaultMode: {
			lexems: [dhc.UNDERSCORE_IDENT_RE],
			contains: ['string', 'comment', 'number', 'regexp', 'function'],
			keywords: {
				'keyword': {
					'in': 1, 'if': 1, 'for': 1, 'while': 1, 'finally': 1, 'var': 1,
					'new': 1, 'function': 1, 'do': 1, 'return': 1, 'void': 1,
					'else': 1, 'break': 1, 'catch': 1, 'instanceof': 1, 'with': 1,
					'throw': 1, 'case': 1, 'default': 1, 'try': 1, 'this': 1,
					'switch': 1, 'continue': 1, 'typeof': 1, 'delete': 1
				},
				'literal': {'true': 1, 'false': 1, 'null': 1}
			}
		},
		modes: [
			dhc.C_LINE_COMMENT_MODE,
			dhc.C_BLOCK_COMMENT_MODE,
			dhc.C_NUMBER_MODE,
			dhc.APOS_STRING_MODE,
			dhc.QUOTE_STRING_MODE,
			dhc.BACKSLASH_ESCAPE,
			{
				className: 'regexp',
				begin: '/.*?[^\\\\/]/[gim]*', end: '^'
			},
			{
				className: 'function',
				begin: 'function\\b', end: '{',
				lexems: [dhc.UNDERSCORE_IDENT_RE],
				keywords: {'function': 1},
				contains: ['title', 'params']
			},
			{
				className: 'title',
				begin: dhc.UNDERSCORE_IDENT_RE, end: '^'
			},
			{
				className: 'params',
				begin: '\\(', end: '\\)',
				contains: ['string', 'comment']
			}
		]
	};

	return dh.languages.javascript;
});

},
'dojox/highlight/languages/xquery':function(){
define("dojox/highlight/languages/xquery", ["dojox/main", "../_base"], function(dojox){

	// Very simple XQuery language file.  Would be nice
	// to eventually handle more of the enclosed expressions
	// and direct XML element construction

	var XQUERY_COMMENT = {
		className: 'comment',
		begin: '\\(\\:', end: '\\:\\)'
	};

	var XQUERY_KEYWORDS = {
		// From section A2.2 of the XQuery 1.0 specification
		'ancestor': 1, 'ancestor-or-self': 1, 'and' : 1,
		'as': 1, 'ascending': 1, 'at': 1, 'attribute': 1,
		'base-uri': 1, 'boundary-space': 1, 'by': 1, 'case': 1,
		'cast': 1, 'castable': 1, 'child': 1, 'collation': 1,
		'comment': 1, 'construction': 1, 'copy-namespaces': 1,
		'declare': 1, 'default': 1, 'descendant': 1, 'descendant-or-self': 1,
		'descending': 1, 'div': 1, 'document': 1, 'document-node': 1,
		'element': 1, 'else': 1, 'empty': 1, 'empty-sequence': 1,
		'encoding': 1, 'eq': 1, 'every': 1, 'except': 1, 'external': 1,
		'following': 1, 'following-sibling': 1, 'for': 1, 'function': 1,
		'ge': 1, 'greatest': 1, 'gt': 1, 'idiv': 1, 'if': 1, 'import': 1,
		'in': 1, 'inherit': 1, 'instance': 1, 'intersect': 1, 'is': 1,
		'item': 1, 'lax': 1, 'le': 1, 'least': 1, 'let': 1, 'lt': 1,
		'mod': 1, 'module': 1, 'namespace': 1, 'ne': 1, 'node': 1,
		'no-inherit': 1, 'no-preserve': 1, 'of': 1, 'option': 1, 'or': 1,
		'order': 1, 'ordered': 1, 'ordering': 1, 'parent': 1,
		'preceding': 1, 'preceding-sibling': 1, 'preserve': 1,
		'processing-instruction': 1, 'return': 1, 'satisfies': 1,
		'schema': 1, 'schema-attribute': 1, 'schema-element': 1,
		'self': 1, 'some': 1, 'stable': 1, 'strict': 1, 'strip': 1,
		'text': 1, 'then': 1, 'to': 1, 'treat': 1, 'typeswitch': 1,
		'union': 1, 'unordered': 1, 'validate': 1, 'variable': 1,
		'version': 1, 'where': 1, 'xquery': 1
	};

	var dh = dojox.highlight, dhc = dh.constants;
	dh.languages.xquery = {
		case_insensitive: true,
			defaultMode: {
				lexems: [dhc.IDENT_RE],
				contains: ['string', 'number', 'comment'],
				keywords: {
					'keyword': XQUERY_KEYWORDS
				}
		},
		modes: [
				XQUERY_COMMENT
		],
		XQUERY_COMMENT: XQUERY_COMMENT
	};

	return dh.languages.xquery;
});

},
'dojox/highlight/languages/html':function(){
define("dojox/highlight/languages/html", ["dojox/main", "../_base", "./xml"], function(dojox){

	var HTML_TAGS = {
		'code': 1, 'kbd': 1, 'font': 1, 'noscript': 1, 'style': 1, 'img': 1,
		'title': 1, 'menu': 1, 'tt': 1, 'tr': 1, 'param': 1, 'li': 1, 'tfoot': 1,
		'th': 1, 'input': 1, 'td': 1, 'dl': 1, 'blockquote': 1, 'fieldset': 1,
		'big': 1, 'dd': 1, 'abbr': 1, 'optgroup': 1, 'dt': 1, 'button': 1,
		'isindex': 1, 'p': 1, 'small': 1, 'div': 1, 'dir': 1, 'em': 1, 'frame': 1,
		'meta': 1, 'sub': 1, 'bdo': 1, 'label': 1, 'acronym': 1, 'sup': 1,
		'body': 1, 'xml': 1, 'basefont': 1, 'base': 1, 'br': 1, 'address': 1,
		'strong': 1, 'legend': 1, 'ol': 1, 'script': 1, 'caption': 1, 's': 1,
		'col': 1, 'h2': 1, 'h3': 1, 'h1': 1, 'h6': 1, 'h4': 1, 'h5': 1, 'table': 1,
		'select': 1, 'noframes': 1, 'span': 1, 'area': 1, 'dfn': 1, 'strike': 1,
		'cite': 1, 'thead': 1, 'head': 1, 'option': 1, 'form': 1, 'hr': 1,
		'var': 1, 'link': 1, 'b': 1, 'colgroup': 1, 'ul': 1, 'applet': 1, 'del': 1,
		'iframe': 1, 'pre': 1, 'frameset': 1, 'ins': 1, 'tbody': 1, 'html': 1,
		'samp': 1, 'map': 1, 'object': 1, 'a': 1, 'xmlns': 1, 'center': 1,
		'textarea': 1, 'i': 1, 'q': 1, 'u': 1
	};
	var HTML_DOCTYPE = {
		className: 'doctype',
		begin: '<!DOCTYPE', end: '>',
		relevance: 10
	};
	var HTML_ATTR = {
		className: 'attribute',
		begin: ' [a-zA-Z]+', end: '^'
	};
	var HTML_VALUE = {
		className: 'value',
		begin: '[a-zA-Z0-9]+', end: '^'
	};

	var dh = dojox.highlight, dhc = dh.constants, dhl = dh.languages, x = dhl.xml;
	dhl.html = {
		defaultMode: {
			contains: ['tag', 'comment', 'doctype']
		},
		case_insensitive: true,
		modes: [
			x.XML_COMMENT,
			HTML_DOCTYPE,
			{
				className: 'tag',
				lexems: [dhc.IDENT_RE],
				keywords: HTML_TAGS,
				begin: '<[A-Za-z/]', end: '>',
				contains: ['attribute'],
				illegal: '[\\+\\.]'
			},
			x.XML_ATTR,
			HTML_ATTR,
			x.XML_VALUE,
			HTML_VALUE
		],
		// exporting constants
		HTML_TAGS: HTML_TAGS,
		HTML_DOCTYPE: HTML_DOCTYPE,
		HTML_ATTR: HTML_ATTR,
		HTML_VALUE: HTML_VALUE
	};

	return dhl.html;
	
});

},
'dojox/highlight/languages/_www':function(){
define("dojox/highlight/languages/_www", ["./xml", "./html", "./css", "./django", "./javascript"], function(){ });

},
'dojox/highlight/languages/css':function(){
define("dojox/highlight/languages/css", ["dojox/main", "../_base", "./html"], function(dojox, dh, html){
	
	var dhc = dh.constants;
	return dh.languages.css = {
		// summary: CSS Language definition file. 
		defaultMode: {
			contains: ['id', 'class', 'attr_selector', 'rules', 'comment'],
			keywords: html.HTML_TAGS,
			lexems: [dhc.IDENT_RE],
			illegal: '='
		},
		case_insensitive: true,
		modes: [
			{
				className: 'id',
				begin: '\\#[A-Za-z0-9_-]+', end: '^'
			},
			{
				className: 'class',
				begin: '\\.[A-Za-z0-9_-]+', end: '^',
				relevance: 0
			},
			{
				className: 'attr_selector',
				begin: '\\[', end: '\\]',
				illegal: '$'
			},
			{
				className: 'rules',
				begin: '{', end: '}',
				lexems: ['[A-Za-z-]+'],
				keywords: {
					'play-during': 1, 'counter-reset': 1,
					'counter-increment': 1, 'min-height': 1, 'quotes': 1,
					'border-top': 1, 'pitch': 1, 'font': 1, 'pause': 1,
					'list-style-image': 1, 'border-width': 1, 'cue': 1,
					'outline-width': 1, 'border-left': 1, 'elevation': 1,
					'richness': 1, 'speech-rate': 1, 'border-bottom': 1,
					'border-spacing': 1, 'background': 1, 'list-style-type': 1,
					'text-align': 1, 'page-break-inside': 1, 'orphans': 1,
					'page-break-before': 1, 'text-transform': 1,
					'line-height': 1, 'padding-left': 1, 'font-size': 1,
					'right': 1, 'word-spacing': 1, 'padding-top': 1,
					'outline-style': 1, 'bottom': 1, 'content': 1,
					'border-right-style': 1, 'padding-right': 1,
					'border-left-style': 1, 'voice-family': 1,
					'background-color': 1, 'border-bottom-color': 1,
					'outline-color': 1, 'unicode-bidi': 1, 'max-width': 1,
					'font-family': 1, 'caption-side': 1,
					'border-right-width': 1, 'pause-before': 1,
					'border-top-style': 1, 'color': 1, 'border-collapse': 1,
					'border-bottom-width': 1, 'float': 1, 'height': 1,
					'max-height': 1, 'margin-right': 1, 'border-top-width': 1,
					'speak': 1, 'speak-header': 1, 'top': 1, 'cue-before': 1,
					'min-width': 1, 'width': 1, 'font-variant': 1,
					'border-top-color': 1, 'background-position': 1,
					'empty-cells': 1, 'direction': 1, 'border-right': 1,
					'visibility': 1, 'padding': 1, 'border-style': 1,
					'background-attachment': 1, 'overflow': 1,
					'border-bottom-style': 1, 'cursor': 1, 'margin': 1,
					'display': 1, 'border-left-width': 1, 'letter-spacing': 1,
					'vertical-align': 1, 'clip': 1, 'border-color': 1,
					'list-style': 1, 'padding-bottom': 1, 'pause-after': 1,
					'speak-numeral': 1, 'margin-left': 1, 'widows': 1,
					'border': 1, 'font-style': 1, 'border-left-color': 1,
					'pitch-range': 1, 'background-repeat': 1,
					'table-layout': 1, 'margin-bottom': 1,
					'speak-punctuation': 1, 'font-weight': 1,
					'border-right-color': 1, 'page-break-after': 1,
					'position': 1, 'white-space': 1, 'text-indent': 1,
					'background-image': 1, 'volume': 1, 'stress': 1,
					'outline': 1, 'clear': 1, 'z-index': 1,
					'text-decoration': 1, 'margin-top': 1, 'azimuth': 1,
					'cue-after': 1, 'left': 1, 'list-style-position': 1
				},
				contains: ['comment', 'value']
			},
			dhc.C_BLOCK_COMMENT_MODE,
			{
				className: 'value',
				begin: ':',
				end: ';',
				endsWithParent: true,
				excludeBegin: true,
				excludeEnd: true
			}
		]
	};
});

},
'dojox/highlight/languages/_dynamic':function(){
define("dojox/highlight/languages/_dynamic", ["./python", "./xquery", "./groovy"], function(){});

},
'dijit/_Templated':function(){
define("dijit/_Templated", [
	"./_WidgetBase",
	"./_TemplatedMixin",
	"./_WidgetsInTemplateMixin",
	"dojo/_base/array", // array.forEach
	"dojo/_base/declare", // declare
	"dojo/_base/lang", // lang.extend lang.isArray
	"dojo/_base/kernel" // kernel.deprecated
], function(_WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin, array, declare, lang, kernel){

/*=====
	var _WidgetBase = dijit._WidgetBase;
	var _TemplatedMixin = dijit._TemplatedMixin;
	var _WidgetsInTemplateMixin = dijit._WidgetsInTemplateMixin;
=====*/

	// module:
	//		dijit/_Templated
	// summary:
	//		Deprecated mixin for widgets that are instantiated from a template.

	// These arguments can be specified for widgets which are used in templates.
	// Since any widget can be specified as sub widgets in template, mix it
	// into the base widget class.  (This is a hack, but it's effective.)
	lang.extend(_WidgetBase, {
		waiRole: "",
		waiState:""
	});

	return declare("dijit._Templated", [_TemplatedMixin, _WidgetsInTemplateMixin], {
		// summary:
		//		Deprecated mixin for widgets that are instantiated from a template.
		//		Widgets should use _TemplatedMixin plus if necessary _WidgetsInTemplateMixin instead.

		// widgetsInTemplate: [protected] Boolean
		//		Should we parse the template to find widgets that might be
		//		declared in markup inside it?  False by default.
		widgetsInTemplate: false,

		constructor: function(){
			kernel.deprecated(this.declaredClass + ": dijit._Templated deprecated, use dijit._TemplatedMixin and if necessary dijit._WidgetsInTemplateMixin", "", "2.0");
		},

		_attachTemplateNodes: function(rootNode, getAttrFunc){

			this.inherited(arguments);

			// Do deprecated waiRole and waiState
			var nodes = lang.isArray(rootNode) ? rootNode : (rootNode.all || rootNode.getElementsByTagName("*"));
			var x = lang.isArray(rootNode) ? 0 : -1;
			for(; x<nodes.length; x++){
				var baseNode = (x == -1) ? rootNode : nodes[x];

				// waiRole, waiState
				var role = getAttrFunc(baseNode, "waiRole");
				if(role){
					baseNode.setAttribute("role", role);
				}
				var values = getAttrFunc(baseNode, "waiState");
				if(values){
					array.forEach(values.split(/\s*,\s*/), function(stateValue){
						if(stateValue.indexOf('-') != -1){
							var pair = stateValue.split('-');
							baseNode.setAttribute("aria-"+pair[0], pair[1]);
						}
					});
				}
			}
		}
	});
});

},
'dojox/highlight':function(){
define("dojox/highlight", ["./highlight/_base"], function(highlight){
	return highlight;
});

},
'dojox/highlight/languages/python':function(){
define("dojox/highlight/languages/python", ["dojox/main", "../_base"], function(dojox){

	var dh = dojox.highlight, dhc = dh.constants;
	dh.languages.python = {
		// summary: Python highlight definitions
		defaultMode: {
			lexems: [dhc.UNDERSCORE_IDENT_RE],
			illegal: '(</|->)',
			contains: ['comment', 'string', 'function', 'class', 'number', 'decorator'],
			keywords: {'and': 1, 'elif': 1, 'is': 1, 'global': 1, 'as': 1, 'in': 1, 'if': 1,
				'from': 1, 'raise': 1, 'for': 1, 'except': 1, 'finally': 1, 'print': 1,
				'import': 1, 'pass': 1, 'None': 1, 'return': 1, 'exec': 1, 'else': 1,
				'break': 1, 'not': 1, 'with': 1, 'class': 1, 'assert': 1, 'yield': 1,
				'try': 1, 'while': 1, 'continue': 1, 'del': 1, 'or': 1, 'def': 1, 'lambda': 1
			}
		},
		modes: [
			{
				className: 'function',
				lexems: [dhc.UNDERSCORE_IDENT_RE],
				begin: '\\bdef ', end: ':',
				illegal: '$',
				keywords: {'def': 1},
				contains: ['title', 'params'],
				relevance: 10
			},
			{
				className: 'class',
				lexems: [dhc.UNDERSCORE_IDENT_RE],
				begin: '\\bclass ', end: ':',
				illegal: '[${]',
				keywords: {'class': 1},
				contains: ['title', 'params'],
				relevance: 10
			},
			{
				className: 'title',
				begin: dhc.UNDERSCORE_IDENT_RE, end: '^'
			},
			{
				className: 'params',
				begin: '\\(', end: '\\)',
				contains: ['string']
			},
			dhc.HASH_COMMENT_MODE,
			dhc.C_NUMBER_MODE,
			{
				className: 'string',
				begin: '\'\'\'', end: '\'\'\'',
				relevance: 10
			},
			{
				className: 'string',
				begin: '"""', end: '"""',
				relevance: 10
			},
			dhc.APOS_STRING_MODE,
			dhc.QUOTE_STRING_MODE,
			dhc.BACKSLASH_ESCAPE,
			{
				className: 'string',
				begin: 'r\'', end: '\'',
				relevance: 10
			},
			{
				className: 'string',
				begin: 'r"', end: '"',
				relevance: 10
			},
			{
				className: 'string',
				begin: 'u\'', end: '(^|[^\\\\])\'',
				relevance: 10
			},
			{
				className: 'string',
				begin: 'u"', end: '(^|[^\\\\])"',
				relevance: 10
			},
			{
				className: 'string',
				begin: 'ur\'', end: '\'',
				relevance: 10
			},
			{
				className: 'string',
				begin: 'ur"', end: '"',
				relevance: 10
			},
			{
				className: 'decorator',
				begin: '@', end: '$'
			}
		]
	};

	return dh.languages.python;
});

},
'dojox/highlight/languages/_static':function(){
define("dojox/highlight/languages/_static", ["./cpp", "./java", "./delphi"], function(){
	
});

},
'dojox/highlight/widget/Code':function(){
define("dojox/highlight/widget/Code", ["dojo", "dijit", "dijit/_Widget", "dijit/_Templated", "dojox/highlight"], function(dojo, dijit){

	dojo.declare("dojox.highlight.widget.Code",[dijit._Widget, dijit._Templated],{
		// summary:
		//		A simple source code formatting widget that adds line numbering, alternating line colors
		//		and line range support on top of dojox.highlight module.

		url: "",
		range:null,
		style:"",
		listType:"1",
		lang:"",

		// Note: If more control over formatting is required, the order list items can be replaced
		// with a table implementation instead... Excercise is left for those that need it...
		templateString:
			'<div class="formatted" style="${style}">'+
				'<div class="titleBar"></div>'+
				'<ol type="${listType}" dojoAttachPoint="codeList" class="numbers"></ol>' +
				'<div style="display:none" dojoAttachPoint="containerNode"></div>' +
			'</div>',
	
		postCreate: function(){
			this.inherited(arguments);
			if(this.url){
				// load from a url
				dojo.xhrGet({
					url: this.url,
					// then poopulate:
					load: dojo.hitch(this,"_populate"),
					error: dojo.hitch(this,"_loadError")
				});
			}else{
				// or just populate from our internal content
				this._populate(this.containerNode.innerHTML);
			}
		},
	
		_populate: function(data){
			// put the content in a common node
			this.containerNode.innerHTML =
				"<pre><code class='" + this.lang + "'>" +
					data.replace(/\</g,"&lt;") +
				"</code></pre>";
			// highlight it
			dojo.query("pre > code",this.containerNode).forEach(dojox.highlight.init);
			// FIXME: in ie7, the innerHTML in a real <pre> isn't split by \n's ?
			// split the content into lines
			var lines = this.containerNode.innerHTML.split("\n");
			dojo.forEach(lines,function(line,i){
				// setup all the lines of the content as <li>'s
				var li = dojo.doc.createElement('li');
				// add some style sugar:
				dojo.addClass(li, (i % 2 !== 0 ? "even" : "odd"));
				line = "<pre><code>" + line + "&nbsp;</code></pre>";
				line = line.replace(/\t/g," &nbsp; ");
				li.innerHTML = line;
				this.codeList.appendChild(li);
			},this);
			// save our data
			this._lines = dojo.query("li",this.codeList);
			this._updateView();
		},
	
		// FIXME: user _setRangeAttr pattern? so you can code.set('range', [1, 100]);
		setRange: function(/* Array */range){
			// summary: update the view to a new passed range
			if(dojo.isArray(range)){
				this.range = range;
				this._updateView();
			}
		},
	
		_updateView: function(){
			// summary: set the list to the current range
			if(this.range){
				var r = this.range;
				this._lines
					// hide them all
					.style({ display:"none" })
					.filter(function(n,i){
						// remove nodes out of range
						return (i + 1 >= r[0] && i + 1 <= r[1]);
					})
					// set them visible again
					.style({ display:"" })
				;
				// set the "start" attribute on the OL so numbering works
				dojo.attr(this.codeList,"start",r[0]);
			}
		},
	
		_loadError: function(error){
			// summary: a generic error handler for the url=""
			console.warn("loading: ", this.url, " FAILED", error);
		}

	});

});
},
'url:dijit/templates/MenuBarItem.html':"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\n\t<span data-dojo-attach-point=\"containerNode\"></span>\n</div>\n",
'dijit/MenuBar':function(){
require({cache:{
'url:dijit/templates/MenuBar.html':"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\"  role=\"menubar\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress: _onKeyPress\"></div>\n"}});
define("dijit/MenuBar", [
	"dojo/_base/declare", // declare
	"dojo/_base/event", // event.stop
	"dojo/keys", // keys.DOWN_ARROW
	"./_MenuBase",
	"dojo/text!./templates/MenuBar.html"
], function(declare, event, keys, _MenuBase, template){

/*=====
	var _MenuBase = dijit._MenuBase;
=====*/

// module:
//		dijit/MenuBar
// summary:
//		A menu bar, listing menu choices horizontally, like the "File" menu in most desktop applications

return declare("dijit.MenuBar", _MenuBase, {
	// summary:
	//		A menu bar, listing menu choices horizontally, like the "File" menu in most desktop applications

	templateString: template,

	baseClass: "dijitMenuBar",

	// _isMenuBar: [protected] Boolean
	//		This is a MenuBar widget, not a (vertical) Menu widget.
	_isMenuBar: true,

	postCreate: function(){
		var l = this.isLeftToRight();
		this.connectKeyNavHandlers(
			l ? [keys.LEFT_ARROW] : [keys.RIGHT_ARROW],
			l ? [keys.RIGHT_ARROW] : [keys.LEFT_ARROW]
		);

		// parameter to dijit.popup.open() about where to put popup (relative to this.domNode)
		this._orient = ["below"];
	},

	focusChild: function(item){
		// overload focusChild so that whenever the focus is moved to a new item,
		// check the previous focused whether it has its popup open, if so, after
		// focusing the new item, open its submenu immediately
		var prev_item = this.focusedChild,
			showpopup = prev_item && prev_item.popup && prev_item.popup.isShowingNow;
		this.inherited(arguments);
		if(showpopup && item.popup && !item.disabled){
			this._openPopup();		// TODO: on down arrow, _openPopup() is called here and in onItemClick()
		}
	},

	_onKeyPress: function(/*Event*/ evt){
		// summary:
		//		Handle keyboard based menu navigation.
		// tags:
		//		protected

		if(evt.ctrlKey || evt.altKey){ return; }

		switch(evt.charOrCode){
			case keys.DOWN_ARROW:
				this._moveToPopup(evt);
				event.stop(evt);
		}
	},

	onItemClick: function(/*dijit._Widget*/ item, /*Event*/ evt){
		// summary:
		//		Handle clicks on an item. Cancels a dropdown if already open.
		// tags:
		//		private
		if(item.popup && item.popup.isShowingNow){
			item.popup.onCancel();
		}else{
			this.inherited(arguments);
		}
	}
});

});

},
'dojox/highlight/languages/_all':function(){
define("dojox/highlight/languages/_all", ["./_static", "./_dynamic", "./_www"], function(){})


}}});

require(["dojo/i18n"], function(i18n){
i18n._preloadLocalizations("bf/nls/featureExplorer", []);
});
define("bf/featureExplorer", [], 1);
