//>>built
define("dojox/charting/Chart",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/html","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/_base/sniff","./Element","./Theme","./Series","./axis2d/common","dojox/gfx","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(t,g,z,m,A,k,u,v,w,l,B,C,D,j,d){function x(a,b){if(a&&b)a.min=Math.min(a.min,b.min),a.max=Math.max(a.max,b.max);return a||b}function n(a,b){var c=
{},f={};g.forEach(a,function(a){var b=c[a.name]=a.getSeriesStats();a.hAxis&&(f[a.hAxis]=x(f[a.hAxis],{min:b.hmin,max:b.hmax}));a.vAxis&&(f[a.vAxis]=x(f[a.vAxis],{min:b.vmin,max:b.vmax}))});g.forEach(a,function(a){var h=c[a.name];if(a.hAxis){var d=f[a.hAxis];h.hmin=d.min;h.hmax=d.max}if(a.vAxis)d=f[a.vAxis],h.vmin=d.min,h.vmax=d.max;a.initializeScalers(b,h)})}var i=dojox.charting,o=d.lambda("item.clear()"),p=d.lambda("item.purgeGroup()"),q=d.lambda("item.destroy()"),r=d.lambda("item.dirty = false"),
s=d.lambda("item.dirty = true"),y=d.lambda("item.name");z("dojox.charting.Chart",null,{constructor:function(a,b){b||(b={});this.margins=b.margins?b.margins:{l:10,t:10,r:10,b:10};this.stroke=b.stroke;this.fill=b.fill;this.delayInMs=b.delayInMs||200;this.title=b.title;this.titleGap=b.titleGap;this.titlePos=b.titlePos;this.titleFont=b.titleFont;this.titleFontColor=b.titleFontColor;this.theme=this.chartTitle=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=!0;this.coords=
null;this.node=A.byId(a);var c=k.getMarginBox(a);this.surface=j.createSurface(this.node,c.w||400,c.h||300)},destroy:function(){g.forEach(this.series,q);g.forEach(this.stack,q);d.forIn(this.axes,q);this.chartTitle&&this.chartTitle.tagName&&u.destroy(this.chartTitle);this.surface.destroy()},getCoords:function(){return m.coords(this.node,!0)},setTheme:function(a){this.theme=a.clone();this.dirty=!0;return this},addAxis:function(a,b){var c;c=b&&b.type||"Default";if(typeof c=="string"){if(!i.axis2d||!i.axis2d[c])throw Error("Can't find axis: "+
c+" - Check require() dependencies.");c=new i.axis2d[c](this,b)}else c=new c(this,b);c.name=a;c.dirty=!0;a in this.axes&&this.axes[a].destroy();this.axes[a]=c;this.dirty=!0;return this},getAxis:function(a){return this.axes[a]},removeAxis:function(a){if(a in this.axes)this.axes[a].destroy(),delete this.axes[a],this.dirty=!0;return this},addPlot:function(a,b){var c;c=b&&b.type||"Default";if(typeof c=="string"){if(!i.plot2d||!i.plot2d[c])throw Error("Can't find plot: "+c+" - didn't you forget to dojo.require() it?");
c=new i.plot2d[c](this,b)}else c=new c(this,b);c.name=a;c.dirty=!0;a in this.plots?(this.stack[this.plots[a]].destroy(),this.stack[this.plots[a]]=c):(this.plots[a]=this.stack.length,this.stack.push(c));this.dirty=!0;return this},getPlot:function(a){return this.stack[this.plots[a]]},removePlot:function(a){if(a in this.plots){var b=this.plots[a];delete this.plots[a];this.stack[b].destroy();this.stack.splice(b,1);d.forIn(this.plots,function(a,c,d){a>b&&(d[c]=a-1)});var c=g.filter(this.series,function(b){return b.plot!=
a});if(c.length<this.series.length)g.forEach(this.series,function(b){b.plot==a&&b.destroy()}),this.runs={},g.forEach(c,function(a,b){this.runs[a.plot]=b},this),this.series=c;this.dirty=!0}return this},getPlotOrder:function(){return d.map(this.stack,y)},setPlotOrder:function(a){var b={},c=d.filter(a,function(a){if(!(a in this.plots)||a in b)return!1;b[a]=1;return!0},this);c.length<this.stack.length&&d.forEach(this.stack,function(a){a=a.name;a in b||c.push(a)});a=d.map(c,function(a){return this.stack[this.plots[a]]},
this);d.forEach(a,function(a,b){this.plots[a.name]=b},this);this.stack=a;this.dirty=!0;return this},movePlotToFront:function(a){if(a in this.plots){var b=this.plots[a];if(b){var c=this.getPlotOrder();c.splice(b,1);c.unshift(a);return this.setPlotOrder(c)}}return this},movePlotToBack:function(a){if(a in this.plots){var b=this.plots[a];if(b<this.stack.length-1){var c=this.getPlotOrder();c.splice(b,1);c.push(a);return this.setPlotOrder(c)}}return this},addSeries:function(a,b,c){b=new C(this,b,c);b.name=
a;a in this.runs?(this.series[this.runs[a]].destroy(),this.series[this.runs[a]]=b):(this.runs[a]=this.series.length,this.series.push(b));this.dirty=!0;if(!("ymin"in b)&&"min"in b)b.ymin=b.min;if(!("ymax"in b)&&"max"in b)b.ymax=b.max;return this},getSeries:function(a){return this.series[this.runs[a]]},removeSeries:function(a){if(a in this.runs){var b=this.runs[a];delete this.runs[a];this.series[b].destroy();this.series.splice(b,1);d.forIn(this.runs,function(a,f,e){a>b&&(e[f]=a-1)});this.dirty=!0}return this},
updateSeries:function(a,b){if(a in this.runs){var c=this.series[this.runs[a]];c.update(b);this._invalidateDependentPlots(c.plot,!1);this._invalidateDependentPlots(c.plot,!0)}return this},getSeriesOrder:function(a){return d.map(d.filter(this.series,function(b){return b.plot==a}),y)},setSeriesOrder:function(a){var b,c={},f=d.filter(a,function(a){if(!(a in this.runs)||a in c)return!1;var f=this.series[this.runs[a]];if(b){if(f.plot!=b)return!1}else b=f.plot;c[a]=1;return!0},this);d.forEach(this.series,
function(a){var d=a.name;!(d in c)&&a.plot==b&&f.push(d)});this.series=d.map(f,function(a){return this.series[this.runs[a]]},this).concat(d.filter(this.series,function(a){return a.plot!=b}));d.forEach(this.series,function(a,b){this.runs[a.name]=b},this);this.dirty=!0;return this},moveSeriesToFront:function(a){if(a in this.runs){var b=this.runs[a],c=this.getSeriesOrder(this.series[b].plot);if(a!=c[0])return c.splice(b,1),c.unshift(a),this.setSeriesOrder(c)}return this},moveSeriesToBack:function(a){if(a in
this.runs){var b=this.runs[a],c=this.getSeriesOrder(this.series[b].plot);if(a!=c[c.length-1])return c.splice(b,1),c.push(a),this.setSeriesOrder(c)}return this},resize:function(a,b){var c;switch(arguments.length){case 1:c=t.mixin({},a);k.setMarginBox(this.node,c);break;case 2:c={w:a,h:b},k.setMarginBox(this.node,c)}c=k.getMarginBox(this.node);var f=this.surface.getDimensions();return f.width!=c.w||f.height!=c.h?(this.surface.setDimensions(c.w,c.h),this.dirty=!0,this.render()):this},getGeometry:function(){var a=
{};d.forIn(this.axes,function(b){b.initialized()&&(a[b.name]={name:b.name,vertical:b.vertical,scaler:b.scaler,ticks:b.ticks})});return a},setAxisWindow:function(a,b,c,f){var d=this.axes[a];d&&(d.setWindow(b,c),g.forEach(this.stack,function(b){if(b.hAxis==a||b.vAxis==a)b.zoom=f}));return this},setWindow:function(a,b,c,f,e){"plotArea"in this||this.calculateGeometry();d.forIn(this.axes,function(d){var e,g;e=d.getScaler().bounds;g=e.span/(e.upper-e.lower);d.vertical?(e=b,g=f/g/e):(e=a,g=c/g/e);d.setWindow(e,
g)});g.forEach(this.stack,function(a){a.zoom=e});return this},zoomIn:function(a,b){var c=this.axes[a];if(c){var c=c.getScaler().bounds,f=Math.min(b[0],b[1]),d=Math.max(b[0],b[1]),f=b[0]<c.lower?c.lower:f,d=b[1]>c.upper?c.upper:d;this.setAxisWindow(a,(c.upper-c.lower)/(d-f),f-c.lower);this.render()}},calculateGeometry:function(){if(this.dirty)return this.fullGeometry();var a=g.filter(this.stack,function(a){return a.dirty||a.hAxis&&this.axes[a.hAxis].dirty||a.vAxis&&this.axes[a.vAxis].dirty},this);
n(a,this.plotArea);return this},fullGeometry:function(){this._makeDirty();g.forEach(this.stack,o);this.theme||this.setTheme(new B(dojox.charting._def));g.forEach(this.series,function(a){if(!(a.plot in this.plots)){if(!i.plot2d||!i.plot2d.Default)throw Error("Can't find plot: Default - didn't you forget to dojo.require() it?");var b=new i.plot2d.Default(this,{});b.name=a.plot;this.plots[a.plot]=this.stack.length;this.stack.push(b)}this.stack[this.plots[a.plot]].addSeries(a)},this);g.forEach(this.stack,
function(a){a.hAxis&&a.setAxis(this.axes[a.hAxis]);a.vAxis&&a.setAxis(this.axes[a.vAxis])},this);var a=this.dim=this.surface.getDimensions();a.width=j.normalizedLength(a.width);a.height=j.normalizedLength(a.height);d.forIn(this.axes,o);n(this.stack,a);var b=this.offsets={l:0,r:0,t:0,b:0};d.forIn(this.axes,function(a){d.forIn(a.getOffsets(),function(a,c){b[c]+=a})});if(this.title){this.titleGap=this.titleGap==0?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||
"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var c=j.normalizedLength(j.splitFontString(this.titleFont).size);b[this.titlePos=="top"?"t":"b"]+=c+this.titleGap}d.forIn(this.margins,function(a,c){b[c]+=a});this.plotArea={width:a.width-b.l-b.r,height:a.height-b.t-b.b};d.forIn(this.axes,o);n(this.stack,this.plotArea);return this},render:function(){this.theme&&this.theme.clear();if(this.dirty)return this.fullRender();
this.calculateGeometry();d.forEachRev(this.stack,function(a){a.render(this.dim,this.offsets)},this);d.forIn(this.axes,function(a){a.render(this.dim,this.offsets)},this);this._makeClean();this.surface.render&&this.surface.render();return this},fullRender:function(){this.fullGeometry();var a=this.offsets,b=this.dim,c;g.forEach(this.series,p);d.forIn(this.axes,p);g.forEach(this.stack,p);this.chartTitle&&this.chartTitle.tagName&&u.destroy(this.chartTitle);this.surface.clear();this.chartTitle=null;var f=
this.theme,e=f.plotarea&&f.plotarea.fill,h=f.plotarea&&f.plotarea.stroke,i=Math.max(0,b.width-a.l-a.r),k=Math.max(0,b.height-a.t-a.b);c={x:a.l-1,y:a.t-1,width:i+2,height:k+2};e&&(e=l.prototype._shapeFill(l.prototype._plotFill(e,b,a),c),this.surface.createRect(c).setFill(e));h&&this.surface.createRect({x:a.l,y:a.t,width:i+1,height:k+1}).setStroke(h);d.foldr(this.stack,function(c,d){return d.render(b,a),0},0);e=this.fill!==void 0?this.fill:f.chart&&f.chart.fill;h=this.stroke!==void 0?this.stroke:f.chart&&
f.chart.stroke;if(e=="inherit"){c=this.node;for(e=new v(m.style(c,"backgroundColor"));e.a==0&&c!=document.documentElement;)e=new v(m.style(c,"backgroundColor")),c=c.parentNode}e&&(e=l.prototype._plotFill(e,b,a),a.l&&(c={width:a.l,height:b.height+1},this.surface.createRect(c).setFill(l.prototype._shapeFill(e,c))),a.r&&(c={x:b.width-a.r,width:a.r+1,height:b.height+2},this.surface.createRect(c).setFill(l.prototype._shapeFill(e,c))),a.t&&(c={width:b.width+1,height:a.t},this.surface.createRect(c).setFill(l.prototype._shapeFill(e,
c))),a.b&&(c={y:b.height-a.b,width:b.width+1,height:a.b+2},this.surface.createRect(c).setFill(l.prototype._shapeFill(e,c))));h&&this.surface.createRect({width:b.width-1,height:b.height-1}).setStroke(h);if(this.title)e=j.renderer=="canvas"||!w("ie")&&!w("opera")?"html":"gfx",h=j.normalizedLength(j.splitFontString(this.titleFont).size),this.chartTitle=D.createText[e](this,this.surface,b.width/2,this.titlePos=="top"?h+this.margins.t:b.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);
d.forIn(this.axes,function(c){c.render(b,a)});this._makeClean();this.surface.render&&this.surface.render();return this},delayedRender:function(){if(!this._delayedRenderHandle)this._delayedRenderHandle=setTimeout(t.hitch(this,function(){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;this.render()}),this.delayInMs);return this},connectToPlot:function(a,b,c){return a in this.plots?this.stack[this.plots[a]].connect(b,c):null},fireEvent:function(a,b,c){if(a in this.runs){var d=
this.series[this.runs[a]].plot;d in this.plots&&(d=this.stack[this.plots[d]])&&d.fireEvent(a,b,c)}return this},_makeClean:function(){g.forEach(this.axes,r);g.forEach(this.stack,r);g.forEach(this.series,r);this.dirty=!1},_makeDirty:function(){g.forEach(this.axes,s);g.forEach(this.stack,s);g.forEach(this.series,s);this.dirty=!0},_invalidateDependentPlots:function(a,b){if(a in this.plots){var c=this.stack[this.plots[a]],d,e=b?"vAxis":"hAxis";if(c[e]){if((d=this.axes[c[e]])&&d.dependOnData())d.dirty=
!0,g.forEach(this.stack,function(a){if(a[e]&&a[e]==c[e])a.dirty=!0})}else c.dirty=!0}}});return dojox.charting.Chart});