<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:doc="http://www.saxonica.com/ns/doc"
    xmlns:f="MyFunctions" xmlns:saxon="http://saxon.sf.net/" xmlns:file="http://expath.org/ns/file" exclude-result-prefixes="xs math" version="3.0">

    <doc:synopsis title="Statistics report generator">
        <p>This stylesheet is usually invoked to postprocess a statistics generation run for rule pattern optimization. It can be invoked serparately, but you
            shouldn't need to in normal circumstances.</p>
    </doc:synopsis>
    
    <xsl:import href="stats-rank.xsl"/>
    <xsl:import href="stats-time.xsl"/>
    <xsl:import href="stats-call.xsl"/>
    <xsl:import href="stats-html.xsl"/>

    <xsl:include href="stats.process.xsl"/>

    <!-- *IMPORTANT* This needs the '-l' option on Saxon to track source line numbers -->

    <!-- This process will produce a subdirectory and an HTML that will point to resources in that subdirectory -->

    <doc:synopsis title="Stats log sets preprocessing">
        <p>Preprocess a set of statistics log files</p>
    </doc:synopsis>
    <xsl:output method="xml" indent="yes"/>
    <xsl:mode on-no-match="shallow-copy"/>

    <xsl:variable name="USE-OLD-MAP" select="starts-with(system-property('xsl:product-version'), '9.6')" static="yes"/>
    <xsl:variable name="USE-NEW-MAP" select="not($USE-OLD-MAP)" static="yes"/>

    <xsl:variable name="this.base-uri" select="base-uri(doc(''))"/>
    <xsl:variable name="base-uri" select="base-uri()"/>

    <xsl:variable name="base-name" select="replace(tokenize($base-uri, '/')[last()], '.xml$', '')"/>
    <xsl:variable name="dir">statistics</xsl:variable>

    <xsl:variable name="dir2" select="resolve-uri($dir, $base-uri)"/>
    
    <xsl:variable name="lib" select="resolve-uri('../', $this.base-uri)"/>
    <xsl:variable name="tools.lib" select="resolve-uri('../lib/', $this.base-uri)"/>

    <xsl:variable name="graphics.css">graphics.css</xsl:variable>
    <xsl:variable name="new.graphics.css" select="
        string-join(($dir2,
        $graphics.css), '/')"/>
    <xsl:variable name="out" select="
            string-join(($dir,
            $base-name), '/')"/>

    <xsl:template match="/">
        <xsl:variable name="stats.docs"
            select="
                //case/doc(resolve-uri(
                concat(@dir, (@stats,
                'stats.xml')[1]), base-uri(.)))/*"/>
        <xsl:variable name="p1">
            <stats uri="{base-uri()}">
                <xsl:apply-templates select="stats/(@xsl | @s | @description)"/>
                <xsl:sequence select="
                        $stats.docs/(@xsl,
                        @source)"/>
                <xsl:apply-templates select="stats/group"/>
            </stats>
        </xsl:variable>
        <xsl:variable name="big-modes" select="$p1/stats/group/comparison/mode[@isBig = true()]/@name"/>
        <xsl:variable name="case.names" select="distinct-values($p1//case/@name)" as="xs:string*"/>
        <xsl:variable name="colours" as="xs:string*"
            select="
                'red',
                'blue',
                'green',
                'lightblue',
                'orange',
                'cyan',
                'brown'"/>
        <xsl:variable name="css.parts" as="xs:string"
            select="
                string-join(for $i in 1 to count($case.names)
                return
                    '.' || $case.names[$i] || '{&#xA; stroke:' || $colours[$i] || ';&#xA; fill:' || $colours[$i] || ';&#xA;}', '&#xA;')"/>
        <xsl:call-template name="prepare">
            <xsl:with-param name="extra.css" select="$css.parts"/>
        </xsl:call-template>
        <xsl:variable name="CSS" select="
                string-join((resolve-uri($dir, $base-uri),
                'baseStyle.css'), '/')"/>
        <result>
            <!--<CSS>
                <xsl:value-of select="$CSS"/>
            </CSS>
            <case.names>
                <xsl:value-of select="$case.names"/>
            </case.names>
            <css>
                <xsl:value-of select="$css.parts"/>
            </css>-->
            <xsl:sequence select="$p1"/>
            <xsl:apply-templates select="$p1" mode="stats.rank">
                <xsl:with-param name="svg.root" select="$out" tunnel="yes"/>
                <xsl:with-param name="modes.wanted" select="$big-modes" tunnel="yes"/>
                <xsl:with-param name="CSS.file" select="$new.graphics.css" tunnel="yes"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="$p1" mode="stats.time">
                <xsl:with-param name="svg.root" select="$out" tunnel="yes"/>
                <xsl:with-param name="CSS.file" select="$new.graphics.css" tunnel="yes"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="$p1" mode="stats.call">
                <xsl:with-param name="svg.root" select="$out" tunnel="yes"/>
                <xsl:with-param name="CSS.file" select="$new.graphics.css" tunnel="yes"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="$p1" mode="stats.html">
                <xsl:with-param name="name" select="$out"/>
            </xsl:apply-templates>
        </result>
    </xsl:template>

    <xsl:template name="prepare" doc:doc="Copy the necessary library files, including SaxonCE, into the target destination.">
        <xsl:param name="extra.css" as="xs:string" doc:doc="Additional entries to add to the graphics CSS file"/>
        <!--<xsl:message select="$tools.lib"/>-->
        <!--  <xsl:message select="
                'Resolve path is:',
                file:resolve-path(base-uri())"/>-->
        <!-- <xsl:message select="
                'Resolve dir is:',
                file:resolve-path($dir2)"/>-->
        <xsl:variable name="newCSS" select="
                string-join(($dir2,
                $graphics.css), '/')"/>

        <xsl:sequence
            select="
                if (not(file:exists($dir2))) then
                    file:create-dir($dir2)
                else
                    ()"/>
        <xsl:sequence select="
                ('Saxonce') ! file:copy(resolve-uri(., $lib), $dir2)"/>
        <xsl:sequence select="
                ('style',
                $graphics.css) ! file:copy(resolve-uri(., $this.base-uri), $dir2)"/>
        <xsl:message select="
                'RR:',
                $newCSS"/>
        <xsl:sequence select="file:append-text($newCSS, '&#xA;' || $extra.css)"/>

        <!--<xsl:sequence select="
                ('style',
                $mystyle) ! file:copy(resolve-uri(., $this.base-uri), $dir2)"/>-->
    </xsl:template>

    <xsl:template match="@xsl | @s | @o">
        <xsl:attribute name="{name()}" select="resolve-uri(., base-uri())"/>
    </xsl:template>

    <xsl:template match="group">
        <xsl:copy>
            <xsl:attribute name="svg" select="$base-name"/>
            <xsl:apply-templates select="@*"/>
            <xsl:variable name="stylesheets" as="element()*">
                <xsl:apply-templates select="case[1]" mode="show.stylesheets"/>
            </xsl:variable>
            <stylesheet>
                <xsl:sequence select="$stylesheets"/>
            </stylesheet>
            <xsl:variable name="cases" as="element()*">
                <xsl:apply-templates select="case"/>
            </xsl:variable>
            <xsl:for-each select="$cases">
                <xsl:copy>
                    <xsl:sequence select="@*"/>
                    <xsl:attribute name="total.pattern" select="format-number(stats/@total.time, '0')"/>
                    <xsl:sequence select="* except stats"/>
                </xsl:copy>
            </xsl:for-each>
            <xsl:variable name="times" select="$cases/stats/mode/rule"/>
            <comparison>
                <xsl:for-each-group select="$times" group-by="../@name">
                    <mode name="{current-grouping-key()}">
                        <xsl:variable name="temp" as="element()*">
                            <xsl:for-each-group select="current-group()" group-by="@loc">
                                <xsl:variable name="line" select="number(substring-after(current-grouping-key(), '#'))"/>
                                <xsl:variable name="module" select="substring-before(current-grouping-key(), '#')"/>
                                <rule>
                                    <xsl:sequence
                                        select="
                                            @loc,
                                            @seq,
                                            @rank,
                                            @prec"/>
                                    <xsl:attribute name="max" select="xs:integer(max(current-group()/@times.total))"/>
                                    <xsl:attribute name="invocations" select="xs:integer(max(current-group()/@invocations))"/>
                                    <xsl:for-each select="current-group()">
                                        <xsl:sort select="../../../@name"/>
                                        <case>
                                            <xsl:sequence
                                                select="
                                                    @* except (@loc,
                                                    @mode,
                                                    @seq,
                                                    @rank),
                                                    ../../../@name"
                                            />
                                        </case>
                                    </xsl:for-each>
                                </rule>
                            </xsl:for-each-group>
                        </xsl:variable>
                        <xsl:variable name="invocations" select="xs:integer(sum($temp/@invocations))"/>
                        <xsl:attribute name="max.time" select="xs:integer(max($temp/@max))"/>
                        <xsl:attribute name="invocations" select="$invocations"/>
                        <xsl:attribute name="isBig" select="$invocations gt 1000"/>
                        <xsl:for-each select="$temp">
                            <xsl:sort select="number(@max)" order="descending"/>
                            <xsl:copy-of select="."/>
                        </xsl:for-each>
                    </mode>
                </xsl:for-each-group>
            </comparison>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="case" as="element()*" mode="show.stylesheets">
        <xsl:variable name="dir" select="@dir"/>
        <xsl:variable name="explain"
            select="
                resolve-uri(
                concat($dir, (@explain,
                'explain.xml')[1]), base-uri(.))"/>
        <xsl:variable name="explain.docs" select="doc($explain)"/>
        <xsl:variable name="sources" select="distinct-values($explain.docs//templateRule/@module)" as="xs:string*"/>
        <xsl:variable name="stylesheet.templates" select="map:new($sources ! map:entry(., doc(.)//xsl:template[@match]))"/>

        <xsl:for-each select="$explain.docs/stylesheet/mode">
            <mode name="{(@name,
                    '#default')[1]}" n.rules="{count(.//templateRule)}">
                <xsl:apply-templates select=".//templateRule">
                    <xsl:with-param name="stylesheet.templates" select="$stylesheet.templates" tunnel="yes"/>
                    <xsl:sort select="number(@rank)" order="descending"/>
                    <xsl:sort select="number(@seq)" order="descending"/>
                </xsl:apply-templates>
            </mode>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="templateRule">
        <xsl:param name="stylesheet.templates" as="map(*)" tunnel="yes"/>
        <xsl:variable name="attributes"
            select="
                @module,
                @line,
                @rank,
                @seq,
                @prec,
                ancestor::ruleSet/@type,
                parent::ruleChain/@key"/>
        <xsl:variable name="template" select="$stylesheet.templates(@module)[saxon:line-number(.) = current()/@line ]"/>
        <xsl:for-each select="$template">
            <template match="{@match}">
                <xsl:sequence select="$attributes"/>
            </template>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="case" as="element()">
        <xsl:variable name="dir" select="@dir"/>
        <xsl:variable name="stats" select="
                resolve-uri(
                concat($dir, (@stats,
                'stats.xml')[1]), base-uri(.))"/>
        <xsl:variable name="stats.docs" select="doc($stats)"/>

        <xsl:copy>
            <xsl:attribute name="xml:base" select="base-uri()"/>
            <xsl:sequence select="@*"/>
            <xsl:attribute name="stats" select="$stats"/>
            <xsl:apply-templates select="$stats.docs" mode="config"/>
            <xsl:sequence select="
                    @name,
                    @label"/>
            <xsl:apply-templates select="$stats.docs" mode="process.stats"/>
            <xsl:variable name="explain"
                select="
                    resolve-uri(
                    concat($dir, (@explain,
                    'explain.xml')[1]), base-uri(.))"/>
            <xsl:variable name="explain.docs" select="doc($explain)"/>
            <xsl:sequence select="$explain.docs//elementRuleIndexes"/>

        </xsl:copy>
    </xsl:template>

    <xsl:mode name="config" on-no-match="deep-skip"/>
    <xsl:template match="document-node() | statsRTL | config" mode="config">
        <xsl:apply-templates select="@* | node()" mode="#current"/>
    </xsl:template>
    <xsl:template match="
            statsRTL/@total.time | statsRTL/@dateTime |
            config/patternOptEE | config/@edition | config/@version"
        mode="config">
        <xsl:copy-of select="."/>
    </xsl:template>
    <xsl:template match="config/@label" mode="config">
        <xsl:variable name="parts" select="tokenize(., '\s*;\s*')"/>
        <xsl:if test="$parts[1]">
            <xsl:attribute name="name" select="$parts[1]"/>
        </xsl:if>
        <xsl:if test="$parts[2]">
            <xsl:attribute name="label" select="$parts[2]"/>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
