<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:f="MyFunctions" xmlns:config="http://saxon.sf.net/ns/configuration"
    xmlns:html="http://www.w3.org/1999/xhtml" exclude-result-prefixes="xs math html" version="3.0" expand-text="yes">
    <!-- The html exclusion is important - CE doesn't respond with matches if it is set as a binding in the HTML -->
    <xsl:output method="html" indent="yes" name="Style"/>
    <xsl:output method="html" indent="no" name="Style.NoIndent"/>

    <xsl:variable name="show-problems" select="false()" static="yes"/>

    <xsl:mode name="stats.html"/>
    <xsl:template match="/">
        <xsl:apply-templates select="." mode="stats.html"/>
    </xsl:template>

    <xsl:template match="/" mode="stats.html">
        <xsl:param name="name">Statistics</xsl:param>
        <output href="{$name}.html"/>

        <xsl:result-document href="{$name}.html" format="Style">
            <html xsl:expand-text="yes">
                <head xsl:expand-text="no">
                    <title>Saxonica Community: XSLT pattern matching statistics</title>
                    <meta name="description" content=""/>
                    <meta name="keywords" content=""/>
                    <meta name="coverage" content="Worldwide"/>
                    <meta name="copyright" content="Copyright Saxonica Ltd"/>
                    <meta name="title" content="Saxonica: XSLT and XQuery Processing"/>
                    <link rel="stylesheet" href="style/saxondocs.css" type="text/css"/>
                    <link rel="stylesheet" href="style/statistics.css" type="text/css"/>
                    <script language="javascript">
                    function resize_background(){
                    var docHeight = Math.max(body.scrollHeight,
                    body.clientHeight, screen.zero(self.innerHeight));
                    document.getElementById('lhLightArea').style.height=docHeight;                            
                    document.getElementById('lhDkBlueArea').style.height=docHeight;                            
                    document.getElementById('rhDkBlueArea').style.height=docHeight;
                    }
                </script>
                </head>
                <!--<body onload="resize_background()" class="main">-->
                <body class="main">
                    <script type="text/javascript" language="javascript" src="Saxonce/Saxonce.nocache.js"/>
                    <script type="application/xslt+xml" language="xslt2.0" src="style/show-stats.xsl" data-initial-template="go"/>

                    <!--                   <script type="application/xslt+xml" language="xslt2.0" src="style/show-stats.xsl" data-source="../genStats.index.1.xml" data-initial-template="go"/>
 -->
                    <div id="rhDkBlueArea"
                        style="position:fixed; width:123px;         height:2000px; z-index:1; right: 0px; top: 0px;  border: 1px none         #000000; background-color: #C1CEDE; layer-background-color: #C1CEDE;         visibility: visible;"/>
                    <div id="lhLightArea"
                        style="position:fixed; width:34px;         height:2000px; z-index:1; left: 66px; top: 0px; border: 1px none         #000000; background-color: #f6fffb; layer-background-color: #f6fffb;         visibility: visible;"/>
                    <div id="lhDkBlueArea"
                        style="position:fixed; width:66px;         height:2000px; z-index:1; left: 0px; top: 0px; border: 1px none #000000;         background-color: #C1CEDE; layer-background-color: #C1CEDE; visibility:         visible;"/>
                    <div id="LogoArea"
                        style="position:absolute; width:340px; height:72px; z-index:3; right: 0px; top: 0px; border: 1px none #000000; visibility: visible;">
                        <a href="http://www.saxonica.com/">
                            <img src="style/img/saxonica_logo.gif" width="340" height="72" border="0" alt="saxonica.com"/>
                        </a>
                    </div>
                    <div id="MainTextArea"
                        style="position:absolute; height:100%; z-index:5; left: 130px; right: 260px; top: 110px; border: 1px none #000000; background-color: #E4EEF0; visibility: visible;">
                        <p id="loading">Please wait - loading CE</p>
                        <table>
                            <tr>
                                <td>
                                    <h2>Pattern Matching Analysis</h2>
                                </td>
                                <td>
                                    <p>
                                        <a class="link button" href="help.html">Help!</a>
                                    </p>
                                </td>
                                <td>
                                    <p class="config">Date:<span class="value">{current-dateTime()}</span></p>
                                </td>
                            </tr>
                        </table>

                        <div>
                            <!--<h3>Variable display</h3>-->
                            <div id="picture">
                                <p>Variable sections  (tables, graphs) will appear here</p>
                            </div>
                        </div>
                        <div class="description">
                            <h3>Description</h3>
                            <xsl:apply-templates select="stats/@description" mode="#current"/>
                            <xsl:apply-templates select="stats/(@* except @description)" mode="#current"/>
                        </div>
                        <xsl:apply-templates select="stats/group" mode="#current"/>
                        <div id="sortToolTip" class="tooltip" style="position:fixed; visibility:hidden; left:0px; top:0px"> Click to sort on this column </div>
                        <div id="configToolTip" class="tooltip" style="position:fixed; visibility:hidden; left:0px; top:0px"> Click to view this configuration </div>
                        <div id="modeToolTip" class="tooltip" style="position:fixed; visibility:hidden; left:0px; top:0px"> Click to view details of this mode </div>
                        <div id="callToolTip" class="tooltip" style="position:fixed; visibility:hidden; left:0px; top:0px"> Click to view details of these
                            matches </div>
                        <div id="timeToolTip" class="tooltip" style="position:fixed; visibility:hidden; left:0px; top:0px"> Click to view details of these times </div>
                        <div id="rankToolTip" class="tooltip" style="position:fixed; visibility:hidden; left:0px; top:0px"> Click to view details of these ranks
                        </div>
                    </div>
                </body>
            </html>
        </xsl:result-document>



        <xsl:result-document href="{$dir}/help.html" format="Style.NoIndent">
            <html xsl:expand-text="yes">
                <head xsl:expand-text="no">
                    <title>Saxonica Community: XSLT pattern matching statistics - HELP</title>
                    <xsl:call-template name="saxon.header"/>
                </head>
                <!--<body onload="resize_background()" class="main">-->
                <body class="main">
                    <xsl:call-template name="saxon.body"/>
                    <div id="MainTextArea"
                        style="position:absolute; height:100%; z-index:5; left: 130px; right: 260px; top: 110px; border: 1px none #000000; background-color: #E4EEF0; visibility: visible;">
                        <h2>Pattern Matching Analysis - HELP</h2>
                        <p class="config">Date:<span class="value">{current-dateTime()}</span>
                        </p>
                        <xsl:apply-templates select="doc('help.xml')" mode="include.saxondoc"/>
                    </div>
                </body>
            </html>
        </xsl:result-document>
    </xsl:template>

    <xsl:mode name="include.saxondoc" on-no-match="shallow-copy"/>
    <xsl:template match="html:samp" mode="include.saxondoc">
        <xsl:copy>
            <xsl:value-of select="."/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="html:include" mode="include.saxondoc">
        <xsl:apply-templates select="doc(resolve-uri(@href, base-uri()))//section[@id = 'commandline']/table" mode="#current"/>
    </xsl:template>
    <xsl:template match="tr" mode="include.saxondoc"/>
    <xsl:template
        match="
            tr[td/p[starts-with(., '-repeat:')
            or starts-with(., '-it:')
            or starts-with(., '-im:')
            or starts-with(., '-l')
            or (. = '-t')]]"
        mode="include.saxondoc">
        <xsl:sequence select="."/>
    </xsl:template>

    <xsl:template name="saxon.header" expand-text="no">
        <meta name="description" content=""/>
        <meta name="keywords" content=""/>
        <meta name="coverage" content="Worldwide"/>
        <meta name="copyright" content="Copyright Saxonica Ltd"/>
        <meta name="title" content="Saxonica: XSLT and XQuery Processing"/>
        <link rel="stylesheet" href="style/saxondocs.css" type="text/css"/>
        <link rel="stylesheet" href="style/statistics.css" type="text/css"/>
        <script language="javascript">
            function resize_background(){
            var docHeight = Math.max(body.scrollHeight,
            body.clientHeight, screen.zero(self.innerHeight));
            document.getElementById('lhLightArea').style.height=docHeight;                            
            document.getElementById('lhDkBlueArea').style.height=docHeight;                            
            document.getElementById('rhDkBlueArea').style.height=docHeight;
            }
        </script>
    </xsl:template>
    <xsl:template name="saxon.body" expand-text="no">
        <div id="rhDkBlueArea"
            style="position:fixed; width:123px;         height:2000px; z-index:1; right: 0px; top: 0px;  border: 1px none         #000000; background-color: #C1CEDE; layer-background-color: #C1CEDE;         visibility: visible;"/>
        <div id="lhLightArea"
            style="position:fixed; width:34px;         height:2000px; z-index:1; left: 66px; top: 0px; border: 1px none         #000000; background-color: #f6fffb; layer-background-color: #f6fffb;         visibility: visible;"/>
        <div id="lhDkBlueArea"
            style="position:fixed; width:66px;         height:2000px; z-index:1; left: 0px; top: 0px; border: 1px none #000000;         background-color: #C1CEDE; layer-background-color: #C1CEDE; visibility:         visible;"/>
        <div id="LogoArea" style="position:absolute; width:340px; height:72px; z-index:3; right: 0px; top: 0px; border: 1px none #000000; visibility: visible;">
            <a href="http://www.saxonica.com/">
                <img src="style/img/saxonica_logo.gif" width="340" height="72" border="0" alt="saxonica.com"/>
            </a>
        </div>
    </xsl:template>

    <xsl:template match="group" mode="stats.html" expand-text="yes">
        <xsl:variable name="svg" select="@svg"/>
        <table id="mainTable">
            <tbody>
                <tr>
                    <td class="VALIGN">
                        <h2>Cases</h2>
                        <table>
                            <thead>
                                <tr>
                                    <th rowspan="2">Description</th>
                                    <th rowspan="2">Date/Time</th>
                                    <!-- <th rowspan="2">Saxon</th>-->
                                    <th colspan="4">Times/ms</th>
                                </tr>
                                <tr>
                                    <th>Total</th>
                                    <th>Pattern</th>
                                    <th>%</th>
                                    <th>Other</th>
                                </tr>
                            </thead>
                            <tbody class="stripe">
                                <xsl:apply-templates select="case" mode="#current"/>
                            </tbody>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td class="VALIGN" xsl:expand-text="yes">
                        <h2>Modes </h2>
                        <p>{count(stylesheet/mode)} total, {count(Scomparison/mode)} used. <input class="control" id="unused" type="checkbox" name="unused"
                                value="Unused"> filter unused</input></p>
                        <table>
                            <thead>
                                <tr>
                                    <th class="sortable" rowspan="2">Name</th>
                                    <th colspan="3">rules</th>
                                    <th colspan="2">ranks</th>
                                    <th class="sortable" rowspan="2" data-type="number">Matches</th>
                                    <th class="sortable" rowspan="2" data-type="number">Max time/μs</th>
                                </tr>
                                <tr>
                                    <th class="sortable" data-type="number">#</th>
                                    <th class="sortable" data-type="number">*</th>
                                    <th class="sortable" data-type="number">used</th>
                                    <th class="sortable" data-type="number">#</th>
                                    <th class="sortable" data-type="number">used</th>
                                </tr>
                            </thead>
                            <tbody id="modes.all" class="stripe">
                                <xsl:apply-templates select="stylesheet/mode" mode="#current">
                                    <xsl:sort
                                        select="
                                            let $n := @name
                                            return
                                                number(../../comparison/mode[@name = $n]/@max.time)"
                                        order="descending"/>
                                </xsl:apply-templates>
                                <tr class="total">
                                    <td>TOTALS</td>
                                    <td class="number">{count(stylesheet/mode/template)}</td>
                                    <td/>
                                    <td class="number">{count(comparison/mode/rule)}</td>
                                    <td/>
                                    <td/>
                                    <td class="number">{sum(comparison/mode/rule/@invocations)}</td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
        <div style="display:none">
            <xsl:apply-templates select="stylesheet/mode" mode="stats.mode.html"/>
            <xsl:apply-templates select="case" mode="show.config"/>
        </div>
    </xsl:template>

    <xsl:function name="f:pic" as="xs:string?">
        <xsl:param name="isBig" as="xs:boolean?"/>
        <xsl:if test="$isBig"> picshow</xsl:if>
    </xsl:function>
    <xsl:function name="f:show" as="xs:string?">
        <xsl:param name="isBig" as="xs:boolean?"/>
        <xsl:if test="$isBig"> show</xsl:if>
    </xsl:function>
    <xsl:template match="stats/@*" mode="stats.html"/>
    <xsl:template match="@xsl | @s | @o" priority="1" expand-text="yes" mode="stats.html">
        <p class="config">-{name()}: <span class="value">{.}</span></p>
    </xsl:template>
    <xsl:template match="@description" priority="1" expand-text="yes" mode="stats.html">
        <p class="config">
            <span class="value">{.}</span>
        </p>
    </xsl:template>

    <xsl:template match="case" mode="stats.html">
        <xsl:variable name="total" select="@total.time div 1000000"/>
        <xsl:variable name="pattern" select="@total.pattern div 1000000"/>
        <tr>
            <td class="hasTip link" tip="config" ref="config-{@name}">{@label}</td>
            <xsl:variable name="dt" select="xs:dateTime(@dateTime)"/>
            <td class="value">{format-dateTime($dt,'[MNn] [D] @ [H01]:[m]')}</td>
            <!-- <td class="value">{substring-before(@dateTime,'T')}<br/>{substring-after(@dateTime,'T')}</td>-->
            <!--<td class="value">{@edition}:{@version}</td>-->
            <td class="number">{format-number($total,',##0')}</td>
            <td class="number">{format-number($pattern,',##0')}</td>
            <td class="number">{format-number($pattern div $total,'0.0%')}</td>
            <td class="number">{format-number($total - $pattern,',##0')}</td>
        </tr>
    </xsl:template>

    <xsl:template match="stylesheet/mode" mode="stats.html">
        <xsl:variable name="svg" select="../../@svg"/>
        <xsl:variable name="all" select="template"/>
        <xsl:variable name="s" select="
                let $n := @name
                return
                    ../../comparison/mode[@name = $n]"/>
        <xsl:variable name="isBig" select="$s/@isBig" as="xs:boolean?"/>
        <xsl:variable name="rules" select="$s/rule"/>
        <xsl:variable name="svg.base" select="$svg || '/modes/' || f:modeFile(@name)"/>
        <tr>
            <xsl:if test="empty($rules)">
                <xsl:attribute name="class">mode-unused</xsl:attribute>
            </xsl:if>
            <xsl:if test="$isBig">
                <xsl:attribute name="class">mode-significant</xsl:attribute>
            </xsl:if>
            <td class="link  hasTip" tip="mode" ref="mode.{@name}">{@name}</td>
            <td class="number">{count($all)}</td>
            <td class="number">{count($all[@type='element()'])}</td>
            <td class="number">{count($rules)}</td>
            <td class="number hasTip link" tip="rank" ref="{$svg.base || '/ranksPlain.flat.svg'}">{max($all/@rank)+1} </td>
            <td class="number">{count(distinct-values($rules/@rank))}</td>
            <td class="number hasTip link" tip="call" ref="{$svg.base || '/calls.flat.svg'}">{format-number(sum($rules/@invocations), ',##0')}</td>
            <td class="number hasTip link" tip="time" ref="{$svg.base || '/times.flat.svg'}">{format-number(sum($rules/@max) div 1000, ',###,##0')}</td>
        </tr>
    </xsl:template>

    <xsl:template match="stylesheet/mode" mode="stats.mode.html">
        <div id="mode.{@name}">
            <h2>Mode:{@name}</h2>
            <table>
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>#rules</th>
                        <th>#ranks</th>
                        <th>#sources</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:for-each-group select="template" group-by="@type">
                        <tr>
                            <td>{current-grouping-key()}</td>
                            <td>{count(current-group())}</td>
                            <td>{count(distinct-values(current-group()/@rank))}</td>
                            <td>{count(distinct-values(current-group()/@module))}</td>
                        </tr>
                    </xsl:for-each-group>
                    <tr/>
                </tbody>
            </table>
        </div>
    </xsl:template>

    <xsl:mode name="show.config" on-no-match="shallow-skip"/>
    <xsl:template match="case" mode="show.config" expand-text="yes">
        <div id="config-{@name}">
            <h2>XSLT Configuration</h2>
            <xsl:variable name="config" select="doc(resolve-uri(concat(@dir, 'config.xml'), base-uri(.)))/*"/>
            <table>
                <thead>
                    <tr>
                        <th>Description</th>
                        <th>Date/Time</th>
                        <th>Saxon</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{@label}</td>
                        <td class="value">{substring-before(@dateTime,'T')}<br/>{substring-after(@dateTime,'T')}</td>
                        <td class="value">{@edition}:{@version}</td>
                    </tr>
                    <tr> </tr>
                </tbody>
            </table>
            <xsl:if test="empty($config//config:patternOptimization)">
                <p>No pattern optimization</p>
            </xsl:if>
            <xsl:apply-templates select="$config" mode="#current"/>
            <xsl:apply-templates select="elementRuleIndexes" mode="#current"/>
        </div>
    </xsl:template>
    <xsl:template match="config:patternOptimization" mode="show.config" expand-text="yes">
        <h3>Pattern optimization</h3>
        <table>
            <tbody>
                <xsl:apply-templates
                    select="
                        config:precondition,
                        config:index,
                        config.rewrite"
                    mode="#current"/>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template match="config:index" mode="show.config" expand-text="yes">
        <tr>
            <xsl:apply-templates select="." mode="config.common"/>
            <td>
                <table>
                    <tbody class="stripe">
                        <tr>
                            <th>index.expr</th>
                            <td>{@index.expr}</td>
                        </tr>
                        <tr>
                            <th>index.value</th>
                            <td>{@index.value}</td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="config:precondition | config:rewrite" mode="show.config" expand-text="yes">
        <tr>
            <xsl:apply-templates select="." mode="config.common"/>
            <td>
                <table>
                    <tbody class="stripe">
                        <tr>
                            <th>to</th>
                            <td>{@to}</td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="config:index | config:precondition" mode="config.common" expand-text="yes">
        <td>{local-name()}</td>
        <td>
            <table>
                <tbody class="stripe">
                    <tr>
                        <th>pattern</th>
                        <td>{@pattern}</td>
                    </tr>
                    <tr>
                        <th>when</th>
                        <td>{@when}</td>
                    </tr>
                    <tr>
                        <th>mode</th>
                        <td>{@mode}</td>
                    </tr>
                </tbody>
            </table>
        </td>
    </xsl:template>

    <xsl:template match="elementRuleIndexes" mode="show.config">
        <h3>Rule Indexes</h3>
        <table>
            <thead>
                <tr>
                    <th>Expression</th>
                    <th>No. keys</th>
                    <th>Max depth.</th>
                    <th>Avg depth.</th>
                </tr>
            </thead>
            <tbody>
                <xsl:apply-templates select="*" mode="#current"/>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template match="elementRuleIndex" mode="show.config">
        <tr>
            <td>{@expr}</td>
            <td class="number">{count(value)}</td>
            <td class="number">{max(value/count(rule))}</td>
            <td class="number">{format-number(avg(value/count(rule)),'0.0')}</td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
