/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import java.io.PrintStream;
import java.text.Collator;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.dm.NodeSequence;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.util.Collations;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;

public class FONIDM {
    protected FONIDocument dom;
    protected Node root;
    protected Object owner;
    ISequence emptySequence = new ISequence(0);

    public FONIDM(FONIDocument fONIDocument) {
        this.dom = fONIDocument;
        this.root = this.newDmNode(fONIDocument.getRootNode());
    }

    public Node document() {
        return this.root;
    }

    public String getDocumentURI() {
        return this.dom.getBaseURI();
    }

    public int estimateMemorySize() {
        return this.dom.estimateMemorySize();
    }

    public Node newDmNode(int n) {
        if (n == 0) {
            return null;
        }
        return new BaseNode(n);
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    class Attributes
    extends ASequence {
        NodeTest nodeTest;
        int nameId = -1;

        Attributes(int n, NodeTest nodeTest) {
            super(n, FONIDM.this.dom.attrIterator(n));
            this.nodeTest = nodeTest;
        }

        boolean checkNode() {
            if (this.curId == 0) {
                return false;
            }
            return this.nodeTest == null || (this.nodeTest.needsNode() ? this.nodeTest.accepts(this.makeNode(this.curId)) : this.nodeTest.accepts(3, FONIDM.this.dom.pnGetName(this.curId)));
        }

        public NodeSequence reborn() {
            return new Attributes(this.ownerId, this.nodeTest);
        }

        public boolean nextNode() {
            while (super.nextNode()) {
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class ASequence
    implements NodeSequence {
        FONIDocument.NodeIterator domIter;
        int ownerId;
        int curId;

        ASequence(int n, FONIDocument.NodeIterator nodeIterator) {
            this.domIter = nodeIterator;
            this.ownerId = n;
        }

        public boolean nextNode() {
            if (!this.domIter.next()) {
                return false;
            }
            this.curId = this.domIter.currentId();
            return true;
        }

        public Node currentNode() {
            this.curId = this.domIter.currentId();
            return this.curId == 0 ? null : this.makeNode(this.curId);
        }

        ANode makeNode(int n) {
            return new ANode(this.ownerId, n);
        }

        public NodeSequence reborn() {
            return new ASequence(this.ownerId, this.domIter.reborn());
        }
    }

    class Preceding
    extends PrecedingSiblings {
        Preceding(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.curId = FONIDM.this.dom.getRootNode();
        }

        public NodeSequence reborn() {
            return new Preceding(this.startId, this.nodeTest);
        }

        public boolean nextNode() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDM.this.dom.getNodeNext(this.curId);
                }
                this.started = true;
                if (this.curId == this.startId) {
                    this.curId = 0;
                    return false;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class PrecedingSiblings
    extends TypedSequence {
        PrecedingSiblings(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.curId = FONIDM.this.dom.getFirstChild(FONIDM.this.dom.getParent(n));
        }

        public NodeSequence reborn() {
            return new PrecedingSiblings(this.startId, this.nodeTest);
        }

        public boolean nextNode() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDM.this.dom.getNextSibling(this.curId);
                }
                this.started = true;
                if (this.curId == this.startId) {
                    this.curId = 0;
                    return false;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Following
    extends TypedSequence {
        Following(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public NodeSequence reborn() {
            return new Following(this.startId, this.nodeTest);
        }

        public boolean nextNode() {
            while (this.curId != 0) {
                this.curId = FONIDM.this.dom.getNodeNext(this.curId);
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class FollowingSiblings
    extends TypedSequence {
        FollowingSiblings(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public NodeSequence reborn() {
            return new FollowingSiblings(this.startId, this.nodeTest);
        }

        public boolean nextNode() {
            while (this.curId != 0) {
                this.curId = FONIDM.this.dom.getNextSibling(this.curId);
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Descendants
    extends DescendantsOrSelf {
        Descendants(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.started = true;
        }

        public NodeSequence reborn() {
            return new Descendants(this.startId, this.nodeTest);
        }
    }

    class DescendantsOrSelf
    extends TypedSequence {
        int lastNode;

        DescendantsOrSelf(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.lastNode = FONIDM.this.dom.getNodeAfter(Math.abs(n));
            if (this.lastNode == 0) {
                this.lastNode = Integer.MAX_VALUE;
            }
        }

        public NodeSequence reborn() {
            return new DescendantsOrSelf(this.startId, this.nodeTest);
        }

        public boolean nextNode() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDM.this.dom.getNodeNext(this.curId);
                }
                this.started = true;
                if (this.curId >= this.lastNode) {
                    this.curId = 0;
                    continue;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Children
    extends TypedSequence {
        Children(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.curId = FONIDM.this.dom.getFirstChild(n);
        }

        public NodeSequence reborn() {
            return new Children(this.startId, this.nodeTest);
        }

        public boolean nextNode() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDM.this.dom.getNextSibling(this.curId);
                }
                this.started = true;
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Ancestors
    extends AncestorsOrSelf {
        Ancestors(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.started = true;
        }

        public NodeSequence reborn() {
            return new Ancestors(this.startId, this.nodeTest);
        }
    }

    class AncestorsOrSelf
    extends TypedSequence {
        AncestorsOrSelf(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDM.this.dom.getParent(this.curId);
                }
                this.started = true;
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }

        public NodeSequence reborn() {
            return new AncestorsOrSelf(this.startId, this.nodeTest);
        }
    }

    class Parent
    extends TypedSequence {
        Parent(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public boolean nextNode() {
            if (this.started) {
                return false;
            }
            this.started = true;
            this.curId = FONIDM.this.dom.getParent(this.curId);
            return this.checkNode();
        }

        public NodeSequence reborn() {
            return new Parent(this.startId, this.nodeTest);
        }
    }

    abstract class TypedSequence
    extends ISequence {
        NodeTest nodeTest;
        int nameId = -1;
        boolean started = false;

        TypedSequence(int n, NodeTest nodeTest) {
            super(n);
            this.nodeTest = nodeTest;
        }

        boolean checkNode() {
            if (this.curId == 0) {
                return false;
            }
            return this.nodeTest == null || (this.nodeTest.needsNode() ? this.nodeTest.accepts(this.currentNode()) : this.nodeTest.accepts(FONIDM.this.dom.getKind(this.curId), FONIDM.this.dom.getName(this.curId)));
        }
    }

    class ISequence
    implements NodeSequence {
        int startId;
        int curId;

        ISequence(int n) {
            this.curId = this.startId = n;
        }

        public NodeSequence reborn() {
            return new ISequence(this.startId);
        }

        public boolean nextNode() {
            this.curId = this.curId < 0 ? -this.curId : FONIDM.this.dom.getNextSibling(this.curId);
            return this.curId != 0;
        }

        public int currentId() {
            return this.curId;
        }

        public Node currentNode() {
            return this.curId == 0 ? null : FONIDM.this.newDmNode(this.curId);
        }
    }

    class NSNode
    extends ANode {
        NSNode(int n, int n2) {
            super(n, n2);
        }

        public String getNodeKind() {
            return "namespace";
        }

        public int getNature() {
            return 7;
        }
    }

    class ANode
    extends BaseNode {
        int offset;

        ANode(int n, int n2) {
            super(n);
            this.offset = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ANode)) {
                return false;
            }
            ANode aNode = (ANode)object;
            return aNode.id == this.id && aNode.offset == this.offset && aNode.getDom() == FONIDM.this.dom;
        }

        public int hashCode() {
            return this.id ^ this.offset;
        }

        public int orderCompare(Node node) {
            int n = super.orderCompare(node);
            if (n != 0) {
                return n;
            }
            if (!(node instanceof ANode)) {
                return 1;
            }
            ANode aNode = (ANode)node;
            n = this.offset - aNode.offset;
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }

        public int getNature() {
            return 3;
        }

        public String getNodeKind() {
            return "attribute";
        }

        public QName getNodeName() {
            return FONIDM.this.dom.getOtherName(FONIDM.this.dom.pnGetNameId(this.offset));
        }

        public String getStringValue() {
            return FONIDM.this.dom.pnGetStringValue(this.offset);
        }

        public Node parent() {
            return FONIDM.this.newDmNode(this.id);
        }

        public NodeSequence children() {
            return FONIDM.this.emptySequence;
        }

        public NodeSequence attributes() {
            return FONIDM.this.emptySequence;
        }

        public NodeSequence namespaces() {
            return FONIDM.this.emptySequence;
        }
    }

    public class BaseNode
    implements Node {
        protected int id;

        public BaseNode(int n) {
            this.id = n;
        }

        protected FONIDocument getDom() {
            return FONIDM.this.dom;
        }

        public Object getOwner() {
            return FONIDM.this.owner;
        }

        public int getDocId() {
            return FONIDM.this.dom.getDocId();
        }

        public int getNodeId() {
            return this.id;
        }

        public String getNodeKind() {
            switch (FONIDM.this.dom.getKind(this.id)) {
                case 1: {
                    return "document";
                }
                case 2: {
                    return "element";
                }
                case 3: {
                    return "attribute";
                }
                case 4: {
                    return "text";
                }
                case 5: {
                    return "processing-instruction";
                }
                case 6: {
                    return "comment";
                }
                case 7: {
                    return "namespace";
                }
            }
            throw new RuntimeException("wrong FONInode, id=" + this.id);
        }

        public QName getNodeName() {
            return FONIDM.this.dom.getName(this.id);
        }

        public Node parent() {
            return FONIDM.this.newDmNode(FONIDM.this.dom.getParent(this.id));
        }

        public String getStringValue() {
            return FONIDM.this.dom.getStringValue(this.id);
        }

        public String getDocumentURI() {
            return FONIDM.this.dom.getBaseURI();
        }

        public String getBaseURI() {
            int n = FONIDM.this.dom.internOtherName(QName.get(Namespace.XML, "base"));
            if (n >= 0) {
                int n2 = this.id;
                while (n2 != 0) {
                    int n3 = FONIDM.this.dom.getAttribute(this.id, n);
                    if (n3 != 0) {
                        return FONIDM.this.dom.pnGetStringValue(n3);
                    }
                    n2 = FONIDM.this.dom.getParent(n2);
                }
            }
            return FONIDM.this.dom.getBaseURI();
        }

        public NodeSequence children() {
            return new ISequence(-FONIDM.this.dom.getFirstChild(this.id));
        }

        public NodeSequence attributes() {
            return new ASequence(this.id, FONIDM.this.dom.attrIterator(this.id));
        }

        public int getDefinedNSCount() {
            return FONIDM.this.dom.getDefinedNSCount(this.id);
        }

        public NodeSequence namespaces(boolean bl) {
            return new ASequence(this, this.id, FONIDM.this.dom.namespaceIterator(this.id, bl)){
                private final /* synthetic */ BaseNode this$1;
                {
                    this.this$1 = baseNode;
                }

                ANode makeNode(int n) {
                    return BaseNode.access$000(this.this$1).new NSNode(this.ownerId, n);
                }
            };
        }

        public int docPosition() {
            if (FONIDM.this.owner != null) {
                return FONIDM.this.owner.hashCode() + FONIDM.this.dom.getDocId();
            }
            return FONIDM.this.hashCode();
        }

        public int getNature() {
            return FONIDM.this.dom.getKind(this.id);
        }

        public boolean isElement() {
            return FONIDM.this.dom.getKind(this.id) == 2;
        }

        public Node document() {
            return FONIDM.this.newDmNode(FONIDM.this.dom.getRootNode());
        }

        public String toString() {
            return "FONI " + this.getNodeKind() + " id=" + this.id + " " + (this.getNodeName() != null ? " name=" + this.getNodeName() : this.getStringValue());
        }

        public Node attribute(QName qName) {
            return FONIDM.this.newDmNode(FONIDM.this.dom.getAttribute(this.id, FONIDM.this.dom.internOtherName(qName)));
        }

        public String getNsPrefix(String string) {
            int n = this.id;
            while (n != 0) {
                FONIDocument.NodeIterator nodeIterator = FONIDM.this.dom.namespaceIterator(n, true);
                while (nodeIterator.next()) {
                    if (!string.equals(FONIDM.this.dom.pnGetStringValue(nodeIterator.currentId()))) continue;
                    return FONIDM.this.dom.pnGetName(nodeIterator.currentId()).getLocalName();
                }
                n = FONIDM.this.dom.getParent(n);
            }
            return null;
        }

        public String getNsUri(String string) {
            int n = this.id;
            while (n != 0) {
                FONIDocument.NodeIterator nodeIterator = FONIDM.this.dom.namespaceIterator(n, true);
                while (nodeIterator.next()) {
                    if (!string.equals(FONIDM.this.dom.pnGetName(nodeIterator.currentId()).getLocalName())) continue;
                    return FONIDM.this.dom.pnGetStringValue(nodeIterator.currentId());
                }
                n = FONIDM.this.dom.getParent(n);
            }
            return null;
        }

        public int orderCompare(Node node) {
            BaseNode baseNode;
            if (node instanceof BaseNode && (baseNode = (BaseNode)node).getDom() == FONIDM.this.dom) {
                return this.id < baseNode.id ? -1 : (this.id > baseNode.id ? 1 : 0);
            }
            int n = this.docPosition() - node.docPosition();
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }

        public boolean contains(Node node) {
            if (!(node instanceof BaseNode)) {
                return false;
            }
            int n = this.id - ((BaseNode)node).id;
            return n >= 0 && n < FONIDM.this.dom.getNodeSpan(this.id);
        }

        public int getNodeSpan() {
            return FONIDM.this.dom.getNodeSpan(this.id);
        }

        public int getNodeDepth() {
            int n = 0;
            int n2 = this.id;
            while (n2 != 0) {
                ++n;
                n2 = FONIDM.this.dom.getParent(n2);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BaseNode)) {
                return false;
            }
            BaseNode baseNode = (BaseNode)object;
            return baseNode.id == this.id && baseNode.getDom() == FONIDM.this.dom;
        }

        public int hashCode() {
            return this.id;
        }

        boolean dumpNode(PrintStream printStream, int n) {
            int n2 = FONIDM.this.dom.getKind(n);
            switch (n2) {
                case 1: 
                case 2: {
                    int n3 = FONIDM.this.dom.getNameId(n);
                    int n4 = FONIDM.this.dom.getAttrCount(n);
                    QName qName = FONIDM.this.dom.getElementName(n3);
                    printStream.print("Element " + n3 + " " + qName + "  " + n4 + " attr:");
                    StringBuffer stringBuffer = new StringBuffer();
                    FONIDocument.NodeIterator nodeIterator = FONIDM.this.dom.attrIterator(n);
                    while (nodeIterator.next()) {
                        int n5 = nodeIterator.currentId();
                        qName = FONIDM.this.dom.getOtherName(FONIDM.this.dom.pnGetNameId(n5));
                        stringBuffer.append(' ').append(qName);
                        stringBuffer.append("='").append(FONIDM.this.dom.pnGetStringValue(n5)).append('\'');
                    }
                    FONIDocument.NodeIterator nodeIterator2 = FONIDM.this.dom.namespaceIterator(n, false);
                    while (nodeIterator2.next()) {
                        int n6 = nodeIterator2.currentId();
                        qName = FONIDM.this.dom.getOtherName(FONIDM.this.dom.pnGetNameId(n6));
                        stringBuffer.append("xmlns:").append(qName).append("='").append(FONIDM.this.dom.pnGetStringValue(n6)).append('\'');
                    }
                    System.out.println(stringBuffer);
                    return true;
                }
                case 4: {
                    printStream.print("Text |");
                    printStream.print(FONIDM.this.dom.getStringValue(n));
                    printStream.println('|');
                    break;
                }
                case 5: {
                    printStream.print("PI " + FONIDM.this.dom.getName(n) + " |");
                    printStream.print(FONIDM.this.dom.getStringValue(n));
                    printStream.println('|');
                    break;
                }
                case 6: {
                    printStream.print("Comment |");
                    printStream.print(FONIDM.this.dom.getStringValue(n));
                    printStream.println('|');
                }
            }
            return false;
        }

        void dumpTree(PrintStream printStream, int n, int n2) {
            printStream.print(n);
            int n3 = 0;
            while (n3 < n2) {
                printStream.print("  ");
                ++n3;
            }
            if (this.dumpNode(printStream, n)) {
                int n4 = FONIDM.this.dom.getFirstChild(n);
                int n5 = 0;
                while (n4 != 0) {
                    int n6 = FONIDM.this.dom.getNextSibling(n4);
                    this.dumpTree(printStream, n4, n2 + 1);
                    n4 = n6;
                    ++n5;
                }
            }
        }

        public boolean deepEqual(Node node, Collator collator) {
            return this.deepEq(this.id, node, collator);
        }

        protected boolean deepEq(int n, Node node, Collator collator) {
            int n2 = FONIDM.this.dom.getKind(n);
            if (n2 != node.getNature() || FONIDM.this.dom.getName(n) != node.getNodeName()) {
                return false;
            }
            if (n2 == 1) {
                return this.contentEq(n, node, collator);
            }
            if (n2 == 2) {
                return this.attributesEq(n, node, collator) && this.contentEq(n, node, collator);
            }
            return Collations.compare(FONIDM.this.dom.getStringValue(n), node.getStringValue(), collator) == 0;
        }

        boolean attributesEq(int n, Node node, Collator collator) {
            NodeSequence nodeSequence = node.attributes();
            int n2 = 0;
            while (nodeSequence.nextNode()) {
                Node node2 = nodeSequence.currentNode();
                int n3 = FONIDM.this.dom.getAttribute(n, FONIDM.this.dom.internOtherName(node2.getNodeName()));
                if (n3 == 0 || Collations.compare(FONIDM.this.dom.pnGetStringValue(n3), node2.getStringValue(), collator) != 0) {
                    return false;
                }
                ++n2;
            }
            return FONIDM.this.dom.getAttrCount(n) == n2;
        }

        boolean contentEq(int n, Node node, Collator collator) {
            NodeSequence nodeSequence = node.children();
            int n2 = FONIDM.this.dom.getFirstChild(n);
            while (n2 != 0) {
                int n3 = FONIDM.this.dom.getKind(n2);
                if (n3 != 6 && n3 != 5) {
                    Node node2;
                    int n4;
                    do {
                        if (nodeSequence.nextNode()) continue;
                        return false;
                    } while ((n4 = (node2 = nodeSequence.currentNode()).getNature()) == 6 || n4 == 5);
                    if (!this.deepEq(n2, node2, collator)) {
                        return false;
                    }
                }
                n2 = FONIDM.this.dom.getNextSibling(n2);
            }
            return !nodeSequence.nextNode();
        }

        public int compareStringValues(Node node, Collator collator) {
            String string = this.getStringValue();
            String string2 = node.getStringValue();
            return collator != null ? collator.compare(string, string2) : string.compareTo(string2);
        }

        public NodeSequence ancestors(NodeTest nodeTest) {
            return new AncestorsOrSelf(this.id, nodeTest);
        }

        public NodeSequence ancestorsOrSelf(NodeTest nodeTest) {
            return new AncestorsOrSelf(this.id, nodeTest);
        }

        public NodeSequence parent(NodeTest nodeTest) {
            return new Parent(this.id, nodeTest);
        }

        public NodeSequence children(NodeTest nodeTest) {
            return new Children(this.id, nodeTest);
        }

        public NodeSequence descendants(NodeTest nodeTest) {
            return new Descendants(this.id, nodeTest);
        }

        public NodeSequence descendantsOrSelf(NodeTest nodeTest) {
            return new DescendantsOrSelf(this.id, nodeTest);
        }

        public NodeSequence attributes(NodeTest nodeTest) {
            return new Attributes(this.id, nodeTest);
        }

        public NodeSequence followingSiblings(NodeTest nodeTest) {
            return new FollowingSiblings(this.id, nodeTest);
        }

        public NodeSequence precedingSiblings(NodeTest nodeTest) {
            return new PrecedingSiblings(this.id, nodeTest);
        }

        public NodeSequence following(NodeTest nodeTest) {
            return new Following(this.id, nodeTest);
        }

        public NodeSequence preceding(NodeTest nodeTest) {
            return new Preceding(this.id, nodeTest);
        }

        public void addChild(Node node) {
            throw new RuntimeException(this.getClass() + ".addChild!");
        }

        public void addAttribute(Node node) {
            throw new RuntimeException(this.getClass() + ".addAttribute!");
        }

        public void addText(String string) {
            throw new RuntimeException(this.getClass() + ".setStringValue!");
        }

        public char[] getChars() {
            return FONIDM.this.dom.getCharValue(this.id, 0);
        }

        public Object getAtomValue() {
            return this.getStringValue();
        }

        public int getAtomType() {
            return 6;
        }

        public long getIntegerValue() throws DataModelException {
            Object object = this.getAtomValue();
            if (object instanceof Long) {
                return (Long)object;
            }
            try {
                return Long.parseLong(this.getStringValue());
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataModelException("atom cannot be converted to integer", numberFormatException);
            }
        }

        public double getDoubleValue() throws DataModelException {
            Object object = this.getAtomValue();
            if (object instanceof Double) {
                return (Double)object;
            }
            try {
                return Double.parseDouble(this.getStringValue());
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataModelException("atom cannot be converted to double", numberFormatException);
            }
        }

        static /* synthetic */ FONIDM access$000(BaseNode baseNode) {
            return baseNode.FONIDM.this;
        }
    }
}

