/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.dm.NodeSequence;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;

public abstract class XMLEventReceiverBase
implements XMLEventReceiver {
    protected NSPrefixMapping prefixes = new NSPrefixMapping();
    protected NSPrefixMapping prefixHints;
    protected int depth = 0;
    protected long maxVolume = -1L;
    protected long volume = 0L;
    protected static final String VOLUME_LIMIT = "volume limit reached";
    protected int nsCnt;
    protected int[] nsCounts = new int[16];
    protected boolean elementStarted;
    protected boolean spaceNeeded;
    protected boolean docStarted;
    protected boolean startDocumentDone;
    protected boolean endDocumentDone;
    protected boolean trace = false;
    protected QName tagName;
    protected QName[] attrNames;
    protected String[] attrValues;
    protected int attrCnt;
    static final char[] blank = new char[]{' '};

    protected abstract void flushElement(boolean var1) throws DataModelException;

    public void definePrefixHints(NSPrefixMapping nSPrefixMapping) {
        this.prefixHints = nSPrefixMapping;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setMaxVolume(int n) {
        this.maxVolume = n;
    }

    public boolean maxVolumeReached() {
        return this.volume >= this.maxVolume;
    }

    public void reset() {
        this.docStarted = false;
        this.elementStarted = false;
        this.endDocumentDone = false;
        this.startDocumentDone = false;
        this.spaceNeeded = false;
        this.depth = 0;
        this.attrCnt = 0;
        this.prefixes = new NSPrefixMapping();
        this.nsCounts = new int[16];
        this.attrNames = new QName[8];
        this.attrValues = new String[8];
    }

    public void terminate() throws DataModelException {
        if (!this.endDocumentDone) {
            this.endDocument();
        }
    }

    public void startDocument() throws DataModelException {
        if (this.attrNames == null) {
            this.reset();
        }
        this.startDocumentDone = true;
    }

    public void endDocument() throws DataModelException {
        this.endDocumentDone = true;
    }

    public void startElement(QName qName) throws DataModelException {
        if (!this.startDocumentDone) {
            this.startDocument();
            this.startDocumentDone = true;
        }
        if (this.trace) {
            System.err.println("--- start elem " + qName);
        }
        this.docStarted = true;
        if (this.elementStarted) {
            this.flushElement(false);
        }
        if (this.depth >= this.nsCounts.length) {
            int[] nArray = this.nsCounts;
            this.nsCounts = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, this.nsCounts, 0, nArray.length);
        }
        this.nsCounts[this.depth++] = this.nsCnt;
        this.nsCnt = 0;
        this.attrCnt = 0;
        this.tagName = qName;
        this.elementStarted = true;
        this.spaceNeeded = false;
    }

    public void namespace(String string, String string2) throws DataModelException {
        if (this.trace) {
            System.err.println("--- namespace " + string + " = " + string2);
        }
        this.prefixes.addMapping(string, string2);
        ++this.nsCnt;
        if (!this.elementStarted) {
            this.text(string + " = " + string2);
        }
    }

    public void attribute(QName qName, String string) throws DataModelException {
        if (this.trace) {
            System.err.println("--- attribute " + qName + " = " + string);
        }
        if (!this.elementStarted) {
            this.text(qName + " = " + string);
            return;
        }
        int n = 0;
        while (n < this.attrCnt) {
            if (this.attrNames[n] == qName) {
                this.attrValues[n] = string;
                return;
            }
            ++n;
        }
        if (this.attrNames == null) {
            System.err.println("***** oh le null");
            return;
        }
        if (this.attrCnt >= this.attrNames.length) {
            QName[] qNameArray = this.attrNames;
            this.attrNames = new QName[qNameArray.length * 2];
            System.arraycopy(qNameArray, 0, this.attrNames, 0, qNameArray.length);
            String[] stringArray = this.attrValues;
            this.attrValues = new String[stringArray.length * 2];
            System.arraycopy(stringArray, 0, this.attrValues, 0, stringArray.length);
        }
        this.attrNames[this.attrCnt] = qName;
        this.attrValues[this.attrCnt] = string;
        ++this.attrCnt;
    }

    public void endElement(QName qName) throws DataModelException {
        if (this.trace) {
            System.err.println("--- end elem " + qName);
        }
        this.prefixes.removeMappings(this.nsCnt);
        if (this.depth == 0) {
            throw new RuntimeException("no open element " + qName);
        }
        this.nsCnt = this.nsCounts[--this.depth];
        this.spaceNeeded = false;
    }

    public String resolvePrefix(String string) {
        Namespace namespace = this.prefixes.convertToNamespace(string);
        return namespace == null ? null : namespace.getURI();
    }

    public void traverse(Node node, boolean bl) throws DataModelException {
        switch (node.getNature()) {
            case 1: {
                this.startDocument();
                NodeSequence nodeSequence = node.children();
                while (nodeSequence.nextNode()) {
                    this.traverse(nodeSequence.currentNode(), bl);
                }
                this.endDocument();
                break;
            }
            case 2: {
                Node node2;
                NodeSequence nodeSequence;
                this.startElement(node.getNodeName());
                if (node.getDefinedNSCount() > 0 || bl) {
                    nodeSequence = node.namespaces(bl);
                    while (nodeSequence.nextNode()) {
                        node2 = nodeSequence.currentNode();
                        this.namespace(node2.getNodeName().getLocalName(), node2.getStringValue());
                    }
                }
                nodeSequence = node.attributes();
                while (nodeSequence.nextNode()) {
                    node2 = nodeSequence.currentNode();
                    this.attribute(node2.getNodeName(), node2.getStringValue());
                }
                nodeSequence = node.children();
                while (nodeSequence.nextNode()) {
                    this.traverse(nodeSequence.currentNode(), false);
                }
                this.endElement(node.getNodeName());
                break;
            }
            case 4: {
                this.text(node.getStringValue());
                break;
            }
            case 5: {
                this.pi(node.getNodeName().toString(), node.getStringValue());
                break;
            }
            case 6: {
                this.comment(node.getStringValue());
                break;
            }
            case 3: {
                this.attribute(node.getNodeName(), node.getStringValue());
                break;
            }
            case 7: {
                this.namespace(node.getNodeName().getLocalName(), node.getStringValue());
                break;
            }
            default: {
                System.err.println("illegal node kind " + node.getNature() + " " + node);
            }
        }
    }
}

