/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import net.xfra.qizxopen.util.WordExtractor;

public class DefaultWordExtractor
implements WordExtractor {
    char[] text;
    int length;
    int ptr;
    int wordStart;
    char[] mapping;
    byte[] charType;

    public DefaultWordExtractor() {
        this.setKeepAccents(false);
    }

    public void start(char[] cArray, int n) {
        this.text = cArray;
        this.length = n;
        this.ptr = 0;
    }

    public boolean isWordStart(char c) {
        return c >= '\u00c0' ? true : this.charType[c] > 1;
    }

    public boolean isWordPart(char c) {
        return c >= '\u00c0' ? true : this.charType[c] > 0;
    }

    public char mapChar(char c) {
        return c >= this.mapping.length ? c : this.mapping[c];
    }

    public char[] nextWord() {
        while (this.ptr < this.length) {
            char c = this.text[this.ptr];
            if (this.isWordStart(c)) {
                this.wordStart = this.ptr;
                int n = this.ptr + 1;
                while (n < this.length) {
                    char c2 = this.text[n];
                    if (!this.isWordPart(c2) && (c2 != '.' || n >= this.length - 1 || Character.isWhitespace(this.text[n + 1]))) break;
                    ++n;
                }
                this.ptr = n;
                if (n - this.wordStart > 1) {
                    char[] cArray = new char[n - this.wordStart];
                    int n2 = cArray.length;
                    while (--n2 >= 0) {
                        cArray[n2] = this.mapChar(this.text[this.wordStart + n2]);
                    }
                    return cArray;
                }
            }
            ++this.ptr;
        }
        return null;
    }

    public char charAt(int n) {
        return this.ptr + n >= this.length ? (char)'\u0000' : this.text[this.ptr + n];
    }

    public char nextChar() {
        if (this.ptr >= this.length) {
            return '\u0000';
        }
        ++this.ptr;
        return this.charAt(0);
    }

    public int wordOffset() {
        return this.wordStart;
    }

    public int wordLength() {
        return this.ptr - this.wordStart;
    }

    private final void mapRange(int n, int n2, char c) {
        while (n <= n2) {
            this.mapping[n] = c;
            ++n;
        }
    }

    public void setKeepAccents(boolean bl) {
        this.charType = new byte[192];
        int n = 48;
        while (n <= 57) {
            this.charType[n] = 2;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            this.charType[n2 + 32] = 2;
            this.charType[n2] = 2;
            ++n2;
        }
        this.charType[95] = 2;
        this.charType[45] = 1;
        this.mapping = new char[768];
        int n3 = 0;
        while (n3 < this.mapping.length) {
            char c = this.mapping[n3] = Character.toLowerCase((char)n3);
            ++n3;
        }
        if (bl) {
            return;
        }
        this.mapRange(192, 197, 'a');
        this.mapping[198] = 230;
        this.mapping[199] = 99;
        this.mapRange(200, 203, 'e');
        this.mapRange(204, 207, 'i');
        this.mapping[209] = 110;
        this.mapRange(210, 216, 'o');
        this.mapRange(217, 220, 'u');
        this.mapping[221] = 121;
        this.mapRange(224, 229, 'a');
        this.mapping[231] = 99;
        this.mapRange(232, 235, 'e');
        this.mapRange(236, 239, 'i');
        this.mapping[240] = 208;
        this.mapping[241] = 110;
        this.mapRange(242, 248, 'o');
        this.mapRange(249, 252, 'u');
        this.mapping[253] = 121;
        this.mapping[254] = 222;
        this.mapping[255] = 121;
        this.mapRange(256, 261, 'a');
        this.mapRange(262, 269, 'c');
        this.mapRange(270, 273, 'd');
        this.mapRange(274, 283, 'e');
        this.mapRange(284, 291, 'g');
        this.mapRange(292, 295, 'h');
        this.mapRange(296, 305, 'i');
        this.mapping[307] = 306;
        this.mapRange(308, 309, 'j');
        this.mapRange(310, 311, 'k');
        this.mapRange(313, 322, 'l');
        this.mapRange(323, 329, 'n');
        this.mapRange(332, 337, 'o');
        this.mapRange(340, 345, 'r');
        this.mapRange(346, 353, 's');
        this.mapRange(354, 359, 't');
        this.mapRange(360, 371, 'u');
        this.mapRange(372, 373, 'w');
        this.mapRange(374, 376, 'y');
        this.mapRange(377, 382, 'z');
        this.mapping[383] = 115;
        this.mapRange(384, 387, 'b');
        this.mapping[390] = 111;
        this.mapRange(391, 392, 'c');
        this.mapRange(393, 396, 'd');
        this.mapping[398] = 101;
        this.mapping[400] = 101;
        this.mapping[401] = 102;
        this.mapping[402] = 102;
        this.mapping[403] = 103;
        this.mapping[407] = 105;
        this.mapping[408] = 107;
        this.mapping[409] = 107;
        this.mapping[410] = 108;
        this.mapping[412] = 109;
        this.mapping[413] = 110;
        this.mapping[414] = 110;
        this.mapping[415] = 111;
        this.mapping[416] = 111;
        this.mapping[417] = 111;
        this.mapping[419] = 418;
        this.mapping[420] = 112;
        this.mapping[421] = 112;
        this.mapping[427] = 116;
        this.mapping[428] = 116;
        this.mapping[429] = 116;
        this.mapping[430] = 116;
        this.mapping[431] = 117;
        this.mapping[432] = 117;
        this.mapping[434] = 118;
        this.mapping[435] = 121;
        this.mapping[436] = 121;
        this.mapping[437] = 122;
        this.mapping[438] = 122;
        this.mapping[440] = 439;
        this.mapping[441] = 439;
        this.mapping[442] = 439;
        this.mapping[461] = 97;
        this.mapping[462] = 97;
        this.mapping[463] = 105;
        this.mapping[464] = 105;
        this.mapping[465] = 111;
        this.mapping[466] = 111;
        this.mapRange(467, 476, 'u');
        this.mapping[477] = 101;
        this.mapping[478] = 97;
        this.mapping[479] = 97;
        this.mapping[480] = 97;
        this.mapping[481] = 97;
        this.mapping[482] = 198;
        this.mapping[483] = 198;
        this.mapping[484] = 103;
        this.mapping[485] = 103;
        this.mapping[486] = 103;
        this.mapping[487] = 103;
        this.mapping[488] = 107;
        this.mapping[489] = 107;
        this.mapping[490] = 111;
        this.mapping[491] = 111;
        this.mapping[492] = 111;
        this.mapping[493] = 111;
        this.mapping[494] = 439;
        this.mapping[495] = 439;
        this.mapping[496] = 106;
        this.mapping[499] = 497;
        this.mapping[500] = 103;
        this.mapping[501] = 103;
        this.mapping[506] = 97;
        this.mapping[507] = 97;
        this.mapping[508] = 198;
        this.mapping[509] = 198;
        this.mapping[510] = 111;
        this.mapping[511] = 111;
        this.mapping[512] = 97;
        this.mapping[513] = 97;
        this.mapping[514] = 97;
        this.mapping[515] = 97;
        this.mapping[516] = 101;
        this.mapping[517] = 101;
        this.mapping[518] = 101;
        this.mapping[519] = 101;
        this.mapping[520] = 105;
        this.mapping[521] = 105;
        this.mapping[522] = 105;
        this.mapping[523] = 105;
        this.mapping[524] = 111;
        this.mapping[525] = 111;
        this.mapping[526] = 111;
        this.mapping[527] = 111;
        this.mapping[528] = 114;
        this.mapping[529] = 114;
        this.mapping[530] = 114;
        this.mapping[531] = 114;
        this.mapping[532] = 117;
        this.mapping[533] = 117;
        this.mapping[534] = 117;
        this.mapping[535] = 117;
        this.mapping[592] = 97;
        this.mapping[595] = 98;
        this.mapping[596] = 111;
        this.mapping[597] = 99;
        this.mapping[598] = 100;
        this.mapping[599] = 100;
        this.mapping[600] = 101;
        this.mapping[603] = 101;
        this.mapping[604] = 101;
        this.mapping[605] = 101;
        this.mapping[606] = 101;
        this.mapping[607] = 106;
        this.mapping[608] = 103;
        this.mapping[609] = 103;
        this.mapping[610] = 103;
        this.mapping[613] = 104;
        this.mapping[614] = 104;
        this.mapping[616] = 105;
        this.mapping[618] = 105;
        this.mapping[619] = 108;
        this.mapping[620] = 108;
        this.mapping[621] = 108;
        this.mapping[623] = 109;
        this.mapping[624] = 109;
        this.mapping[625] = 109;
        this.mapping[626] = 110;
        this.mapping[627] = 110;
        this.mapping[628] = 110;
        this.mapping[629] = 111;
        this.mapping[630] = 338;
        this.mapping[633] = 114;
        this.mapping[634] = 114;
        this.mapping[635] = 114;
        this.mapping[636] = 114;
        this.mapping[637] = 114;
        this.mapping[638] = 114;
        this.mapping[639] = 114;
        this.mapping[640] = 114;
        this.mapping[641] = 114;
        this.mapping[642] = 115;
        this.mapping[644] = 106;
        this.mapping[647] = 116;
        this.mapping[648] = 116;
        this.mapping[649] = 117;
        this.mapping[651] = 118;
        this.mapping[652] = 118;
        this.mapping[653] = 119;
        this.mapping[654] = 122;
        this.mapping[655] = 121;
        this.mapping[656] = 122;
        this.mapping[657] = 122;
        this.mapping[658] = 439;
        this.mapping[659] = 439;
        this.mapping[663] = 99;
        this.mapping[665] = 98;
        this.mapping[666] = 101;
        this.mapping[667] = 103;
        this.mapping[668] = 104;
    }

    public static void main(String[] stringArray) {
        DefaultWordExtractor defaultWordExtractor = new DefaultWordExtractor();
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-a")) {
                    defaultWordExtractor.setKeepAccents(true);
                } else {
                    char[] cArray = stringArray[n].toCharArray();
                    defaultWordExtractor.start(cArray, cArray.length);
                    char[] cArray2 = defaultWordExtractor.nextWord();
                    while (cArray2 != null) {
                        System.out.println(new String(cArray2));
                        cArray2 = defaultWordExtractor.nextWord();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

