/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.dt.WrappedObjectValue;

public class ObjectArraySequence
extends GenericValue {
    protected Object[] items;
    protected int size;
    protected int index = -1;

    public ObjectArraySequence(Object[] objectArray, int n) {
        this.items = objectArray;
        this.size = n;
    }

    public ObjectArraySequence(Vector vector) {
        this.items = vector.toArray();
        this.size = this.items.length;
    }

    public ObjectArraySequence(ArrayList arrayList) {
        this.items = arrayList.toArray();
        this.size = this.items.length;
    }

    public ObjectArraySequence(Enumeration enumeration) {
        Object[] objectArray = new Object[4];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (n >= objectArray.length) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[objectArray2.length * 2];
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            }
            objectArray[n++] = enumeration.nextElement();
        }
        this.items = objectArray;
        this.size = n;
    }

    public boolean next() throws XQueryException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = this.items[this.index] instanceof String ? new SingleString((String)this.items[this.index]) : new SingleWrappedObject(this.items[this.index]);
        return true;
    }

    public Value bornAgain() {
        return new ObjectArraySequence(this.items, this.size);
    }

    public static Object[] expand(Value value) throws XQueryException {
        Object[] objectArray;
        Object[] objectArray2 = new Object[8];
        int n = 0;
        while (value.next()) {
            if (n >= objectArray2.length) {
                objectArray = objectArray2;
                objectArray2 = new Object[objectArray.length * 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            }
            objectArray2[n++] = ((WrappedObjectValue)value.asItem()).getObject();
        }
        if (n == objectArray2.length) {
            return objectArray2;
        }
        objectArray = new Object[n];
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        return objectArray;
    }
}

