/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.AtomicType;
import net.xfra.qizxopen.xquery.dt.SingleString;

public class StringType
extends AtomicType {
    public String getShortName() {
        return "string";
    }

    protected boolean checkValue(String string) {
        return true;
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        ItemType itemType = value.getType();
        String string = null;
        try {
            string = value.asString();
        }
        catch (TypeException typeException) {
            throw new TypeException("cannot cast to xs:string: " + typeException.getMessage());
        }
        if (!this.checkValue(string)) {
            throw new TypeException("cannot cast to xs:" + this.getShortName() + ": value does not conform to facets");
        }
        return new SingleString(string, this);
    }
}

