/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.dt.SingleFloat;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

public abstract class Function {
    public Expression staticCheck(StaticContext staticContext, Expression[] expressionArray, Expression expression) {
        return staticContext.resolve(this.getProtos(), expressionArray, expression);
    }

    public QName getName() {
        return this.getProtos()[0].qname;
    }

    public abstract Prototype[] getProtos();

    public static abstract class TreeCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Node node = this.evalAsNode(focus, evalContext);
            return node == null ? Value.empty : new SingleNode(node);
        }

        public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
            EventDrivenBuilder eventDrivenBuilder = new EventDrivenBuilder();
            this.evalAsEvents(eventDrivenBuilder, focus, evalContext);
            return eventDrivenBuilder.crop();
        }

        public abstract void evalAsEvents(XMLEventReceiver var1, Focus var2, EvalContext var3) throws XQueryException;
    }

    public static abstract class OptStringCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.evalAsOptString(focus, evalContext);
            return string == null ? Value.empty : new SingleString(string);
        }

        public abstract String evalAsOptString(Focus var1, EvalContext var2) throws XQueryException;

        public String evalAsString(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.evalAsOptString(focus, evalContext);
            if (string == null) {
                evalContext.error((Expression)this, "unexpected empty sequence");
            }
            return string;
        }
    }

    public static abstract class StringCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleString(this.evalAsString(focus, evalContext));
        }

        public abstract String evalAsString(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class DoubleCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleDouble(this.evalAsDouble(focus, evalContext));
        }

        public abstract double evalAsDouble(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class FloatCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleFloat(this.evalAsFloat(focus, evalContext));
        }

        public abstract float evalAsFloat(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class IntegerCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleInteger(this.evalAsInteger(focus, evalContext));
        }

        public abstract long evalAsInteger(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class BoolCall
    extends Call {
        public abstract boolean evalAsBoolean(Focus var1, EvalContext var2) throws XQueryException;

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleBoolean(this.evalAsBoolean(focus, evalContext));
        }

        public boolean evalAsEffectiveBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
            return this.evalAsBoolean(focus, evalContext);
        }
    }

    public static abstract class Call
    extends Expression {
        public Expression[] args;
        public Prototype prototype;

        public boolean visit(Expression.Visitor visitor) {
            return visitor.examine(this) && visitor.visit(this.args);
        }

        public void dump(ExprDump exprDump) {
            exprDump.header(this, "Call " + this.prototype);
            exprDump.display("args", this.args);
        }

        public void compilationHook() {
        }
    }
}

