/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.dt.FloatArraySequence;
import net.xfra.qizxopen.xquery.dt.IntegerArraySequence;
import net.xfra.qizxopen.xquery.dt.ObjectArraySequence;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.dt.SingleFloat;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.dt.StringArraySequence;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.dt.WrappedObjectValue;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.impl.PredefinedModule;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.GlobalVariable;

public class JavaFunction
extends Function {
    Prototype[] prototypes;
    public static boolean trace = false;
    static final int NONE = 0;
    static final int STRING = 1;
    static final int BOOLEAN = 2;
    static final int DOUBLE = 3;
    static final int FLOAT = 4;
    static final int INTEGER = 5;
    static final int INT = 6;
    static final int SHORT = 7;
    static final int BYTE = 8;
    static final int NODE = 9;
    static final int WRAPPED_OBJECT = 10;
    static final int STRING_ARRAY = 11;
    static final int CHAR_ARRAY = 12;
    static final int DOUBLE_ARRAY = 13;
    static final int FLOAT_ARRAY = 14;
    static final int INTEGER_ARRAY = 15;
    static final int INT_ARRAY = 16;
    static final int SHORT_ARRAY = 17;
    static final int BYTE_ARRAY = 18;
    static final int NODE_ARRAY = 19;
    static final int WRAPPED_OBJECT_ARRAY = 20;
    static final int CHAR = 21;
    static final int ENUMERATION = 22;
    static final int VECTOR = 23;
    static final int ARRAYLIST = 24;
    static final Type[] typeTable = new Type[]{Type.NONE, Type.STRING.opt, Type.BOOLEAN, Type.DOUBLE, Type.FLOAT, Type.INTEGER, Type.INT, Type.SHORT, Type.BYTE, Type.NODE.opt, Type.WRAPPED_OBJECT.opt, Type.STRING.star, Type.INTEGER.star, Type.DOUBLE.star, Type.DOUBLE.star, Type.INTEGER.star, Type.INTEGER.star, Type.INTEGER.star, Type.INTEGER.star, Type.NODE.star, Type.WRAPPED_OBJECT.star, Type.INTEGER, Type.WRAPPED_OBJECT.star, Type.WRAPPED_OBJECT.star, Type.WRAPPED_OBJECT.star};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$JavaFunction$Call;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$dm$Node;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$ArrayList;

    static Prototype convertPrototype(QName qName, Method method, QName qName2) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        Prototype prototype = new Prototype(qName, null, method, null);
        prototype.autoArg0 = qName2;
        int n = classArray.length;
        int n2 = 0;
        if (qName2 == null && !Modifier.isStatic(method.getModifiers())) {
            prototype.arg("p0", (Type)Type.WRAPPED_OBJECT);
            ++n;
        }
        prototype.conversions = new int[n];
        if (n > classArray.length) {
            prototype.conversions[n2++] = 10;
        }
        int n3 = 0;
        while (n3 < classArray.length) {
            int n4 = JavaFunction.convertType(classArray[n3]);
            prototype.conversions[n2++] = n4;
            prototype.arg("p" + (n3 + 1), typeTable[n4]);
            ++n3;
        }
        prototype.resultConversion = JavaFunction.convertType(method.getReturnType());
        prototype.returnType = typeTable[prototype.resultConversion];
        return prototype;
    }

    static Prototype convertConstructor(QName qName, Constructor constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return null;
        }
        Class<?>[] classArray = constructor.getParameterTypes();
        Prototype prototype = new Prototype(qName, null, null, constructor);
        prototype.conversions = new int[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            int n2;
            prototype.conversions[n] = n2 = JavaFunction.convertType(classArray[n]);
            prototype.arg("p" + (n + 1), typeTable[n2]);
            ++n;
        }
        prototype.returnType = Type.WRAPPED_OBJECT;
        return prototype;
    }

    public static int convertType(Class clazz) {
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = JavaFunction.class$("java.lang.String")) : class$java$lang$String)) {
            return 1;
        }
        if (clazz == (class$net$xfra$qizxopen$xquery$dm$Node == null ? (class$net$xfra$qizxopen$xquery$dm$Node = JavaFunction.class$("net.xfra.qizxopen.xquery.dm.Node")) : class$net$xfra$qizxopen$xquery$dm$Node)) {
            return 9;
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaFunction.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 2;
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JavaFunction.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 3;
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = JavaFunction.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = JavaFunction.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 5;
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaFunction.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 6;
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = JavaFunction.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 7;
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaFunction.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 8;
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = JavaFunction.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 21;
        }
        if (clazz == Void.TYPE) {
            return 0;
        }
        if (clazz == (class$java$util$Enumeration == null ? (class$java$util$Enumeration = JavaFunction.class$("java.util.Enumeration")) : class$java$util$Enumeration)) {
            return 22;
        }
        if (clazz == (class$java$util$Vector == null ? (class$java$util$Vector = JavaFunction.class$("java.util.Vector")) : class$java$util$Vector)) {
            return 23;
        }
        if (clazz == (class$java$util$ArrayList == null ? (class$java$util$ArrayList = JavaFunction.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return 24;
        }
        if (clazz.isArray()) {
            String string = clazz.getName();
            if (string.equals("[Ljava.lang.String;")) {
                return 11;
            }
            if (string.equals("[Lnet.xfra.qizxopen.xquery.dm.Node;")) {
                return 19;
            }
            if (string.equals("[D")) {
                return 13;
            }
            if (string.equals("[F")) {
                return 14;
            }
            if (string.equals("[J")) {
                return 15;
            }
            if (string.equals("[I")) {
                return 16;
            }
            if (string.equals("[S")) {
                return 17;
            }
            if (string.equals("[B")) {
                return 18;
            }
            if (string.equals("[C")) {
                return 12;
            }
            return 20;
        }
        return 10;
    }

    public static Value convertResult(Object object, int n) {
        if (object == null) {
            return Value.empty;
        }
        switch (n) {
            case 0: {
                return Value.empty;
            }
            case 1: {
                return new SingleString((String)object);
            }
            case 2: {
                return new SingleBoolean((Boolean)object);
            }
            case 3: {
                return new SingleDouble((Double)object);
            }
            case 4: {
                return new SingleFloat(((Float)object).floatValue());
            }
            case 5: {
                return new SingleInteger((Long)object);
            }
            case 6: {
                return new SingleInteger(((Integer)object).intValue(), Type.INT);
            }
            case 7: {
                return new SingleInteger(((Short)object).intValue(), Type.SHORT);
            }
            case 8: {
                return new SingleInteger(((Byte)object).intValue(), Type.BYTE);
            }
            case 21: {
                return new SingleInteger(((Byte)object).intValue(), Type.INTEGER);
            }
            case 9: {
                return new SingleNode((Node)object);
            }
            case 10: {
                return new SingleWrappedObject(object);
            }
            case 11: {
                String[] stringArray = (String[])object;
                return new StringArraySequence(stringArray, stringArray.length);
            }
            case 13: {
                double[] dArray = (double[])object;
                return new FloatArraySequence(dArray, dArray.length);
            }
            case 14: {
                float[] fArray = (float[])object;
                return new FloatArraySequence(fArray, fArray.length);
            }
            case 15: {
                long[] lArray = (long[])object;
                return new IntegerArraySequence(lArray, lArray.length);
            }
            case 16: {
                int[] nArray = (int[])object;
                return new IntegerArraySequence(nArray, nArray.length);
            }
            case 17: {
                short[] sArray = (short[])object;
                return new IntegerArraySequence(sArray, sArray.length);
            }
            case 18: {
                byte[] byArray = (byte[])object;
                return new IntegerArraySequence(byArray, byArray.length);
            }
            case 12: {
                char[] cArray = (char[])object;
                return new IntegerArraySequence(cArray, cArray.length);
            }
            case 19: {
                Object[] objectArray = (Node[])object;
                return objectArray == null ? Value.empty : new ArraySequence(objectArray, objectArray.length);
            }
            case 20: {
                Object[] objectArray = (Object[])object;
                return objectArray == null ? Value.empty : new ObjectArraySequence(objectArray, objectArray.length);
            }
            case 22: {
                return new ObjectArraySequence((Enumeration)object);
            }
            case 23: {
                return new ObjectArraySequence((Vector)object);
            }
            case 24: {
                return new ObjectArraySequence((ArrayList)object);
            }
        }
        throw new IllegalArgumentException("bad result conversion");
    }

    public JavaFunction(Prototype[] prototypeArray, int n) {
        this.prototypes = new Prototype[n];
        System.arraycopy(prototypeArray, 0, this.prototypes, 0, n);
    }

    public net.xfra.qizxopen.xquery.fn.Prototype[] getProtos() {
        return this.prototypes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Call
    extends Function.Call {
        GlobalVariable autoArg0;

        public void dump(ExprDump exprDump) {
            exprDump.header(this, this.getClass().getName());
            exprDump.display("prototype", this.prototype.toString());
            if (this.autoArg0 != null) {
                exprDump.display("auto arg", this.autoArg0);
            }
            exprDump.display("actual arguments", this.args);
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Prototype prototype = (Prototype)this.prototype;
            if (prototype.method != null) {
                boolean bl = Modifier.isStatic(prototype.method.getModifiers()) || this.autoArg0 != null;
                Object object = null;
                if (!bl) {
                    object = this.convertArg(this.args[0], prototype.conversions[0], focus, evalContext);
                } else if (this.autoArg0 != null) {
                    Value value = evalContext.loadGlobal(this.autoArg0);
                    object = ((SingleWrappedObject)value).getObject();
                }
                int n = bl ? prototype.argCnt : prototype.argCnt - 1;
                int n2 = bl ? 0 : 1;
                Object[] objectArray = new Object[n];
                int n3 = 0;
                while (n3 < n) {
                    objectArray[n3] = this.convertArg(this.args[n3 + n2], prototype.conversions[n3 + n2], focus, evalContext);
                    ++n3;
                }
                try {
                    Object object2 = prototype.method.invoke(object, objectArray);
                    if (trace) {
                        System.err.println("calling Java method: " + prototype.method + "\n for " + prototype);
                    }
                    return JavaFunction.convertResult(object2, prototype.resultConversion);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exception exception = (Exception)invocationTargetException.getCause();
                    evalContext.error((Expression)this, new EvalException("exception in extension function: " + exception, exception));
                }
                catch (Exception exception) {
                    evalContext.error((Expression)this, new EvalException("invocation of extension function: " + exception, exception));
                }
            } else {
                Object[] objectArray = new Object[prototype.argCnt];
                int n = 0;
                while (n < prototype.argCnt) {
                    objectArray[n] = this.convertArg(this.args[n], prototype.conversions[n], focus, evalContext);
                    ++n;
                }
                try {
                    if (trace) {
                        System.err.println("calling Java constructor: " + prototype.constructor + "\n for " + prototype);
                    }
                    Object t = prototype.constructor.newInstance(objectArray);
                    return JavaFunction.convertResult(t, 10);
                }
                catch (Exception exception) {
                    evalContext.error((Expression)this, "invocation of extension constructor: " + exception);
                }
            }
            return Value.empty;
        }

        Object convertArg(Expression expression, int n, Focus focus, EvalContext evalContext) throws XQueryException {
            switch (n) {
                case 1: {
                    return expression.evalAsString(focus, evalContext);
                }
                case 2: {
                    return new Boolean(expression.evalAsBoolean(focus, evalContext));
                }
                case 3: {
                    return new Double(expression.evalAsDouble(focus, evalContext));
                }
                case 4: {
                    return new Float(expression.evalAsFloat(focus, evalContext));
                }
                case 5: {
                    return new Long(expression.evalAsInteger(focus, evalContext));
                }
                case 6: {
                    return new Integer((int)expression.evalAsInteger(focus, evalContext));
                }
                case 7: {
                    return new Short((short)expression.evalAsInteger(focus, evalContext));
                }
                case 8: {
                    return new Byte((byte)expression.evalAsInteger(focus, evalContext));
                }
                case 9: {
                    return expression.evalAsNode(focus, evalContext);
                }
                case 10: {
                    Item item = expression.evalAsItem(focus, evalContext);
                    if (item instanceof StringValue) {
                        return ((StringValue)item).asString();
                    }
                    return ((WrappedObjectValue)item).getObject();
                }
                case 21: {
                    return new Character((char)expression.evalAsInteger(focus, evalContext));
                }
                case 11: {
                    return StringArraySequence.expand(expression.eval(focus, evalContext));
                }
                case 13: {
                    return FloatArraySequence.expandDoubles(expression.eval(focus, evalContext));
                }
                case 14: {
                    return FloatArraySequence.expandFloats(expression.eval(focus, evalContext));
                }
                case 15: {
                    return IntegerArraySequence.expandIntegers(expression.eval(focus, evalContext));
                }
                case 16: {
                    return IntegerArraySequence.expandInts(expression.eval(focus, evalContext));
                }
                case 17: {
                    return IntegerArraySequence.expandShorts(expression.eval(focus, evalContext));
                }
                case 18: {
                    return IntegerArraySequence.expandBytes(expression.eval(focus, evalContext));
                }
                case 12: {
                    return IntegerArraySequence.expandChars(expression.eval(focus, evalContext));
                }
                case 19: {
                    return ArraySequence.expandNodes(expression.eval(focus, evalContext));
                }
                case 20: {
                    return ObjectArraySequence.expand(expression.eval(focus, evalContext));
                }
            }
            throw new IllegalArgumentException("bad conversion");
        }
    }

    public static class Plugger
    implements PredefinedModule.FunctionPlugger {
        HashSet allowedClasses;

        public void authorizeClass(String string) {
            if (this.allowedClasses == null) {
                this.allowedClasses = new HashSet();
            }
            this.allowedClasses.add(string);
        }

        public Function plug(QName qName) throws SecurityException {
            Prototype[] prototypeArray;
            String string = qName.getURI();
            if (!string.startsWith("java:")) {
                return null;
            }
            String string2 = string.substring(5);
            QName qName2 = null;
            int n = string2.indexOf(63);
            if (n > 0) {
                int n2 = string2.indexOf(61, n);
                prototypeArray = string2.substring(n + 1, n2);
                String string3 = string2.substring(n2 + 1);
                qName2 = QName.get(string3, (String)prototypeArray);
                string2 = string2.substring(0, n);
            }
            if (this.allowedClasses != null && !this.allowedClasses.contains(string2)) {
                throw new SecurityException("security restriction on class " + string2);
            }
            try {
                Class<?> clazz = Class.forName(string2);
                int n3 = 0;
                String string4 = Util.camelCase(qName.getLocalName(), false);
                if (trace) {
                    System.err.println("found Java class " + clazz + " for function " + string4);
                }
                if (string4.equals("new")) {
                    int n4 = clazz.getModifiers();
                    if (!Modifier.isPublic(n4) || Modifier.isAbstract(n4) || Modifier.isInterface(n4)) {
                        return null;
                    }
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    prototypeArray = new Prototype[constructorArray.length];
                    int n5 = 0;
                    while (n5 < constructorArray.length) {
                        prototypeArray[n3] = JavaFunction.convertConstructor(qName, constructorArray[n5]);
                        if (prototypeArray[n3] != null) {
                            if (trace) {
                                System.err.println("detected constructor " + prototypeArray[n3]);
                            }
                            ++n3;
                        }
                        ++n5;
                    }
                } else {
                    Method[] methodArray = clazz.getMethods();
                    prototypeArray = new Prototype[methodArray.length];
                    int n6 = 0;
                    while (n6 < methodArray.length) {
                        if (methodArray[n6].getName().equals(string4)) {
                            prototypeArray[n3] = JavaFunction.convertPrototype(qName, methodArray[n6], qName2);
                            if (prototypeArray[n3] != null) {
                                if (trace) {
                                    System.err.println("detected method " + prototypeArray[n3]);
                                }
                                ++n3;
                            }
                        }
                        ++n6;
                    }
                }
                if (n3 > 0) {
                    return new JavaFunction(prototypeArray, n3);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (trace) {
                    System.err.println("*** class not found " + string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static class Prototype
    extends net.xfra.qizxopen.xquery.fn.Prototype {
        Method method;
        Constructor constructor;
        int[] conversions;
        int resultConversion;
        QName autoArg0;

        public Prototype(QName qName, Type type, Method method, Constructor constructor) {
            super(qName, type, class$net$xfra$qizxopen$xquery$fn$JavaFunction$Call == null ? (class$net$xfra$qizxopen$xquery$fn$JavaFunction$Call = JavaFunction.class$("net.xfra.qizxopen.xquery.fn.JavaFunction$Call")) : class$net$xfra$qizxopen$xquery$fn$JavaFunction$Call);
            this.method = method;
            this.constructor = constructor;
        }

        public Function.Call newInstance(StaticContext staticContext, Expression[] expressionArray) {
            Call call = (Call)super.newInstance(staticContext, expressionArray);
            if (this.autoArg0 != null && !Modifier.isStatic(this.method.getModifiers())) {
                GlobalVariable globalVariable = staticContext.lookforGlobalVariable(this.autoArg0);
                if (globalVariable == null) {
                    throw new RuntimeException("no such auto arg " + this.autoArg0);
                }
                call.autoArg0 = globalVariable;
            }
            return call;
        }
    }
}

