/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.NodeType;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;

public class UserFunction
extends Function {
    Signature[] protos = new Signature[1];
    Module module;
    int location;
    int localSize;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$UserFunction$Call;

    public UserFunction(Module module, int n) {
        this.module = module;
        this.location = n;
    }

    public Prototype[] getProtos() {
        return this.protos;
    }

    public Signature addPrototype(QName qName) {
        Signature signature = new Signature(qName);
        if (this.protos[0] == null) {
            this.protos[0] = signature;
        } else {
            Signature[] signatureArray = this.protos;
            this.protos = new Signature[signatureArray.length + 1];
            System.arraycopy(signatureArray, 0, this.protos, 0, signatureArray.length);
            this.protos[signatureArray.length] = signature;
        }
        return signature;
    }

    public void dump(ExprDump exprDump) {
        exprDump.println("UserFunction");
        int n = 0;
        while (n < this.protos.length) {
            exprDump.display("proto", this.protos[n].toString());
            exprDump.display("body", this.protos[n].body);
            ++n;
        }
    }

    public void setLocalSize(int n) {
        this.localSize = n;
    }

    public Value eval(Focus focus, EvalContext evalContext) {
        throw new RuntimeException("UserFunction not evaluable");
    }

    public void staticCheck(StaticContext staticContext) {
        LocalVariable localVariable = staticContext.markLocalVariables();
        int n = 0;
        while (n < this.protos.length) {
            Signature signature = this.protos[n];
            signature.argDecls = new LocalVariable[signature.argCnt];
            int n2 = 0;
            while (n2 < signature.argCnt) {
                QName qName = signature.argNames[n2];
                signature.argDecls[n2] = staticContext.defineLocalVariable(qName, signature.argTypes[n2], null);
                ++n2;
            }
            if (signature.body == null) {
                staticContext.getLog().error(this.module, this.location, "external functions not supported this way");
                return;
            }
            signature.body = staticContext.staticCheck(signature.body, 0);
            if (!signature.returnType.accepts(signature.body.getType())) {
                staticContext.error(signature.body, "improper type %1 for returned expression, expecting %2", signature.body.getType().toString(staticContext), signature.returnType.toString(staticContext));
            }
            ++n;
        }
        staticContext.popLocalVariables(localVariable);
    }

    private boolean needsDynamicCheck(Type type) {
        NodeTest nodeTest = null;
        return type instanceof NodeType && (nodeTest = ((NodeType)type).nodeTest) != null && !nodeTest.staticallyCheckable();
    }

    public Expression staticCheck(StaticContext staticContext, Expression[] expressionArray, Expression expression) {
        Call call = (Call)staticContext.resolve(this.protos, expressionArray, expression);
        call.def = this;
        Signature signature = (Signature)call.prototype;
        call.argChecks = new Type[expressionArray.length];
        int n = Math.min(expressionArray.length, signature.argCnt);
        int n2 = 0;
        while (n2 < n) {
            Type type = signature.argTypes[n2];
            Type type2 = expressionArray[n2].getType();
            boolean bl = this.needsDynamicCheck(type.getItemType());
            if (type2.getOccurrence() == 0 && bl) {
                call.argChecks[n2] = type;
            }
            if (type.getOccurrence() != 3 || bl) {
                call.argChecks[n2] = type;
            }
            ++n2;
        }
        return call;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Call
    extends Function.Call {
        UserFunction def;
        Expression body;
        Type[] argChecks;
        LocalVariable[] argDecls;

        public void dump(ExprDump exprDump) {
            exprDump.header(this, this.getClass().getName());
            exprDump.display("prototype", this.prototype.toString());
            exprDump.display("localSize", "" + this.getLocalSize());
            exprDump.display("actual arguments", this.args);
        }

        public int getLocalSize() {
            return this.def.localSize;
        }

        protected EvalContext createContext(Focus focus, EvalContext evalContext) throws XQueryException {
            EvalContext evalContext2 = evalContext.subContext(this);
            Type[] typeArray = this.prototype.argTypes;
            if (this.body == null) {
                Signature signature = (Signature)this.prototype;
                this.body = signature.body;
                this.argDecls = signature.argDecls;
            }
            int n = 0;
            while (n < this.args.length) {
                try {
                    evalContext2.storeLocal(this.argDecls[n].address, this.args[n], this.argChecks[n], focus, evalContext);
                }
                catch (TypeException typeException) {
                    evalContext.error(this.args[n], "type mismatch on argument '" + this.prototype.argNames[n] + "' of function " + this.prototype.displayName(evalContext.getStaticContext()) + " : " + typeException.getMessage());
                }
                ++n;
            }
            evalContext.at(this);
            return evalContext2;
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            evalContext.at(this);
            EvalContext evalContext2 = this.createContext(focus, evalContext);
            Value value = this.body.eval(null, evalContext2);
            return value;
        }

        public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
            evalContext.at(this);
            EvalContext evalContext2 = this.createContext(focus, evalContext);
            this.body.evalAsEvents(xMLEventReceiver, null, evalContext2);
        }

        public long evalAsInteger(Focus focus, EvalContext evalContext) throws XQueryException {
            EvalContext evalContext2 = this.createContext(focus, evalContext);
            return this.body.evalAsInteger(null, evalContext2);
        }

        public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            EvalContext evalContext2 = this.createContext(focus, evalContext);
            return this.body.evalAsDouble(null, evalContext2);
        }
    }

    public static class Signature
    extends Prototype {
        public Expression body;
        LocalVariable[] argDecls;

        Signature(QName qName) {
            super(qName, Type.ANY, class$net$xfra$qizxopen$xquery$fn$UserFunction$Call == null ? (class$net$xfra$qizxopen$xquery$fn$UserFunction$Call = UserFunction.class$("net.xfra.qizxopen.xquery.fn.UserFunction$Call")) : class$net$xfra$qizxopen$xquery$fn$UserFunction$Call);
        }
    }
}

