/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.impl.Module;

public abstract class Expression {
    public Module module;
    public int location;
    protected Type type = Type.ANY;
    public static final int WITHIN_SUBTREE = 1;
    public static final int WITHIN_NODE = 2;
    public static final int SAME_DEPTH = 4;
    public static final int DOCUMENT_ORDER = 8;
    public static final int UNORDERED = 16;
    public static final int CONSTANT = 32;
    public static final int NUMERIC = 64;

    public void dump(ExprDump exprDump) {
        exprDump.println(this.getClass().getName());
    }

    public Expression atSamePlaceAs(Expression expression) {
        this.module = expression.module;
        this.location = expression.location;
        return this;
    }

    public static Expression[] addExpr(Expression[] expressionArray, Expression expression) {
        Expression[] expressionArray2 = new Expression[expressionArray.length + 1];
        System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
        expressionArray2[expressionArray.length] = expression;
        return expressionArray2;
    }

    public Expression staticCheck(StaticContext staticContext) {
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getFlags() {
        return 0;
    }

    protected void checkFocus(Focus focus, EvalContext evalContext) throws EvalException {
        if (focus == null) {
            evalContext.error(this, "no context item");
        }
    }

    public abstract boolean visit(Visitor var1);

    public Expression findSubExpression(Class clazz) {
        Finder finder = new Finder(clazz);
        this.visit(finder);
        return finder.found;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        throw new XQueryException(this.getClass() + " evaluation not implemented");
    }

    public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, new TypeException("unexpected empty sequence"));
            }
            boolean bl = value.asBoolean();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return bl;
        }
        catch (EmptyException emptyException) {
            evalContext.error(this, new TypeException("unexpected empty sequence"));
            return false;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return false;
        }
    }

    public boolean evalEffectiveBooleanValue(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                return false;
            }
            boolean bl = value.asBoolean();
            return value.next() ? true : bl;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return false;
        }
    }

    public long evalAsInteger(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, new TypeException("unexpected empty sequence"));
            }
            long l = value.asInteger();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return l;
        }
        catch (EmptyException emptyException) {
            evalContext.error(this, new TypeException("unexpected empty sequence"));
            return 0L;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return 0L;
        }
    }

    public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                throw EmptyException.allowed();
            }
            long l = value.asInteger();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return l;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return 0L;
        }
    }

    public float evalAsFloat(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, new TypeException("unexpected empty sequence"));
            }
            float f = value.asFloat();
            if (value.next()) {
                evalContext.error(this, "too many items");
            }
            return f;
        }
        catch (EmptyException emptyException) {
            evalContext.error(this, new TypeException("unexpected empty sequence"));
            return 0.0f;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return 0.0f;
        }
    }

    public float evalAsOptFloat(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                throw EmptyException.allowed();
            }
            float f = value.asFloat();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return f;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return 0.0f;
        }
    }

    public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, "unexpected empty sequence");
            }
            double d = value.asDouble();
            if (value.next()) {
                evalContext.error(this, "too many items");
            }
            return d;
        }
        catch (EmptyException emptyException) {
            evalContext.error(this, new TypeException("unexpected empty sequence"));
            return 0.0;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return 0.0;
        }
    }

    public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                throw EmptyException.allowed();
            }
            double d = value.asDouble();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return d;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return 0.0;
        }
    }

    public String evalAsString(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, new TypeException("unexpected empty sequence"));
            }
            String string = value.asString();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return string;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return null;
        }
    }

    public String evalAsOptString(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                return null;
            }
            String string = value.asString();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return string;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return null;
        }
    }

    public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, new TypeException("unexpected empty sequence"));
            }
            Node node = value.asNode();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return node;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return null;
        }
    }

    public Node evalAsOptNode(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                return null;
            }
            Node node = value.asNode();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return node;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return null;
        }
    }

    public Item evalAsItem(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                evalContext.error(this, new TypeException("unexpected empty sequence"));
            }
            Item item = value.asItem();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return item;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return null;
        }
    }

    public Item evalAsOptItem(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            Value value = this.eval(focus, evalContext);
            if (!value.next()) {
                return null;
            }
            Item item = value.asItem();
            if (value.next()) {
                evalContext.error(this, new TypeException("too many items"));
            }
            return item;
        }
        catch (TypeException typeException) {
            evalContext.error(this, typeException);
            return null;
        }
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        Value value = this.eval(focus, evalContext);
        try {
            boolean bl = false;
            while (value.next()) {
                if (value.isNode()) {
                    xMLEventReceiver.traverse(value.asNode(), true);
                    continue;
                }
                xMLEventReceiver.atom(value.asString());
            }
        }
        catch (DataModelException dataModelException) {
            evalContext.error(this, "error in constructor: " + dataModelException.getMessage());
        }
    }

    private static class Finder
    extends Visitor {
        Class searched;
        Expression found = null;

        Finder(Class clazz) {
            this.searched = clazz;
        }

        public boolean examine(Expression expression) {
            if (expression.getClass().isAssignableFrom(this.searched)) {
                this.found = expression;
                return false;
            }
            return true;
        }
    }

    public static abstract class Visitor {
        public abstract boolean examine(Expression var1);

        public boolean visit(Expression[] expressionArray) {
            int n = 0;
            while (n < expressionArray.length) {
                if (expressionArray[n] != null && !expressionArray[n].visit(this)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

