/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.time.Date;
import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.Time;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleDecimal;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NumericOp;

public class PlusOp
extends NumericOp {
    static Prototype[] protos = new Prototype[]{Prototype.op("+", Type.DOUBLE, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecD")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD).hidden().arg("op1", (Type)Type.DOUBLE).arg("op2", (Type)Type.UNTYPED_ATOMIC), Prototype.op("+", Type.DOUBLE, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecD")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD).hidden().arg("op1", (Type)Type.UNTYPED_ATOMIC).arg("op2", (Type)Type.DOUBLE), Prototype.op("+", Type.INTEGER, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecI == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecI = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecI")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecI).arg("op1", (Type)Type.INTEGER).arg("op2", (Type)Type.INTEGER), Prototype.op("+", Type.DECIMAL, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDec == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDec = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecDec")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDec).arg("op1", (Type)Type.DECIMAL).arg("op2", (Type)Type.DECIMAL), Prototype.op("+", Type.FLOAT, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecF == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecF = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecF")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecF).arg("op1", (Type)Type.FLOAT).arg("op2", (Type)Type.FLOAT), Prototype.op("+", Type.DOUBLE, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecD")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD).arg("op1", (Type)Type.DOUBLE).arg("op2", (Type)Type.DOUBLE), Prototype.op("+", Type.DATE_TIME, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecTime")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime).arg("d", (Type)Type.DATE_TIME).arg("seconds", (Type)Type.DOUBLE), Prototype.op("+", Type.TIME, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecTime")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime).arg("t", (Type)Type.TIME).arg("seconds", (Type)Type.DOUBLE), Prototype.op("+", Type.DATE, class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDate == null ? (class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDate = PlusOp.class$("net.xfra.qizxopen.xquery.op.PlusOp$ExecDate")) : class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDate).arg("d", (Type)Type.DATE).arg("days", (Type)Type.INTEGER)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$PlusOp$ExecD;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$PlusOp$ExecI;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDec;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$PlusOp$ExecF;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$PlusOp$ExecTime;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$PlusOp$ExecDate;

    public PlusOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Prototype[] getProtos() {
        return protos;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "Op +");
        exprDump.display("expr1", this.operands[0]);
        exprDump.display("expr2", this.operands[1]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ExecDate
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            evalContext.at(this);
            Item item = this.args[0].evalAsOptItem(focus, evalContext);
            if (item == null) {
                return Value.empty;
            }
            long l = this.args[1].evalAsInteger(focus, evalContext);
            DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
            try {
                return new SingleMoment(new Date(dateTimeBase.addSeconds(86400L * l)), Type.DATE);
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error((Expression)this, dateTimeException.getMessage());
                return null;
            }
        }
    }

    public static class ExecTime
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            evalContext.at(this);
            Item item = this.args[0].evalAsOptItem(focus, evalContext);
            if (item == null) {
                return Value.empty;
            }
            double d = this.args[1].evalAsDouble(focus, evalContext);
            DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
            DateTimeBase dateTimeBase2 = dateTimeBase.addSeconds(d);
            try {
                if (item.getType() == Type.TIME) {
                    dateTimeBase2 = new Time(dateTimeBase2);
                }
                return new SingleMoment(dateTimeBase2, item.getType());
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error((Expression)this, dateTimeException.getMessage());
                return null;
            }
        }
    }

    public static class ExecDec
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Value value = this.args[0].eval(focus, evalContext);
            Value value2 = this.args[1].eval(focus, evalContext);
            evalContext.at(this);
            return new SingleDecimal(value.asDecimal().add(value2.asDecimal()));
        }
    }

    public static class ExecD
    extends Function.DoubleCall {
        public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            double d = this.args[0].evalAsDouble(focus, evalContext);
            double d2 = this.args[1].evalAsDouble(focus, evalContext);
            evalContext.at(this);
            return d + d2;
        }
    }

    public static class ExecF
    extends Function.FloatCall {
        public float evalAsFloat(Focus focus, EvalContext evalContext) throws XQueryException {
            float f = this.args[0].evalAsFloat(focus, evalContext);
            float f2 = this.args[1].evalAsFloat(focus, evalContext);
            evalContext.at(this);
            return f + f2;
        }
    }

    public static class ExecI
    extends Function.IntegerCall {
        public long evalAsInteger(Focus focus, EvalContext evalContext) throws XQueryException {
            long l = this.args[0].evalAsInteger(focus, evalContext);
            long l2 = this.args[1].evalAsInteger(focus, evalContext);
            evalContext.at(this);
            if (!Conversion.isIntegerRange((double)l + (double)l2)) {
                evalContext.error((Expression)this, "integer overflow");
            }
            return l + l2;
        }
    }
}

