/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.app;

import net.xfra.qizxopen.util.CLOptions;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.fn.JavaFunction;

import java.io.*;
import java.net.URL;

import javax.xml.transform.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;
//import javax.xml.parsers.*;
import org.xml.sax.*;

/**
 *	Simple test of SAXXQueryProcessor.
 *	
 */
public class XQT extends SAXXQueryProcessor
{
    // options:
    public String  queryFile;
    public String  styleSheet;
    public String  baseURI;
    public String  modules = ".";
    public String  inputURI = null;
    public String  output = "out.xml";
    public String[] globals = new String[0];
    public String[] appargs = new String[0];
    public String  timezone;
    public String  collation;

    Log log = new Log();	// writes to System.err
    PrintWriter stderr = new PrintWriter(System.err, true);

    XQT() {
    }

    static public void main( String args[] )
    {
	CLOptions options = new CLOptions("XQT");
	options.declare("-sheet", "styleSheet", CLOptions.NEXT_ARG,
			"XSLT style sheet used as second stage");
	options.declare("-baseURI", CLOptions.NEXT_ARG, "default base URI for documents and modules");
	options.declare("-modules", CLOptions.NEXT_ARG, "base URI for resolving module locations");
	options.declare("-input", "inputURI", CLOptions.NEXT_ARG, "URI for input()");
	options.declare("-D", "globals", CLOptions.STICKY_ARG,
			"variable_name=value!initialize a global variable defined in the query.");
	options.declare("-out", "output", CLOptions.NEXT_ARG, "output file (defaults to standard output)");
	options.declare("-timezone", CLOptions.NEXT_ARG, "implicit timezone in duration format");
	options.declare("-collation", CLOptions.NEXT_ARG, "default collation");
	options.declare("--", "appargs", CLOptions.ALL_ARG,
			"pass all following arguments to XQuery processor in variable 'arguments'");
	options.declare("-help", null, CLOptions.HELP_ARG, "print this help");
	options.argument("<query file>", "queryFile", 0,
			 "a file containing a query to execute. if '-', use standard input.\n"+
			 "               If absent, enter interactive mode.");

        try {
	    TransformerFactory factory = TransformerFactory.newInstance();
	    XQT app = new XQT(); 
	    
	    options.parse(args, app);
	    app.setModuleManager( new ModuleManager(app.modules) );
	    app.setDocumentManager( new DocumentManager(app.baseURI) );
	    app.initGlobal(QName.get("arguments"), app.appargs);

	    if(app.queryFile == null || app.styleSheet == null) {
		options.printHelp(System.err);
		System.exit(1);
	    }
	    else {
		long start = System.currentTimeMillis();
		Templates ssheet = factory.newTemplates (
		            new StreamSource( new File( app.styleSheet).getAbsoluteFile ()));
		System.err.println(" xslt compilation: "+ (System.currentTimeMillis() - start));

		start = System.currentTimeMillis();
		FileOutputStream stream = new FileOutputStream (app.output);
		StreamResult target = new StreamResult (stream);
		Transformer processor = ssheet.newTransformer();

		Log log = new Log();
		Query query = app.compileQuery( new File(app.queryFile), log );
		app.setQuery(query);

		InputSource input = null;
		if(app.inputURI != null)
		    input = new InputSource(app.inputURI);
		processor.transform (new SAXSource(app, input), target);
		System.err.println(" total running time: "+ (System.currentTimeMillis() - start));
	    }   
        } catch (CLOptions.Exception e) {
	    System.exit(1);
        } catch (Exception e) {
	    
            e.printStackTrace();
	    System.exit(1);
        }
    }

} // end of class XQT

