/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 *  Implementation of function qizx:catch-error( expr, fallback ).
 *
 */
public class QizxCatchError extends Function {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "catch-error");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.ANY, Exec.class)
	    .arg("expr", Type.ANY) .arg("fallback", Type.ANY)
    };

    public Prototype[] getProtos() { return protos; }

    public Expression  staticCheck( StaticContext context, Expression[] arguments,
				    Expression subject )
    {
        Expression res = context.resolve(getProtos(), arguments, subject);
	if(arguments.length == 2)
	    res.setType( arguments[0].getType().unionWith( arguments[1].getType() ));
	return res;
    }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    try {
		return args[0].eval( focus, context );
	    }
	    catch (EvalException e) {
		//Log log = context.getStaticContext().getLog();
		//log.trace( module, location, "caught "+ e.getMessage(), null);
		return args[1].eval( focus, context );
	    }
        }
    }
}
