/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.text.NumberFormat;
import java.text.ParsePosition;

/**
 *	Converts a number using a locale or a Java NumberFormat.
 */
public class DefaultNumberConverter implements NumberConverter
{
    NumberFormat format;
    ParsePosition position = new ParsePosition(0);
    //TODO option tout ou bien accepter prefixe, si oui quels chars peuvent suivre
    int maxSuffix = 2;

    /**
     * Uses the default locale.
     */
    public DefaultNumberConverter() {
	format = NumberFormat.getInstance();
    }

    /**
     *	General case: use a NumberFormat.
     */
    public DefaultNumberConverter(NumberFormat format) {
	this.format = format;
    }

    public double convert( String value ) {
	position.setIndex(0);
	Number n = format.parse(value, position);
	if( n == null || 
	    position.getIndex() < value.length() - maxSuffix )
	    return Double.NaN;
	return n.doubleValue();
    }

} // end of class DefaultNumberConverter
