/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
/*
 * Copyright (c) 2001-2002 Pixware. 
 *
 * Author: Hussein Shafie
 *
 */
package net.xfra.qizxopen.util;

import java.util.Hashtable;

public final class Namespace
{
    private static Hashtable namespaces = new Hashtable();

    public static Namespace NONE  = get("");
    public static Namespace XML   = get("http://www.w3.org/XML/1998/namespace");
    public static Namespace XLINK = get("http://www.w3.org/1999/xlink");
    public static Namespace XSLT  = get("http://www.w3.org/1999/XSL/Transform");
    public static Namespace XSL   = get("http://www.w3.org/1999/XSL/Format");
    public static Namespace XSD   = get("http://www.w3.org/2001/XMLSchema");
    public static Namespace XSI   = get("http://www.w3.org/2001/XMLSchema-instance");
    public static Namespace FN    = get("http://www.w3.org/2003/05/xquery-functions");
    public static Namespace OP    = get("http://www.w3.org/2003/05/xquery-operators");
    public static Namespace XDT   = get("http://www.w3.org/2003/11/xpath-datatypes");

    private String uri;

    public static Namespace get(String uri) {
	if (uri == null)
	    throw new IllegalArgumentException("null uri");

	Namespace ns = (Namespace) namespaces.get(uri);
	if (ns == null) {
	    ns = new Namespace(uri);
	    namespaces.put(uri, ns);
	}

	return ns;
    }

    private Namespace(String uri) {
	this.uri = uri;
    }

    public String getURI() {
	return uri;
    }

    public boolean equals(Object other) {
	return (other == this);
    }

    public int hashCode() {
	return System.identityHashCode(this);
    }

    public String toString() {
	return uri;
    }

    public int compareTo(Namespace other) {
	return uri.compareTo(other.uri);
    }
}

