/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;
import java.nio.charset.Charset;
import java.nio.ByteBuffer;
import java.net.URL;
import java.net.URI;
import java.net.MalformedURLException;
import java.io.File;
import java.io.IOException;

/**
 *	
 *	
 */
public class Util
{
    public static void printf(char[] buffer) {
	fprintf(System.out, buffer);
    }

    public static void fprintf(java.io.PrintStream out, char[] buffer) {
	for(int i = 0; i < buffer.length; i++)
	    if(buffer[i] < ' ')
		 out.print("&"+(int)buffer[i]+";");
	    else out.print(buffer[i]);
    }

    final static char hexDigits[] = {
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

    public static String toHex( int h, int minDigit ) {
	char [] digits = new char[8];
	int d = 7;
	do {
	    digits[d --] = hexDigits[ h & 0xf ];
	    h >>= 4;
	    -- minDigit;
	} while(h != 0 || minDigit > 0);
	return new String(digits, d + 1, 7 - d);
    }

    public static int comparison( int diff ) {
	return diff < 0 ? -1 : diff > 0 ? 1 : 0;
    }

    public static int comparison( double diff ) {
	return diff < 0 ? -1 : diff > 0 ? 1 : 0;
    }

    /**
     *	Converts a name to 'camelCase': hyphens are removed,
     *	letters following hyphens are converted to uppercase.
     *	Initial letter converted to uppercase if 'capitalize'.
     *	eg: this-to-that becomes ThisToThat
     */
    public static String camelCase( String name, boolean capitalize ) {
	StringBuffer n = new StringBuffer(name.length());
	n.append( capitalize? Character.toUpperCase(name.charAt(0)) : name.charAt(0));
	for(int i = 1, L = name.length(); i < L; i++) {
	    char c = name.charAt(i);
	    if(c != '-') 
		n.append(c);
	    else if(++i < L)
		n.append( Character.toUpperCase(name.charAt(i)) );
	}
	return n.toString();
    }

    

    /**
     *	Converts a relative or absolute path or an uri to an absolute URL
     */
    public static URL uriToURL( String uri ) throws IOException {
	if(uri == null)
	    uri = ".";
	if(!uri.endsWith("/"))
	    uri = uri.concat("/");
	URL rurl = null;
	try { 
	    rurl = new URL(uri);
	} catch(MalformedURLException e) {
	    rurl = new File(uri).getCanonicalFile().toURL();
	}
	return rurl;
    }

    /**
     *	Normalizes a path. If 'absolute', return a path with a leading slash
     */
    public static String normalizePath(String path, boolean absolute) {
	int L = path.length(), save = 1, lastSlash = 0;
	char[] cpath = new char[L + 1];
	cpath[0] = '/'; 
	for(int i = 0; i < L; i++) {
	    char cc = path.charAt(i);
	    if(cc == '/' || cc == '\\') {
		if(cpath[save-1] == '/')
		    continue;	// duplicate separator
		save = processComponent(cpath, save);
		cpath[save++] = '/';
	    }
	    else cpath[save++] = cc;
	}
	save = processComponent(cpath, save);	// final component
	if(save > 2 && cpath[save-1] == '/')
	    -- save;
	if(save == 0)
	    return absolute? "/" : ".";
	
	int start = 1;
	if(absolute || path.charAt(0) == '/' || path.charAt(0) == '\\')
	    start = 0;
	return new String(cpath, start, save - start);
    }

    // treats /. or /.. and trim appropriately
    static private int processComponent(char[] cpath, int pos) {
	if(pos < 2 || cpath[pos-1] != '.')
	    return pos;
	if(cpath[pos-2] == '/')
	    // remove trailing /.
	    return pos - 2;
	if(pos < 3 || cpath[pos-2] != '.' || cpath[pos-3] != '/')
	    return pos;
	// we have a trailing /..  : go back to preceding slash
	pos -= 3;
	while(pos > 0 && cpath[pos-1] != '/')
	    --pos;
	return pos;
    }

    

    public static String RESERVED = ";/?:@&=+$,#[]";
    public static String MARKS = "-_.!~*'()";
    public static String HEX = "0123456789ABCDEFabcdef";
    static Charset UTF8;

    static {
	try {
            UTF8 = Charset.forName("UTF-8");
        }
        catch (Exception e) {  e.printStackTrace();  }
    }

    static boolean isHexa( char c ) {
	return HEX.indexOf(c) >= 0;
    }

    /**
     *	Escapes URI characters. If escReserved is true, escapes also reserved characters.
     */
    public static void escapeURI( String uri, boolean escReserved, StringBuffer out) {
	for(int i = 0, L = uri.length(); i < L; i++) {
	    char c = uri.charAt(i);
	    if(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' ||
	       MARKS.indexOf(c) >= 0 || !(escReserved && RESERVED.indexOf(c) >= 0) || 
	       (c == '%' && i < L-2 && isHexa(uri.charAt(i+1)) && isHexa(uri.charAt(i+2))))
		out.append(c);
	    else
		try {
		    ByteBuffer bb = UTF8.encode(uri.substring(i, i+1));
		    for(; bb.hasRemaining(); ) {
			byte b = bb.get();
			out.append( '%' );
			out.append( HEX.charAt( b >>> 4 ));
			out.append( HEX.charAt( b & 0xf ));
		    }
		} catch (Exception e) {
		    e.printStackTrace();
		}
	}
    }

} // end of class Util

