/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.io.*;

/**
 *	
 *	
 */
public class VInputStream extends BufferedInputStream
{
    public VInputStream( File file ) throws FileNotFoundException {
	super(new FileInputStream(file));
    }

    public int readVint( ) throws IOException {
	int r = 0;
	for(;;) {
	    int b = read();
	    r = (r << 7) + (b & 0x7f);
	    if( b < 128 )
		break;
	}
	return r;
    }

    public long readVlong( ) throws IOException {
	long r = 0;
	for(;;) {
	    int b = read();
	    r = (r << 7) + (b & 0x7f);
	    if( b < 128 )
		break;
	}
	return r;
    }

} // end of class VInputStream

