/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.io.*;

/**
 *	Binary output stream with support for variable-length positive integers.
 *	BUG: tell() is correct only if we use only the output methods defined here.
 */
public class VOutputStream extends BufferedOutputStream
{
    public VOutputStream( File file ) throws FileNotFoundException {
	super(new FileOutputStream(file));
    }

    public void putVlong( long code ) throws IOException {
	if (code < 0) throw new IllegalArgumentException("negative code: "+code);
	int	bc = codeBytes.length;
	boolean first = true;
	do {
	    codeBytes[-- bc] = (byte) (code & 0x7f);
	    if (!first)
		codeBytes[bc] |= 0x80;
	    code >>= 7;
	    first = false;
	} while(code != 0);
	write(codeBytes, bc, codeBytes.length - bc);
	count += codeBytes.length - bc;
    }

    /**
     *	Closes and synchronizes the file on disk.
     */
    public void syncClose() throws IOException {
	flush();
	((FileOutputStream) out).getFD().sync();
	close();
    }

/*
    public void putVint( int code ) throws IOException {
	if (code < 0) throw new IllegalArgumentException("negative code: "+code);
	int bc = codeBytes.length;
	boolean first = true;
	do {
	    codeBytes[-- bc] = (byte) (code & 0x7f);
	    if (!first)
		codeBytes[bc] |= 0x80;
	    code >>= 7;
	    first = false;
	} while(code != 0);
	write(codeBytes, bc, codeBytes.length - bc);
	count += codeBytes.length - bc;
    }
*/
    public void putVint( int code ) throws IOException {
	int nb = 0;
	if(code < 0x80) {
	    codeBytes[0] = (byte) code;
	    nb = 1;
	}
	else if(code < 0x4000) {
	    codeBytes[0] = (byte) (((code >> 7 ) & 0x7f) | 0x80);
	    codeBytes[1] = (byte) (code & 0x7f);
	    nb = 2;
	}
	else if(code < 0x200000) {
	    codeBytes[0] = (byte) (((code >> 14) & 0x7f) | 0x80);
	    codeBytes[1] = (byte) (((code >> 7 ) & 0x7f) | 0x80);
	    codeBytes[2] = (byte) (code & 0x7f);
	    nb = 3;
	}
	else if(code < 0x10000000) {
	    codeBytes[0] = (byte) (((code >> 21) & 0x7f) | 0x80);
	    codeBytes[1] = (byte) (((code >> 14) & 0x7f) | 0x80);
	    codeBytes[2] = (byte) (((code >> 7 ) & 0x7f) | 0x80);
	    codeBytes[3] = (byte) (code & 0x7f);
	    nb = 4;
	}
	else {
	    codeBytes[0] = (byte) (((code >> 28) & 0x7f) | 0x80);
	    codeBytes[1] = (byte) (((code >> 21) & 0x7f) | 0x80);
	    codeBytes[2] = (byte) (((code >> 14) & 0x7f) | 0x80);
	    codeBytes[3] = (byte) (((code >> 7 ) & 0x7f) | 0x80);
	    codeBytes[4] = (byte) (code & 0x7f);
	    nb = 5;
	}
	write(codeBytes, 0, nb);
	count += nb;
    }

    public long tell() {
	return count;
    }

    byte      codeBytes[] = new byte[9];	// buffer for varint
    long      count;

} // end of class VOutputStream

