/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.util.*;

/**
 * 	A compiled Query. This is essentially an opaque object.
 * 	Initialization methods are defined in superclass Module.
 */
public class Query extends Module
{
    public Expression  body;

    public Query( ) {
	moduleNS = LOCAL_NS;
    }

    public Type getType() {
	return body.getType();
    }

    public void dump( ExprDump d ) {
	d.println( "Query" );
        d.display( "declarations", declarations);
        d.display( "body", body);
    }
    
    public void staticCheck( ModuleManager mman, Log log ) {
	super.staticCheck(mman, log); //  module
	if(body != null) {
	    resetLocals();
	    body = staticCheck( body, 0 );
	    allocateLocalAddress(lastLocal);
	}
    }

    public Value  eval( Focus focus, EvalContext context ) throws XQueryException {
	try {
	    return body == null ? Value.empty : body.eval(focus, context);
	}
        catch (EmptyException e) {
	    return Value.empty;
        }
        catch (EvalException err) {
	    if(err.getContext() == null) // should not happen but
		err.setContext(context);
	    throw err;
        }
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException {
	try {
	    body.evalAsEvents( output, focus, context );
	}
        catch (EmptyException e) {
        }
        catch (EvalException err) {
	    if(err.getContext() == null) // should not happen but
		err.setContext(context);
	    throw err;
        }
    }
}
