/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.UntypedAtomicType;
import net.xfra.qizxopen.xquery.*;

import java.math.BigDecimal;
import java.text.Collator;

/**
 *	Abstract base for actual Node implementations.
 */
public abstract class NodeBase implements Node
{
    public ItemType  getType() {
	return Type.NODE;
    }

    public boolean  isNode() {
	return true;
    }

    public boolean  asBoolean() throws TypeException {
	return asString().length() != 0;	// OPTIM	
    }

    public long     asInteger() throws TypeException {
	return Conversion.toInteger( asString() ); 
    }

    public BigDecimal asDecimal() throws TypeException {
	return Conversion.toDecimal( asString() ); 
    }

    public float    asFloat() throws TypeException {
	return Conversion.toFloat( asString() ); 
    }

    public double   asDouble() throws TypeException {
	return Conversion.toDouble( asString() ); 
    }

    public String   asString()  throws TypeException {
	return getStringValue();
    }
    
    public Node     asNode() throws TypeException {
	return this;
    }

    public Item     asItem() throws TypeException {
	return this;
    }

    /**
     *	Value comparison: equivalent to (untypedAtomic, string-value). TODO schema import
     */
    public int compareTo( Item that, Collator collator, int implicitTimeZone)
	throws TypeException {
	// TODO: can be optimised by traversal comparison (stream on the stringvalue)
	return UntypedAtomicType.comparison( this, that, collator );
    }

    /**
     *	Based on identity, not on string-value. 
     */
    public boolean equals( Object that ) {
	if(this == that)
	    return true;
	if( !(that instanceof Node) )
	    return false;
	return orderCompare( (Node) that ) == 0;
    }

    /**
     *	Based on identity, not on string-value.
     *	Redefined here just for documentation purpose.
     */
    public int hashCode() {
	return super.hashCode();
    }

} // end of class NodeBase

