/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.Util;

import java.math.BigDecimal;
import java.text.Collator;

/**
 *	Abstract decimal value.
 */
public abstract class DecimalValue extends BaseValue
{
    public DecimalValue() {
	itemType = Type.DECIMAL;
    }

    public abstract BigDecimal getValue();

    public Item asItem() {
	return this;
    }

    public String asString() throws TypeException  {
	String s = getValue().toString();
	// remove trailing zeroes:
	int last = s.length();
	for(; --last >= 0; )
	    if(s.charAt(last) != '0')
		break;
	if(last < 0 || s.charAt(last) == '.')
	    -- last;	//++ last;	// Nov 2003
	return s.substring(0, last + 1);
    }

    public double asDouble() throws TypeException  {
	return getValue().doubleValue();
    }

    public float asFloat() throws TypeException  {
	return getValue().floatValue();
    }

    public boolean equals( Object that ) {
	if(! (that instanceof DecimalValue) )
	    return false;
        return getValue().equals( ((DecimalValue) that).getValue() );
    }

    public int hashCode() {
	return getValue().hashCode();
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone ) throws TypeException {
	if( Type.UNTYPED_ATOMIC.accepts(that.getType()) )
	    return Util.comparison( asDouble() - that.asDouble() );

	if( !Type.NUMERIC.accepts( that.getType() ) )
	    return INCOMPARABLE;
	if(that.getType() == Type.DECIMAL)
	    return getValue().compareTo( ((DecimalValue) that).getValue() );
	else
	    return getValue().compareTo( new BigDecimal(that.asDouble()) );
    }
}

