/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.time.GMonth;
import net.xfra.qizxopen.util.time.DateTimeException;

public class GMonthType extends MomentType {

    public String getShortName() {
        return "gMonth";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	GMonth result = null;
	try {
	    if(type instanceof StringType)
		result = GMonth.parseGMonth( value.asString() );
	    else if(Type.INTEGER.accepts(type) )
		result = new GMonth( (int) value.asInteger(), 0, 0, 0 );
	    else if(type == Type.DATE || type == Type.DATE_TIME)
		result = new GMonth(((MomentValue) value.asItem()).getValue());
	    else throw new DateTimeException("invalid type "+type);
	} catch (DateTimeException e) {
	    throw new TypeException("cannot cast to xs:gMonth : "+ e.getMessage());
        }
	return new SingleMoment( result, Type.G_MONTH );
    }
}
