/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;

/**
 *	Implementation of a single item of type dateTime, date, time, gDay etc.
 *	
 */
public class SingleMoment extends MomentValue
{
    protected DateTimeBase value;
    private boolean started = false;

    public SingleMoment( DateTimeBase value, ItemType subType ) {
	this.value = value;
	itemType = subType;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleMoment(value, itemType);
    }

    public DateTimeBase getValue() {
	return value;
    }

} // end of class SingleMoment

