/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.dt.DistinctValueSequence;

public class DistinctValues extends Function {

    static Prototype[] protos = { 
        Prototype.fn("distinct-values", Type.ANY_ATOMIC_TYPE.star, Exec.class)
            .arg("srcval", Type.ANY_ATOMIC_TYPE.star),
        Prototype.fn("distinct-values", Type.ANY_ATOMIC_TYPE.star, Exec.class)
            .arg("srcval", Type.ANY_ATOMIC_TYPE.star)
            .arg("collationLiteral", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }


    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    return new DistinctValueSequence( args[0].eval(focus, context) );
        }
    }
}
