/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.DurationValue;

/**
 *  Implementation of function fn:get-day (replaces get-day-from-***).
 */
public class GetDay extends Function {

    static Prototype[] protos = { 
      Prototype.fn("get-day", Type.INTEGER.opt, Exec.class).arg("op", Type.DATE.opt),
      Prototype.fn("get-day", Type.INTEGER.opt, Exec.class).arg("op", Type.DATE_TIME.opt),
      Prototype.fn("get-day", Type.INTEGER.opt, Exec.class).arg("op", Type.G_DAY.opt),
      Prototype.fn("get-day", Type.INTEGER.opt, Exec.class).arg("op", Type.G_MONTH_DAY.opt),
      Prototype.fn("get-day", Type.INTEGER.opt, Exec.class).arg("op", Type.DURATION.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.IntegerCall {
        public long evalAsInteger(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item v = args[0].evalAsOptItem(focus, context);
	    if(v == null)
		throw EmptyException.allowed();
	    if(v.getType() == Type.DURATION) {
		DurationValue dv = (DurationValue) v;	
		return dv.getValue().getDay();
	    }
	    else if(v instanceof MomentValue) {
		MomentValue mv = (MomentValue) v;
		return mv.getValue().getDay();
	    }
	    else // The unseen problem
		context.error(this, "type not supported: "+ v.getType());
	    return 0;
        }
    }
}
