/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleDuration;

/**
 *  Implementation of function fn:get-timezone-from-dateTime.
 */
public class GetTimezoneFromDateTime extends Function {

    static Prototype[] protos = { 
      Prototype.fn("get-timezone-from-dateTime", Type.DURATION.opt, Exec.class).arg("op", Type.DATE_TIME.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item v = args[0].evalAsOptItem(focus, context);
	    if(v == null)
		throw EmptyException.allowed();
	    DateTimeBase dt = null;
	    if(v instanceof MomentValue)
		dt = ((MomentValue) v).getValue();
	    else try {
		dt = DateTime.parseDateTime( v.asString(), context.getImplicitTimezone() );
	    }
	    catch(DateTimeException e) {
		return context.error(this, "cannot cast to xs:dateTime : "+ e.getMessage());
	    }
	    return new SingleDuration( new Duration(0, dt.getTimeZone() * 60) );
        }
    }
}

