/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.op.FilterExpr;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:item-at.
 */
public class ItemAt extends Function {

    static Prototype[] protos = { 
        Prototype.fn("item-at", Type.ITEM.opt, Exec.class)
            .arg("sequence", Type.ITEM.star) .arg("pos", Type.INTEGER)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Value seq = args[0].eval(focus, context);
	    int pos = (int) args[1].evalAsInteger(focus, context);
	    return new FilterExpr.Index(seq, pos); // no error raised if wrong pos
        }
    }
}
