/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;

/**
 *  Implementation of function fn:name.
 */
public class Name extends Function {

    static Prototype[] protos = { 
        Prototype.fn("name", Type.STRING, Exec.class),
        Prototype.fn("name", Type.STRING, Exec.class)
            .arg("srcval", Type.NODE.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
	    Node node;
	    if(args.length == 0) {
		if(focus == null || !focus.getItem().isNode())
		    return "";
		node = focus.getItem().asNode();
	    }
	    else node = args[0].evalAsOptNode(focus, context);
	    if(node == null)
		return "";
	    QName name = node.getNodeName();
	    if(name == null)
		return "";
	    if(name.getNamespace() == Namespace.NONE)
		return name.getLocalName();

	    String prefix = node.getNsPrefix( name.getURI() );
	    if(prefix == null)
		return context.getStaticContext().prefixedName(name);
	    if(prefix.length() == 0)
		return name.getLocalName();
	    return prefix + ":" + name.getLocalName();
        }
    }
}
