/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import java.util.regex.*;

/**
 *  Implementation of function fn:replace.
 */
public class Replace extends Matches {

    static Prototype[] protos = { 
        Prototype.fn("replace", Type.STRING.opt, Exec.class)
            .arg("input", Type.STRING.opt)
            .arg("pattern", Type.STRING)
            .arg("replacement", Type.STRING),
        Prototype.fn("replace", Type.STRING.opt, Exec.class)
            .arg("input", Type.STRING.opt)
            .arg("pattern", Type.STRING)
            .arg("replacement", Type.STRING)
            .arg("flags", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

	Pattern precompiled;
	// precompile regexp if constant
	public void compilationHook() {
	    Expression xflags = args.length < 4 ? null : args[3];
	    precompiled = precompileRegexp(args[1], xflags, false);
	}

        public String evalAsString(Focus focus, EvalContext context)
	    throws XQueryException {
	    String input = args[0].evalAsOptString(focus, context);
	    String replacement = args[2].evalAsString(focus, context);
	    if(input == null)
		input = "";
            context.at(this);

	    Expression xflags = args.length < 4 ? null : args[3];
	    Pattern pat = precompiled != null ? 
		precompiled : compileRegexp(args[1], xflags, false, focus, context);
	    Matcher matcher = pat.matcher(input);

	    return matcher.replaceAll( replacement );
        }
    }
}
