/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:sequence-node-identical.
 */
public class SequenceNodeIdentical extends Function {

    static Prototype[] protos = { 
        Prototype.fn("sequence-node-identical", Type.BOOLEAN.opt, Exec.class)
            .arg("parameter1", Type.NODE.star)
            .arg("parameter2", Type.NODE.star)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.BoolCall {

        public boolean evalAsBoolean(Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
	    Value s1 = args[0].eval(focus, context);
	    Value s2 = args[1].eval(focus, context);
	    // NOTE: this is not conformant but the spec is absurd
	    for(;;) {
		if(!s1.next())
		    return !s2.next();
		if(!s2.next())
		    return false;
		if(!s1.asNode().equals(s2.asNode()))
		    return false;
	    }
        }
    }
}
