/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:string-length.
 */
public class StringLength extends Function {

    static Prototype[] protos = { 
        Prototype.fn("string-length", Type.INTEGER.opt, Exec.class),
        Prototype.fn("string-length", Type.INTEGER.opt, Exec.class)
            .arg("srcval", Type.STRING.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.IntegerCall {

        public long evalAsInteger(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String s;
	    if(args.length == 0) {
		checkFocus(focus, context);
		s = focus.getItem().asString();
	    }
	    else s = args[0].evalAsOptString(focus, context);
	    return s == null ? 0 : s.length();
        }
    }

}
