/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.util.time.Time;
import net.xfra.qizxopen.util.time.DateTimeException;

/**
 *  Implementation of function xs:time.
 */
public class XS_time extends CastFunction {

    static Prototype[] protos = { 
        Prototype.xs("time", Type.TIME, Exec.class) .arg("srcval", Type.ANY_ATOMIC_TYPE),
        Prototype.xs("time", Type.TIME, ExecM.class)
	.arg("hours", Type.INTEGER).arg("minutes",Type.INTEGER).arg("seconds",Type.INTEGER)
    };
    public Prototype[] getProtos() { return protos; }

    public static class ExecM extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    int hour = (int) args[0].evalAsInteger(focus, context);
	    int minute = (int) args[1].evalAsInteger(focus, context);
	    int second = (int) args[2].evalAsInteger(focus, context);
            context.at(this);
	    try {
		return new SingleMoment( new Time(hour, minute, second, 0, 0, 0),
					 Type.TIME );
	    }
	    catch (DateTimeException e) {
		context.error(this, e.getMessage()); return Value.empty;
	    }
        }
    }
}
