/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.impl;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.util.QName;

/**
 *  Implementation of a Sequence Type with its occurrence indicator.
 * 
 */
public class SequenceType extends Type {

    ItemType  itemType;
    byte  occ = OPTMULTI_OCC;

    public SequenceType( ItemType itemType ) {
	this.itemType = itemType;
    }

    public SequenceType( ItemType itemType, byte occ ) {
        this.itemType = itemType;
        this.occ = occ;
    }

    public ItemType getItemType() {
	return itemType;
    }

    public int getOccurrence() {
	return occ;
    }

    public String toString(StaticContext ctx) {
	String s = itemType.toString(ctx);
	switch(occ) {
	case OPT_OCC:
	    return s + "?";
	case MULTI_OCC:
	    return s + "+";
	case OPTMULTI_OCC:
	    return s + "*";
	default:
	    return s;
	}
    }

    public String toString() {
	String s = itemType.toString();
	switch(occ) {
	case OPT_OCC:
	    return s + "?";
	case MULTI_OCC:
	    return s + "+";
	case OPTMULTI_OCC:
	    return s + "*";
	default:
	    return s;
	}
    }

    public void dump( ExprDump d ) {
	d.println("SequenceType "+this);
    }

    public boolean accepts( Type valueType ) {
	ItemType vitemType = valueType.getItemType();
	if( vitemType == Type.NONE )
	    return isOptional( valueType.getOccurrence() );

	// That's all: we cannot check the occurrence count in static analysis
	return itemType.accepts(vitemType);
    }
}
