/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 *  Implementation of operator idiv.
 * 
 */
public class IDivOp extends NumericOp {

    public IDivOp( Expression expr1, Expression expr2 ) {
        super( expr1, expr2 );
    }

    public void dump( ExprDump d ) {
	d.header( this, "idiv" );
        d.display("expr1", operands[0]);
        d.display("expr2", operands[1]);
    }

    static Prototype[] protos = { 
        Prototype.op("idiv", Type.INTEGER, ExecI.class)
	  .arg("op1", Type.INTEGER).arg("op2", Type.INTEGER),
    };
    public Prototype[] getProtos() { return protos; }

    public static class ExecI extends Function.IntegerCall {

	public long evalAsInteger( Focus focus, EvalContext context ) throws XQueryException {
	    long e1 = args[0].evalAsInteger(focus, context);
	    long e2 = args[1].evalAsInteger(focus, context);
	    context.at(this);
	    if(e2 == 0)
		context.error(this, "division by zero");
	    
	    return e1 / e2;
	}
    }
}
